/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.rs;

import esecurity.enroll.bean.GeneralNames;
import esecurity.enroll.constants.KeyAlgo;
import esecurity.enroll.constants.KeyType;
import esecurity.oss.bean.ClientCredentials;
import esecurity.oss.bean.FeaCertificate;
import esecurity.oss.bean.InputParams;
import esecurity.oss.bean.ListFeaCertificateRequest;
import esecurity.oss.bean.SignDocRequest;
import esecurity.oss.client.OSSFERestProxy;
import esecurity.oss.enumerators.ParamsEnum;
import it.actalis.ellips.capi.core.Actalis_PrivateKey;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ExtendedCredentials;
import it.actalis.ellips.capi.core.SessionCredentials;
import it.actalis.ellips.capi.core.TokenParameters;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.ArubaTrustStore;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.provider.RemoteToken;
import it.actalis.ellips.capi.rs.FeaInitializeParameters;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.util.logging.Level;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;

public class FeaSignatureToken
extends RemoteToken {
    public static final String TOKEN_RS = "RemoteSignatureToken";
    private String a = "";
    private String b;
    private String c;
    private String d;
    private static NetworkConfig e = new NetworkConfig();
    private UrlClient f = null;
    private OSSFERestProxy g = null;
    private FeaCertificate[] h = null;
    private String i = null;
    private boolean j = false;
    private URLCredentials k = null;

    public FeaSignatureToken() {
    }

    public FeaSignatureToken(Logger logger, URLCredentials uRLCredentials) {
        if (logger != null) {
            FeaSignatureToken.logger = logger;
        }
        this.k = uRLCredentials;
    }

    private void a() throws CapiException {
        ClientCredentials clientCredentials = new ClientCredentials();
        clientCredentials.setClientuser(this.user);
        if (this.b != null && !this.b.equals("")) {
            clientCredentials.setClientpwd(this.b);
        }
        this.f = new UrlClient(e, logger);
        this.g = new OSSFERestProxy(logger, this.f, this.k, ArubaTrustStore.getTSRS(), true);
        ListFeaCertificateRequest listFeaCertificateRequest = new ListFeaCertificateRequest();
        listFeaCertificateRequest.setCredentials(clientCredentials);
        listFeaCertificateRequest.setTransactionid(this.i);
        try {
            clientCredentials = this.g.listCerts(this.a, listFeaCertificateRequest);
            if (clientCredentials == null || clientCredentials.getCode() == null) {
                logger.error("Empty Response");
                throw new CapiException("Network Error", -2147483136);
            }
            clientCredentials.getCode().equals("0000");
            this.h = clientCredentials.getFeaCerts();
            return;
        }
        catch (IOException iOException) {
            this.h = new FeaCertificate[0];
            java.util.logging.Logger.getLogger(FeaSignatureToken.class.getName()).log(Level.SEVERE, null, iOException);
            return;
        }
    }

    public void initializeLib(String[] stringArray) throws CapiException {
        if (stringArray == null || stringArray.length < 5 || stringArray[0] == null || stringArray[1] == null || stringArray[3] == null || stringArray[4] == null || stringArray[5] == null && (stringArray[7] == null || stringArray[8] == null || stringArray[9] == null)) {
            throw new CapiException("Wrong args", 1001);
        }
        try {
            this.a = this.argsResolver(stringArray, 0);
            if (Util.isNullOrEmpty((String)this.a)) {
                throw new CapiException("Empty URL: \"" + stringArray[0] + "\"", 1002);
            }
            new URL(this.a);
            logger.debug("Selected url: " + this.a);
        }
        catch (MalformedURLException malformedURLException) {
            throw new CapiException("Not valid URL: \"" + stringArray[0] + "\"", 1002);
        }
        this.user = this.argsResolver(stringArray, 1);
        if (Util.isNullOrEmpty((String)this.user)) {
            throw new CapiException("Wrong Username", 1002);
        }
        this.b = this.argsResolver(stringArray, 2);
        if (Util.isNullOrEmpty((String)this.b)) {
            throw new CapiException("Wrong Password", 1002);
        }
        this.i = this.argsResolver(stringArray, 3);
        this.c = this.argsResolver(stringArray, 4);
        this.d = this.argsResolver(stringArray, 5);
        this.j = this.argsResolver(stringArray, 6) != null ? this.argsResolver(stringArray, 6).equalsIgnoreCase("true") : false;
        this.a();
    }

    public void initializeLib(String[] stringArray, boolean bl) throws CapiException {
        logger.debug("initializeLib() with tokenSoftSia parameter");
        this.initializeLib(stringArray);
    }

    public void initializeLib(TokenParameters tokenParameters) throws CapiException {
        if (!(tokenParameters instanceof FeaInitializeParameters)) {
            throw new CapiException("Wrong args", 1001);
        }
        try {
            this.a = ((FeaInitializeParameters)tokenParameters).getServiceUrl();
            if (Util.isNullOrEmpty((String)this.a)) {
                throw new CapiException("Empty URL: \"" + ((FeaInitializeParameters)tokenParameters).getServiceUrl() + "\"", 1002);
            }
            new URL(this.a);
            logger.debug("Selected url: " + this.a);
        }
        catch (MalformedURLException malformedURLException) {
            throw new CapiException("Not valid URL: \"" + ((FeaInitializeParameters)tokenParameters).getServiceUrl() + "\"", 1002);
        }
        this.user = ((FeaInitializeParameters)tokenParameters).getUsername();
        if (Util.isNullOrEmpty((String)this.user)) {
            throw new CapiException("Wrong Username", 1002);
        }
        this.b = ((FeaInitializeParameters)tokenParameters).getPassword();
        if (Util.isNullOrEmpty((String)this.b)) {
            throw new CapiException("Wrong Password", 1002);
        }
        this.i = ((FeaInitializeParameters)tokenParameters).getTransactionId();
        this.c = ((FeaInitializeParameters)tokenParameters).getOtp();
        this.d = ((FeaInitializeParameters)tokenParameters).getVerifiedSession();
        this.j = ((FeaInitializeParameters)tokenParameters).isSuspendAfterSign();
        this.a();
    }

    public String[] getLibInfo() {
        String string = "FEA Signature";
        String string2 = "";
        String string3 = "Ellips FEA Signature Token";
        String string4 = "1.0";
        String string5 = "Actalis S.p.A.";
        String string6 = "";
        String string7 = "Actalis S.p.A.";
        String string8 = "";
        String string9 = "Actalis S.p.A.";
        return new String[]{string, string2, string3, string4, string5, string6, string7, string8, string9};
    }

    public void openSession(boolean bl, String string) throws CapiException {
        throw new CapiException("openSession not supported", 1004);
    }

    public void closeSession() throws CapiException {
        logger.debug("Closing session");
        this.h = null;
        this.i = null;
        this.publicSessionOpen = false;
    }

    public boolean isSessionOpen() throws CapiException {
        return !Util.isNullOrEmpty((String)this.i);
    }

    public String getCert(String string) throws CapiException {
        if (string == null || this.h == null || this.h.length == 0) {
            return null;
        }
        FeaCertificate[] feaCertificateArray = this.h;
        int n = this.h.length;
        for (int i = 0; i < n; ++i) {
            FeaCertificate feaCertificate = feaCertificateArray[i];
            if (!feaCertificate.getAlias().equals(string)) continue;
            return new String(Base64.encode((byte[])feaCertificate.getCertificate()));
        }
        return null;
    }

    public void setCert(String string, byte[] byArray, int n, boolean bl) throws CapiException {
        throw new CapiException("Remote Signature doesn't support setting certificates into the token", 1004);
    }

    public String installCertificate(Certificate certificate) throws CapiException {
        throw new CapiException("Remote Signature doesn't support install certificates into the token", 1004);
    }

    public PublicKey getPublicKey(String string) throws CapiException {
        if (this.h == null || this.h.length <= 0) {
            return null;
        }
        if (string == null) {
            return null;
        }
        FeaCertificate[] feaCertificateArray = this.h;
        int n = this.h.length;
        for (int i = 0; i < n; ++i) {
            FeaCertificate feaCertificate = feaCertificateArray[i];
            if (!string.equals(feaCertificate.getAlias())) continue;
            string = new Certificate(feaCertificate.getCertificate());
            return string.getPublicKey();
        }
        return null;
    }

    public PrivateKey getPrivateKey(String string) throws CapiException {
        if (this.h == null || this.h.length <= 0) {
            return null;
        }
        Actalis_PrivateKey actalis_PrivateKey = new Actalis_PrivateKey(string);
        actalis_PrivateKey.setCryptoDev((TokenSpi)this);
        actalis_PrivateKey.setPublicInfo(this.getPublicKey(string));
        return actalis_PrivateKey;
    }

    public byte[] doSign(byte[] object, String string, int n) throws CapiException {
        try {
            logger.debug("mode:" + n);
            logger.debug("DigestInfo:" + new String(Base64.encode((byte[])object)));
            logger.debug("alias:" + string);
            object = ASN1Sequence.getInstance((Object)object);
            object = new DigestInfo((ASN1Sequence)object);
            logger.debug("digest:" + new String(Base64.encode((byte[])object.getDigest())));
            string = new SignDocRequest();
            InputParams[] inputParamsArray = new ClientCredentials();
            inputParamsArray.setClientuser(this.user);
            inputParamsArray.setClientpwd(this.b);
            string.setCredentials((ClientCredentials)inputParamsArray);
            string.setTransactionid(this.i);
            string.setSuspendAfterSign(this.j);
            inputParamsArray = new InputParams();
            if (this.c != null && !"".equals(this.c)) {
                inputParamsArray.setName(ParamsEnum.OTP);
                inputParamsArray.setValue(this.c);
            } else {
                inputParamsArray.setName(ParamsEnum.VERIFIEDSESSION);
                inputParamsArray.setValue(this.d);
            }
            inputParamsArray = new InputParams[]{inputParamsArray};
            string.setParams(inputParamsArray);
            string.setDocumenthash(object.getDigest());
            object = this.g.signDoc(this.a, (SignDocRequest)string);
            logger.debug("return_code" + object.getCode());
            if (object.getCode().equals("0000")) {
                return object.getSignedhash();
            }
            if (object.getCode().equals("0003")) {
                throw new CapiException("Invalid OTP", 2014);
            }
            if (object.getCode().equals("1030")) {
                throw new CapiException("Max Signed Reached", 10040);
            }
        }
        catch (IOException iOException) {
            logger.error(iOException.getMessage(), (Throwable)iOException);
        }
        return null;
    }

    public byte[] doDecrypt(byte[] byArray, String string, int n) throws CapiException {
        throw new CapiException("Remote Signature doesn't support the Decrypt functionality", 1004);
    }

    public String[] listObjects(String string, byte by) throws CapiException {
        if (this.h == null) {
            throw new CapiException("Session not opened", 10013);
        }
        try {
            String[] stringArray = new String[this.h.length];
            if (this.h.length == 0) {
                return stringArray;
            }
            int n = 0;
            Object[] objectArray = this.h;
            int n2 = this.h.length;
            for (int i = 0; i < n2; ++i) {
                Object object = objectArray[i];
                if ((this.getObjectType((String)(object = object.getAlias())) & by) == 0 || string != null && ((String)object).indexOf(string) < 0) continue;
                stringArray[n] = object;
                ++n;
            }
            if (n == 0) {
                return new String[0];
            }
            objectArray = new String[n];
            for (n2 = 0; n2 < n; ++n2) {
                objectArray[n2] = stringArray[n2];
            }
            return objectArray;
        }
        catch (Exception exception) {
            logger.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 10040);
        }
    }

    public SessionCredentials openSessionWithExtendedAuth(boolean bl, String string, ExtendedCredentials extendedCredentials) throws CapiException {
        return null;
    }

    public void resetToken(String string) throws CapiException {
    }

    public String certReq(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey, Provider provider) throws CapiException {
        return null;
    }

    public byte[] generateCertificateRequest(KeyType keyType, KeyAlgo keyAlgo, int n, String string, GeneralNames[] generalNamesArray, String string2) throws CapiException {
        return new byte[0];
    }

    public static void setDefaultNetworkConfig(NetworkConfig networkConfig) {
        e = networkConfig;
    }

    public String getSelected_url() {
        return this.a;
    }

    public void setSelected_url(String string) {
        this.a = string;
    }

    public String certReq(String string, X500Name x500Name) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String certReq(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey, String string) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CertificationRequest generatePKCS10CertificationRequest(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

