/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.http.arubautils;

import esecurity.statistics.utils.AdditionalLogInfo;
import esecurity.statistics.utils.StatisticsInfoUtils;
import it.actalis.ellips.capi.http.arubautils.HttpRequest;
import it.actalis.ellips.capi.http.arubautils.HttpResponse;
import it.actalis.ellips.capi.http.arubautils.Parameters;
import it.actalis.ellips.capi.http.arubautils.RequestData;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.UrlReturn;
import java.security.KeyStore;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpClient<R extends HttpRequest, S extends HttpResponse> {
    private static final Logger logger2 = LoggerFactory.getLogger(UrlClient.class);
    protected Logger logger = logger2;
    protected UrlClient client = null;
    boolean debug = false;

    public HttpClient(UrlClient client, KeyStore cdb, boolean ignorecert) {
        this(client, cdb, ignorecert, null);
    }

    public HttpClient(UrlClient client, KeyStore store, boolean ignorecert, Logger logger) {
        if (logger != null) {
            this.logger = logger;
        }
        this.client = client;
        if (ignorecert) {
            client.setSSLTrustAllRoot(ignorecert);
            client.setSSLHallHostVerified(ignorecert);
        } else if (store != null) {
            client.setTrustStore(store);
        }
        if (System.getProperties().getProperty("esecurity.asb.gw.debug") != null) {
            this.debug = System.getProperties().getProperty("esecurity.asb.gw.debug").equals("true");
        }
    }

    public S sendRequest(String url, R request, URLCredentials cred) {
        S response = this.buildEmptyResponse();
        RequestData data = this.buildRequestData(request);
        boolean hasCorrelationId = false;
        for (Parameters param : data.getParam()) {
            if (!param.getName().equals("CorrelationId")) continue;
            hasCorrelationId = true;
            break;
        }
        if (!hasCorrelationId) {
            AdditionalLogInfo info = StatisticsInfoUtils.getAdditionalInfo();
            String correlationId = "";
            if (info == null) {
                StatisticsInfoUtils.initStatisticInfo();
                info = StatisticsInfoUtils.getAdditionalInfo();
            }
            if ((correlationId = info.getCorrelationId()) == null || correlationId.isEmpty()) {
                correlationId = UUID.randomUUID().toString();
                info.setCorrelationId(correlationId);
            }
            Parameters param = new Parameters("CorrelationId", correlationId);
            data.getParam().add(param);
        }
        UrlReturn ret = this.client.downloadUrl(url, data, cred, ((HttpRequest)request).getMethod());
        ((HttpResponse)response).setStatus(ret.getStatus());
        ((HttpResponse)response).setMessage(ret.getStatusMessage());
        ((HttpResponse)response).setResponseData(ret.getData());
        ((HttpResponse)response).setErrorData(ret.getErrordata());
        ((HttpResponse)response).setStatusCode(ret.getStatus_code());
        return response;
    }

    protected abstract S buildEmptyResponse();

    protected abstract RequestData buildRequestData(R var1);

    public void setConnectionTimeout(long cTimeout) {
        this.client.setConnectionTimeout(cTimeout);
    }

    public void setReadTimeout(long rTimeout) {
        this.client.setReadTimeout(rTimeout);
    }
}

