/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.vol.utils;

import esecurity.dts.TimeStampToken;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.vol.exception.VolException;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.b;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.xml.sax.SAXException;

public class Utils {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final String enchar = "ISO8859_1";

    public static Date getSigningDateFromTStamp(byte[] object) {
        if (object == null) {
            return null;
        }
        try {
            TimeStampToken timeStampToken = new TimeStampToken((byte[])object);
            object = timeStampToken;
            return Utils.getSigningDateFromTStamp(timeStampToken);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Date getSigningDateFromTStamp(TimeStampToken object) {
        if (object == null) {
            return null;
        }
        try {
            object = ((TimeStampToken)object).getTimeStamp();
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            simpleDateFormat.setTimeZone(timeZone);
            return simpleDateFormat.parse(((String)object).trim());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isDigestAlgorithmValid(String object, Calendar calendar) {
        if (((String)(object = ((String)object).toLowerCase().replace("-", ""))).contains("sha256")) {
            return true;
        }
        object = Calendar.getInstance();
        return ((Calendar)object).before(Constants.CNIPA45_THRESHOLD_DATE) || calendar.before(Constants.CNIPA45_THRESHOLD_DATE);
    }

    public static String getFilename(String[] objectArray) {
        String string = "";
        String string2 = "";
        for (int i = 0; i < objectArray.length; ++i) {
            string = string + objectArray[i];
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1", ProvUtils.bcProvider);
            messageDigest.reset();
            messageDigest.update(string.getBytes());
            objectArray = messageDigest.digest();
            for (int i = 0; i < objectArray.length; ++i) {
                string2 = string2.concat(Utils.byteToHex((byte)objectArray[i]));
            }
            string2 = string2.toUpperCase();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            string2 = "";
        }
        return string2;
    }

    public static String byteToHex(byte by) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] cArray2 = new char[]{cArray[by >> 4 & 0xF], cArray[by & 0xF]};
        return new String(cArray2);
    }

    public static String splice(String[] stringArray) {
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i] + "~";
        }
        string = string.substring(0, string.length() - 1);
        return string;
    }

    public static String parseXMLDate(String string) {
        Cloneable cloneable = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
        try {
            cloneable = cloneable.parse(string);
            string = simpleDateFormat.format((Date)cloneable);
            return string;
        }
        catch (ParseException parseException) {
            return string;
        }
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[16384];
        while ((n = inputStream.read(byArray, 0, 16384)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static void inputStreamToOutputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray, 0, 4096)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
    }

    public static String getFileName(String string) {
        if (string.indexOf("/") >= 0) {
            String string2 = string;
            return string2.substring(string2.lastIndexOf("/") + 1, string.length());
        }
        if (string.indexOf("\\") >= 0) {
            String string3 = string;
            return string3.substring(string3.lastIndexOf("\\") + 1, string.length());
        }
        return string;
    }

    public static String signatureToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            String string;
            int n = byArray[i];
            if (n < 0) {
                n += 256;
            }
            if ((string = Integer.toHexString(n)).length() % 2 != 0) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String calculateDigest(InputStream object, String object2) throws NoSuchAlgorithmException, IOException {
        int n;
        if (object2 == null || ((String)object2).equalsIgnoreCase("")) {
            object2 = "SHA-256";
        }
        object2 = MessageDigest.getInstance((String)object2, ProvUtils.bcProvider);
        byte[] byArray = new byte[4096];
        while ((n = ((InputStream)object).read(byArray)) >= 0) {
            ((MessageDigest)object2).update(byArray, 0, n);
        }
        byte[] byArray2 = ((MessageDigest)object2).digest();
        object = byArray2;
        return Utils.signatureToString(byArray2);
    }

    public static String calculateDigest(InputStream object, OutputStream outputStream, String object2) throws VolException {
        try {
            int n;
            if (object2 == null || ((String)object2).equalsIgnoreCase("")) {
                object2 = "SHA-256";
            }
            object2 = MessageDigest.getInstance((String)object2);
            byte[] byArray = new byte[4096];
            while ((n = ((InputStream)object).read(byArray)) >= 0) {
                outputStream.write(byArray, 0, n);
                ((MessageDigest)object2).update(byArray, 0, n);
            }
            outputStream.flush();
            byte[] byArray2 = ((MessageDigest)object2).digest();
            object = byArray2;
            return Utils.signatureToString(byArray2);
        }
        catch (Exception exception) {
            throw new VolException(exception);
        }
    }

    public static String retrieveCommonName(String string) {
        try {
            Object object = new X509Principal(string);
            object = object.getValues(new ASN1ObjectIdentifier("2.5.4.3"));
            if (((Vector)object).size() > 0) {
                return (String)((Vector)object).get(0);
            }
        }
        catch (Exception exception) {}
        return string;
    }

    public static String base64Encode(String string) {
        return new String(Base64.encode((byte[])string.getBytes()));
    }

    public static byte[] base64DecodeStr(String string) throws CapiException {
        if (string == null) {
            return null;
        }
        return Base64.decode((String)string);
    }

    public static byte[] base64Encode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return Base64.encode((byte[])byArray);
    }

    public static String newString(byte[] object) {
        if (object == null) {
            return null;
        }
        try {
            return new String((byte[])object, enchar);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = unsupportedEncodingException;
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    public static String base64EncodeStr(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return Utils.newString(Utils.base64Encode(byArray));
    }

    public static String getNewId() {
        return String.valueOf(Util.secureRandom.nextInt(10000));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkPdf(String object) {
        if (((String)object).isEmpty()) {
            return false;
        }
        if (!((File)(object = new File((String)object))).exists()) {
            return false;
        }
        boolean bl = false;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream((File)object);
            object = new byte[5];
            if (fileInputStream.read((byte[])object, 0, 5) != -1) {
                bl = ((String)(object = new String((byte[])object))).startsWith("%FDF-") || ((String)object).startsWith("%PDF-");
            }
        }
        catch (IOException iOException) {
            bl = false;
            if (fileInputStream == null) return bl;
            try {
                fileInputStream.close();
                return bl;
            }
            catch (IOException iOException2) {
                return bl;
            }
        }
        catch (Throwable throwable) {
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fileInputStream.close();
            return bl;
        }
        catch (IOException iOException) {
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkXml(File file) {
        boolean bl;
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            bl = Utils.checkXml(fileInputStream);
        }
        catch (IOException iOException) {
            bl = false;
            if (fileInputStream == null) return bl;
            try {
                fileInputStream.close();
                return bl;
            }
            catch (IOException iOException2) {
                return bl;
            }
        }
        catch (Throwable throwable) {
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fileInputStream.close();
            return bl;
        }
        catch (IOException iOException) {
            return bl;
        }
    }

    public static boolean checkXml(FileInputStream fileInputStream) {
        boolean bl;
        if (fileInputStream == null) {
            return false;
        }
        try {
            Object object = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object).setFeature("http://xml.org/sax/features/external-general-entities", false);
            ((DocumentBuilderFactory)object).setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            ((DocumentBuilderFactory)object).setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            ((DocumentBuilderFactory)object).setXIncludeAware(false);
            ((DocumentBuilderFactory)object).setExpandEntityReferences(false);
            object = ((DocumentBuilderFactory)object).newDocumentBuilder();
            ((DocumentBuilder)object).setErrorHandler(new b());
            ((DocumentBuilder)object).parse(fileInputStream);
            bl = true;
        }
        catch (SAXException sAXException) {
            bl = false;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            bl = false;
        }
        catch (IOException iOException) {
            bl = false;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return bl;
    }

    public static int translateReasonToRevocation(String string) {
        if (string == null || string.equalsIgnoreCase("")) {
            return 0;
        }
        if (string.equals("AffiliationChanged")) {
            return 3;
        }
        if (string.equals("CACompromise")) {
            return 2;
        }
        if (string.equals("CertificateHold")) {
            return 6;
        }
        if (string.equals("CessationOfOperation")) {
            return 5;
        }
        if (string.equals("KeyCompromise")) {
            return 1;
        }
        if (string.equals("RemoveFromCRL")) {
            return 8;
        }
        if (string.equals("Superseded")) {
            return 4;
        }
        if (string.equals("Unspecified")) {
            return 0;
        }
        return 0;
    }

    public static void copyFile(File file, File file2) throws IOException {
        AbstractInterruptibleChannel abstractInterruptibleChannel;
        block6: {
            if (!file2.exists()) {
                file2.createNewFile();
            }
            FileChannel fileChannel = null;
            abstractInterruptibleChannel = null;
            try {
                fileChannel = new FileInputStream(file).getChannel();
                abstractInterruptibleChannel = new FileOutputStream(file2).getChannel();
                ((FileChannel)abstractInterruptibleChannel).transferFrom(fileChannel, 0L, fileChannel.size());
                if (fileChannel == null) break block6;
            }
            catch (Throwable throwable) {
                if (fileChannel != null) {
                    fileChannel.close();
                }
                if (abstractInterruptibleChannel != null) {
                    abstractInterruptibleChannel.close();
                }
                throw throwable;
            }
            fileChannel.close();
        }
        if (abstractInterruptibleChannel != null) {
            abstractInterruptibleChannel.close();
            return;
        }
    }

    public static void copyFile(File file, File file2, boolean bl) throws IOException {
        AbstractInterruptibleChannel abstractInterruptibleChannel;
        block8: {
            if (!file2.exists()) {
                file2.createNewFile();
            } else if (bl) {
                file2.delete();
            }
            FileChannel fileChannel = null;
            abstractInterruptibleChannel = null;
            try {
                fileChannel = new FileInputStream(file).getChannel();
                abstractInterruptibleChannel = new FileOutputStream(file2).getChannel();
                ((FileChannel)abstractInterruptibleChannel).transferFrom(fileChannel, 0L, fileChannel.size());
                if (fileChannel == null) break block8;
            }
            catch (Throwable throwable) {
                if (fileChannel != null) {
                    fileChannel.close();
                }
                if (abstractInterruptibleChannel != null) {
                    abstractInterruptibleChannel.close();
                }
                throw throwable;
            }
            fileChannel.close();
        }
        if (abstractInterruptibleChannel != null) {
            abstractInterruptibleChannel.close();
            return;
        }
    }

    public static String oidToHashAlgName(String string) {
        if (string == null) {
            return "";
        }
        if (string.equals("1.3.14.3.2.26")) {
            return DigestAlgorithm.SHA1.name();
        }
        if (string.equals("1.2.840.11359.2.5")) {
            return DigestAlgorithm.MD5.name();
        }
        if (string.equals("2.16.840.1.101.3.4.2.1")) {
            return DigestAlgorithm.SHA256.name();
        }
        return string;
    }

    public static String hashAlgNameToOid(String string) {
        if (string.equalsIgnoreCase("SHA-1") || string.equalsIgnoreCase(Constants.SHA1)) {
            return DigestAlgorithm.SHA1.getId();
        }
        if (string.equalsIgnoreCase("MD5")) {
            return DigestAlgorithm.MD5.getId();
        }
        if (string.equalsIgnoreCase("SHA-256") || string.equalsIgnoreCase(Constants.SHA256)) {
            return DigestAlgorithm.SHA256.getId();
        }
        return string;
    }

    static /* synthetic */ Logger a() {
        return a;
    }
}

