/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import it.actalis.ellips.capi.core.CapiException;
import java.awt.image.BufferedImage;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.Base64;

public class QRCodeUtils {
    public static BufferedImage generateQRCode(String string, int n, int n2) throws CapiException {
        try {
            QRCodeWriter qRCodeWriter = new QRCodeWriter();
            string = qRCodeWriter.encode(string, BarcodeFormat.QR_CODE, n, n2);
            return MatrixToImageWriter.toBufferedImage((BitMatrix)string);
        }
        catch (Exception exception) {
            throw new CapiException(exception.getMessage(), 1003);
        }
    }

    public static BufferedImage generateQRCodeWithEncryptedContents(String string, int n, int n2, byte[] byArray, byte[] byArray2) throws CapiException {
        if (byArray == null || byArray.length != 32) {
            throw new CapiException("Wrong key size", 1003);
        }
        if (byArray2 == null || byArray2.length != 16) {
            throw new CapiException("Wrong initialization vector size", 1003);
        }
        string = QRCodeUtils.a(string, byArray, byArray2);
        return QRCodeUtils.generateQRCode(string, n, n2);
    }

    private static String a(String object, byte[] object2, byte[] byArray) throws CapiException {
        try {
            PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()));
            object2 = new ParametersWithIV((CipherParameters)new KeyParameter(object2), byArray);
            paddedBufferedBlockCipher.init(true, (CipherParameters)object2);
            object = ((String)object).getBytes();
            int n = paddedBufferedBlockCipher.getOutputSize(((Object)object).length);
            byte[] byArray2 = new byte[n];
            int n2 = paddedBufferedBlockCipher.processBytes((byte[])object, 0, ((Object)object).length, byArray2, 0);
            int n3 = paddedBufferedBlockCipher.doFinal(byArray2, n2);
            byte[] byArray3 = new byte[n2 += n3];
            System.arraycopy(byArray2, 0, byArray3, 0, n2);
            return Base64.toBase64String((byte[])byArray3);
        }
        catch (Exception exception) {
            throw new CapiException(exception.getMessage(), 1003);
        }
    }
}

