/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.tsl.CertDb;
import esecurity.tsl.ServiceDbItem;
import esecurity.tsl.TSLServiceTypeIdentifiers;
import esecurity.validator.ValidationDate;
import esecurity.validator.bean.ValidatedCertificate;
import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.x509status.CertificateStatus;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.signature.SignatureLevel;
import it.actalis.ellips.capi.tsl.TSLStatus;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.LinkedList;

public class StepX509Status
extends MultipleValidationSubStepImpl {
    private final DateFormat a = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");

    public StepX509Status() {
        super(ValidationType.CERTIFICATE);
    }

    protected LinkedList<ValidatorMessage> innerChecks(LinkedList<ValidatorMessage> linkedList, ValidationContextParameters validationContextParameters) {
        linkedList = new LinkedList();
        if (validationContextParameters == null || validationContextParameters.getConfig() == null) {
            linkedList.add(new ValidatorMessage(null, MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName()));
            return linkedList;
        }
        if (validationContextParameters.getSignerCertificate() == null) {
            linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName()));
            return linkedList;
        }
        try {
            if (validationContextParameters.getLevelValidation() == null || validationContextParameters.getLevelValidation().getLevel() != SignatureLevel.LT && validationContextParameters.getLevelValidation().getLevel() != SignatureLevel.LTA) {
                ValidatedCertificate validatedCertificate = validationContextParameters.getSignerCertificate();
                Object object = validationContextParameters.getCalculatedValidationDate();
                object = validationContextParameters.getValidator().getStatusService().checkStatus(validatedCertificate.getCert(), (ValidationDate)object);
                ((CertificateStatus)object).applyToValidate(validatedCertificate);
                if (!"NOT FOUND".equals(validatedCertificate.getCrlStatus())) {
                    if (validatedCertificate.getCrlBean() == null) {
                        linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0017_OCSP_USED_FOR_CERT_VALIDATION, new Object[0]));
                    } else {
                        linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0018_CRL_USED_FOR_CERT_VALIDATION, new Object[0]));
                    }
                }
                this.a.setTimeZone(validationContextParameters.getTimeZone());
                if (validatedCertificate.isCertRevoked()) {
                    object = this.a.format(validatedCertificate.getRevocationDate());
                    if (validatedCertificate.getRevocationReason().equalsIgnoreCase("6")) {
                        linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0006_CERT_SUSPENDED, object));
                        linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0014_CERT_VALIDATION_TO_DATE, new Object[0]));
                    } else {
                        linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0007_CERT_REVOKED, object));
                        linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0014_CERT_VALIDATION_TO_DATE, new Object[0]));
                    }
                }
                if (!(validatedCertificate.getCertIssuer() == null || validatedCertificate.isCertValid() || validatedCertificate.isCertRevoked() || validatedCertificate.getCrlStatus().equalsIgnoreCase("VALID") || validatedCertificate.getCrlStatus().equalsIgnoreCase("VERIFIED SIGNATURE"))) {
                    StepX509Status.a(validatedCertificate.getCert(), validationContextParameters, linkedList);
                }
            }
            if (validationContextParameters.getSignerCertificate().getCert().isRsVerified()) {
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0015_CERT_VERIFIED, new Object[0]));
            }
        }
        catch (Exception exception) {
            linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName()));
        }
        return linkedList;
    }

    private static void a(Certificate iterator, ValidationContextParameters validationContextParameters, LinkedList<ValidatorMessage> linkedList) {
        Object object = validationContextParameters.getCertDB();
        boolean bl = ((CertDb)object).containsCertificate((Certificate)((Object)iterator));
        if (bl) {
            iterator = ((CertDb)object).queryServiceItems((Certificate)((Object)iterator));
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (TSLServiceTypeIdentifiers.SignerCertificate.equals((Object)((ServiceDbItem)object).getServiceType()) || TSLServiceTypeIdentifiers.Fea.equals((Object)((ServiceDbItem)object).getServiceType()) || TSLServiceTypeIdentifiers.User.equals((Object)((ServiceDbItem)object).getServiceType()) || TSLServiceTypeIdentifiers.CaIssuer.equals((Object)((ServiceDbItem)object).getServiceType()) || TSLStatus.isStatusIn(TSLStatus.StatusGroup.UNTRUSTED, ((ServiceDbItem)object).getServiceStatus()) || TSLStatus.isStatusIn(TSLStatus.StatusGroup.REMOVED, ((ServiceDbItem)object).getServiceStatus())) continue;
                return;
            }
        }
        if (validationContextParameters.getSignature() != null && validationContextParameters.getSignature().getFormat() != null && validationContextParameters.getSignature().getFormat().equals((Object)SignatureFormat.TST)) {
            linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0004_TSACERT_STATUS_UNKNOWN, new Object[0]));
            linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0005_TSACERT_STATUS_TEMP_UNAVAIABLE, new Object[0]));
            return;
        }
        linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0001_STATUS_UNKNOWN, new Object[0]));
        linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0002_STATUS_TEMP_UNAVAIABLE, new Object[0]));
    }
}

