/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.parser.utils;

import esecurity.validator.bean.ParsedTransientDocument;
import esecurity.validator.bean.TransientDocument;
import esecurity.validator.parser.SignatureParser;
import esecurity.validator.parser.SignatureParserBuilder;
import esecurity.validator.parser.utils.EventHandlerSelector;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.exception.ParsingException;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.util.TimeZone;
import org.slf4j.Logger;

public class ParserUtils {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static TransientDocument parseDoc(InputHandler inputHandler, EventHandlerSelector eventHandlerSelector, NetworkConfig networkConfig) {
        return ParserUtils.parseDoc(inputHandler, eventHandlerSelector, networkConfig, Constants.DEFAULT_TIMEZONE);
    }

    public static TransientDocument parseDoc(InputHandler inputHandler, EventHandlerSelector eventHandlerSelector, NetworkConfig networkConfig, TimeZone timeZone) {
        return ParserUtils.parseDoc(inputHandler, eventHandlerSelector, networkConfig, timeZone, null);
    }

    public static TransientDocument parseDoc(InputHandler inputHandler, EventHandlerSelector eventHandlerSelector, NetworkConfig networkConfig, TimeZone timeZone, File file) {
        ParsedTransientDocument parsedTransientDocument = null;
        SignatureParser signatureParser = SignatureParserBuilder.findParser(inputHandler);
        boolean bl = false;
        if (signatureParser != null) {
            if (signatureParser.isInvalidFormat()) {
                bl = true;
            } else {
                try {
                    parsedTransientDocument = signatureParser.parse(inputHandler, eventHandlerSelector, networkConfig, timeZone, file);
                }
                catch (ParsingException parsingException) {
                    bl = true;
                    a.error("some errors parsing the file:" + parsingException.getMessage());
                }
            }
        }
        if (parsedTransientDocument == null) {
            parsedTransientDocument = new ParsedTransientDocument(inputHandler);
            parsedTransientDocument.setSigned(false);
            parsedTransientDocument.setInvalidFormat(bl);
        }
        return parsedTransientDocument;
    }
}

