/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.bean;

import com.fasterxml.jackson.annotation.JsonIgnore;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

public abstract class ValidatedBean {
    protected LinkedList<ValidatorMessage> messages = new LinkedList();

    public LinkedList<ValidatorMessage> getMessages() {
        return this.messages;
    }

    public void setMessages(LinkedList<ValidatorMessage> linkedList) {
        for (int i = 0; i < linkedList.size(); ++i) {
            this.addMessage(linkedList.get(i));
        }
    }

    @JsonIgnore
    public void addMessage(ValidatorMessage validatorMessage) {
        if (!this.messages.contains(validatorMessage)) {
            this.messages.add(validatorMessage);
        }
    }

    public boolean isValid() {
        boolean bl = true;
        for (ValidatorMessage validatorMessage : this.messages) {
            if (validatorMessage.getLevel() != MessageLevel.ERROR) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean hasBeanWarnings() {
        boolean bl = false;
        for (ValidatorMessage validatorMessage : this.messages) {
            if (validatorMessage.getLevel() != MessageLevel.WARNING) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean hasMessage(ValidatorMessageEnum validatorMessageEnum) {
        return this.hasMessage(validatorMessageEnum.getCode());
    }

    protected boolean hasMessage(String string) {
        boolean bl = false;
        for (ValidatorMessage validatorMessage : this.messages) {
            if (!validatorMessage.getMessageCode().equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String getMessageByCode(ValidatorMessageEnum validatorMessageEnum) {
        String string = null;
        for (ValidatorMessage validatorMessage : this.messages) {
            if (!validatorMessage.getMessageCode().equals(validatorMessageEnum.getCode())) continue;
            string = validatorMessage.getMessage();
            break;
        }
        return string;
    }
}

