/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.tsl.rootupdater;

import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.util.TmpFileUtils;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.utils.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;

public class TSLCache {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private File b;
    private boolean c = false;

    public void setCacheFolder(String string) {
        if (Util.isNullOrEmpty(string)) {
            return;
        }
        this.b = new File(string);
        if (this.b.mkdirs()) {
            this.c = true;
            return;
        }
        this.c = this.b.exists();
    }

    public String getCacheFolder() {
        if (!this.c) {
            return null;
        }
        return this.b.getAbsolutePath();
    }

    public void archiveTSL(String string, InputHandler object) throws FileNotFoundException, NoSuchAlgorithmException, IOException {
        File file;
        if (!this.c) {
            return;
        }
        Object object2 = this.getLastArchivedTSL(string);
        object = TSLCache.a((InputHandler)object);
        if (object2 != null && FileUtils.areIdenticalFile((File)object, (File)object2)) {
            return;
        }
        String string2 = string;
        object2 = this;
        if (!((TSLCache)object2).c) {
            file = null;
        } else {
            int n = 1;
            Object[] objectArray = new Object[2];
            objectArray[0] = string2;
            ++n;
            objectArray[1] = 1;
            File file2 = new File(((TSLCache)object2).b + File.separator + String.format("%s-%05d.xml", objectArray));
            while (file2.exists()) {
                file2 = new File(((TSLCache)object2).b + File.separator + String.format("%s-%05d.xml", string2, n++));
            }
            file = file2;
        }
        object2 = file;
        Files.copy(((File)object).toPath(), ((File)object2).toPath(), StandardCopyOption.REPLACE_EXISTING);
        a.info("TSL {} was archived to {}", (Object)string, (Object)((File)object2).getAbsolutePath());
    }

    private static File a(InputHandler closeable) throws IOException {
        closeable = ((InputHandler)closeable).getInputAsNewStream();
        it.actalis.ellips.util.File file = TmpFileUtils.createTempFile("tsl_", ".xml");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            int n;
            byte[] byArray = new byte[4096];
            while ((n = ((InputStream)closeable).read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            Util.closeQuietly(closeable);
            Util.closeQuietly(fileOutputStream);
        }
        return file;
    }

    public File getLastArchivedTSL(String string) {
        if (!this.c) {
            return null;
        }
        int n = 1;
        File file = null;
        File file2 = new File(this.b + File.separator + String.format("%s-%05d.xml", string, 1));
        while (file2.exists()) {
            file = file2;
            file2 = new File(this.b + File.separator + String.format("%s-%05d.xml", string, ++n));
        }
        return file;
    }
}

