/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.datahandlers.outputs;

import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.DataHandler;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;

public abstract class OutputHandler
extends DataHandler
implements Closeable,
Flushable {
    protected ProxyOutputStreamHandler proxyOutputStream = null;
    protected Long writtenSize = 0L;
    protected OutputStream outputStream = null;
    protected boolean isInit = false;
    protected boolean closed = false;

    public Long getWrittenSize() {
        return this.writtenSize;
    }

    public boolean isSizeConstrained() {
        return this.totalSize != null;
    }

    public boolean isFull() {
        return this.totalSize != null && this.writtenSize >= this.totalSize;
    }

    public void write(int n) throws IOException {
        this.throwExIfNecessary(1);
        this.a();
        this.outputStream.write(n);
        OutputHandler outputHandler = this;
        this.writtenSize = outputHandler.writtenSize + 1L;
    }

    public void write(byte[] byArray) throws IOException {
        this.throwExIfNecessary(byArray.length);
        this.a();
        this.outputStream.write(byArray);
        OutputHandler outputHandler = this;
        this.writtenSize = outputHandler.writtenSize + (long)byArray.length;
    }

    public void write(byte[] object, int n, int n2) throws IOException {
        this.throwExIfNecessary(n2);
        this.a();
        this.outputStream.write((byte[])object, n, n2);
        object = this;
        this.writtenSize = object.writtenSize + (long)n2;
    }

    private void a() throws IOException {
        if (!this.isInit) {
            this.isInit = true;
            this.initBeforeFirstWrite();
        }
    }

    protected void initBeforeFirstWrite() throws IOException {
    }

    protected void finalizeBeforeClosing() throws IOException {
    }

    protected void throwExIfNecessary(int n) throws IOException {
        if (this.totalSize != null && this.writtenSize + (long)n > this.totalSize) {
            throw new IOException("Unable to write " + n + " byte(s) because specified final size is " + this.totalSize + " and actual written size is " + this.writtenSize + ".");
        }
    }

    public OutputStream getAsOutputStream() throws IOException {
        if (!this.closed) {
            if (this.proxyOutputStream == null) {
                this.proxyOutputStream = new ProxyOutputStreamHandler(this);
            }
            return this.proxyOutputStream;
        }
        throw new IOException("Handler is Closed");
    }

    @Override
    public void flush() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.flush();
            this.finalizeBeforeClosing();
            Util.closeQuietly(this.outputStream);
            this.proxyOutputStream = null;
            this.closed = true;
        }
    }

    public class ProxyOutputStreamHandler
    extends OutputStream {
        private /* synthetic */ OutputHandler a;

        public ProxyOutputStreamHandler(OutputHandler outputHandler) {
            this.a = outputHandler;
        }

        @Override
        public void write(int n) throws IOException {
            this.a.write(n);
        }

        @Override
        public void close() throws IOException {
            this.a.close();
        }

        @Override
        public void flush() throws IOException {
            this.a.flush();
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.a.write(byArray, n, n2);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.a.write(byArray);
        }
    }
}

