/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.core.qc;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.qc.PkixQCSyntaxv1;
import it.actalis.ellips.capi.core.qc.PkixQCSyntaxv2;
import it.actalis.ellips.capi.core.qc.QcEuCompliance;
import it.actalis.ellips.capi.core.qc.QcEuLimitValue;
import it.actalis.ellips.capi.core.qc.QcEuRetentionPeriod;
import it.actalis.ellips.capi.core.qc.QcPDS;
import it.actalis.ellips.capi.core.qc.QcSSCD;
import it.actalis.ellips.capi.core.qc.QcSimple;
import it.actalis.ellips.capi.core.qc.QcStatements;
import it.actalis.ellips.capi.core.qc.QcType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public abstract class QcStatement {
    protected String oid;
    protected ASN1Encodable info;

    public QcStatement(String string, ASN1Encodable aSN1Encodable) {
        this.oid = string;
        this.info = aSN1Encodable;
    }

    public static QcStatement getInstance(String string, ASN1Encodable aSN1Encodable) throws CapiException {
        QcStatements qcStatements = QcStatements.retrieveByID(new ASN1ObjectIdentifier(string));
        if (qcStatements == null) {
            return QcStatement.a(null, string, aSN1Encodable);
        }
        return QcStatement.a(qcStatements, null, aSN1Encodable);
    }

    public static QcStatement getInstance(QcStatements qcStatements, ASN1Encodable aSN1Encodable) throws CapiException {
        return QcStatement.a(qcStatements, null, aSN1Encodable);
    }

    private static QcStatement a(QcStatements qcStatements, String string, ASN1Encodable aSN1Encodable) throws CapiException {
        if (qcStatements != null) {
            switch (qcStatements) {
                case QcEuCompliance: {
                    return new QcEuCompliance(aSN1Encodable);
                }
                case QcEuLimitValue: {
                    return new QcEuLimitValue(aSN1Encodable);
                }
                case QcEuRetentionPeriod: {
                    return new QcEuRetentionPeriod(aSN1Encodable);
                }
                case QcSSCD: {
                    return new QcSSCD(aSN1Encodable);
                }
                case PkixQCSyntaxv1: {
                    return new PkixQCSyntaxv1(aSN1Encodable);
                }
                case PkixQCSyntaxv2: {
                    return new PkixQCSyntaxv2(aSN1Encodable);
                }
                case QcPDS: {
                    return new QcPDS(aSN1Encodable);
                }
                case QcType: {
                    return new QcType(aSN1Encodable);
                }
            }
        } else {
            return new QcSimple(string, aSN1Encodable);
        }
        throw new CapiException("Unable to generate Qc", 1003);
    }
}

