/*
 * Decompiled with CFR 0.152.
 */
package esecurity.tsl.sqllite;

import esecurity.tsl.sqllite.ManifestSigner;
import it.actalis.ellips.capi.core.CapiError;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.provider.ActalisKeyStoreParameters;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;

public class TokenManifestSigner
implements ManifestSigner {
    private KeyStore keystore;
    Signature sigActa;
    PrivateKey key;
    Certificate cert;

    public TokenManifestSigner(TokenSpi enumeration, String string) throws CapiException {
        try {
            this.keystore = KeyStore.getInstance("ActalisKeyStore", ProvUtils.actalisProvider);
            enumeration = new ActalisKeyStoreParameters((TokenSpi)((Object)enumeration));
            this.keystore.load((KeyStore.LoadStoreParameter)((Object)enumeration));
            enumeration = this.keystore.aliases();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement();
                if (!this.keystore.isKeyEntry(string2)) continue;
                this.key = (PrivateKey)this.keystore.getKey(string2, string.toCharArray());
                this.cert = new Certificate(this.keystore.getCertificate(string2).getEncoded());
            }
            if (this.key == null) {
                throw new CapiException("No key Avaiable", 1003);
            }
            return;
        }
        catch (Exception exception) {
            throw new CapiException("Unable to use Token", 1003, exception);
        }
    }

    @Override
    public Certificate getSigner() {
        return this.cert;
    }

    @Override
    public void init() {
        try {
            this.sigActa = Signature.getInstance("SHA256WithRSAEncryption", ProvUtils.actalisProvider);
            this.sigActa.initSign(this.key);
            return;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
            throw new CapiError("Capi Signature Error", 1003);
        }
    }

    @Override
    public void update(byte[] byArray) {
        try {
            this.sigActa.update(byArray);
            return;
        }
        catch (SignatureException signatureException) {
            throw new CapiError("Capi Signature Error", 1003);
        }
    }

    @Override
    public byte[] sign() {
        try {
            return this.sigActa.sign();
        }
        catch (SignatureException signatureException) {
            throw new CapiError("Capi Signature Error", 1003);
        }
    }
}

