/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.rs;

import esecurity.enroll.bean.GeneralNames;
import esecurity.enroll.constants.KeyAlgo;
import esecurity.enroll.constants.KeyType;
import esecurity.oss.bean.ClientCredentials;
import esecurity.oss.bean.FeaCertificate;
import esecurity.oss.bean.InputParams;
import esecurity.oss.bean.ListFeaCertificateRequest;
import esecurity.oss.bean.SignDocRequest;
import esecurity.oss.client.OSSFERestProxy;
import esecurity.oss.enumerators.ParamsEnum;
import it.actalis.ellips.capi.core.Actalis_PrivateKey;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.ExtendedCredentials;
import it.actalis.ellips.capi.core.SessionCredentials;
import it.actalis.ellips.capi.core.TokenParameters;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.ArubaTrustStore;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.rs.FeaInitializeParameters;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.util.logging.Level;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;

public class FeaSignatureToken
extends TokenSpi {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final String TOKEN_RS = "RemoteSignatureToken";
    private String b = "";
    private String c;
    private String d;
    private String e;
    private String f;
    private static NetworkConfig g = new NetworkConfig();
    private UrlClient h = null;
    private OSSFERestProxy i = null;
    private FeaCertificate[] j = null;
    private String k = null;
    private boolean l = false;
    private URLCredentials m = null;

    public FeaSignatureToken() {
    }

    public FeaSignatureToken(Logger logger, URLCredentials uRLCredentials) {
        if (logger != null) {
            a = logger;
        }
        this.m = uRLCredentials;
    }

    private static String a(String[] stringArray, int n) {
        if (stringArray.length < n + 1 || stringArray[n] == null) {
            return null;
        }
        return stringArray[n];
    }

    private void a() throws CapiException {
        ClientCredentials clientCredentials = new ClientCredentials();
        clientCredentials.setClientuser(this.c);
        if (this.d != null && !this.d.equals("")) {
            clientCredentials.setClientpwd(this.d);
        }
        this.h = new UrlClient(g, a);
        this.i = new OSSFERestProxy(a, this.h, this.m, ArubaTrustStore.getTSRS(), true);
        ListFeaCertificateRequest listFeaCertificateRequest = new ListFeaCertificateRequest();
        listFeaCertificateRequest.setCredentials(clientCredentials);
        listFeaCertificateRequest.setTransactionid(this.k);
        try {
            clientCredentials = this.i.listCerts(this.b, listFeaCertificateRequest);
            if (clientCredentials == null || clientCredentials.getCode() == null) {
                a.error("Empty Response");
                throw new CapiException("Network Error", -2147483136);
            }
            clientCredentials.getCode().equals("0000");
            this.j = clientCredentials.getFeaCerts();
            return;
        }
        catch (IOException iOException) {
            this.j = new FeaCertificate[0];
            java.util.logging.Logger.getLogger(FeaSignatureToken.class.getName()).log(Level.SEVERE, null, iOException);
            return;
        }
    }

    public void initializeLib(String[] stringArray) throws CapiException {
        if (stringArray == null || stringArray.length < 5 || stringArray[0] == null || stringArray[1] == null || stringArray[3] == null || stringArray[4] == null || stringArray[5] == null && (stringArray[7] == null || stringArray[8] == null || stringArray[9] == null)) {
            throw new CapiException("Wrong args", 1001);
        }
        try {
            this.b = FeaSignatureToken.a(stringArray, 0);
            if (Util.isNullOrEmpty((String)this.b)) {
                throw new CapiException("Empty URL: \"" + stringArray[0] + "\"", 1002);
            }
            new URL(this.b);
            a.debug("Selected url: " + this.b);
        }
        catch (MalformedURLException malformedURLException) {
            throw new CapiException("Not valid URL: \"" + stringArray[0] + "\"", 1002);
        }
        this.c = FeaSignatureToken.a(stringArray, 1);
        if (Util.isNullOrEmpty((String)this.c)) {
            throw new CapiException("Wrong Username", 1002);
        }
        this.d = FeaSignatureToken.a(stringArray, 2);
        if (Util.isNullOrEmpty((String)this.d)) {
            throw new CapiException("Wrong Password", 1002);
        }
        this.k = FeaSignatureToken.a(stringArray, 3);
        this.e = FeaSignatureToken.a(stringArray, 4);
        this.f = FeaSignatureToken.a(stringArray, 5);
        this.l = FeaSignatureToken.a(stringArray, 6) != null ? FeaSignatureToken.a(stringArray, 6).equalsIgnoreCase("true") : false;
        this.a();
    }

    public void initializeLib(String[] stringArray, boolean bl) throws CapiException {
        a.debug("initializeLib() with tokenSoftSia parameter");
        this.initializeLib(stringArray);
    }

    public void initializeLib(TokenParameters tokenParameters) throws CapiException {
        if (!(tokenParameters instanceof FeaInitializeParameters)) {
            throw new CapiException("Wrong args", 1001);
        }
        try {
            this.b = ((FeaInitializeParameters)tokenParameters).getServiceUrl();
            if (Util.isNullOrEmpty((String)this.b)) {
                throw new CapiException("Empty URL: \"" + ((FeaInitializeParameters)tokenParameters).getServiceUrl() + "\"", 1002);
            }
            new URL(this.b);
            a.debug("Selected url: " + this.b);
        }
        catch (MalformedURLException malformedURLException) {
            throw new CapiException("Not valid URL: \"" + ((FeaInitializeParameters)tokenParameters).getServiceUrl() + "\"", 1002);
        }
        this.c = ((FeaInitializeParameters)tokenParameters).getUsername();
        if (Util.isNullOrEmpty((String)this.c)) {
            throw new CapiException("Wrong Username", 1002);
        }
        this.d = ((FeaInitializeParameters)tokenParameters).getPassword();
        if (Util.isNullOrEmpty((String)this.d)) {
            throw new CapiException("Wrong Password", 1002);
        }
        this.k = ((FeaInitializeParameters)tokenParameters).getTransactionId();
        this.e = ((FeaInitializeParameters)tokenParameters).getOtp();
        this.f = ((FeaInitializeParameters)tokenParameters).getVerifiedSession();
        this.l = ((FeaInitializeParameters)tokenParameters).isSuspendAfterSign();
        this.a();
    }

    public void finalizeLib() {
        try {
            this.closeSession();
            return;
        }
        catch (CapiException capiException) {
            a.debug("Error closing session: " + capiException.getMessage());
            return;
        }
    }

    public String[] getLibInfo() {
        String string = "FEA Signature";
        String string2 = "";
        String string3 = "Ellips FEA Signature Token";
        String string4 = "1.0";
        String string5 = "Actalis S.p.A.";
        String string6 = "";
        String string7 = "Actalis S.p.A.";
        String string8 = "";
        String string9 = "Actalis S.p.A.";
        return new String[]{string, string2, string3, string4, string5, string6, string7, string8, string9};
    }

    public String getLibName() {
        return null;
    }

    public boolean isTokenInserted() throws CapiException {
        return true;
    }

    public String getLabel() throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    public String getSerialNumber() throws CapiException {
        return "0";
    }

    public long getFreeSpace() throws CapiException {
        return -1L;
    }

    public void changePIN(String string, String string2) throws CapiException {
        throw new CapiException("Remote Signature doesn't support PIN changing", 1004);
    }

    public void changePUK(String string, String string2) throws CapiException {
        throw new CapiException("Remote Signature doesn't support PUK changing", 1004);
    }

    public long getMaxRSAKeyLength() throws CapiException {
        return 2048L;
    }

    public long getMinRSAKeyLength() throws CapiException {
        return 768L;
    }

    public void unblockPIN(String string, String string2) throws CapiException {
        throw new CapiException("Remote Signature doesn't support unblocking", 1004);
    }

    public long getMaxPINLen() throws CapiException {
        return 100L;
    }

    public long getMinPINLen() throws CapiException {
        return 0L;
    }

    public void openSession(boolean bl, String string) throws CapiException {
        throw new CapiException("openSession not supported", 1004);
    }

    public void openSession(boolean bl, String string, int n) throws CapiException {
        throw new CapiException("openSession not supported with slot information", 1004);
    }

    public void openSessionAuthPath(boolean bl) throws CapiException {
        throw new CapiException("authentication path not supported", 1004);
    }

    public void openPublicSession() throws CapiException {
    }

    public void closeSession() throws CapiException {
        a.debug("Closing session");
        this.j = null;
        this.k = null;
    }

    public boolean isSessionOpen() throws CapiException {
        return !Util.isNullOrEmpty((String)this.k);
    }

    public byte[] getData(String string) throws CapiException {
        throw new CapiException("Remote Signature doesn't support exporting certificates", 1004);
    }

    public void setData(String string, byte[] byArray, int n) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing genric data", 1004);
    }

    public String getCert(String string) throws CapiException {
        if (string == null || this.j == null || this.j.length == 0) {
            return null;
        }
        FeaCertificate[] feaCertificateArray = this.j;
        int n = this.j.length;
        for (int i = 0; i < n; ++i) {
            FeaCertificate feaCertificate = feaCertificateArray[i];
            if (!feaCertificate.getAlias().equals(string)) continue;
            return new String(Base64.encode((byte[])feaCertificate.getCertificate()));
        }
        return null;
    }

    public void setCert(String string, byte[] byArray, int n, boolean bl) throws CapiException {
        throw new CapiException("Remote Signature doesn't support setting certificates into the token", 1004);
    }

    public String installCertificate(Certificate certificate) throws CapiException {
        throw new CapiException("Remote Signature doesn't support install certificates into the token", 1004);
    }

    public boolean canImport() {
        return false;
    }

    public boolean canExport(String string) {
        return false;
    }

    public int canUnblock() {
        return 0;
    }

    public void genKeyPair(String string, int n, int n2, int n3) throws CapiException {
        throw new CapiException("Remote Signature doesn't support generating key pair", 1004);
    }

    public void genKeyPair(String string, KeyAlgo keyAlgo, int n, int n2, int n3) throws CapiException {
        throw new CapiException("Remote Signature doesn't support generating key pair", 1004);
    }

    public String impCred(String string, PrivateKey privateKey, int n, int n2) throws CapiException {
        throw new CapiException("Remote Signature doesn't support importing credentials", 1004);
    }

    public PrivateKey expCred(String string) throws CapiException {
        throw new CapiException("Remote Signature doesn't support exporting a PrivateKey", 1004);
    }

    public PublicKey getPublicKey(String string) throws CapiException {
        if (this.j == null || this.j.length <= 0) {
            return null;
        }
        if (string == null) {
            return null;
        }
        FeaCertificate[] feaCertificateArray = this.j;
        int n = this.j.length;
        for (int i = 0; i < n; ++i) {
            FeaCertificate feaCertificate = feaCertificateArray[i];
            if (!string.equals(feaCertificate.getAlias())) continue;
            string = new Certificate(feaCertificate.getCertificate());
            return string.getPublicKey();
        }
        return null;
    }

    public PrivateKey getPrivateKey(String string) throws CapiException {
        if (this.j == null || this.j.length <= 0) {
            return null;
        }
        Actalis_PrivateKey actalis_PrivateKey = new Actalis_PrivateKey(string);
        actalis_PrivateKey.setCryptoDev((TokenSpi)this);
        actalis_PrivateKey.setPublicInfo(this.getPublicKey(string));
        return actalis_PrivateKey;
    }

    public void instCert(String string, Certificate certificate, boolean bl, boolean bl2) throws CapiException {
        throw new CapiException("Remote Signature doesn't support installing certificates", 1004);
    }

    public int getKeyUsage(String string, boolean bl) throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    public int getKeyLength(String string) throws CapiException {
        throw new CapiException("Remote Signature doesn't support retrieving key's information", 1004);
    }

    public byte[] doSign(byte[] object, String string, int n) throws CapiException {
        try {
            a.debug("mode:" + n);
            a.debug("DigestInfo:" + new String(Base64.encode((byte[])object)));
            a.debug("alias:" + string);
            object = ASN1Sequence.getInstance((Object)object);
            object = new DigestInfo((ASN1Sequence)object);
            a.debug("digest:" + new String(Base64.encode((byte[])object.getDigest())));
            string = new SignDocRequest();
            InputParams[] inputParamsArray = new ClientCredentials();
            inputParamsArray.setClientuser(this.c);
            inputParamsArray.setClientpwd(this.d);
            string.setCredentials((ClientCredentials)inputParamsArray);
            string.setTransactionid(this.k);
            string.setSuspendAfterSign(this.l);
            inputParamsArray = new InputParams();
            if (this.e != null && !"".equals(this.e)) {
                inputParamsArray.setName(ParamsEnum.OTP);
                inputParamsArray.setValue(this.e);
            } else {
                inputParamsArray.setName(ParamsEnum.VERIFIEDSESSION);
                inputParamsArray.setValue(this.f);
            }
            inputParamsArray = new InputParams[]{inputParamsArray};
            string.setParams(inputParamsArray);
            string.setDocumenthash(object.getDigest());
            object = this.i.signDoc(this.b, (SignDocRequest)string);
            a.debug("return_code" + object.getCode());
            if (object.getCode().equals("0000")) {
                return object.getSignedhash();
            }
            if (object.getCode().equals("0003")) {
                throw new CapiException("Invalid OTP", 2014);
            }
            if (object.getCode().equals("1030")) {
                throw new CapiException("Max Signed Reached", 10040);
            }
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
        }
        return null;
    }

    public byte[] doDecrypt(byte[] byArray, String string, int n) throws CapiException {
        throw new CapiException("Remote Signature doesn't support the Decrypt functionality", 1004);
    }

    public String[] listObjects(String string, byte by) throws CapiException {
        if (this.j == null) {
            throw new CapiException("Session not opened", 10013);
        }
        try {
            String[] stringArray = new String[this.j.length];
            if (this.j.length == 0) {
                return stringArray;
            }
            int n = 0;
            Object[] objectArray = this.j;
            int n2 = this.j.length;
            for (int i = 0; i < n2; ++i) {
                Object object = objectArray[i];
                if ((this.getObjectType((String)(object = object.getAlias())) & by) == 0 || string != null && ((String)object).indexOf(string) < 0) continue;
                stringArray[n] = object;
                ++n;
            }
            if (n == 0) {
                return new String[0];
            }
            objectArray = new String[n];
            for (n2 = 0; n2 < n; ++n2) {
                objectArray[n2] = stringArray[n2];
            }
            return objectArray;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 10040);
        }
    }

    public void deleteObject(String string) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    public byte getObjectType(String string) throws CapiException {
        return 2;
    }

    public String getObjectID(String string) throws CapiException {
        return string;
    }

    public int getObjectSize(String string) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    public void renameObject(String string, String string2, int n) throws CapiException {
        throw new CapiException("Remote Signature doesn't support storing objects", 1004);
    }

    public void setCert(String string, Certificate certificate, int n, byte[] byArray, boolean bl) throws CapiException {
    }

    public void setCkaId(String string, String string2, byte[] byArray) throws CapiException {
    }

    public boolean exist(String string) throws CapiException {
        for (String string2 : this.listObjects(null, (byte)2)) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public String generateID(String[] stringArray) {
        return FeaSignatureToken.a(stringArray, 2) + "@" + FeaSignatureToken.a(stringArray, 3);
    }

    public boolean requiredExtendedAuth() {
        return false;
    }

    public SessionCredentials openSessionWithExtendedAuth(boolean bl, String string, ExtendedCredentials extendedCredentials) throws CapiException {
        return null;
    }

    public void resetToken(String string) throws CapiException {
    }

    public String certReq(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey, Provider provider) throws CapiException {
        return null;
    }

    public byte[] generateCertificateRequest(KeyType keyType, KeyAlgo keyAlgo, int n, String string, GeneralNames[] generalNamesArray, String string2) throws CapiException {
        return new byte[0];
    }

    public static void setDefaultNetworkConfig(NetworkConfig networkConfig) {
        g = networkConfig;
    }

    public String getSelected_url() {
        return this.b;
    }

    public void setSelected_url(String string) {
        this.b = string;
    }

    public String certReq(String string, X500Name x500Name) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String certReq(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey, String string) throws CapiException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CertificationRequest generatePKCS10CertificationRequest(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

