/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.http.arubautils.rest;

import it.actalis.ellips.capi.http.arubautils.HttpClient;
import it.actalis.ellips.capi.http.arubautils.RequestData;
import it.actalis.ellips.capi.http.arubautils.URLCredentials;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.arubautils.UrlReturn;
import it.actalis.ellips.capi.http.arubautils.rest.RestClientRequest;
import it.actalis.ellips.capi.http.arubautils.rest.RestResponse;
import java.security.KeyStore;
import org.slf4j.Logger;

public class RestClient
extends HttpClient<RestClientRequest, RestResponse> {
    boolean debug = false;

    public RestClient(UrlClient client, KeyStore cdb, boolean ignorecert) {
        super(client, cdb, ignorecert);
    }

    public RestClient(UrlClient client, KeyStore store, boolean ignorecert, Logger logger) {
        super(client, store, ignorecert, logger);
    }

    protected RestResponse buildEmptyResponse() {
        return new RestResponse();
    }

    protected RequestData buildRequestData(RestClientRequest request) {
        RequestData data = new RequestData();
        data.setParam(request.getParameters());
        String method = request.getMethod();
        if ("POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method)) {
            data.setType(request.getType());
            if (request.getBody() != null) {
                data.setPostStream(request.getBody());
            }
        }
        return data;
    }

    @Deprecated
    public String sendJson(String url, String value, URLCredentials cred) {
        String strReturn = "";
        try {
            UrlReturn ret;
            RequestData rdata = new RequestData();
            rdata.setPostdata(value.getBytes("UTF8"));
            rdata.setType("JSON");
            if (this.debug) {
                this.logger.debug(value);
            }
            if ((ret = this.client.downloadUrl(url, rdata, cred)).getStatus().startsWith("OK")) {
                strReturn = new String(ret.getData());
            } else {
                this.logger.error(ret.getStatusMessage());
            }
        }
        catch (Exception ex) {
            this.logger.info(ex.getMessage());
        }
        return strReturn;
    }

    @Deprecated
    public byte[] sendJsonByte(String url, byte[] value, URLCredentials cred) {
        byte[] arrReturn = null;
        try {
            UrlReturn ret;
            RequestData rdata = new RequestData();
            rdata.setPostdata(value);
            rdata.setType("JSON");
            if (this.debug) {
                this.logger.debug(new String(value, "UTF-8"));
            }
            if ((ret = this.client.downloadUrl(url, rdata, cred)).getStatus().startsWith("OK")) {
                arrReturn = ret.getData();
            } else {
                this.logger.error(ret.getStatusMessage());
            }
        }
        catch (Exception ex) {
            this.logger.info(ex.getMessage());
        }
        return arrReturn;
    }

    @Deprecated
    public RestResponse sendRawJson(String url, byte[] value, URLCredentials cred) {
        RestResponse response = new RestResponse();
        try {
            RequestData rdata = new RequestData();
            rdata.setPostdata(value);
            rdata.setType("JSON");
            if (this.debug) {
                this.logger.debug(new String(value, "UTF-8"));
            }
            UrlReturn ret = this.client.downloadUrl(url, rdata, cred);
            response.setStatus(ret.getStatus());
            response.setMessage(ret.getStatusMessage());
            if (ret.getStatus().startsWith("OK")) {
                response.setResponseData(ret.getData());
            } else {
                this.logger.error(ret.getStatusMessage());
                if (ret.getErrordata() != null) {
                    response.setErrorData(ret.getErrordata());
                }
            }
        }
        catch (Exception ex) {
            this.logger.info(ex.getMessage());
            response.setStatus("KO");
            response.setMessage(ex.getMessage());
        }
        return response;
    }
}

