/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dsd.core.auth.hashes;

import esecurity.dsd.core.Log;
import esecurity.dsd.core.auth.HashGenerator;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Sha256Generator
implements HashGenerator {
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA256";
    private String salt;

    private static String bytesToHex(byte[] hash) {
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(0xFF & hash[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    @Override
    public String hash(String unsecured) {
        SecretKeySpec signingKey = new SecretKeySpec(this.salt.getBytes(), HMAC_SHA1_ALGORITHM);
        try {
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(signingKey);
            return Sha256Generator.bytesToHex(mac.doFinal(unsecured.getBytes()));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            Log.logger().error("Error in secure hash function: ".concat(e.getMessage()));
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public void setSalt(String salt) {
        this.salt = salt;
    }
}

