/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.utils;

import esecurity.crypto.gui.model.signer.Signer;
import esecurity.crypto.gui.properties.AppProperties;
import esecurity.crypto.gui.properties.ClientProperties;
import esecurity.crypto.gui.properties.NetworkProperties;
import esecurity.crypto.gui.properties.UserProperties;
import esecurity.crypto.gui.service.i18n.I18N;
import esecurity.desktop.FileDialog;
import esecurity.desktop.View;
import esecurity.validator.ValidatorConfig;
import it.actalis.ellips.capi.cms.encrypt.EncryptEnvelopeGenerator;
import it.actalis.ellips.capi.cms.encrypt.EncryptEnvelopeOptions;
import it.actalis.ellips.capi.cms.encrypt.EncryptionAlgorithm;
import it.actalis.ellips.capi.core.msg.LanguagesCode;
import it.actalis.ellips.capi.datahandlers.builders.DataHandlerBuilder;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.datahandlers.outputs.OutputHandler;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.logging.utils.EllipsLoggerUtils;
import it.actalis.vol.utils.ConfigFile;
import it.actalis.vol.utils.Constants;
import java.awt.Desktop;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public class GUIUtils {
    private static final EllipsLogger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static final I18N b = I18N.getInstance("esecurity/crypto/gui/theme/i18n/i18n");

    public static boolean openUrl(String string) {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(new URI(string));
                return true;
            }
            catch (IOException | URISyntaxException exception) {
                a.error(exception.getMessage(), (Throwable)exception);
            }
        }
        return false;
    }

    public static boolean copyIfNeeded(File file, File file2) {
        if (file != null && file2 != null && !file2.exists() && file.exists()) {
            a.debug(file2.getAbsolutePath() + " not exist, copy it from " + file.getAbsolutePath());
            try {
                Files.copy(file.toPath(), file2.toPath(), new CopyOption[0]);
                return true;
            }
            catch (IOException iOException) {
                a.error(iOException.getMessage(), (Throwable)iOException);
            }
        }
        return false;
    }

    public static ValidatorConfig getValidatorConfig() {
        String[] stringArray;
        CharSequence charSequence;
        ClientProperties clientProperties = ClientProperties.getInstance();
        ConfigFile configFile = new ConfigFile(null);
        String string = clientProperties.get(AppProperties.CDB_FILE, "");
        if (string != null) {
            configFile.setElement("certdb.file", string);
            configFile.setElement("certdb.pwd", "1234567890AAbbCCdd");
        }
        configFile.setElement("verify.revocation", "true");
        configFile.setElement("verify.mode", clientProperties.get(AppProperties.PREFER_OCSP, "OCSPFIRST"));
        configFile.setBinElement("crl.cacheinmemory", clientProperties.get(AppProperties.CACHE_CRL, "").equals("S"));
        configFile.setElement("crl.dir", clientProperties.get(AppProperties.CRL_FOLDER, ""));
        configFile.setElement("crl.behavior", "LDAPFIRST");
        configFile.setElement("crl.ldap.timeout", "60000");
        configFile.setElement("crl.http.timeout", "60000");
        configFile.setElement("ocsp.timeout", "60000");
        configFile.setElement("usedatesign", "0");
        configFile.setElement("crl.update.period", "5");
        configFile.setElement("http.proxy", "false");
        string = clientProperties.getNetworkConfig();
        if (string.isAutomaticProxyDiscovery()) {
            configFile.setElement("http.proxy.auto", "true");
        } else if (string.getProxy() != null && !string.getProxy().isEmpty()) {
            configFile.setElement("http.proxy", "true");
            configFile.setElement("http.proxy.host", string.getProxy());
            configFile.setElement("http.proxy.type", string.getProxyType());
            configFile.setElement("http.proxy.port", string.getProxyPort());
            configFile.setElement("http.proxy.user", string.getUserProxy());
            configFile.setElement("http.proxy.pass", string.getPasswordProxy());
            charSequence = new StringBuilder();
            stringArray = string.getProxynohosts();
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    if (((StringBuilder)charSequence).length() == 0) {
                        ((StringBuilder)charSequence).append(string2);
                        continue;
                    }
                    ((StringBuilder)charSequence).append(",").append(string2);
                }
            }
            configFile.setElement("http.proxy.noProxyHosts", ((StringBuilder)charSequence).toString());
            configFile.setElement("http.proxy.workstation", "");
            configFile.setElement("http.proxy.domain", "");
            configFile.setElement("http.proxy.realm", "");
        }
        charSequence = clientProperties.get(NetworkProperties.CRL_PROXY_HOST, "");
        stringArray = clientProperties.get(NetworkProperties.CRL_PROXY_PORT, "");
        if (charSequence != null && !((String)charSequence).isEmpty()) {
            configFile.setElement("sogei.proxy", (String)charSequence);
            if (stringArray != null && !stringArray.isEmpty()) {
                configFile.setElement("sogei.proxy.port", (String)stringArray);
            }
        }
        configFile.setElement("ldap.proxy ", "false");
        if (string.getLdapProxy() != null && !string.getLdapProxy().isEmpty()) {
            configFile.setElement("ldap.proxy", "true");
            configFile.setElement("ldap.proxy.host", string.getLdapProxy());
            configFile.setElement("ldap.proxy.type", string.getLdapProxyType());
            configFile.setElement("ldap.proxy.port", string.getLdapProxyPort());
            configFile.setElement("ldap.proxy.user", string.getLdapUserProxy());
            configFile.setElement("ldap.proxy.pass", string.getLdapPasswordProxy());
        }
        configFile.setElement("log.config", "log4j.properties");
        stringArray = clientProperties.get(UserProperties.TIME_ZONE, "GMT+0");
        configFile.setElement("timeZone", (String)stringArray);
        configFile.setElement("language", clientProperties.get(UserProperties.LANGUAGE, LanguagesCode.IT.name()));
        return new ValidatorConfig(configFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveCryptLog(EllipsLogger object, View object2) throws IOException {
        try {
            object2 = new FileDialog((View)object2, b.get("save_error_data__dialog", new Object[0]), new String[]{".zip.p7e"});
            ((FileDialog)object2).setInitialFileName("ErrorLogs");
            object2 = ((FileDialog)object2).showSaveDialog();
            Object object3 = new ByteArrayOutputStream();
            EllipsLoggerUtils.zipLogger((EllipsLogger)object, (OutputStream)object3);
            object = new ArrayList();
            Object object4 = CertificateFactory.getInstance("X.509");
            object4 = (X509Certificate)((CertificateFactory)object4).generateCertificate(GUIUtils.class.getResourceAsStream("/esecurity/crypto/gui/utils/cert/p12log.cer"));
            object.add(object4);
            object4 = new EncryptEnvelopeOptions();
            object4.setAlgorithm(EncryptionAlgorithm.AES256_CBC);
            object4.setRecipients((List)object);
            try {
                object = DataHandlerBuilder.get().setBytes(((ByteArrayOutputStream)object3).toByteArray()).buildInput();
                object3 = null;
                try {
                    block18: {
                        object2 = DataHandlerBuilder.get().setFile((File)object2).buildOutput();
                        Throwable throwable = null;
                        try {
                            object4.setInput((InputHandler)object);
                            object4.setOutput((OutputHandler)object2);
                            EncryptEnvelopeGenerator encryptEnvelopeGenerator = new EncryptEnvelopeGenerator();
                            encryptEnvelopeGenerator.encrypt((EncryptEnvelopeOptions)object4);
                            if (object2 == null) break block18;
                        }
                        catch (Throwable throwable2) {
                            try {
                                Throwable throwable3 = throwable2;
                                throwable = throwable2;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (object2 == null) throw throwable4;
                                if (throwable == null) {
                                    object2.close();
                                    throw throwable4;
                                }
                                try {
                                    object2.close();
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                    throw throwable4;
                                }
                            }
                        }
                        object2.close();
                    }
                    if (object == null) return;
                }
                catch (Throwable throwable) {
                    try {
                        object2 = throwable;
                        object3 = throwable;
                        throw object2;
                    }
                    catch (Throwable throwable6) {
                        if (object == null) throw throwable6;
                        if (object3 == null) {
                            object.close();
                            throw throwable6;
                        }
                        try {
                            object.close();
                            throw throwable6;
                        }
                        catch (Throwable throwable7) {
                            ((Throwable)object3).addSuppressed(throwable7);
                            throw throwable6;
                        }
                    }
                }
                object.close();
                return;
            }
            catch (Throwable throwable) {
                a.error(throwable.getMessage(), throwable);
            }
            return;
        }
        catch (CertificateException certificateException) {
            a.error(certificateException.getMessage(), (Throwable)certificateException);
        }
    }

    public static void saveClearLog(EllipsLogger ellipsLogger, View object) throws IOException {
        object = new FileDialog((View)object, b.get("save_error_data__dialog", new Object[0]), new String[]{".zip"});
        ((FileDialog)object).setInitialFileName("ErrorLogs");
        object = ((FileDialog)object).showSaveDialog();
        Object object2 = new ByteArrayOutputStream();
        EllipsLoggerUtils.zipLogger((EllipsLogger)ellipsLogger, (OutputStream)object2);
        try {
            block12: {
                block11: {
                    ellipsLogger = DataHandlerBuilder.get().setFile((File)object).buildOutput();
                    object = null;
                    try {
                        ellipsLogger.write(((ByteArrayOutputStream)object2).toByteArray());
                        if (ellipsLogger == null) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            object2 = throwable;
                            object = throwable;
                            throw object2;
                        }
                        catch (Throwable throwable2) {
                            if (ellipsLogger != null) {
                                if (object != null) {
                                    try {
                                        ellipsLogger.close();
                                    }
                                    catch (Throwable throwable3) {
                                        ((Throwable)object).addSuppressed(throwable3);
                                    }
                                } else {
                                    ellipsLogger.close();
                                }
                            }
                            throw throwable2;
                        }
                    }
                    break block12;
                }
                return;
            }
            ellipsLogger.close();
        }
        catch (Throwable throwable) {
            a.error(throwable.getMessage(), throwable);
        }
    }

    public static String generateIdFromKeyHandler(String string, Signer signer) {
        return string + "_" + GUIUtils.cleanId(signer.getAlias());
    }

    public static String cleanId(String string) {
        return string.replaceAll("[^a-zA-Z0-9]", "");
    }
}

