/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.pades;

import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.StepsUtils;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.core.StepSignatureDPCM45DigestAlgoCheck;
import esecurity.validator.steps.pades.PadesStepSignatureDPCM45CMSSignedDataCheck;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.vol.utils.Constants;
import java.util.Date;
import java.util.LinkedList;

public class PadesStepSignatureDPCM45Compliance
extends SingleValidationSubStepImpl {
    public PadesStepSignatureDPCM45Compliance() {
        super(ValidationType.SIGNATURE);
        this.subSteps.add(new StepSignatureDPCM45DigestAlgoCheck());
        this.subSteps.add(new PadesStepSignatureDPCM45CMSSignedDataCheck());
    }

    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> messageLevel, ValidationContextParameters validationContextParameters) {
        Date date = validationContextParameters.getCalculatedValidationDate().getDate();
        if ((validationContextParameters.getProfile() == ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE || validationContextParameters.getProfile() == ValidationProfile.GRAPHOMETRIC_SIGNATURE_PROFILE) && date.after(Constants.DPCM_CNIPA_45_2009) && date.before(Constants.DPCM_AGID_121_2019) && (messageLevel = StepsUtils.retrieveWorstLevel(messageLevel)) != MessageLevel.INFO) {
            return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), messageLevel, (EsecurityMessage)ValidatorMessageEnum.ES0005_NOCNIPA45, new Object[0]);
        }
        return null;
    }
}

