/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.validation.utils;

import esecurity.crypto.gui.facade.StatusLevel;
import esecurity.crypto.gui.service.i18n.I18N;
import esecurity.validator.bean.ValidatedDocument;
import esecurity.validator.bean.ValidatedSigner;
import esecurity.validator.constants.ContainerFormat;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;

public class DocumentUtils {
    private static final I18N a = I18N.getInstance((String)"esecurity/crypto/gui/validation/i18n/i18n");

    public static StatusLevel getDocumentLevel(ValidatedDocument validatedDocument) {
        if (validatedDocument.hasMessage(ValidatorMessageEnum.EA0003_INVALID_DATA)) {
            return StatusLevel.NONE;
        }
        if (!validatedDocument.isSigned()) {
            if (validatedDocument.getParent() == null || !validatedDocument.getParent().isSigned() || validatedDocument.getReferenceSigners().isEmpty()) {
                return StatusLevel.NONE;
            }
            if (!validatedDocument.isReferenceSignersAllOK()) {
                return StatusLevel.ERROR;
            }
            if (validatedDocument.hasBeanWarnings()) {
                return StatusLevel.WARNING;
            }
            return StatusLevel.SUCCESS;
        }
        if (!validatedDocument.isOverAllOk()) {
            return StatusLevel.ERROR;
        }
        if (validatedDocument.hasBeanWarnings() || ((ValidatedSigner)validatedDocument.getSigners().get(0)).getContainerFormat() == ContainerFormat.ASIC && !validatedDocument.isAllSubDocumentHaveReferenceSigner()) {
            return StatusLevel.WARNING;
        }
        return StatusLevel.SUCCESS;
    }

    public static String getDocumentDescription(ValidatedDocument validatedDocument) {
        if (validatedDocument.getShortName() == null) {
            return "ROOT";
        }
        if (validatedDocument.hasMessage(ValidatorMessageEnum.EA0003_INVALID_DATA)) {
            return validatedDocument.getShortName() + " - " + validatedDocument.getMessageByCode(ValidatorMessageEnum.EA0003_INVALID_DATA);
        }
        if (validatedDocument.isSigned()) {
            return validatedDocument.getShortName();
        }
        if (validatedDocument.getParent() == null || validatedDocument.getParent().isSigned() && validatedDocument.getReferenceSigners().isEmpty()) {
            return validatedDocument.getShortName() + " - " + a.get("validation_form__validated_document_model_file_not_signed", new Object[0]);
        }
        return validatedDocument.getShortName();
    }

    public static String getStatusIconClass(StatusLevel statusLevel, boolean bl) {
        if (StatusLevel.SUCCESS.equals((Object)statusLevel) && bl) {
            return "ver_success_blue_icon";
        }
        if (StatusLevel.SUCCESS.equals((Object)statusLevel)) {
            return "ver_success_icon";
        }
        if (StatusLevel.WARNING.equals((Object)statusLevel)) {
            return "ver_warning_icon";
        }
        if (StatusLevel.ERROR.equals((Object)statusLevel)) {
            return "ver_error_icon";
        }
        return "";
    }
}

