/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.xades;

import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.xades.bean.XadesSignatureReference;
import esecurity.validator.xades.bean.XadesSignerInfoData;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.vol.utils.Constants;
import java.util.Date;
import java.util.LinkedList;

public class XadesStepSignatureDigestAlgoirthmCheck
extends SingleValidationSubStepImpl {
    public XadesStepSignatureDigestAlgoirthmCheck() {
        super(ValidationType.SIGNATURE);
    }

    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> cloneable, ValidationContextParameters validationContextParameters) {
        if (validationContextParameters == null) {
            return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, new Object[]{((Object)((Object)this)).getClass().getName()});
        }
        cloneable = validationContextParameters.getCalculatedValidationDate().getDate();
        if ((validationContextParameters.getProfile() == ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE || validationContextParameters.getProfile() == ValidationProfile.GRAPHOMETRIC_SIGNATURE_PROFILE) && ((Date)cloneable).after(Constants.DPCM_AGID_121_2019)) {
            DigestAlgorithm digestAlgorithm;
            cloneable = (XadesSignerInfoData)validationContextParameters.getSignature().getSignerInfoData();
            if (cloneable != null && cloneable.getReferences() != null && cloneable.getReferences().size() > 0) {
                for (XadesSignatureReference xadesSignatureReference : cloneable.getReferences()) {
                    if (xadesSignatureReference != null && xadesSignatureReference.getDigestMethodAlgorithm() != null && xadesSignatureReference.getDigestMethodAlgorithm().equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#sha256")) continue;
                    digestAlgorithm = DigestAlgorithm.valueFromXadesId((String)xadesSignatureReference.getDigestMethodAlgorithm());
                    if (digestAlgorithm == null) {
                        return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0029_DIGEST_ALGORITHM_NOT_SUPPORTED, new Object[]{xadesSignatureReference.getDigestMethodAlgorithm(), ((Object)((Object)this)).getClass().getName()});
                    }
                    if (digestAlgorithm.isForbidden()) {
                        return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0030_DIGEST_ALGORITHM_FORBIDDEN, new Object[]{digestAlgorithm.name(), ((Object)((Object)this)).getClass().getName()});
                    }
                    if (digestAlgorithm.isRecommended()) continue;
                    return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0016_DIGEST_ALGORITHM_NOT_RECOMMENDED, new Object[]{digestAlgorithm.name(), ((Object)((Object)this)).getClass().getName()});
                }
            }
            if (cloneable != null && cloneable.getSigningCertificates() != null && cloneable.getSigningCertificates().size() > 0) {
                for (XadesSignatureReference xadesSignatureReference : cloneable.getSigningCertificates()) {
                    if (xadesSignatureReference != null && xadesSignatureReference.getDigestMethod() != null && xadesSignatureReference.getDigestMethod().equalsIgnoreCase("http://www.w3.org/2001/04/xmlenc#sha256")) continue;
                    digestAlgorithm = DigestAlgorithm.valueFromXadesId((String)xadesSignatureReference.getDigestMethod());
                    if (digestAlgorithm == null) {
                        return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0029_DIGEST_ALGORITHM_NOT_SUPPORTED, new Object[]{xadesSignatureReference.getDigestMethod(), ((Object)((Object)this)).getClass().getName()});
                    }
                    if (digestAlgorithm.isForbidden()) {
                        return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0030_DIGEST_ALGORITHM_FORBIDDEN, new Object[]{digestAlgorithm.name(), ((Object)((Object)this)).getClass().getName()});
                    }
                    if (digestAlgorithm.isRecommended()) continue;
                    return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0016_DIGEST_ALGORITHM_NOT_RECOMMENDED, new Object[]{digestAlgorithm.name(), ((Object)((Object)this)).getClass().getName()});
                }
            }
        }
        return null;
    }
}

