/**
 * Initialize  JQueryUI's tooltips
 *
 * @returns {undefined}
 */
function decrypt_loadTooltip() {
    $(document).tooltip({
        content: function () {
            var element = $(this);
            if (element.is("[title]")) {
                return element.attr("title");
            }
        },

        open: function (event, ui) {
            $(".ui-tooltip").addClass("cg-custom-tooltip");
        }

    });
}

function encrypt_OutcomeAlignColumn() {
    try {
        var headWidth = $("#outcomePanel_errorDocumentsTableArea_tableBody").width();
        $("#outcomePanel_errorDocumentsTableArea_tableBody .cg-tableColumn").width((headWidth / 2) + 1);
    } catch (exception) {
        error(exception.stack);
    }
}

function decrypt_toggleShowHideIcon(iconId, inputId) {
    try {
        var input = document.getElementById(inputId);
        if (input.getAttribute("type") == "password") {
            input.setAttribute("type", "text");
            removeClass(iconId, "cg-show-icon");
            addClass(iconId, "cg-hide-icon");
        } else {
            input.setAttribute("type", "password");
            removeClass(iconId, "cg-hide-icon");
            addClass(iconId, "cg-show-icon");
        }
    } catch (exception) {
        error(exception.stack);
    }
}

function onPinInputUpdated(pinInputId, decryptButtonId) {
    var pinInputEl = document.getElementById(pinInputId);
    if (pinInputEl.value !== null && pinInputEl.value !== "") {
        document.getElementById(decryptButtonId).removeAttribute('disabled');
        removeClass(decryptButtonId, 'disabled');
    } else {
        document.getElementById(decryptButtonId).setAttribute('disabled', 'disabled');
        addClass(decryptButtonId, 'disabled');
    }
}