/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.certdb;

import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.certdb.CertDBDiff;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.certdb.CertDBUtils;
import it.actalis.ellips.capi.certdb.c;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.core.Version;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.UrlClient;
import it.actalis.ellips.capi.http.bc.Base64;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.util.ini.IniFileException;
import it.actalis.ellips.capi.util.ini.SignedIniFile;
import it.actalis.ellips.capi.util.map.LRUMap;
import it.actalis.vol.utils.Constants;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.util.encoders.DecoderException;
import org.slf4j.Logger;

@Deprecated
public class CertDB {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static LRUMap<String, CertDB> b = new LRUMap(10);
    private static Thread c = null;
    private static c d = null;
    private String e = null;
    private SignedIniFile f = null;
    private byte[] g = null;
    private long h = -1L;
    private List<String> i = new LinkedList<String>();
    public static final String CDB_DEFAULT_KEY = "1234567890AAbbCCdd";

    private CertDB(String string, String string2, boolean bl) throws CertDBException {
        this(string, string2, bl, false);
    }

    private CertDB(String string, String object, boolean bl, boolean bl2) throws CertDBException {
        try {
            object = Util.getBytes((String)object);
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw new CertDBException(capiException.getMessage(), 80000);
        }
        this.g = (byte[])object;
        this.e = string;
        try {
            if (bl) {
                File file = new File(string);
                if (file.exists()) {
                    a.debug("cdb already present ...");
                } else {
                    a.debug("creating new cdb ...");
                    this.f = new SignedIniFile(String.format(Constants.CERT_DB_HEADER, "100", Version.getVersion()));
                    this.f.store(string, (byte[])object);
                    a.debug("new cdb was created");
                    file = new File(string);
                    this.h = file.lastModified();
                }
            }
            this.b();
            return;
        }
        catch (IniFileException iniFileException) {
            IniFileException iniFileException2 = iniFileException;
            throw CertDBException.a(iniFileException);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new CertDBException("Wrong password or altered", 80001);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CertDBException("File not found", 80004);
        }
        catch (IOException iOException) {
            throw new CertDBException("I/O error", 80005);
        }
        catch (CapiException capiException) {
            throw new CertDBException(capiException.getMessage(), 80005);
        }
        catch (Exception exception) {
            throw new CertDBException(exception.getMessage(), 80005);
        }
    }

    public static synchronized void startUpdateControl() {
        if (d == null) {
            d = new c(b);
            c = new Thread(d);
            c.setDaemon(true);
            c.start();
        }
    }

    public static synchronized void stopUpdateControl() throws InterruptedException {
        if (d != null) {
            d.a();
            c.join();
            d = null;
            c = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CertDB getInstance(String string, String string2, boolean bl, boolean bl2) throws CertDBException {
        if (!bl2) {
            return new CertDB(string, string2, bl);
        }
        CertDB certDB = (CertDB)b.get(string);
        if (certDB != null) {
            return certDB;
        }
        LRUMap<String, CertDB> lRUMap = b;
        synchronized (lRUMap) {
            certDB = (CertDB)b.get(string);
            if (certDB != null) {
                return certDB;
            }
            certDB = new CertDB(string, string2, bl);
            b.put(string, certDB);
        }
        return certDB;
    }

    private SignedIniFile a() {
        if (this.f != null) {
            return this.f;
        }
        try {
            this.b();
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage());
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            a.error(unrecoverableKeyException.getMessage());
        }
        catch (IniFileException iniFileException) {
            a.error(iniFileException.getMessage());
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage());
        }
        catch (Exception exception) {
            a.error(exception.getMessage());
        }
        return this.f;
    }

    private synchronized void b() throws IOException, UnrecoverableKeyException, IniFileException, CapiException, UnsupportedEncodingException, InstantiationException, InstantiationException, IllegalAccessException {
        if (this.f == null) {
            this.f = new SignedIniFile(this.e, this.g, CertDBItem.class);
            File file = new File(this.e);
            this.h = file.lastModified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CertDBItem certDBItem) throws CertDBException {
        if (certDBItem.getParent() != null && certDBItem.getParent() != this) {
            throw new CertDBException("Cannot add Item, already in another DB", 80010);
        }
        if (certDBItem.getType() == 0) {
            throw new CertDBException("Cannot add item, type is UNKNOWN", 80012);
        }
        if (certDBItem.getType() == 8) {
            throw new CertDBException("Cannot add item, type is SUSPECT", 80008);
        }
        SignedIniFile signedIniFile = this.f;
        synchronized (signedIniFile) {
            String string = certDBItem.getIniPropertyStringValue("cert");
            if (this.a().containsProperty("cert", string)) {
                throw new CertDBException("Certificate already present", 80011);
            }
            int n = 0;
            String string2 = CertDB.a(certDBItem, 0);
            while (this.a().containsObject(string2)) {
                string2 = CertDB.a(certDBItem, ++n);
            }
            certDBItem.a(string2);
            certDBItem.a(this);
            this.a().setObject(string2, certDBItem);
            return;
        }
    }

    static String a(CertDBItem certDBItem, int n) {
        return CertDB.a(certDBItem.getSubject(), n);
    }

    private static String a(String string, int n) {
        String string2 = null;
        try {
            string2 = new String(Base64.encode((byte[])string.getBytes("UTF-8"))) + "-" + n;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            a.error(unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(CertDBItem certDBItem) throws CertDBException {
        SignedIniFile signedIniFile = this.f;
        synchronized (signedIniFile) {
            boolean bl = true;
            try {
                Integer.parseInt(certDBItem.getID());
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            if (bl) {
                this.a().removeObject(new Integer(certDBItem.getID()).toString());
            } else {
                this.a().removeObject(certDBItem.getID());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(CertDBItem certDBItem) throws CertDBException {
        try {
            SignedIniFile signedIniFile = this.f;
            synchronized (signedIniFile) {
                if (this.contains(certDBItem.getCert(false)) == null) {
                    return false;
                }
                this.a().setObject(certDBItem.getID(), certDBItem);
                return true;
            }
        }
        catch (CapiException capiException) {
            return false;
        }
    }

    public CertDBItem[] list(int n) throws CertDBException {
        return this.list(n, 127);
    }

    public CertDBItem[] list(int n, int n2) throws CertDBException {
        a.debug("getting object list ... ");
        String[] stringArray = this.a().getObjectList2();
        a.debug("selecting items list ... ");
        Vector<CertDBItem> vector = new Vector<CertDBItem>();
        for (int i = 0; i < stringArray.length; ++i) {
            CertDBItem certDBItem = this.b(stringArray[i]);
            if (n2 != 127 && (n2 & certDBItem.getUsage()) == 0) {
                a.debug("list: skipped usage for " + certDBItem.getName());
                continue;
            }
            if ((n & certDBItem.getType()) <= 0) continue;
            vector.addElement(certDBItem);
        }
        a.debug("returning items list ... ");
        CertDBItem[] certDBItemArray = new CertDBItem[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            certDBItemArray[i] = (CertDBItem)vector.elementAt(i);
        }
        return certDBItemArray;
    }

    public int getSize() {
        return this.a().size();
    }

    public void onLineVerify(NetworkConfig networkConfig, byte[] byArray, List<CertDBItem> list) throws CapiException {
        this.a(networkConfig, byArray, list);
    }

    public CertDBItem[] onLineVerify(NetworkConfig networkConfig, CertDBItem object) throws CapiException {
        try {
            object = ((CertDBItem)object).getCertificate().getInternalCert().getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            a.error(certificateEncodingException.getMessage(), (Throwable)certificateEncodingException);
            throw new CapiException("Invalid certificate", 30005, certificateEncodingException);
        }
        return this.a(networkConfig, (byte[])object);
    }

    public CertDBItem[] onLineVerify(NetworkConfig networkConfig, byte[] byArray) throws CapiException {
        return this.a(networkConfig, byArray);
    }

    public CertDBItem[] onLineVerify(ValidationContextParameters validationContextParameters) throws CapiException {
        byte[] byArray;
        try {
            byArray = validationContextParameters.getSignerCertificate().getCert().getInternalCert().getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            a.error(certificateEncodingException.getMessage(), (Throwable)certificateEncodingException);
            throw new CapiException("Invalid certificate", 30005, certificateEncodingException);
        }
        return this.a(validationContextParameters.getConfig().getNetConfiguration(), byArray);
    }

    private CertDBItem[] a(NetworkConfig networkConfig, byte[] byArray) throws CapiException {
        ArrayList<CertDBItem> arrayList = new ArrayList<CertDBItem>();
        this.a(networkConfig, byArray, arrayList);
        ArrayList<CertDBItem> arrayList2 = arrayList;
        return arrayList2.toArray(new CertDBItem[arrayList2.size()]);
    }

    private void a(NetworkConfig networkConfig, byte[] object, List<CertDBItem> list) throws CapiException {
        try {
            if (a.isDebugEnabled()) {
                a.debug("verify chain element: " + new it.actalis.ellips.capi.core.Certificate((byte[])object).getName() + ", " + new it.actalis.ellips.capi.core.Certificate((byte[])object).getOcspUrl() + ", " + Arrays.toString(new it.actalis.ellips.capi.core.Certificate((byte[])object).getCdpURLs()));
            }
            this.a((byte[])object, null, list);
            return;
        }
        catch (CapiException capiException) {
            byte[] byArray;
            if (!list.isEmpty()) {
                List<CertDBItem> list2 = list;
                object = new it.actalis.ellips.capi.core.Certificate(list2.get(list2.size() - 1).getCert(true));
            } else {
                object = new it.actalis.ellips.capi.core.Certificate((byte[])object);
            }
            if (Util.isNullOrEmpty(((it.actalis.ellips.capi.core.Certificate)object).getCaIssuer())) {
                throw capiException;
            }
            if (((it.actalis.ellips.capi.core.Certificate)object).getIssuerDN().equals(((it.actalis.ellips.capi.core.Certificate)object).getSubjectDN())) {
                throw capiException;
            }
            UrlClient urlClient = new UrlClient(networkConfig, a);
            if ((object = urlClient.downloadUrl(((it.actalis.ellips.capi.core.Certificate)object).getCaIssuer(), null, null)) == null || object.getStatus() == null || !object.getStatus().equals("OK") || object.getData() == null) {
                throw capiException;
            }
            object = this.canImport(object.getData());
            ((CertDBItem)object).setSource(4);
            list.add((CertDBItem)object);
            try {
                byArray = ((CertDBItem)object).getCertificate().getInternalCert().getEncoded();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                a.error(certificateEncodingException.getMessage(), (Throwable)certificateEncodingException);
                throw new CapiException("Invalid certificate", 30005, certificateEncodingException);
            }
            this.onLineVerify(networkConfig, byArray, list);
            this.add((CertDBItem)object);
            return;
        }
    }

    public boolean resolveChainOnLine(NetworkConfig networkConfig, byte[] object, LinkedList<CertDBItem> linkedList) throws CapiException {
        boolean bl = false;
        String string = "";
        try {
            it.actalis.ellips.capi.core.Certificate certificate = new it.actalis.ellips.capi.core.Certificate((byte[])object);
            object = certificate;
            if (certificate.getIssuerDN().equals(object.getSubjectDN())) {
                throw new CapiException("this is self-signed certificate", 30005, 0);
            }
            string = object.getCaIssuer();
            if (Util.isNullOrEmpty(string)) {
                throw new CapiException("current certificate has not caIssuer information: incomplete chain", 30005, 1);
            }
            if (this.i.contains(string = string.toLowerCase())) {
                return false;
            }
            object = null;
            Object object2 = new UrlClient(networkConfig, a);
            try {
                object2 = object2.downloadUrl(string, null, null);
                if (object2 == null || object2.getStatus() == null || !object2.getStatus().equals("OK") || object2.getData() == null || object2.getData().length == 0) {
                    throw new CapiException("unable to download the caIssuer certificate", 30005, 1);
                }
                object = Util.getBytesFromPemOrBase64(object2.getData());
            }
            catch (Exception exception) {}
            if (object == null) {
                throw new CapiException("unable to download the caIssuer certificate", 30005, 2);
            }
            object2 = this.canImport((byte[])object);
            for (int i = 0; i < linkedList.size(); ++i) {
                if (!Arrays.equals(linkedList.get(i).getCert(true), ((CertDBItem)object2).getCert(true))) continue;
                throw new CapiException("caIssuer certificate is not as expected: chain loop!", 30005, 1);
            }
            linkedList.add((CertDBItem)object2);
            bl = this.resolveChainOnLine(networkConfig, ((CertDBItem)object2).getCert(true), linkedList);
        }
        catch (CapiException capiException) {
            object = capiException;
            if (capiException.getDetailReason() == 0) {
                bl = true;
            } else if (!(object instanceof CertDBException)) {
                a.info(object.getMessage() + " -> " + string);
            }
        }
        catch (DecoderException decoderException) {
            a.info("unable to decode caIssuer certificate " + string);
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
        }
        if (!bl && !this.i.contains(string)) {
            this.i.add(string);
        }
        return bl;
    }

    public CertDBItem[] verify(byte[] byArray) throws CertDBException, CapiException {
        a.debug("verifying cert byte[]");
        return this.a(byArray, null, null);
    }

    public CertDBItem[] verify(CertDBItem certDBItem) throws CertDBException, CapiException {
        a.debug("verifying cert DBItem");
        return this.a(null, certDBItem, null);
    }

    public void changePwd(String string, String string2) throws CertDBException {
        try {
            if (!Util.equalsBlock(Util.getBytes(string), this.g)) {
                throw new CertDBException("Wrong password", 80002);
            }
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CertDBException("Wrong password", 80002);
        }
        try {
            this.g = Util.getBytes(string2);
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw new CertDBException(capiException.getMessage(), 80000);
        }
        a.debug("changing pwd to DB...");
        try {
            this.store();
            a.debug("changed  pwd to DB...");
            return;
        }
        catch (CertDBException certDBException) {
            a.debug(certDBException.getMessage(), (Throwable)certDBException);
            try {
                this.g = Util.getBytes(string);
            }
            catch (CapiException capiException) {
                a.debug(capiException.getMessage(), (Throwable)capiException);
                throw new CertDBException(capiException.getMessage(), 80000);
            }
            throw certDBException;
        }
    }

    public CertDBItem canImport(byte[] byArray) throws CapiException, CertDBException {
        return this.canImport(byArray, null);
    }

    public CertDBItem canImport(byte[] byArray, List<CertDBItem.EllipsUsage> list) throws CapiException, CertDBException {
        return this.canImport(byArray, list, 2);
    }

    public CertDBItem canImport(byte[] object, List<CertDBItem.EllipsUsage> object2, int n) throws CapiException, CertDBException {
        it.actalis.ellips.capi.core.Certificate certificate = new it.actalis.ellips.capi.core.Certificate((byte[])object);
        SignedIniFile signedIniFile = this.f;
        synchronized (signedIniFile) {
            CertDBItem certDBItem = this.contains((byte[])object);
            if (certDBItem != null) {
                throw new CertDBException("Cannot import item, already in DB", 80011);
            }
            certDBItem = new CertDBItem(null, (byte[])object, (List<CertDBItem.EllipsUsage>)object2);
            certDBItem.setSource(n);
            switch (certDBItem.getType()) {
                case 1: 
                case 2: {
                    List<String> list = this.a(CertDBUtils.getIssuerFromCert(certificate));
                    object = list;
                    if (list.isEmpty() || n == 1) {
                        return certDBItem;
                    }
                    try {
                        CertDB certDB = this;
                        it.actalis.ellips.capi.core.Certificate certificate2 = certificate;
                        object2 = object;
                        object = certDB;
                        certDB.a((List<String>)object2, certificate2, null);
                        return certDBItem;
                    }
                    catch (CertDBException certDBException) {
                        a.debug(certDBException.getMessage(), (Throwable)certDBException);
                        throw certDBException;
                    }
                }
                case 4: {
                    return certDBItem;
                }
                case 8: {
                    throw new CertDBException("Cannot import a certificate altered", 80008);
                }
            }
            throw new CertDBException("Cannot import unknown certificate", 80012);
        }
    }

    public void store() throws CertDBException {
        CertDB certDB = this;
        certDB.a(certDB.e, false);
    }

    public void store(String string) throws CertDBException {
        this.a(string, true);
    }

    public void store(File file) throws CertDBException {
        this.a(file.getAbsolutePath(), true);
    }

    private void a(String object, boolean bl) throws CertDBException {
        try {
            this.a().setLoadTkId(String.format(Constants.CERT_DB_HEADER, "100", Version.getVersion()).getBytes());
            this.a().store((String)object, this.g, bl);
        }
        catch (IniFileException iniFileException) {
            object = iniFileException;
            throw CertDBException.a(iniFileException);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new CertDBException("Wrong password or altered", 80001);
        }
        catch (IOException iOException) {
            throw new CertDBException("I/O error", 80006);
        }
        object = new File(this.e);
        this.h = ((File)object).lastModified();
    }

    public CertDBItem contains(byte[] object) throws CapiException {
        List<String> list = this.a(CertDBUtils.getSubjectFromCert((it.actalis.ellips.capi.core.Certificate)(object = (Object)new it.actalis.ellips.capi.core.Certificate((byte[])object))));
        if (list.size() == 0) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            try {
                Object object2 = this.f.getProperty(list.get(i), "cert");
                object2 = new it.actalis.ellips.capi.core.Certificate(Util.getBytes((String)object2));
                if (!((it.actalis.ellips.capi.core.Certificate)object2).equals(object)) continue;
                return this.b(list.get(i));
            }
            catch (Exception exception) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
        }
        return null;
    }

    private List<String> a(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        int n = 0;
        String string2 = CertDB.a(string, 0);
        while (this.a().getObject(string2) != null) {
            linkedList.add(string2);
            string2 = CertDB.a(string, ++n);
        }
        return linkedList;
    }

    private CertDBItem b(String string) {
        CertDBItem certDBItem = (CertDBItem)this.a().getObject(string);
        certDBItem.a(this);
        certDBItem.a(string);
        return certDBItem;
    }

    private CertDBItem[] a(byte[] object, CertDBItem object2, List<CertDBItem> list) throws CertDBException, CapiException {
        int n;
        it.actalis.ellips.capi.core.Certificate certificate;
        Vector<Object> vector = new Vector<Object>();
        int n2 = -1;
        boolean bl = false;
        boolean bl2 = false;
        int n3 = 20;
        int n4 = 82112;
        Vector vector2 = new Vector();
        if (object2 == null) {
            certificate = new it.actalis.ellips.capi.core.Certificate((byte[])object);
            object = this.contains((byte[])object);
        } else {
            certificate = ((CertDBItem)object2).getCertificate();
            object = object2;
        }
        while (!bl && --n3 > 0) {
            Object object3;
            it.actalis.ellips.capi.core.Certificate certificate2;
            if (bl2) {
                int n5;
                vector.addElement(object);
                ++n2;
                if (certificate.hasUnsupportedCriticalExtension()) {
                    CertDB.a(n2, 82113, vector2);
                }
                if ((n5 = certificate.getBasicConstraintsPathLen()) >= 0 && n2 > n5) {
                    a.debug("verify KO: violated pathLen:" + n5);
                    CertDB.a(n2, 82111, vector2);
                    bl = true;
                    continue;
                }
                int n6 = ((CertDBItem)object).getTrust();
                if (n6 == 2) {
                    a.debug("verify OK: cert trusted");
                    CertDB.a(n2, 82101, vector2);
                    bl = true;
                    continue;
                }
                if (n6 == 0) {
                    a.debug("verify KO: cert UNtrusted");
                    CertDB.a(n2, 82111, vector2);
                    bl = true;
                    continue;
                }
                a.debug("verify: inheriting status from parent");
            } else {
                if (certificate.hasUnsupportedCriticalExtension()) {
                    a.debug("hasUnsupportedCritExt");
                }
                if (object != null) {
                    a.debug("verify: cert is already in CertDB");
                    int n7 = ((CertDBItem)object).getTrust();
                    if (n7 == 2) {
                        a.debug("verify OK: cert trusted");
                        n4 = CertDB.a(82101, n4);
                        bl = true;
                        continue;
                    }
                    if (n7 == 0) {
                        a.debug("verify KO: cert UNtrusted");
                        n4 = CertDB.a(82111, n4);
                        bl = true;
                        continue;
                    }
                    a.debug("verify: inheriting status from parent");
                }
            }
            Object object4 = this.a(CertDBUtils.getIssuerFromCert(certificate));
            try {
                certificate2 = certificate;
                object3 = object4;
                object4 = this;
                object3 = ((CertDB)object4).a((List<String>)object3, certificate2, null);
                if (bl2) {
                    CertDB.a(n2, 82100, vector2);
                } else {
                    n4 = CertDB.a(82100, n4);
                    bl2 = true;
                }
            }
            catch (CertDBException certDBException) {
                a.debug(certDBException.getMessage(), (Throwable)certDBException);
                if (bl2) {
                    CertDB.a(n2, certDBException.getErrorCode(), vector2);
                } else {
                    n4 = CertDB.a(certDBException.getErrorCode(), n4);
                    bl2 = true;
                }
                bl = true;
                continue;
            }
            if (list != null) {
                list.add((CertDBItem)object3);
            }
            if ((certificate2 = new it.actalis.ellips.capi.core.Certificate(((CertDBItem)object3).getCert(false))).equals(certificate)) {
                bl = true;
            } else {
                certificate = certificate2;
            }
            object = object3;
        }
        if (n3 <= 0) {
            a.debug("verify: Max number of loops reached");
            throw new CertDBException("Too many loop", 80000);
        }
        object2 = new int[vector2.size()];
        CertDBItem[] certDBItemArray = new CertDBItem[vector.size()];
        for (n = 0; n < certDBItemArray.length; ++n) {
            certDBItemArray[n] = (CertDBItem)vector.elementAt(n);
            object2[n] = Integer.parseInt((String)vector2.elementAt(n));
        }
        if (n4 == 82101 || n4 == 82100) {
            if (certDBItemArray.length == 0) {
                if (n4 == 82101) {
                    return certDBItemArray;
                }
                throw new CertDBException("Why VERIFIED and no chain ?", 80020);
            }
            for (n = 0; n < ((Object)object2).length; ++n) {
                if (object2[n] == 82101 || object2[n] == 82100) continue;
                throw new CertDBException("The chain is incomplete or untrusted", 80021, certDBItemArray, (int[])object2, n4);
            }
            return certDBItemArray;
        }
        if (certDBItemArray.length == 0) {
            switch (n4) {
                case 82111: {
                    throw new CertDBException("untrusted", 82111, certDBItemArray, (int[])object2, n4);
                }
                case 30007: {
                    throw new CertDBException("altered?", 30007, certDBItemArray, (int[])object2, n4);
                }
            }
            throw new CertDBException("Issuer certificate not found", 80020, certDBItemArray, (int[])object2, n4);
        }
        throw new CertDBException("The chain is incomplete or untrusted", 80021, certDBItemArray, (int[])object2, n4);
    }

    private CertDBItem a(List<String> list, it.actalis.ellips.capi.core.Certificate certificate, ValidationProfile object) throws CertDBException {
        int n;
        if (list.isEmpty()) {
            throw new CertDBException("no issuer(s) found in CertDB", 82114, null, null);
        }
        object = new int[list.size()];
        CertDBItem[] certDBItemArray = new CertDBItem[list.size()];
        for (n = 0; n < list.size(); ++n) {
            certDBItemArray[n] = null;
            try {
                CertDBItem certDBItem = this.b(list.get(n));
                a.debug("Loop " + n + ": trying with " + certDBItem.getName());
                try {
                    certificate.verify(certDBItem.getCert(false));
                    object[n] = (ValidationProfile)82100;
                    return certDBItem;
                }
                catch (CapiException capiException) {
                    a.debug(capiException.getMessage(), (Throwable)capiException);
                    certDBItemArray[n] = certDBItem;
                    object[n] = (ValidationProfile)capiException.getErrorCode();
                    continue;
                }
                catch (Exception exception) {
                    a.debug(exception.getMessage(), (Throwable)exception);
                    object[n] = (ValidationProfile)1003;
                    continue;
                }
            }
            catch (Exception exception) {
                a.debug(exception.getMessage(), (Throwable)exception);
                object[n] = (ValidationProfile)1003;
            }
        }
        a.debug("no verified found; list status errors ...");
        block14: for (n = 0; n < ((ValidationProfile)object).length; ++n) {
            switch (object[n]) {
                case 1001: {
                    a.debug("[" + n + "]=null_args  " + (int)object[n] + ":" + certDBItemArray[n]);
                    continue block14;
                }
                case 30002: {
                    a.debug("[" + n + "]=cert_format" + (int)object[n] + ":" + certDBItemArray[n]);
                    continue block14;
                }
                case 30004: {
                    a.debug("[" + n + "]=crtverifyss" + (int)object[n] + ":" + certDBItemArray[n]);
                    continue block14;
                }
                case 30003: {
                    a.debug("[" + n + "]=cert_verify" + (int)object[n] + ":" + certDBItemArray[n]);
                    continue block14;
                }
                case 30006: {
                    a.debug("[" + n + "]=cert_subjki" + (int)object[n] + ":" + certDBItemArray[n]);
                    continue block14;
                }
                case 30007: {
                    a.debug("[" + n + "]=certaltered" + (int)object[n] + ":" + certDBItemArray[n]);
                    continue block14;
                }
                default: {
                    a.debug("[" + n + "]=" + list.get(n) + (int)object[n] + ":" + certDBItemArray[n]);
                }
            }
        }
        throw new CertDBException("issuer(s) not verified", (int)object[0], null, null);
    }

    private static int a(int n, int n2) {
        switch (n2) {
            case 82100: 
            case 82112: {
                a.debug("status itself ex-valid set to " + n);
                n2 = n;
                return n2;
            }
            case 82101: {
                if (n == 82100) break;
                a.debug("status itself ex-valid set to " + n);
                n2 = n;
                return n2;
            }
            case 82113: {
                if (n == 82112 || n == 82101 || n == 82111 || n == 82100) break;
                a.debug("status itself ex-! set to " + n);
                n2 = n;
                return n2;
            }
            case 82111: {
                if (n == 82112 || n == 82101 || n == 82100) break;
                a.debug("status itself ex-! set to " + n);
                n2 = n;
                return n2;
            }
            default: {
                if (n == 82112 || n == 82101 || n == 82100 || n == 82113 || n == 82111) break;
                a.debug("status itself ex-X set to " + n);
                n2 = n;
                return n2;
            }
        }
        a.debug("status itself value =" + n2);
        a.debug("not overwritten with=" + n);
        return n2;
    }

    private static void a(int n, int n2, Vector vector) {
        if (n >= vector.size()) {
            a.debug("status appending " + n2 + " at pos:" + n);
            vector.insertElementAt(Integer.valueOf(n2).toString(), n);
            return;
        }
        int n3 = Integer.parseInt((String)vector.elementAt(n));
        switch (n3) {
            case 82100: 
            case 82112: {
                a.debug("status ex-valid set to " + n2);
                vector.insertElementAt(Integer.valueOf(n2).toString(), n);
                return;
            }
            case 82101: {
                if (n2 == 82100) break;
                a.debug("status ex-valid set to " + n2);
                vector.insertElementAt(Integer.valueOf(n2).toString(), n);
                return;
            }
            case 82113: {
                if (n2 == 82112 || n2 == 82101 || n2 == 82111 || n2 == 82100) break;
                a.debug("status ex-! set to " + n2);
                vector.insertElementAt(Integer.valueOf(n2).toString(), n);
                return;
            }
            case 82111: {
                if (n2 == 82112 || n2 == 82101 || n2 == 82100) break;
                a.debug("status ex-! set to " + n2);
                vector.insertElementAt(Integer.valueOf(n2).toString(), n);
                return;
            }
            default: {
                if (n2 == 82112 || n2 == 82101 || n2 == 82100 || n2 == 82113 || n2 == 82111) break;
                a.debug("status ex-X set to " + n2);
                vector.insertElementAt(Integer.valueOf(n2).toString(), n);
                return;
            }
        }
        a.debug("status value =" + n3);
        a.debug("not overwritten with=" + n2);
    }

    public String getFilePath() {
        return this.e;
    }

    public static CertDB instanceFromList(LinkedList<X509Certificate> object, String object2, String object3) throws CertDBException {
        File file = new File((String)object2);
        if (file.exists()) {
            file.delete();
        }
        object2 = new CertDB((String)object2, (String)object3, true);
        if (object == null) {
            return object2;
        }
        object = ((AbstractSequentialList)object).iterator();
        while (object.hasNext()) {
            object3 = (X509Certificate)object.next();
            try {
                object3 = ((CertDB)object2).canImport(((Certificate)object3).getEncoded());
                ((CertDB)object2).add((CertDBItem)object3);
            }
            catch (CapiException capiException) {
            }
            catch (CertificateEncodingException certificateEncodingException) {}
        }
        return object2;
    }

    public KeyStore toTrustStore() throws CertDBException, KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        CertDBItem[] certDBItemArray = this.list(6);
        for (int i = 0; i < certDBItemArray.length; ++i) {
            try {
                keyStore.setCertificateEntry("cert_" + i, certDBItemArray[i].getCertificate().getInternalCert());
                continue;
            }
            catch (Exception exception) {
                a.error(exception.getMessage(), (Throwable)exception);
            }
        }
        return keyStore;
    }

    public void refresh() throws CertDBException {
        Serializable serializable = new File(this.e);
        if (this.h < serializable.lastModified()) {
            try {
                this.f = null;
                this.b();
                return;
            }
            catch (IniFileException iniFileException) {
                serializable = iniFileException;
                throw CertDBException.a(iniFileException);
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                throw new CertDBException("Wrong password or altered", 80001);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new CertDBException("File not found", 80004);
            }
            catch (IOException iOException) {
                throw new CertDBException("I/O error", 80005);
            }
            catch (CapiException capiException) {
                throw new CertDBException(capiException.getMessage(), 80005);
            }
            catch (Exception exception) {
                throw new CertDBException(exception.getMessage(), 80005);
            }
        }
    }

    public String getVersion() {
        return new String(this.a().getLoadTkId());
    }

    public String getVersionCdbFormat() {
        String string = new String(this.a().getLoadTkId());
        if (string.contains("[")) {
            string = string.replace("Ellips CertDB v. ", "");
            int n = string.indexOf("[");
            string = string.substring(0, n).trim();
            return string;
        }
        return null;
    }

    public String getVersionCAPI() {
        String string = new String(this.a().getLoadTkId());
        if ((string = string.replace("Ellips CertDB v. ", "")).contains("[")) {
            int n = string.indexOf("[");
            string = string.substring(n + 1, string.length() - 1).trim();
            return string;
        }
        String string2 = string.substring(0, string.length()).trim();
        return string2;
    }

    @Deprecated
    public void mergeFromPreviousVersionOld(CertDB certDBItemArray, boolean bl) throws CertDBException, CapiException {
        a.info("Merge CertDB from previous version");
        a.info("- current version: " + this.getVersion());
        a.info("- previous version: " + certDBItemArray.getVersion());
        if (!this.isMergeableWith((CertDB)certDBItemArray)) {
            throw new CapiException("current cdb is not mergeable with the previous one: previous cdb format is newer than current", 80003);
        }
        for (CertDBItem certDBItem : certDBItemArray.list(7)) {
            int n = certDBItem.getSource();
            CertDBItem certDBItem2 = this.contains(certDBItem.getCert(true));
            if (certDBItem2 != null) {
                if (n == 3 || n == 2 || certDBItem2.getSource() == 0 || n != 0) continue;
                certDBItem2.resetEllipsUsage();
                certDBItem2.addEllipsUsages(certDBItem.getEllipsUsages());
                certDBItem2.setSource(0);
                continue;
            }
            certDBItem2 = this.canImport(certDBItem.getCert(true), null, n);
            if (n != 3) {
                if (n == 2) {
                    certDBItem2.setSource(2);
                    certDBItem2.addEllipsUsages(certDBItem.getEllipsUsages());
                    this.add(certDBItem2);
                }
                if (n != 0 || bl) continue;
                certDBItem2.setSource(0);
                certDBItem2.addEllipsUsages(certDBItem.getEllipsUsages());
                this.add(certDBItem2);
                continue;
            }
            certDBItem2.setSource(2);
            try {
                this.add(certDBItem2);
            }
            catch (CertDBException certDBException) {
                a.error(certDBException.getMessage(), (Throwable)certDBException);
            }
        }
    }

    public void mergeFromPreviousVersion(CertDB certDB) throws CertDBException, CapiException {
        this.mergeFromPreviousVersion(certDB, false);
    }

    public void mergeFromPreviousVersion(CertDB certDBItemArray, boolean bl) throws CertDBException, CapiException {
        a.info("Merge CertDB from previous version");
        a.info("- current version: " + this.getVersion());
        a.info("- previous version: " + certDBItemArray.getVersion());
        if (!this.isMergeableWith((CertDB)certDBItemArray)) {
            throw new CapiException("current cdb is not mergeable with the previous one: previous cdb format is newer than current", 80003);
        }
        block18: for (CertDBItem certDBException : certDBItemArray.list(7)) {
            CertDBItem certDBItem = this.contains(certDBException.getCert(true));
            boolean bl2 = bl;
            CertDBItem certDBItem2 = certDBItem;
            certDBItem = certDBException;
            CertDB certDB = this;
            if (certDBItem != null && certDBItem2 != null) {
                switch (certDBItem.getSource()) {
                    case 0: {
                        switch (certDBItem2.getSource()) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: {
                                certDBItem2.resetEllipsUsage();
                                certDBItem2.addEllipsUsages(certDBItem.getEllipsUsages());
                                certDBItem2.setSource(0);
                                continue block18;
                            }
                            case 0: {
                                continue block18;
                            }
                            default: {
                                throw new CapiException("Unexpected item source", 80000);
                            }
                        }
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        continue block18;
                    }
                    default: {
                        throw new CapiException("Unexpected item source", 80000);
                    }
                }
            }
            if (certDBItem == null) continue;
            certDBItem2 = certDB.canImport(certDBItem.getCert(true), null, certDBItem.getSource());
            boolean bl3 = true;
            switch (certDBItem.getSource()) {
                case 3: {
                    certDBItem2.setSource(2);
                    certDBItem2.addEllipsUsages(certDBItem.getEllipsUsages());
                    break;
                }
                case 0: {
                    if (bl2) {
                        bl3 = false;
                        break;
                    }
                    certDBItem2.setSource(0);
                    certDBItem2.addEllipsUsages(certDBItem.getEllipsUsages());
                    break;
                }
                case 1: {
                    bl3 = false;
                    break;
                }
                case 2: {
                    certDBItem2.setSource(2);
                    certDBItem2.addEllipsUsages(certDBItem.getEllipsUsages());
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                default: {
                    throw new CapiException("Unexpected item source", 80000);
                }
            }
            if (!bl3) continue;
            try {
                certDB.add(certDBItem2);
            }
            catch (CertDBException certDBException2) {
                a.error(certDBException2.getMessage(), (Throwable)certDBException2);
            }
        }
    }

    public boolean isMergeableWith(CertDB object) {
        if (((CertDB)object).getVersionCdbFormat() == null) {
            return true;
        }
        object = ((CertDB)object).getVersionCdbFormat();
        String string = this.getVersionCdbFormat();
        if (string == null) {
            return false;
        }
        return string.compareTo((String)object) >= 0;
    }

    public int cleanPreTSLOrphans() throws CapiException {
        int n = 0;
        boolean bl = true;
        int n2 = 0;
        while (bl && n2 < 3) {
            bl = false;
            ++n2;
            for (CertDBItem certDBItem : this.list(7)) {
                if (certDBItem.getSource() != 5) continue;
                byte[] byArray = certDBItem.getCertificate().getAuthorityKeyIdentifier();
                boolean bl2 = false;
                for (CertDBItem certDBItem2 : this.list(7)) {
                    byte[] byArray2;
                    if (certDBItem2.getType() != 2 && certDBItem2.getSource() != 5 || !Util.equalsBlock(byArray, byArray2 = certDBItem2.getCertificate().getAuthorityKeyIdentifier())) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                this.delete(certDBItem);
                bl = true;
                ++n;
                a.info("removed orphan root " + certDBItem.getID());
            }
        }
        return n;
    }

    public CertDBDiff diffFrom(CertDB certDB) throws CertDBException, CapiException {
        return this.diffFrom(certDB, null);
    }

    public CertDBDiff diffFrom(CertDB certDB, ArrayList<it.actalis.ellips.capi.core.Certificate> arrayList) throws CertDBException, CapiException {
        int n;
        CertDBDiff certDBDiff = new CertDBDiff();
        for (CertDBItem certDBItem : certDB.list(7)) {
            CertDBItem certDBItem2;
            if (arrayList != null) {
                boolean bl = false;
                for (n = 0; n < arrayList.size(); ++n) {
                    if (!new it.actalis.ellips.capi.core.Certificate(certDBItem.getCert(true)).equals(arrayList.get(n))) continue;
                    bl = true;
                }
                if (bl) continue;
            }
            if ((certDBItem2 = this.contains(certDBItem.getCert(true))) != null) {
                if (certDBItem2.isEqualTo(certDBItem)) continue;
                certDBDiff.addUpdated(certDBItem, certDBItem2);
                continue;
            }
            certDBDiff.addRemove(certDBItem);
        }
        for (CertDBItem certDBItem : this.list(7)) {
            CertDBItem certDBItem3;
            if (arrayList != null) {
                boolean bl = false;
                for (n = 0; n < arrayList.size(); ++n) {
                    if (!new it.actalis.ellips.capi.core.Certificate(certDBItem.getCert(true)).equals(arrayList.get(n))) continue;
                    bl = true;
                }
                if (bl) continue;
            }
            if ((certDBItem3 = certDB.contains(certDBItem.getCert(true))) != null) continue;
            certDBDiff.addAdded(certDBItem);
        }
        return certDBDiff;
    }

    public boolean isValidChain(CertDBItem[] certDBItemArray, ValidationProfile validationProfile) {
        if (certDBItemArray == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = true;
        for (CertDBItem certDBItem : certDBItemArray) {
            boolean bl3 = CertDBItem.SOURCES_IN_CDB.contains(certDBItem.getSource());
            boolean bl4 = certDBItem.getSource() == 5;
            boolean bl5 = CertDBItem.SOURCES_TRUSTED.contains(certDBItem.getSource());
            if (ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE.equals((Object)validationProfile) && 1 == certDBItem.getSource()) {
                bl = true;
            } else if (bl5) {
                bl = true;
            }
            if (!bl3 || certDBItem.isAdmittedByProfile(validationProfile) || bl4) continue;
            a.debug(String.format("certificate %s is not valid for selected validation profile %s", certDBItem.getName(), validationProfile.name()));
            bl2 = false;
            break;
        }
        return bl2 && bl;
    }
}

