/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.parser.utils;

import esecurity.dts.TimeStampToken;
import esecurity.dts.util.ApiGeneralException;
import esecurity.validator.bean.RefCertificate;
import esecurity.validator.bean.ReferenceDoc;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.bean.TransientDocument;
import esecurity.validator.bean.TstSpecific;
import esecurity.validator.constants.ContainerFormat;
import esecurity.validator.constants.SignatureFormat;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import org.slf4j.Logger;

public class TSTUtils {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static SignatureInformation tstToVol(TransientDocument transientDocument, byte[] object, InputHandler object2, String string, DateFormat dateFormat) throws ApiGeneralException {
        SignatureInformation signatureInformation = new SignatureInformation();
        try {
            signatureInformation.setFormat(SignatureFormat.TST);
            signatureInformation.setSignatureInfo((byte[])object);
            signatureInformation.setContainerFormat(ContainerFormat.SELF);
            if (string != null && !string.isEmpty()) {
                signatureInformation.addRefDoc(new ReferenceDoc(string, true));
            }
            object = new TimeStampToken((byte[])object);
            boolean bl = false;
            try {
                bl = ((TimeStampToken)object).compare(((InputHandler)object2).getInputAsNewStream());
            }
            catch (Exception exception) {}
            if (((TimeStampToken)object).getTSACert() != null) {
                object2 = Utils.calculateDigest(new ByteArrayInputStream(((TimeStampToken)object).getTSACert().getDerEncoded()), Constants.SHA256);
                signatureInformation.setRefsCertId((String)object2);
                RefCertificate refCertificate = new RefCertificate();
                refCertificate.setId((String)object2);
                refCertificate.setContent(((TimeStampToken)object).getTSACert().getDerEncoded());
                refCertificate.setCapiCertificate(((TimeStampToken)object).getTSACert());
                signatureInformation.setSignatureDate(dateFormat.format(((TimeStampToken)object).getDate()));
                object2 = refCertificate.getCapiCertificate();
                signatureInformation.setSignerName(((Certificate)object2).getName());
                transientDocument.addCert(refCertificate);
                boolean bl2 = false;
                try {
                    bl2 = ((TimeStampToken)object).verifySignature();
                }
                catch (Exception exception) {}
                if (bl && bl2) {
                    signatureInformation.setCorrupted(false);
                } else {
                    signatureInformation.setCorrupted(true);
                }
            } else {
                signatureInformation.setSignerName("NO_CERT_FOUND_INSIDE_SIGNATURE");
            }
            object2 = new TstSpecific();
            ((TstSpecific)object2).setRelatedToDoc(bl);
            signatureInformation.setTstSpecific((TstSpecific)object2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            a.error(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
        }
        return signatureInformation;
    }
}

