/*
 * Decompiled with CFR 0.152.
 */
package esecurity.tsl;

import esecurity.tsl.CertDb;
import esecurity.tsl.CertDbType;
import esecurity.tsl.memory.MemoryCdb;
import esecurity.tsl.sqllite.ManifestValidator;
import esecurity.tsl.sqllite.SqlLiteCdb;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import java.io.File;
import java.io.IOException;

public class CertDbBuilder {
    private File file;
    private CertDbType type;
    private ManifestValidator validator;
    private NetworkConfig networkConfig;

    private CertDbBuilder() {
    }

    public static CertDbBuilder get() {
        return new CertDbBuilder();
    }

    public CertDbBuilder setNetworkConfig(NetworkConfig networkConfig) {
        this.networkConfig = networkConfig;
        return this;
    }

    public CertDbBuilder setFile(File file) {
        this.file = file;
        return this;
    }

    public CertDbBuilder setType(CertDbType certDbType) {
        this.type = certDbType;
        return this;
    }

    public CertDbBuilder setManifestValidator(ManifestValidator manifestValidator) {
        this.validator = manifestValidator;
        return this;
    }

    public CertDb build() throws IOException {
        if (this.type == CertDbType.MEMORY) {
            return this.initMemory();
        }
        if (this.type == CertDbType.SQLLITE) {
            return this.initSqlLite();
        }
        return null;
    }

    private CertDb initMemory() throws IOException {
        if (this.networkConfig == null) {
            throw new IOException("Invalid Parameter networkConfig");
        }
        return new MemoryCdb(this.networkConfig);
    }

    private CertDb initSqlLite() throws IOException {
        if (this.networkConfig == null) {
            throw new IOException("Invalid Parameter networkConfig");
        }
        if (this.file == null) {
            throw new IOException("Invalid Parameter file");
        }
        if (this.validator == null) {
            throw new IOException("Invalid Parameter ManifestValidator");
        }
        return new SqlLiteCdb(this.networkConfig, this.file, this.validator);
    }
}

