/*
 * Decompiled with CFR 0.152.
 */
package esecurity.tsl;

import esecurity.tsl.ChainEntry;
import esecurity.tsl.ServiceDbItem;
import esecurity.tsl.TSLServiceTypeIdentifiers;
import esecurity.validator.ValidationDate;
import esecurity.validator.constants.ValidationProfile;
import it.actalis.ellips.capi.tsl.TSLStatus;
import java.util.Date;
import java.util.Iterator;

public class CertChain
implements Iterable<ChainEntry> {
    private ChainEntry startEntry = null;

    public CertChain(ChainEntry chainEntry) {
        this.startEntry = chainEntry;
    }

    public boolean overAllOk() {
        return !this.startEntry.isCorruptedSignature();
    }

    public boolean isMatchProfile(ValidationProfile validationProfile, ValidationDate validationDate) {
        if (!this.overAllOk()) {
            return false;
        }
        if (ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE.equals((Object)validationProfile)) {
            return this.isMatchQualified(validationDate.getDate());
        }
        return this.isMatchNotQualified(validationProfile, validationDate.getDate());
    }

    private boolean isMatchNotQualified(ValidationProfile validationProfile, Date date) {
        for (ChainEntry chainEntry : this) {
            if (this.isSignerCertificate(chainEntry)) continue;
            if (!this.isEntryInCdb(chainEntry)) {
                return false;
            }
            if (!chainEntry.isAdmittedByProfile(validationProfile, date)) {
                return false;
            }
            if (!chainEntry.getCert().getIssuerDN().equals(chainEntry.getCert().getSubjectDN())) continue;
            return true;
        }
        return false;
    }

    private boolean isMatchQualified(Date date) {
        for (ChainEntry chainEntry : this) {
            if (!this.isEntryInCdb(chainEntry)) continue;
            if (this.isEntryPreTsl(chainEntry)) break;
            if (!chainEntry.isAdmittedByProfile(ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, date)) {
                return false;
            }
            if (!this.isEntryTrusted(chainEntry, date)) {
                return false;
            }
            if (!this.isEntrysigned(chainEntry)) continue;
            return true;
        }
        return false;
    }

    private boolean isEntrysigned(ChainEntry iterator) {
        if ((iterator = ((ChainEntry)((Object)iterator)).getCertDbItem()).isEmpty()) {
            return false;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            ServiceDbItem serviceDbItem = (ServiceDbItem)iterator.next();
            if (!serviceDbItem.isValidSignature()) continue;
            return true;
        }
        return false;
    }

    private boolean isSignerCertificate(ChainEntry iterator) {
        if ((iterator = ((ChainEntry)((Object)iterator)).getCertDbItem()).isEmpty()) {
            return false;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            ServiceDbItem serviceDbItem = (ServiceDbItem)iterator.next();
            if (!TSLServiceTypeIdentifiers.SignerCertificate.equals((Object)serviceDbItem.getServiceType())) continue;
            return true;
        }
        return false;
    }

    private boolean isEntryInCdb(ChainEntry iterator) {
        if ((iterator = ((ChainEntry)((Object)iterator)).getCertDbItem()).isEmpty()) {
            return false;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            ServiceDbItem serviceDbItem = (ServiceDbItem)iterator.next();
            TSLServiceTypeIdentifiers tSLServiceTypeIdentifiers = serviceDbItem.getServiceType();
            if (tSLServiceTypeIdentifiers.equals((Object)TSLServiceTypeIdentifiers.SignerCertificate)) {
                return false;
            }
            if (!tSLServiceTypeIdentifiers.equals((Object)TSLServiceTypeIdentifiers.CaIssuer) || serviceDbItem.isValidSignature()) continue;
            return false;
        }
        return true;
    }

    private boolean isEntryPreTsl(ChainEntry iterator) {
        if ((iterator = ((ChainEntry)((Object)iterator)).getCertDbItem()).isEmpty()) {
            return false;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            ServiceDbItem serviceDbItem = (ServiceDbItem)iterator.next();
            TSLServiceTypeIdentifiers tSLServiceTypeIdentifiers = serviceDbItem.getServiceType();
            if (!tSLServiceTypeIdentifiers.equals((Object)TSLServiceTypeIdentifiers.CaIssuer) || !serviceDbItem.isValidSignature()) continue;
            return true;
        }
        return false;
    }

    private boolean isEntryTrusted(ChainEntry iterator, Date date) {
        if ((iterator = ((ChainEntry)((Object)iterator)).getCertDbItem()).isEmpty()) {
            return false;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            ServiceDbItem serviceDbItem = (ServiceDbItem)iterator.next();
            if (serviceDbItem.getStatusStartingTime() != null && serviceDbItem.getStatusStartingTime().after(date)) {
                for (ServiceDbItem serviceDbItem2 : serviceDbItem.getHistory()) {
                    if (serviceDbItem2.getStatusStartingTime() != null && serviceDbItem2.getStatusStartingTime().after(date) || TSLStatus.isStatusIn(TSLStatus.StatusGroup.UNTRUSTED, serviceDbItem2.getServiceStatus()) || TSLStatus.isStatusIn(TSLStatus.StatusGroup.REMOVED, serviceDbItem2.getServiceStatus())) continue;
                    return true;
                }
                continue;
            }
            if (TSLStatus.isStatusIn(TSLStatus.StatusGroup.UNTRUSTED, serviceDbItem.getServiceStatus()) || TSLStatus.isStatusIn(TSLStatus.StatusGroup.REMOVED, serviceDbItem.getServiceStatus())) continue;
            return true;
        }
        return false;
    }

    public ChainEntry getStartEntry() {
        return this.startEntry;
    }

    @Override
    public Iterator<ChainEntry> iterator() {
        return new Iterator<ChainEntry>(){
            ChainEntry current = null;

            @Override
            public boolean hasNext() {
                if (this.current != null) {
                    return this.current.parent != null;
                }
                return CertChain.this.startEntry != null;
            }

            @Override
            public ChainEntry next() {
                if (this.current != null) {
                    this.current = this.current.parent;
                    return this.current;
                }
                if (CertChain.this.startEntry != null) {
                    this.current = CertChain.this.startEntry;
                }
                return this.current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove from CertChain is forbidden");
            }
        };
    }
}

