/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.util.m7m;

import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.slf4j.Logger;

public class SimpleMimeReader {
    private InputStream a = null;
    private String b = "";
    private String c = "";
    private String d = "";
    private String e = "";
    private byte[] f = new byte[0];
    private byte[] g = new byte[0];
    private boolean h = false;
    private ByteArrayOutputStream i = new ByteArrayOutputStream(4096);
    private static final Logger j = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("USAGE: java SimpleMimeReader MimeFileName");
            return;
        }
        long l = System.currentTimeMillis();
        try {
            SimpleMimeReader simpleMimeReader = new SimpleMimeReader(new FileInputStream(stringArray[0]));
            System.out.println("BOUNDARY: " + simpleMimeReader.getBoundaryText());
            System.out.println("PREAMBLE: " + simpleMimeReader.getPreamble());
            System.out.println("CONTENT-TYPE: " + SimpleMimeReader.getHeaderValue(simpleMimeReader.getMessageHeader(), "content-type"));
            System.out.println("MESSAGE HEADER:\n" + simpleMimeReader.getMessageHeader());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            while (simpleMimeReader.nextPart()) {
                System.out.println("----------\nPART " + ++n + "\n----------");
                System.out.println("TYPE: " + simpleMimeReader.getPartType());
                System.out.println("ENCODING: " + simpleMimeReader.getPartEncoding());
                System.out.println("CONTENT ID: " + simpleMimeReader.getPartID());
                System.out.println("CONTENT DISPOSITION: " + SimpleMimeReader.getHeaderValue(simpleMimeReader.getPartHeader(), "Content-Disposition"));
                System.out.println("HEADER:\n" + simpleMimeReader.getPartHeader());
                long l2 = simpleMimeReader.getPartData(byteArrayOutputStream);
                System.out.println("BODY LENGTH: " + l2);
                byteArrayOutputStream.writeTo(new FileOutputStream(stringArray[0] + ".file" + n));
                byteArrayOutputStream.reset();
            }
            System.out.println("----------");
            System.out.println("EPILOGUE: " + simpleMimeReader.getEpilogue());
        }
        catch (Exception exception) {
            j.error(exception.getMessage(), (Throwable)exception);
        }
        long l3 = System.currentTimeMillis();
        System.out.println(String.valueOf(l3 - l) + " ms");
    }

    public SimpleMimeReader(InputStream inputStream) {
        this.a = new BufferedInputStream(inputStream, 4096);
        this.b();
    }

    public boolean nextPart() {
        if (this.c.equals(this.b + "--")) {
            String string = this.b;
            this.b = "";
            this.h = false;
            this.g = this.getPartDataAsBytes();
            this.b = string;
            this.c = "";
            this.d = "";
            return false;
        }
        if (!this.h) {
            this.getPartData(null);
        }
        this.d = this.b.length() == 0 && this.d.length() == 0 ? this.e : this.a();
        this.h = false;
        return this.d.length() > 0;
    }

    public String getBoundaryText() {
        return this.b;
    }

    public String getMessageHeader() {
        return this.e;
    }

    public String getPartHeader() {
        return this.d;
    }

    public String getPreamble() {
        return new String(this.f);
    }

    public byte[] getPreambleBytes() {
        byte[] byArray = new byte[this.f.length];
        System.arraycopy(this.f, 0, byArray, 0, this.f.length);
        return byArray;
    }

    public String getEpilogue() {
        return new String(this.g);
    }

    public byte[] getEpilogueBytes() {
        byte[] byArray = new byte[this.g.length];
        System.arraycopy(this.g, 0, byArray, 0, this.g.length);
        return byArray;
    }

    public byte[] getPartDataAsBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.getPartData(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public String getPartDataAsString() {
        return new String(this.getPartDataAsBytes());
    }

    public long getPartData(OutputStream object) {
        long l = 0L;
        if (this.h) {
            return 0L;
        }
        BufferedOutputStream bufferedOutputStream = null;
        if (object != null) {
            bufferedOutputStream = new BufferedOutputStream((OutputStream)object, 4096);
        }
        byte[] byArray = new byte[]{};
        SimpleMimeReader simpleMimeReader = this;
        byte[] byArray2 = simpleMimeReader.a(simpleMimeReader.a);
        while (byArray2.length > 0) {
            object = new String(byArray2);
            if (this.b.length() > 0 && ((String)object).startsWith(this.b)) {
                if (byArray.length > 1) {
                    int n = byArray[byArray.length - 2] == 13 ? byArray.length - 2 : byArray.length - 1;
                    l += (long)SimpleMimeReader.a(bufferedOutputStream, byArray, n);
                }
                this.c = ((String)object).trim();
                break;
            }
            l += (long)SimpleMimeReader.a(bufferedOutputStream, byArray, byArray.length);
            byArray = byArray2;
            SimpleMimeReader simpleMimeReader2 = this;
            byArray2 = simpleMimeReader2.a(simpleMimeReader2.a);
        }
        if (byArray2.length == 0 && byArray.length > 0) {
            l += (long)SimpleMimeReader.a(bufferedOutputStream, byArray, byArray.length);
        }
        if (bufferedOutputStream != null) {
            try {
                bufferedOutputStream.flush();
            }
            catch (Exception exception) {}
        }
        this.h = true;
        return l;
    }

    private static int a(OutputStream outputStream, byte[] byArray, int n) {
        if (outputStream == null) {
            return 0;
        }
        try {
            outputStream.write(byArray, 0, n);
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public String getPartType() {
        return SimpleMimeReader.getHeaderValue(this.d, "Content-Type");
    }

    public String getPartEncoding() {
        return SimpleMimeReader.getHeaderValue(this.d, "Content-Transfer-Encoding");
    }

    public String getDescription() {
        return SimpleMimeReader.getHeaderValue(this.d, "Content-Description");
    }

    public String getPartID() {
        return SimpleMimeReader.getHeaderValue(this.d, "Content-ID");
    }

    public static String getHeaderValue(String string, String string2) {
        String string3 = null;
        boolean bl = false;
        if (!(string2 = string2.toLowerCase()).endsWith(":")) {
            string2 = string2 + ":";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (string.toLowerCase().startsWith(string2)) {
                string3 = string.substring(string2.length()).trim();
                bl = true;
                continue;
            }
            if (!bl || string.length() <= 0) continue;
            if (Character.isWhitespace(string.charAt(0))) {
                string3 = string3 + " " + string.trim();
                continue;
            }
            bl = false;
        }
        return string3;
    }

    private String a() {
        StringBuffer stringBuffer = new StringBuffer("");
        SimpleMimeReader simpleMimeReader = this;
        Object object = simpleMimeReader.a(simpleMimeReader.a);
        while (((byte[])object).length > 0) {
            String string = new String((byte[])object);
            object = string;
            if (string.trim().length() == 0) break;
            stringBuffer.append((String)object);
            SimpleMimeReader simpleMimeReader2 = this;
            object = simpleMimeReader2.a(simpleMimeReader2.a);
        }
        return stringBuffer.toString();
    }

    private void b() {
        String string;
        while (this.e.trim().length() == 0) {
            this.e = this.e + this.a();
            try {
                if (this.a.available() != 0) continue;
                System.out.println("Reached the EOF");
                break;
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
            }
        }
        if ((string = SimpleMimeReader.getHeaderValue(this.e, "content-type")) != null) {
            int n = string.toLowerCase().indexOf("boundary");
            int n2 = string.indexOf(59, n);
            if (n2 < 0) {
                n2 = string.length();
            }
            if (n > 0 && n2 > n) {
                this.b = string.substring(n + 9, n2);
            }
        }
        if (this.b.startsWith("\"")) {
            this.b = this.b.substring(1);
        }
        if (this.b.endsWith("\"")) {
            this.b = this.b.substring(0, this.b.length() - 1);
        }
        this.b = this.b.trim();
        if (this.b.length() == 0) {
            this.h = true;
            return;
        }
        this.b = "--" + this.b;
        this.f = this.getPartDataAsBytes();
    }

    private byte[] a(InputStream inputStream) {
        this.i.reset();
        try {
            int n;
            while ((n = inputStream.read()) != -1) {
                this.i.write(n);
                if (n != 10) continue;
                break;
            }
        }
        catch (Exception exception) {}
        return this.i.toByteArray();
    }
}

