/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.search.browser.firefox;

import com.btr.proxy.search.browser.firefox.FirefoxProfileSource;
import com.btr.proxy.search.desktop.win.Win32ProxyUtils;
import com.btr.proxy.util.Logger;
import java.io.File;
import java.io.IOException;

class WinFirefoxProfileSource
implements FirefoxProfileSource {
    private String getAppFolder() {
        return new Win32ProxyUtils().readUserHomedir();
    }

    public File getProfileFolder() throws IOException {
        File appDataDir = new File(this.getAppFolder());
        File cfgDir = new File(appDataDir, "Mozilla" + File.separator + "Firefox" + File.separator + "Profiles");
        if (!cfgDir.exists()) {
            Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "Firefox windows settings folder not found.", new Object[0]);
            return null;
        }
        File[] profiles = cfgDir.listFiles();
        if (profiles == null || profiles.length == 0) {
            Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "Firefox windows settings folder not found.", new Object[0]);
            return null;
        }
        for (File p : profiles) {
            if (!p.getName().endsWith(".default")) continue;
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Firefox windows settings folder is {0}.", p);
            return p;
        }
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Firefox windows settings folder is {0}.", profiles[0]);
        return profiles[0];
    }
}

