/*
 * Decompiled with CFR 0.152.
 */
package it.arubapec.ca.pkcs11.card;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.TokenHelper;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.provider.ActalisSingleton;
import it.actalis.ellips.util.ATR;
import it.actalis.pkcs11.PKCS11Exception;
import it.actalis.pkcs11.PKCS11Object;
import it.actalis.pkcs11.PKCS11Session;
import it.actalis.pkcs11.PKCS11Slot;
import it.actalis.pkcs11.nat.NativePKCS11;
import it.actalis.pkcs11.nat.Platform;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.pcsc.SCardUtils;
import it.arubapec.ca.pkcs11.card.CNSStrategy;
import it.arubapec.ca.pkcs11.card.Card;
import it.arubapec.ca.pkcs11.card.CardFamily;
import it.arubapec.ca.pkcs11.card.CardFamilyMatch;
import it.arubapec.ca.pkcs11.card.CardLibrary;
import it.arubapec.ca.pkcs11.card.CardService;
import it.arubapec.ca.pkcs11.card.CardUtilsConfig;
import it.arubapec.ca.pkcs11.card.CertificateInfo;
import it.arubapec.ca.pkcs11.card.DSStrategy;
import it.arubapec.ca.pkcs11.card.DataFileInfo;
import it.arubapec.ca.pkcs11.card.FamilyName;
import it.arubapec.ca.pkcs11.card.ObjectsInfo;
import it.arubapec.ca.utils.ConfigParameter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectDirectoryAttributes;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.paddings.ZeroBytePadding;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;

@Deprecated
public class CardUtils {
    public static final int KEY_DS = 0;
    public static final int KEY_AUTH = 1;
    public static final int KEY_CNS = 2;
    public static final int KEY_P11 = 3;
    public static final int CNSKEY_SIZE = 1024;
    public static final int DSKEY_SIZE = 2048;
    private static String a;
    private static CardFamily b;
    private static final Logger c;
    public static final String NO_CARD_DETECTED = "No card detected";
    public static final String NO_MODULE_LOADED = "No module loaded";
    public static final String NO_DRIVER_INIT = "No driver initialized for identified modules";
    public static final String NO_CARD_LOADED = "No card loaded";
    public static final String NO_VALID_URL = "Not valid URL:";
    private static CardService d;

    @Deprecated
    public static int SetBlackList(String string) {
        int n;
        try {
            a = string;
            n = 0;
        }
        catch (Exception exception) {
            n = -1;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return n;
    }

    public static List<Card> retrieveCardListV2(ConfigParameter configParameter) {
        CardUtilsConfig cardUtilsConfig = new CardUtilsConfig();
        cardUtilsConfig.setP11Override(configParameter.getP11Override());
        cardUtilsConfig.setIgnoreATR(configParameter.getIgnoreAtr());
        cardUtilsConfig.setRuntimeType(configParameter.getRuntimeType());
        return CardUtils.retrieveCardListV2(cardUtilsConfig);
    }

    public static List<Card> retrieveCardListV2(CardUtilsConfig iterator) {
        ArrayList<Card> arrayList = new ArrayList<Card>();
        try {
            iterator = CardUtils.retrieveCardMap((CardUtilsConfig)((Object)iterator));
            for (List<Card> list : iterator.values()) {
                arrayList.addAll(list);
            }
        }
        catch (IOException iOException) {
            c.error("Errore metodo retrieveCardMap(): " + iOException.getMessage(), (Throwable)iOException);
            arrayList.clear();
        }
        return arrayList;
    }

    public static Card refreshCard(Card card) {
        Card card2;
        block6: {
            card2 = null;
            try {
                if (card.getSetup() == null && card.getConf() == null) {
                    throw new CapiException("Card without any configuration!", 1003);
                }
                List<Card> list = card.getConf() != null ? CardUtils.retrieveCardListV2(card.getConf()) : CardUtils.retrieveCardListV2(card.getSetup());
                if (list.size() <= 0) break block6;
                c.info("scandisco l'elenco delle card");
                for (int i = 0; i < list.size(); ++i) {
                    c.info("confronto il seriale card con il seriale previsto dalla richiesta di rinnovo");
                    if (!list.get(i).getSerial().equals(card.getSerial())) continue;
                    c.info("card individuata");
                    card2 = list.get(i);
                    break;
                }
            }
            catch (Throwable throwable) {
                c.error("Errore in fase di recupero card valida: " + throwable.getMessage());
            }
        }
        return card2;
    }

    public static boolean verifyPin(Card object, String string) throws PKCS11Exception {
        boolean bl;
        block17: {
            bl = false;
            if (object != null) {
                NativePKCS11 nativePKCS11 = null;
                try {
                    nativePKCS11 = ((Card)object).getCardFamily().getPKCS11(true);
                    object = ((Card)object).getSlot().openSession(6, null, null);
                    if (object == null) break block17;
                    try {
                        try {
                            ((PKCS11Session)object).logout();
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                        }
                        ((PKCS11Session)object).login(false, string);
                        bl = true;
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                        throw pKCS11Exception;
                    }
                    finally {
                        if (object != null) {
                            try {
                                ((PKCS11Session)object).logout();
                            }
                            catch (PKCS11Exception pKCS11Exception) {
                                c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                            }
                            ((PKCS11Session)object).close();
                        }
                    }
                }
                finally {
                    if (nativePKCS11 != null) {
                        nativePKCS11.libFinalizePublic();
                    }
                }
            }
        }
        return bl;
    }

    public static int ResetPinPuk(Card card, String string) throws PKCS11Exception {
        int n = -1;
        if (card != null) {
            n = CardUtils.initPin(card, string, card.getCardFamily().getDefaultPIN()) ? (CardUtils.changePuk(card, string, card.getCardFamily().getDefaultPUK()) ? 1 : -2) : -3;
        }
        return n;
    }

    public static String DecryptCodiceUtente(String string, String string2) {
        try {
            string = CardUtils.a(string.getBytes("UTF-8"), Base64.decode((byte[])string2.getBytes("UTF-8"))).substring(0, 8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = "KO-Errore in fase di decifratura: " + unsupportedEncodingException.getMessage();
        }
        return string;
    }

    public static String DecryptPIN(String string, String string2) {
        try {
            string = CardUtils.a(string.getBytes("UTF-8"), Base64.decode((byte[])string2.getBytes("UTF-8"))).substring(0, 5);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = "KO-Errore in fase di decifratura: " + unsupportedEncodingException.getMessage();
        }
        return string;
    }

    public static String DecryptPUK(String string, String string2) {
        try {
            string = CardUtils.a(string.getBytes("UTF-8"), Base64.decode((byte[])string2.getBytes("UTF-8"))).substring(0, 8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = "KO-Errore in fase di decifratura: " + unsupportedEncodingException.getMessage();
        }
        return string;
    }

    private static String a(byte[] byArray, byte[] object) {
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = new byte[16];
        for (int i = 0; i < 32; ++i) {
            if (i < 16) {
                if (i > 7) {
                    byArray3[i] = 0;
                    continue;
                }
                byArray3[i] = object[i];
                continue;
            }
            byArray4[i - 16] = object[i];
        }
        AESEngine aESEngine = new AESEngine();
        object = new CBCBlockCipher((BlockCipher)aESEngine);
        object = new PaddedBufferedBlockCipher((BlockCipher)object);
        try {
            object.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(CardUtils.c(new String(byArray))), byArray3));
            int n = object.processBytes(byArray4, 0, 16, byArray2, 0);
            if (n == 0) {
                object.doFinal(byArray2, n);
            }
            object = new String(byArray2);
            byArray = object;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            if (exception.getMessage().equals("pad block corrupted")) {
                object = new CBCBlockCipher((BlockCipher)aESEngine);
                try {
                    PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher((BlockCipher)object, (BlockCipherPadding)new ZeroBytePadding());
                    object = paddedBufferedBlockCipher;
                    paddedBufferedBlockCipher.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(CardUtils.c(new String(byArray))), byArray3));
                    int n = object.processBytes(byArray4, 0, 16, byArray2, 0);
                    if (n == 0) {
                        object.doFinal(byArray2, n);
                    }
                    object = new String(byArray2);
                }
                catch (Exception exception3) {
                    object = "KO-Errore in fase di decifratura: " + exception3.getMessage();
                }
            } else {
                object = "KO-Errore in fase di decifratura: " + exception2.getMessage();
            }
            byArray = object;
        }
        return byArray;
    }

    public static String installX509(Card card, String string, String string2, String string3) {
        return CardUtils.a(card, string, string2, string3);
    }

    public static String installX509(Card card, String string, String string2) {
        return CardUtils.a(card, "", string, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String a(Card object, String object2, String string, String object3) {
        String string2 = "";
        if (object == null) return "KO-Nessuna card individuata";
        try {
            CardUtils.refreshCard((Card)object);
            PKCS11Session pKCS11Session = ((Card)object).getSlot().openSession(6, null, null);
            if (pKCS11Session == null) return string2;
            try {
                try {
                    pKCS11Session.logout();
                }
                catch (PKCS11Exception pKCS11Exception) {
                    c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                }
                if (object2 != null && !((String)object2).equals("")) {
                    pKCS11Session.login(false, (String)object2);
                } else {
                    pKCS11Session.login(false, ((Card)object).getCardFamily().getDefaultPIN());
                }
                int[] nArray = new int[]{0, 258};
                object = new Object[]{PKCS11Object.CERTIFICATE, string};
                if (CardUtils.a(pKCS11Session, nArray, (Object[])object) == 0) {
                    object = CertificateFactory.getInstance("X.509");
                    object2 = new ByteArrayInputStream(Base64.decode((String)object3));
                    object = (X509Certificate)((CertificateFactory)object).generateCertificate((InputStream)object2);
                    object2 = new ASN1Integer(((X509Certificate)object).getSerialNumber());
                    if (object != null) {
                        object3 = new int[]{0, 128, 2, 1, 130, 258, 3, 17, 129, 257};
                        object = new Object[]{PKCS11Object.CERTIFICATE, PKCS11Object.X_509, PKCS11Object.FALSE, PKCS11Object.TRUE, object2.getEncoded("DER"), string.getBytes("UTF-8"), string.getBytes("UTF-8"), ((Certificate)object).getEncoded(), PrincipalUtil.getIssuerX509Principal((X509Certificate)object).getEncoded(), PrincipalUtil.getSubjectX509Principal((X509Certificate)object).getEncoded()};
                        try {
                            pKCS11Session.createObject((int[])object3, (Object[])object);
                            string2 = "OK";
                            return string2;
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                            string2 = "KO-" + pKCS11Exception.getMessage();
                        }
                        return string2;
                    } else {
                        string2 = "KO-Errore in fase di generazione dell'oggetto X509";
                    }
                    return string2;
                } else {
                    string2 = "KO-La card contiene gi\u00e0 un certificato con la chiave indicata";
                }
                return string2;
            }
            catch (PKCS11Exception pKCS11Exception) {
                c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                string2 = "KO-Errore in fase di login alla card";
                return string2;
            }
            catch (Exception exception) {
                string2 = "KO-Errore in fase di installazione del certificato";
                return string2;
            }
            finally {
                if (pKCS11Session != null) {
                    try {
                        pKCS11Session.logout();
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                    }
                    pKCS11Session.close();
                }
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
            return "KO-Errore in fase di accesso alla card";
        }
    }

    public static String ChangePinPuk(Card object, String string, String string2, String string3, String string4) throws PKCS11Exception {
        object = CardUtils.changePin((Card)object, string, string2) ? (CardUtils.changePuk((Card)object, string3, string4) ? "OK" : "KO-Fallito changePuk") : "KO-Fallito changePin";
        return object;
    }

    public static boolean changePin(Card object, String string, String string2) throws PKCS11Exception {
        boolean bl = false;
        if (object != null) {
            CardUtils.refreshCard((Card)object);
            object = ((Card)object).getSlot().openSession(6, null, null);
            try {
                try {
                    ((PKCS11Session)object).logout();
                }
                catch (PKCS11Exception pKCS11Exception) {
                    c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                }
                ((PKCS11Session)object).login(false, string);
                ((PKCS11Session)object).setPIN(string, string2);
                bl = true;
            }
            catch (PKCS11Exception pKCS11Exception) {
                c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                throw pKCS11Exception;
            }
            catch (Exception exception) {
                c.error(exception.getMessage(), (Throwable)exception);
            }
            finally {
                if (object != null) {
                    try {
                        ((PKCS11Session)object).logout();
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                    }
                    ((PKCS11Session)object).close();
                }
            }
        }
        return bl;
    }

    public static boolean changePuk(Card object, String string, String string2) throws PKCS11Exception {
        boolean bl = false;
        if (object != null) {
            CardUtils.refreshCard((Card)object);
            object = ((Card)object).getSlot().openSession(6, null, null);
            try {
                try {
                    ((PKCS11Session)object).logout();
                }
                catch (PKCS11Exception pKCS11Exception) {
                    c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                }
                ((PKCS11Session)object).login(true, string);
                ((PKCS11Session)object).setPIN(string, string2);
                bl = true;
            }
            catch (PKCS11Exception pKCS11Exception) {
                c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                throw pKCS11Exception;
            }
            catch (Exception exception) {
                c.error(exception.getMessage(), (Throwable)exception);
            }
            finally {
                if (object != null) {
                    try {
                        ((PKCS11Session)object).logout();
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                    }
                    ((PKCS11Session)object).close();
                }
            }
        }
        return bl;
    }

    public static boolean initPin(Card object, String string, String string2) throws PKCS11Exception {
        boolean bl = false;
        if (object != null) {
            CardUtils.refreshCard((Card)object);
            object = ((Card)object).getSlot().openSession(6, null, null);
            try {
                try {
                    ((PKCS11Session)object).logout();
                }
                catch (PKCS11Exception pKCS11Exception) {
                    c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                }
                ((PKCS11Session)object).login(true, string);
                ((PKCS11Session)object).initPIN(string2);
                bl = true;
            }
            catch (PKCS11Exception pKCS11Exception) {
                c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                throw pKCS11Exception;
            }
            catch (Exception exception) {
                c.error(exception.getMessage(), (Throwable)exception);
            }
            finally {
                if (object != null) {
                    try {
                        ((PKCS11Session)object).logout();
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                    }
                    ((PKCS11Session)object).close();
                }
            }
        }
        return bl;
    }

    public static String generateKey(Card card, String string, int n, int n2, int n3) {
        return CardUtils.a(card, string, n, n2, n3);
    }

    public static String generateKey(Card card, String string, int n, int n2) {
        return CardUtils.a(card, string, n, n2, -1);
    }

    public static String generateKey(Card card, int n, int n2) {
        return CardUtils.a(card, "", n, n2, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String a(Card card, String string, int n, int n2, int n3) {
        String string2 = "";
        if (card == null) return "KO-" + CardUtils.class.getName() + "-Errore nessuna card individuata";
        try {
            CardUtils.refreshCard(card);
            PKCS11Session pKCS11Session = card.getSlot().openSession(6, null, null);
            if (pKCS11Session != null) {
                try {
                    if (string != null & !string.equals("")) {
                        CardUtils.a(pKCS11Session, string);
                    } else {
                        CardUtils.a(pKCS11Session, card.getCardFamily().getDefaultPIN());
                    }
                    string2 = CardUtils.a(pKCS11Session, n, n2, card.getCardFamily().getSelected_lib().getDrive(), n3);
                }
                catch (Exception exception) {
                    string2 = "KO-" + CardUtils.class.getName() + "-" + exception.getMessage();
                }
            }
            if (pKCS11Session == null) return string2;
            try {
                pKCS11Session.logout();
            }
            catch (PKCS11Exception pKCS11Exception) {
                c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
            }
            pKCS11Session.close();
            return string2;
        }
        catch (PKCS11Exception pKCS11Exception) {
            c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
            return "KO-" + CardUtils.class.getName() + "-" + pKCS11Exception.getMessage();
        }
        catch (Exception exception) {
            return "KO-" + CardUtils.class.getName() + "-" + exception.getMessage();
        }
    }

    private static String a(PKCS11Session pKCS11Session, int n, int n2, String objectArray, int n3) {
        String string;
        block33: {
            n3 = Math.max(0, n3);
            String string2 = "";
            Object object = "";
            String string3 = "";
            string = "KO-Errore generico in fase di generazione chiave";
            boolean bl = false;
            try {
                if (pKCS11Session != null) {
                    ObjectsInfo objectsInfo = CardUtils.a(pKCS11Session, true);
                    switch (n) {
                        case 0: {
                            if (objectArray.contains("asepkcs")) {
                                string2 = "Firma" + String.valueOf(n3);
                                object = "Firma" + String.valueOf(n3);
                                string3 = "Firma" + String.valueOf(n3);
                                break;
                            }
                            string2 = "DS" + String.valueOf(n3);
                            object = "DS" + String.valueOf(n3);
                            string3 = "DS" + String.valueOf(n3);
                            break;
                        }
                        case 1: {
                            string2 = "AUTH" + String.valueOf(n3);
                            object = "AUTH" + String.valueOf(n3);
                            string3 = "AUTH" + String.valueOf(n3);
                            break;
                        }
                        case 2: {
                            string2 = "CNS" + String.valueOf(n3);
                            object = "CNS" + String.valueOf(n3);
                            string3 = "CNS" + String.valueOf(n3);
                            break;
                        }
                        case 3: {
                            string2 = "FP11" + String.valueOf(n3);
                            object = "FP11" + String.valueOf(n3);
                            string3 = "FP11" + String.valueOf(n3);
                        }
                    }
                    Object object2 = new int[]{0, 258};
                    Object[] objectArray2 = new Object[]{PKCS11Object.PRIVATE_KEY, string2};
                    while (CardUtils.a(pKCS11Session, object2, objectArray2) == 1) {
                        ++n3;
                        switch (n) {
                            case 0: {
                                if (objectArray.contains("asepkcs")) {
                                    string2 = "Firma" + String.valueOf(n3);
                                    object = "Firma" + String.valueOf(n3);
                                    string3 = "Firma" + String.valueOf(n3);
                                    break;
                                }
                                string2 = "DS" + String.valueOf(n3);
                                object = "DS" + String.valueOf(n3);
                                string3 = "DS" + String.valueOf(n3);
                                break;
                            }
                            case 1: {
                                string2 = "AUTH" + String.valueOf(n3);
                                object = "AUTH" + String.valueOf(n3);
                                string3 = "AUTH" + String.valueOf(n3);
                                break;
                            }
                            case 2: {
                                string2 = "CNS" + String.valueOf(n3);
                                object = "CNS" + String.valueOf(n3);
                                string3 = "CNS" + String.valueOf(n3);
                                break;
                            }
                            case 3: {
                                string2 = "FP11" + String.valueOf(n3);
                                object = "FP11" + String.valueOf(n3);
                                string3 = "FP11" + String.valueOf(n3);
                            }
                        }
                        objectArray2[1] = string2;
                        if (n3 <= 9) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        objectArray = PKCS11Object.PUBLIC_KEY;
                        Object[] objectArray3 = PKCS11Object.PRIVATE_KEY;
                        Boolean bl2 = Boolean.FALSE;
                        object2 = Boolean.FALSE;
                        if (n != 0) {
                            bl2 = Boolean.TRUE;
                            object2 = Boolean.TRUE;
                        }
                        int[] nArray = new int[]{0, 258, 2, 1, 3, 260, 266, 262, 289, 290, 267};
                        objectArray = new Object[]{objectArray, string2.getBytes(), PKCS11Object.FALSE, PKCS11Object.TRUE, object, bl2, PKCS11Object.TRUE, object2, n2, new BigInteger("65537"), PKCS11Object.TRUE};
                        object = new int[]{0, 258, 2, 1, 3, 259, 261, 264, 263, 265};
                        objectArray3 = new Object[]{objectArray3, string2.getBytes(), PKCS11Object.TRUE, PKCS11Object.TRUE, string3, PKCS11Object.TRUE, bl2, PKCS11Object.TRUE, object2, PKCS11Object.TRUE};
                        c.debug("start with key generation trials (5)");
                        try {
                            int n4;
                            boolean bl3 = false;
                            for (int i = 0; i < 5; ++i) {
                                c.debug("trial " + i + "...");
                                object2 = pKCS11Session.generateKeyPair(0, null, nArray, objectArray, (int[])object, objectArray3);
                                c.debug("generation done. now check consistency");
                                int n5 = object2[0].getBigIntegerAttributeValue(288).bitLength();
                                n4 = object2[1].getBigIntegerAttributeValue(288).bitLength();
                                if (n5 != n2 || n4 != n2) {
                                    object2[0].destroy();
                                    object2[1].destroy();
                                    c.error(String.format("errore %d: le chiavi dovevano essere a %d bit. La chiave 0 e' a %d bit e la chiave 1 e' a %d bit", i, n2, n5, n4));
                                    continue;
                                }
                                BigInteger bigInteger = object2[0].getBigIntegerAttributeValue(288).shiftRight(n5 - 8);
                                if (bigInteger.intValue() == 0) {
                                    object2[0].destroy();
                                    object2[1].destroy();
                                    c.error(String.format("errore %d: La chiave 0 e' lunga %d bit ma il primo byte \u00e8 a zero", i, n5));
                                    continue;
                                }
                                BigInteger bigInteger2 = object2[1].getBigIntegerAttributeValue(288).shiftRight(n4 - 8);
                                if (bigInteger2.intValue() == 0) {
                                    object2[0].destroy();
                                    object2[1].destroy();
                                    c.error(String.format("errore %d: La chiave 1 e' lunga %d bit ma il primo byte \u00e8 a zero", i, n4));
                                    continue;
                                }
                                c.info("chiavi generate con la dimensione richiesta");
                                bl3 = true;
                                break;
                            }
                            if (bl3) {
                                c.debug("search for created key ID...");
                                ObjectsInfo objectsInfo2 = CardUtils.a(pKCS11Session, true);
                                for (int i = 0; i < objectsInfo2.getIDs().size(); ++i) {
                                    String string4 = objectsInfo2.getIDs().get(i);
                                    n4 = 0;
                                    for (int j = 0; j < objectsInfo.getIDs().size(); ++j) {
                                        if (!string4.equals(objectsInfo.getIDs().get(j))) continue;
                                        n4 = 1;
                                        break;
                                    }
                                    if (n4 != 0) continue;
                                    string = string4;
                                    c.debug("key ID is: " + string);
                                    break block33;
                                }
                                break block33;
                            }
                            string = "KO-Errore generazione chiave " + string2 + ". Dimensione chiave non conforme alla richiesta";
                        }
                        catch (Exception exception) {
                            string = "KO-Errore generazione chiave " + string2 + ": " + exception.getMessage();
                        }
                        break block33;
                    }
                    string = "KO-" + CardUtils.class.getName() + "Errore in fase di generazione chiave: elenco chiavi esaurito";
                    break block33;
                }
                string = "KO-" + CardUtils.class.getName() + "Errore in fase di generazione chiave: sessione non valida";
            }
            catch (Exception exception) {
                string = "KO-" + CardUtils.class.getName() + "Errore in fase di generazione chiave: " + exception.getMessage();
            }
        }
        return string;
    }

    /*
     * Loose catch block
     */
    public static int existObject(Card card, int[] nArray, Object[] objectArray, String string) {
        int n;
        int n2 = 0;
        try {
            block16: {
                PKCS11Session pKCS11Session = null;
                pKCS11Session = card.getSlot().openSession(6, null, null);
                CardUtils.a(pKCS11Session, string);
                if (0L != 0L) {
                    n2 = CardUtils.a(pKCS11Session, nArray, objectArray);
                }
                if (pKCS11Session == null) break block16;
                try {
                    pKCS11Session.logout();
                }
                catch (PKCS11Exception pKCS11Exception) {}
                pKCS11Session.close();
                break block16;
                catch (PKCS11Exception pKCS11Exception) {
                    try {
                        c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                        n2 = -1;
                        if (pKCS11Session == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (pKCS11Session != null) {
                            try {
                                pKCS11Session.logout();
                            }
                            catch (PKCS11Exception pKCS11Exception2) {}
                            pKCS11Session.close();
                        }
                        throw throwable;
                    }
                    try {
                        pKCS11Session.logout();
                    }
                    catch (PKCS11Exception pKCS11Exception3) {}
                    pKCS11Session.close();
                }
            }
            n = n2;
        }
        catch (PKCS11Exception pKCS11Exception) {
            c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
            n = -1;
        }
        return n;
    }

    private static int a(PKCS11Session pKCS11Session, int[] object, Object[] objectArray) {
        int n;
        int n2 = 0;
        try {
            pKCS11Session.findObjectsInit((int[])object, objectArray);
            object = pKCS11Session.findObject();
            pKCS11Session.findObjectsFinal();
            if (object != null) {
                n2 = 1;
            }
            n = n2;
        }
        catch (PKCS11Exception pKCS11Exception) {
            c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
            n = -1;
        }
        return n;
    }

    private static String a(String object) {
        object = ((String)object).toCharArray();
        String string = "";
        for (int i = 0; i <= ((Object)object).length - 1; ++i) {
            if (object[i] == 43) continue;
            string = string + (char)object[i];
        }
        return string;
    }

    private static String a(int n, int n2) {
        String string = Integer.toHexString(n);
        for (int i = 1; i <= n2; ++i) {
            if (string.length() >= n2) continue;
            string = "0" + string;
        }
        return string;
    }

    public static String destroyUserDataFile(Card object, String objectArray) {
        String string = "";
        String string2 = "";
        try {
            if (object != null) {
                PKCS11Session pKCS11Session = null;
                try {
                    pKCS11Session = ((Card)object).getSlot().openSession(6, null, null);
                }
                catch (PKCS11Exception pKCS11Exception) {
                    c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                    string2 = "KO-Errore in fase di apertura sessione: " + pKCS11Exception.getMessage();
                }
                if (pKCS11Session != null) {
                    try {
                        if (string2.equals("")) {
                            CardUtils.a(pKCS11Session, (String)objectArray);
                            object = new int[]{0};
                            objectArray = new Object[]{PKCS11Object.DATA};
                            pKCS11Session.findObjectsInit((int[])object, objectArray);
                            PKCS11Object pKCS11Object = pKCS11Session.findObject();
                            pKCS11Session.findObjectsFinal();
                            if (pKCS11Object != null) {
                                pKCS11Object.destroy();
                                string2 = CardUtils.a(pKCS11Session, (int[])object, objectArray) != 1 ? "OK" : "KO-Errore in fase di cancellazione PDATA";
                            }
                        }
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                        string2 = "KO-Errore in fase di Login: " + pKCS11Exception.getMessage();
                    }
                    finally {
                        if (pKCS11Session != null) {
                            try {
                                pKCS11Session.logout();
                            }
                            catch (PKCS11Exception pKCS11Exception) {
                                c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                            }
                            pKCS11Session.close();
                        }
                    }
                }
            }
            object = string2.equals("") ? string : string2;
        }
        catch (Exception exception) {
            try {
                string2 = "KO-" + exception.getMessage();
                object = string2.equals("") ? string : string2;
            }
            catch (Throwable throwable) {
                string2.equals("");
                throw throwable;
            }
        }
        return object;
    }

    public static String retrieveCertificate(PKCS11Session object, int[] object2, Object[] objectArray) {
        String string = "KO-Errore in fase di recupero certificato da rimuovere";
        try {
            if (object != null) {
                if (CardUtils.a((PKCS11Session)object, (int[])object2, objectArray) == 1) {
                    ((PKCS11Session)object).findObjectsInit((int[])object2, objectArray);
                    object2 = ((PKCS11Session)object).findObject();
                    ((PKCS11Session)object).findObjectsFinal();
                    object = ((PKCS11Object)object2).getByteArrayAttributeValue(17);
                    string = new String(Base64.encode((byte[])object));
                } else {
                    string = "";
                }
            }
            object = string;
        }
        catch (Exception exception) {
            string = "KO-" + exception.getMessage();
            object = string;
        }
        return object;
    }

    public static String retrieveCertificate(Card object, int[] nArray, Object[] objectArray) {
        String string = "KO-Errore in fase di recupero certificato da rimuovere";
        try {
            if (object != null) {
                PKCS11Session pKCS11Session = null;
                try {
                    try {
                        pKCS11Session = ((Card)object).getSlot().openSession(6, null, null);
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                        string = "KO-Errore in fase di apertura sessione: " + pKCS11Exception.getMessage();
                    }
                    if (pKCS11Session != null) {
                        string = CardUtils.retrieveCertificate(pKCS11Session, nArray, objectArray);
                    }
                }
                catch (PKCS11Exception pKCS11Exception) {
                    c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                    string = "KO-Errore in fase di apertura sessione: " + pKCS11Exception.getMessage();
                }
                finally {
                    if (pKCS11Session != null) {
                        try {
                            pKCS11Session.logout();
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                        }
                        pKCS11Session.close();
                    }
                }
            }
            object = string;
        }
        catch (Exception exception) {
            string = "KO-" + exception.getMessage();
            object = string;
        }
        return object;
    }

    public static String retrieveCertificate(Card object, String objectArray) {
        Object object2 = "KO-Errore in fase di recupero certificato da rimuovere";
        try {
            if (object != null) {
                object2 = new int[]{0, 258};
                objectArray = new Object[]{PKCS11Object.CERTIFICATE, objectArray};
                object = CardUtils.retrieveCertificate((Card)object, (int[])object2, objectArray);
                return object;
            }
        }
        catch (Exception exception) {
            object2 = "KO-" + exception.getMessage();
        }
        return object2;
    }

    public static List<CertificateInfo> retrieveCertificates(Card object, int[] objectArray, Object[] object2) {
        ArrayList<CertificateInfo> arrayList = new ArrayList<CertificateInfo>();
        try {
            if (object != null) {
                PKCS11Session pKCS11Session = null;
                try {
                    pKCS11Session = ((Card)object).getSlot().openSession(6, null, null);
                    if (pKCS11Session != null && CardUtils.a(pKCS11Session, objectArray, (Object[])object2) > 0) {
                        pKCS11Session.findObjectsInit((int[])objectArray, (Object[])object2);
                        while ((object = pKCS11Session.findObject()) != null) {
                            objectArray = ((PKCS11Object)object).getByteArrayAttributeValue(17);
                            object = ((PKCS11Object)object).getByteArrayAttributeValue(258);
                            object2 = new CertificateInfo();
                            ((CertificateInfo)object2).setX509(new String(Base64.encode((byte[])objectArray)));
                            ((CertificateInfo)object2).setID(new String((byte[])object));
                            arrayList.add((CertificateInfo)object2);
                        }
                    }
                }
                catch (PKCS11Exception pKCS11Exception) {
                    c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                }
                catch (Exception exception) {
                    c.error(exception.getMessage(), (Throwable)exception);
                }
                finally {
                    if (pKCS11Session != null) {
                        try {
                            pKCS11Session.logout();
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                        }
                        pKCS11Session.close();
                    }
                }
            }
            object = arrayList;
        }
        catch (Exception exception) {
            object = arrayList;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return object;
    }

    private static ObjectsInfo a(PKCS11Session pKCS11Session, boolean bl) {
        ObjectsInfo objectsInfo;
        block13: {
            c.debug("get IDs list");
            objectsInfo = new ObjectsInfo();
            objectsInfo.setEsito("OK");
            objectsInfo.setTipo("PubKey");
            if (bl) {
                objectsInfo.setTipo("PriKey");
            }
            try {
                int[] nArray = new int[]{0};
                Object[] objectArray = new Object[]{PKCS11Object.PRIVATE_KEY};
                objectArray[0] = bl ? PKCS11Object.PRIVATE_KEY : PKCS11Object.PUBLIC_KEY;
                if (CardUtils.a(pKCS11Session, nArray, objectArray) > 0) {
                    c.debug("some ids are present");
                    pKCS11Session.findObjectsInit(nArray, objectArray);
                    c.debug("ids found");
                    try {
                        Object object;
                        while ((object = pKCS11Session.findObject()) != null) {
                            object = new String(((PKCS11Object)object).getByteArrayAttributeValue(258), "UTF-8");
                            objectsInfo.getIDs().add((String)object);
                        }
                        break block13;
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                        throw pKCS11Exception;
                    }
                    finally {
                        pKCS11Session.findObjectsFinal();
                    }
                }
                objectsInfo.setEsito("OK");
            }
            catch (PKCS11Exception pKCS11Exception) {
                c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                objectsInfo.setEsito("KO-" + pKCS11Exception.getMessage());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                objectsInfo.setEsito("KO-" + unsupportedEncodingException.getMessage());
            }
        }
        c.debug(objectsInfo.getIDs().size() + " ids returned to caller");
        return objectsInfo;
    }

    public static ObjectsInfo retrieveKeysIDList(Card card, String string, boolean bl) {
        ObjectsInfo objectsInfo;
        block18: {
            objectsInfo = null;
            try {
                if (card != null) {
                    PKCS11Session pKCS11Session = null;
                    try {
                        card = CardUtils.refreshCard(card);
                        pKCS11Session = card.getSlot().openSession(6, null, null);
                        if (pKCS11Session != null) {
                            CardUtils.a(pKCS11Session, string);
                            objectsInfo = CardUtils.a(pKCS11Session, bl);
                        }
                        break block18;
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                        ((ObjectsInfo)null).setEsito("KO-" + pKCS11Exception.getMessage());
                        break block18;
                    }
                    finally {
                        if (pKCS11Session != null) {
                            try {
                                pKCS11Session.logout();
                            }
                            catch (PKCS11Exception pKCS11Exception) {
                                c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                            }
                            pKCS11Session.close();
                        }
                    }
                }
                ((ObjectsInfo)null).setEsito("KO-Errore in fase listing chiavi");
            }
            catch (Exception exception) {
                objectsInfo.setEsito("KO-" + exception.getMessage());
                objectsInfo.setIDs(null);
            }
        }
        return objectsInfo;
    }

    public static ObjectsInfo retrieveCertsIDList(Card object, String object2) {
        ObjectsInfo objectsInfo = new ObjectsInfo();
        objectsInfo.setEsito("OK");
        objectsInfo.setTipo("Cert");
        try {
            block23: {
                if (object != null) {
                    try {
                        object = ((Card)object).getSlot().openSession(6, null, null);
                        if (object == null) break block23;
                        try {
                            CardUtils.a((PKCS11Session)object, (String)object2);
                            object2 = new int[]{0};
                            Object[] objectArray = new Object[]{PKCS11Object.CERTIFICATE};
                            if (CardUtils.a((PKCS11Session)object, (int[])object2, objectArray) > 0) {
                                ((PKCS11Session)object).findObjectsInit((int[])object2, objectArray);
                                while ((object2 = ((PKCS11Session)object).findObject()) != null) {
                                    object2 = new String(((PKCS11Object)object2).getByteArrayAttributeValue(258), "UTF-8");
                                    objectsInfo.getIDs().add((String)object2);
                                }
                            } else {
                                objectsInfo.setEsito("OK");
                            }
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                            objectsInfo.setEsito("KO-" + pKCS11Exception.getMessage());
                        }
                        finally {
                            if (object != null) {
                                try {
                                    ((PKCS11Session)object).logout();
                                }
                                catch (PKCS11Exception pKCS11Exception) {
                                    c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                                }
                                ((PKCS11Session)object).close();
                            }
                        }
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                        objectsInfo.setEsito("KO-" + pKCS11Exception.getMessage());
                    }
                } else {
                    objectsInfo.setEsito("KO-Errore in fase listing certificati");
                }
            }
            object = objectsInfo;
        }
        catch (Exception exception) {
            objectsInfo.setEsito("KO-" + exception.getMessage());
            objectsInfo.setIDs(null);
            object = objectsInfo;
        }
        return object;
    }

    public static List<DataFileInfo> retrieveDataFiles(Card object, int[] objectArray, Object[] object2) {
        ArrayList<DataFileInfo> arrayList = new ArrayList<DataFileInfo>();
        try {
            if (object != null) {
                PKCS11Session pKCS11Session = null;
                try {
                    pKCS11Session = ((Card)object).getSlot().openSession(6, null, null);
                    if (pKCS11Session != null && CardUtils.a(pKCS11Session, objectArray, (Object[])object2) > 0) {
                        pKCS11Session.findObjectsInit((int[])objectArray, (Object[])object2);
                        while ((object = pKCS11Session.findObject()) != null) {
                            objectArray = ((PKCS11Object)object).getByteArrayAttributeValue(17);
                            object = ((PKCS11Object)object).getByteArrayAttributeValue(258);
                            object2 = new DataFileInfo();
                            ((DataFileInfo)object2).setContent(new String(Base64.encode((byte[])((byte[])objectArray))));
                            ((DataFileInfo)object2).setID(new String((byte[])object));
                            arrayList.add((DataFileInfo)object2);
                        }
                    }
                }
                catch (PKCS11Exception pKCS11Exception) {
                    c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                }
                catch (Exception exception) {
                    c.error(exception.getMessage(), (Throwable)exception);
                }
                finally {
                    if (pKCS11Session != null) {
                        try {
                            pKCS11Session.logout();
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                        }
                        pKCS11Session.close();
                    }
                }
            }
            object = arrayList;
        }
        catch (Exception exception) {
            object = arrayList;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return object;
    }

    /*
     * Exception decompiling
     */
    public static String retrieveUserDataFile(Card var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String retrieveKeyModulus(Card card, String string, String object, boolean bl) {
        String string2;
        block21: {
            string2 = "KO-Errore in fase di recupero del modulo della chiave " + string;
            try {
                if (card == null) break block21;
                PKCS11Session pKCS11Session = null;
                try {
                    pKCS11Session = card.getSlot().openSession(6, null, null);
                    if (pKCS11Session == null) break block21;
                    boolean bl2 = true;
                    try {
                        CardUtils.a(pKCS11Session, (String)object);
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                        bl2 = false;
                        string2 = "KO-Errore in fase di login per recupero oggetto privato: " + pKCS11Exception.getMessage();
                    }
                    if (bl2) {
                        object = new int[]{0, 258};
                        Object object2 = new Object[]{PKCS11Object.PRIVATE_KEY, string};
                        object2[0] = bl ? PKCS11Object.PRIVATE_KEY : PKCS11Object.PUBLIC_KEY;
                        if (CardUtils.a(pKCS11Session, (int[])object, (Object[])object2) == 1) {
                            pKCS11Session.findObjectsInit((int[])object, (Object[])object2);
                            object2 = pKCS11Session.findObject();
                            pKCS11Session.findObjectsFinal();
                            string2 = new String(Base64.encode((byte[])((PKCS11Object)object2).getByteArrayAttributeValue(288)));
                        } else {
                            string2 = "KO-chiave non trovata";
                        }
                    }
                }
                catch (PKCS11Exception pKCS11Exception) {
                    c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                    string2 = "KO-Errore in fase di apertura sessione: " + pKCS11Exception.getMessage();
                }
                finally {
                    if (pKCS11Session != null) {
                        try {
                            pKCS11Session.logout();
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                        }
                        pKCS11Session.close();
                    }
                }
            }
            catch (Exception exception) {
                string2 = "KO-" + exception.getMessage();
            }
        }
        return string2;
    }

    /*
     * Loose catch block
     */
    public static String destroyCert(Card object, String objectArray, String object2) {
        String string;
        block34: {
            string = "";
            try {
                c.info("Avvio destroyCert");
                if (object == null) break block34;
                PKCS11Session pKCS11Session = null;
                try {
                    pKCS11Session = ((Card)object).getSlot().openSession(6, null, null);
                }
                catch (PKCS11Exception pKCS11Exception) {
                    c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                    string = "KO-Errore in fase di apertura sessione: " + pKCS11Exception.getMessage();
                }
                if (pKCS11Session == null || !string.equals("")) break block34;
                try {
                    c.info("Eseguo login");
                    CardUtils.a(pKCS11Session, (String)object2);
                    c.info("Verifico presenza certificato");
                    object = new int[]{0, 258};
                    objectArray = new Object[]{PKCS11Object.CERTIFICATE, objectArray};
                    pKCS11Session.findObjectsInit((int[])object, objectArray);
                    object2 = pKCS11Session.findObject();
                    pKCS11Session.findObjectsFinal();
                    if (object2 != null) {
                        c.info("Avvio eliminazione certificato");
                        try {
                            ((PKCS11Object)object2).destroy();
                            string = "OK";
                            c.info("Certificato eliminato con successo");
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                            string = "KO-Errore in fase di cancellazione Certificato";
                        }
                    } else {
                        c.info("Certificato non presente");
                        string = "OK";
                    }
                    if (string.equals("OK")) {
                        c.info("Verifico presenza chiave privata");
                        objectArray[0] = PKCS11Object.PRIVATE_KEY;
                        pKCS11Session.findObjectsInit((int[])object, objectArray);
                        object2 = pKCS11Session.findObject();
                        pKCS11Session.findObjectsFinal();
                        if (object2 != null) {
                            c.info("Avvio eliminazione chiave privata");
                            try {
                                ((PKCS11Object)object2).destroy();
                                string = "OK";
                                c.info("Chiave privata eliminata con successo");
                            }
                            catch (PKCS11Exception pKCS11Exception) {
                                c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                                string = "KO-Errore in fase di cancellazione chiave privata";
                            }
                        } else {
                            c.info("Chiave privata non presente");
                            string = "OK";
                        }
                        if (string.equals("OK")) {
                            c.info("Verifico presenza chiave pubblica");
                            objectArray[0] = PKCS11Object.PUBLIC_KEY;
                            pKCS11Session.findObjectsInit((int[])object, objectArray);
                            object2 = pKCS11Session.findObject();
                            pKCS11Session.findObjectsFinal();
                            if (object2 != null) {
                                c.info("Avvio eliminazione chiave pubblica");
                                try {
                                    ((PKCS11Object)object2).destroy();
                                    string = "OK";
                                    c.info("Chiave pubblica eliminata con successo");
                                }
                                catch (PKCS11Exception pKCS11Exception) {
                                    c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                                    string = "KO-Errore in fase di cancellazione chiave pubblica";
                                }
                            } else {
                                c.info("Chiave pubblica non presente");
                                string = "OK";
                            }
                        }
                    }
                }
                catch (PKCS11Exception pKCS11Exception) {
                    c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                    string = "KO-" + pKCS11Exception.getMessage();
                }
                finally {
                    if (pKCS11Session != null) {
                        try {
                            pKCS11Session.logout();
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                        }
                        pKCS11Session.close();
                    }
                }
            }
            catch (PKCS11Exception pKCS11Exception) {
                c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                string = "KO-PKCS11Exception:" + pKCS11Exception.getMessage();
                c.error("PKCS11Exception", (Throwable)pKCS11Exception);
                c.info("Fine destroyCert");
                object = string.equals("") ? "OK" : string;
            }
            catch (Exception exception) {
                string = "KO-" + exception.getMessage();
                {
                    catch (Throwable throwable) {
                        c.info("Fine destroyCert");
                        string.equals("");
                        throw throwable;
                    }
                }
                c.info("Fine destroyCert");
                object = string.equals("") ? "OK" : string;
            }
        }
        c.info("Fine destroyCert");
        object = string.equals("") ? "OK" : string;
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String existsCert(Card object, String string, String string2) {
        String string3 = "KO-Errore verifica esistenza certificato";
        try {
            if (object == null) return string3;
            CardUtils.refreshCard((Card)object);
            try {
                object = ((Card)object).getSlot().openSession(6, null, null);
                return CardUtils.existsCert((PKCS11Session)object, string, string2);
            }
            catch (PKCS11Exception pKCS11Exception) {
                c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                string3 = "KO-" + pKCS11Exception.getMessage();
            }
            return string3;
        }
        catch (Exception exception) {
            string3 = "KO-" + exception.getMessage();
            return string3;
        }
    }

    public static String existsCert(PKCS11Session object, String object2, String object3) {
        String string = "KO-Errore verifica esistenza certificato";
        try {
            if (object != null) {
                try {
                    CardUtils.a((PKCS11Session)object, (String)object3);
                    object3 = new int[]{0, 258};
                    object2 = new Object[]{PKCS11Object.CERTIFICATE, object2};
                    ((PKCS11Session)object).findObjectsInit((int[])object3, (Object[])object2);
                    object2 = ((PKCS11Session)object).findObject();
                    ((PKCS11Session)object).findObjectsFinal();
                    string = object2 != null ? "OK" : "KO";
                }
                catch (PKCS11Exception pKCS11Exception) {
                    c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                    string = "KO-" + pKCS11Exception.getMessage();
                }
                finally {
                    if (object != null) {
                        try {
                            ((PKCS11Session)object).logout();
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                        }
                        ((PKCS11Session)object).close();
                    }
                }
            }
            object = string;
        }
        catch (Exception exception) {
            string = "KO-" + exception.getMessage();
            object = string;
        }
        return object;
    }

    public static String existsKey(Card object, String object2, String object3, boolean bl) {
        String string = "KO-Errore verifica esistenza certificato";
        try {
            block19: {
                if (object != null) {
                    CardUtils.refreshCard((Card)object);
                    try {
                        object = ((Card)object).getSlot().openSession(6, null, null);
                        if (object == null) break block19;
                        try {
                            CardUtils.a((PKCS11Session)object, (String)object3);
                            object3 = new int[]{0, 258};
                            object2 = new Object[]{PKCS11Object.PRIVATE_KEY, object2};
                            object2[0] = bl ? PKCS11Object.PRIVATE_KEY : PKCS11Object.PUBLIC_KEY;
                            ((PKCS11Session)object).findObjectsInit((int[])object3, (Object[])object2);
                            object2 = ((PKCS11Session)object).findObject();
                            ((PKCS11Session)object).findObjectsFinal();
                            string = object2 != null ? "OK" : "KO";
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                            string = "KO-" + pKCS11Exception.getMessage();
                        }
                        finally {
                            if (object != null) {
                                try {
                                    ((PKCS11Session)object).logout();
                                }
                                catch (PKCS11Exception pKCS11Exception) {
                                    c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                                }
                                ((PKCS11Session)object).close();
                            }
                        }
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                        string = "KO-" + pKCS11Exception.getMessage();
                    }
                }
            }
            object = string;
        }
        catch (Exception exception) {
            string = "KO-" + exception.getMessage();
            object = string;
        }
        return object;
    }

    public static String createUserDataFile(Card object, String object2, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String object3, String object4, String objectArray, String string11, String string12) {
        string6 = "";
        string8 = "";
        try {
            block31: {
                if (object != null) {
                    object3 = null;
                    try {
                        object3 = ((Card)object).getSlot().openSession(6, null, null);
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                        string8 = "KO-Errore in fase di apertura sessione: " + pKCS11Exception.getMessage();
                    }
                    if (object3 != null && string8.equals("")) {
                        try {
                            CardUtils.a((PKCS11Session)object3, ((Card)object).getCardFamily().getDefaultPIN());
                            if (!string8.equals("")) break block31;
                            object4 = new int[]{0};
                            objectArray = new Object[]{PKCS11Object.DATA};
                            if (CardUtils.a((PKCS11Session)object3, (int[])object4, objectArray) != 1) {
                                int n = ((String)object2).length();
                                int n2 = string.length();
                                int n3 = string2.length();
                                int n4 = string3.length();
                                int n5 = string4.length();
                                int n6 = string5.length();
                                int n7 = string7.length();
                                int n8 = string9.length();
                                int n9 = string10.length();
                                int n10 = string12.length();
                                if (n <= 0 || n >= 9 || n2 <= 0 || n2 >= 9 || n3 <= 0 || n3 >= 50 || n4 >= 50 || n5 <= 0 || n5 >= 9 || n6 != 1 || n7 != 16 || n8 != 4 || n9 != 4) break block31;
                                object2 = CardUtils.a(4, 2) + ((Card)object).getSerial().substring(0, 4) + CardUtils.a(n, 2) + (String)object2 + CardUtils.a(n2, 2) + string + CardUtils.a(n3, 2) + string2 + CardUtils.a(n4, 2) + string3 + CardUtils.a(n5, 2) + string4 + CardUtils.a(n6, 2) + string5 + CardUtils.a(0, 2) + CardUtils.a(n7, 2) + string7 + CardUtils.a(0, 2) + CardUtils.a(n8, 2) + string9 + CardUtils.a(0, 2) + CardUtils.a(0, 2) + CardUtils.a(n9, 2) + string10 + CardUtils.a(0, 2) + CardUtils.a(0, 2);
                                int n11 = ((String)object2).length();
                                object2 = CardUtils.a(n11 += 6, 6) + (String)object2;
                                try {
                                    Object[] objectArray2;
                                    int[] nArray;
                                    string6 = CardUtils.b((String)object2);
                                    if (string6 == "") break block31;
                                    Object[] objectArray3 = new char[400];
                                    object2 = ((String)object2).toCharArray();
                                    for (int i = 0; i < ((Object)object2).length; ++i) {
                                        objectArray3[i] = (char)object2[i];
                                    }
                                    if (n10 > 0 && n10 < 200) {
                                        char[] cArray = string12.toCharArray();
                                        for (int i = 0; i < n10; ++i) {
                                            objectArray3[i + 201] = cArray[i];
                                        }
                                    }
                                    if (CardUtils.a((PKCS11Session)object3, nArray = new int[]{0, 3}, objectArray2 = new Object[]{PKCS11Object.DATA, "PDATA"}) == 1) break block31;
                                    try {
                                        objectArray2 = new int[]{0, 1, 3, 17};
                                        objectArray3 = new Object[]{PKCS11Object.DATA, PKCS11Object.TRUE, "PDATA", new String((char[])objectArray3)};
                                        try {
                                            ((PKCS11Session)object3).createObject((int[])objectArray2, objectArray3);
                                        }
                                        catch (PKCS11Exception pKCS11Exception) {
                                            c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                                            string8 = "KO-Errore in fase di creazione file dati personali: " + pKCS11Exception.getMessage();
                                        }
                                        break block31;
                                    }
                                    catch (Exception exception) {
                                        string8 = "KO-Errore in fase di ricerca file dati personali: " + exception.getMessage();
                                    }
                                }
                                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                                    string8 = "KO-Errore in fase di creazione file dati personali: " + noSuchAlgorithmException.getMessage();
                                }
                                catch (UnsupportedEncodingException unsupportedEncodingException) {
                                    string8 = "KO-Errore in fase di creazione file dati personali: " + unsupportedEncodingException.getMessage();
                                }
                                break block31;
                            }
                            string8 = "KO-La card contiene gia' un PDATA";
                        }
                        catch (Exception exception) {
                            string8 = "KO-Errore in fase di Login: " + exception.getMessage();
                        }
                        finally {
                            if (object3 != null) {
                                try {
                                    ((PKCS11Session)object3).logout();
                                }
                                catch (PKCS11Exception pKCS11Exception) {
                                    c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                                }
                                ((PKCS11Session)object3).close();
                            }
                        }
                    }
                }
            }
            object = string8.equals("") ? string6 : string8;
        }
        catch (Exception exception) {
            try {
                string8 = "KO-: " + exception.getMessage();
                object = string8.equals("") ? string6 : string8;
            }
            catch (Throwable throwable) {
                string8.equals("");
                throw throwable;
            }
        }
        return object;
    }

    public static String createUserDataFileString(Card object, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String object2, String object3, String objectArray, String string12, String string13) {
        string7 = "";
        string9 = "";
        try {
            if (object != null) {
                object2 = null;
                try {
                    object2 = ((Card)object).getSlot().openSession(6, null, null);
                }
                catch (PKCS11Exception pKCS11Exception) {
                    c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                    string9 = "KO-Errore in fase di apertura sessione: " + pKCS11Exception.getMessage();
                }
                if (object2 != null && string9.equals("")) {
                    try {
                        if (string9.equals("")) {
                            object3 = new int[]{0};
                            objectArray = new Object[]{PKCS11Object.DATA};
                            if (CardUtils.a((PKCS11Session)object2, (int[])object3, objectArray) != 1) {
                                int n = string.length();
                                int n2 = string2.length();
                                int n3 = string3.length();
                                int n4 = string4.length();
                                int n5 = string5.length();
                                int n6 = string6.length();
                                int n7 = string8.length();
                                int n8 = string10.length();
                                int n9 = string11.length();
                                string13.length();
                                if (n > 0 && n < 9 && n2 > 0 && n2 < 9 && n3 > 0 && n3 < 50 && n4 < 50 && n5 > 0 && n5 < 9 && n6 == 1 && n7 == 16 && n8 == 4 && n9 == 4) {
                                    string = CardUtils.a(4, 2) + ((Card)object).getSerial().substring(0, 4) + CardUtils.a(n, 2) + string + CardUtils.a(n2, 2) + string2 + CardUtils.a(n3, 2) + string3 + CardUtils.a(n4, 2) + string4 + CardUtils.a(n5, 2) + string5 + CardUtils.a(n6, 2) + string6 + CardUtils.a(0, 2) + CardUtils.a(n7, 2) + string8 + CardUtils.a(0, 2) + CardUtils.a(n8, 2) + string10 + CardUtils.a(0, 2) + CardUtils.a(0, 2) + CardUtils.a(n9, 2) + string11 + CardUtils.a(0, 2) + CardUtils.a(0, 2);
                                    int n10 = string.length();
                                    string9 = string = CardUtils.a(n10 += 6, 6) + string;
                                } else {
                                    string9 = "KO-I dati forniti son malformati";
                                }
                            } else {
                                string9 = "KO-La card contiene gi\u00e0\u00a0un PDATA";
                            }
                        }
                    }
                    catch (Exception exception) {
                        string9 = "KO-Errore in fase di creazione stringa PDATA: " + exception.getMessage();
                    }
                    finally {
                        try {
                            ((PKCS11Session)object2).logout();
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                        }
                        ((PKCS11Session)object2).close();
                    }
                }
            }
            object = string9.equals("") ? string7 : string9;
        }
        catch (Exception exception) {
            try {
                string9 = "KO-: " + exception.getMessage();
                object = string9.equals("") ? string7 : string9;
            }
            catch (Throwable throwable) {
                string9.equals("");
                throw throwable;
            }
        }
        return object;
    }

    public static String createUserDataFileV2(Card object, String objectArray, String objectArray2) {
        block29: {
            String string = "";
            String string2 = "";
            try {
                c.info("Inizio createUserDataFileV2");
                c.info("Buffer: " + (String)objectArray);
                if (object == null) break block29;
                PKCS11Session pKCS11Session = null;
                try {
                    pKCS11Session = object.getSlot().openSession(6, null, null);
                }
                catch (PKCS11Exception pKCS11Exception) {
                    c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                    string2 = "KO-Errore in fase di apertura sessione: " + pKCS11Exception.getMessage();
                }
                if (pKCS11Session == null || !string2.equals("")) break block29;
                try {
                    c.info("Effettuo login");
                    Object[] objectArray3 = objectArray2;
                    if (objectArray2.equals("")) {
                        objectArray3 = object.getCardFamily().getDefaultPIN();
                    }
                    CardUtils.a(pKCS11Session, (String)objectArray3);
                    if (!string2.equals("")) break block29;
                    object = new int[]{0};
                    objectArray2 = new Object[]{PKCS11Object.DATA};
                    c.info("Verifico presenza oggetto dati");
                    if (CardUtils.a(pKCS11Session, (int[])object, objectArray2) != 1) {
                        c.info("Oggetto dati assente provvedo a creazione");
                        try {
                            c.info("Calcolo hash del buffer");
                            string = CardUtils.b((String)objectArray);
                            if (string == "") break block29;
                            object = new byte[400];
                            objectArray = objectArray.getBytes("ISO-8859-1");
                            for (int i = 0; i < objectArray.length; ++i) {
                                object[i] = objectArray[i];
                            }
                            int[] nArray = new int[]{0, 3};
                            objectArray = new Object[]{PKCS11Object.DATA, "PDATA"};
                            c.info("Verifico presenza PDATA");
                            if (CardUtils.a(pKCS11Session, nArray, objectArray) == 1) break block29;
                            c.info("PDATA assente avvio creazione");
                            try {
                                c.info("Definizione template");
                                objectArray = new int[]{0, 1, 3, 17};
                                object = new Object[]{PKCS11Object.DATA, PKCS11Object.TRUE, "PDATA", object};
                                try {
                                    c.info("Avvio creazione");
                                    pKCS11Session.createObject((int[])objectArray, (Object[])object);
                                    string2 = string;
                                }
                                catch (PKCS11Exception pKCS11Exception) {
                                    c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                                    string2 = "KO-Errore in fase di installazione PDATA: " + pKCS11Exception.getMessage();
                                }
                                break block29;
                            }
                            catch (Exception exception) {
                                c.error("Errore in fase di creazione Template PDATA: " + exception.getMessage());
                                string2 = "KO-Errore in fase di creazione Template PDATA: " + exception.getMessage();
                            }
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                            c.error("Errore in fase di installazione PDATA: " + noSuchAlgorithmException.getMessage());
                            string2 = "KO-Errore in fase di installazione PDATA: " + noSuchAlgorithmException.getMessage();
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            string2 = "KO-Errore in fase di installazione PDATA: " + unsupportedEncodingException.getMessage();
                        }
                        break block29;
                    }
                    c.error("La card contiene gi\u00e0\u00a0 un PDATA");
                    string2 = "KO-La card contiene gi\u00e0\u00a0 un PDATA";
                }
                catch (Exception exception) {
                    c.error("Errore in fase di Login: " + exception.getMessage());
                    string2 = "KO-Errore in fase di Login: " + exception.getMessage();
                }
                finally {
                    if (pKCS11Session != null) {
                        try {
                            pKCS11Session.logout();
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                        }
                        pKCS11Session.close();
                    }
                }
            }
            catch (Exception exception) {
                string2 = "KO-: " + exception.getMessage();
                c.error("Errore in fase di generazione PDATA: " + exception.getMessage());
            }
            finally {
                object = string2.equals("") ? string : string2;
                c.info("Valore di ritorno: " + (String)object);
                c.info("Fine createUserDataFileV2");
            }
        }
        return object;
    }

    public static String createCSR(Card card, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17, String string18, String string19, String string20) {
        return CardUtils.a(card, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, string15, string16, string17, string18, string19, string20);
    }

    public static String createCSR(Card card, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17, String string18, String string19) {
        return CardUtils.createCSR(card, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, string15, string16, string17, string18, string19, null);
    }

    public static String createCSR(Card card, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17, String string18) {
        return CardUtils.createCSR(card, "", string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, string15, string16, string17, string18);
    }

    /*
     * Loose catch block
     */
    private static String a(Card object, String object2, String string, String object3, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17, String string18) {
        String string19 = "";
        c.debug("createCSR dump:");
        c.debug("    TipoCSR=" + string);
        c.debug("    KeyID=" + (String)object3);
        c.debug("    Nome=" + string2);
        c.debug("    Cognome=" + string3);
        c.debug("    Organizzazione=" + string4);
        c.debug("    UnitaOrganizzativa1=" + string5);
        c.debug("    UnitaOrganizzativa2=" + string6);
        c.debug("    UnitaOrganizzativa3=" + string7);
        c.debug("    UnitaOrganizzativa4=" + string8);
        c.debug("    UnitaOrganizzativa5=" + string9);
        c.debug("    Localita=" + string10);
        c.debug("    SerialeUtente=" + string11);
        c.debug("    Titolo=" + string12);
        c.debug("    Email=" + string13);
        c.debug("    upn=" + string14);
        c.debug("    Description=" + string15);
        c.debug("    DateOfBirth=" + string16);
        c.debug("    HashPDATA=" + string17);
        c.debug("    OrgId=" + string18);
        boolean bl = true;
        if (string11 != null && !string11.isEmpty()) {
            string11 = string11.replace("SERIALNUMBER=", "");
            if (!(string11 = CardUtils.removeIllegalChars(string11)).isEmpty()) {
                bl = false;
            }
        }
        if (string3 != null && !string3.isEmpty()) {
            string3 = string3.replace("SURNAME=", "");
            if (!(string3 = CardUtils.removeIllegalChars(string3)).isEmpty()) {
                bl = false;
            }
        }
        if (string2 != null && !string2.isEmpty()) {
            string2 = string2.replace("GIVENNAME=", "");
            if (!(string2 = CardUtils.removeIllegalChars(string2)).isEmpty()) {
                bl = false;
            }
        }
        if (string12 != null && !string12.isEmpty()) {
            string12 = string12.replace("T=", "");
            if (!(string12 = CardUtils.removeIllegalChars(string12)).isEmpty()) {
                bl = false;
            }
        }
        if (string10 != null && !string10.isEmpty()) {
            string10 = string10.replace("C=", "");
            if (!(string10 = CardUtils.removeIllegalChars(string10)).isEmpty()) {
                bl = false;
            }
        }
        if (string4 != null && !string4.isEmpty()) {
            string4 = string4.replace("O=", "");
            if (!(string4 = CardUtils.removeIllegalChars(string4)).isEmpty()) {
                bl = false;
            }
        }
        if (string18 != null && !string18.isEmpty()) {
            string18 = string18.replace("O=", "");
            if (!(string18 = CardUtils.removeIllegalChars(string18)).isEmpty()) {
                bl = false;
            }
        }
        if (string9 != null && !string9.isEmpty()) {
            string9 = string9.replace("OU=", "");
            if (!(string9 = CardUtils.removeIllegalChars(string9)).isEmpty()) {
                bl = false;
            }
        }
        if (string8 != null && !string8.isEmpty()) {
            string8 = string8.replace("OU=", "");
            if (!(string8 = CardUtils.removeIllegalChars(string8)).isEmpty()) {
                bl = false;
            }
        }
        if (string7 != null && !string7.isEmpty()) {
            string7 = string7.replace("OU=", "");
            if (!(string7 = CardUtils.removeIllegalChars(string7)).isEmpty()) {
                bl = false;
            }
        }
        if (string6 != null && !string6.isEmpty()) {
            string6 = string6.replace("OU=", "");
            if (!(string6 = CardUtils.removeIllegalChars(string6)).isEmpty()) {
                bl = false;
            }
        }
        if (string5 != null && !string5.isEmpty()) {
            string5 = string5.replace("OU=", "");
            if (!(string5 = CardUtils.removeIllegalChars(string5)).isEmpty()) {
                bl = false;
            }
        }
        if (string15 != null && !string15.isEmpty()) {
            string15 = string15.replace("2.5.4.13=", "");
            if (!(string15 = CardUtils.removeIllegalChars(string15)).isEmpty()) {
                bl = false;
            }
        }
        if (bl) {
            object = "KO-Errore generale: parametri non validi per la creazione del CSR.";
            return "KO-Errore generale: parametri non validi per la creazione del CSR.";
        }
        if (string13 == null) {
            string13 = "";
        }
        try {
            block104: {
                if (object != null) {
                    PKCS11Session pKCS11Session = null;
                    try {
                        CardUtils.refreshCard((Card)object);
                        pKCS11Session = ((Card)object).getSlot().openSession(6, null, null);
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                        string19 = "KO-Errore in fase di apertura sessione: " + pKCS11Exception.getMessage();
                    }
                    if (pKCS11Session != null && string19.equals("")) {
                        Object object4 = new int[]{0, 258};
                        Object object5 = new Object[]{PKCS11Object.PUBLIC_KEY, object3};
                        Object object6 = null;
                        try {
                            pKCS11Session.findObjectsInit((int[])object4, (Object[])object5);
                            object6 = pKCS11Session.findObject();
                            pKCS11Session.findObjectsFinal();
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                            string19 = "KO-" + CardUtils.class.getName() + "-Errore in fase di ricerca chiave pubblica: " + pKCS11Exception.getMessage();
                        }
                        if (string19.equals("")) {
                            if (object6 != null) {
                                object4 = null;
                                object5 = null;
                                TokenSpi tokenSpi = null;
                                try {
                                    String[] stringArray;
                                    try {
                                        stringArray = new ASN1Integer(((PKCS11Object)object6).getByteArrayAttributeValue(288)).getPositiveValue();
                                        object6 = new ASN1Integer(((PKCS11Object)object6).getBigIntegerAttributeValue(290)).getPositiveValue();
                                        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec((BigInteger)stringArray, (BigInteger)object6);
                                        stringArray = KeyFactory.getInstance("RSA", "SunJSSE");
                                        object4 = stringArray.generatePublic(rSAPublicKeySpec);
                                    }
                                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                                        c.error("Errore in fase di recupero chiave pubblica", (Throwable)noSuchAlgorithmException);
                                        string19 = "KO-" + CardUtils.class.getName() + "-Errore in fase di recupero chiave pubblica: " + noSuchAlgorithmException.getMessage();
                                    }
                                    catch (InvalidKeySpecException invalidKeySpecException) {
                                        c.error("Errore in fase di recupero chiave pubblica", (Throwable)invalidKeySpecException);
                                        string19 = "KO-" + CardUtils.class.getName() + "-Errore in fase di recupero chiave pubblica: " + invalidKeySpecException.getMessage();
                                    }
                                    catch (Exception exception) {
                                        c.error("Errore in fase di recupero chiave pubblica", (Throwable)exception);
                                        string19 = "KO-" + CardUtils.class.getName() + "-Errore in fase di recupero chiave pubblica: " + exception.getMessage();
                                    }
                                    try {
                                        tokenSpi = ((Card)object).getToken();
                                        tokenSpi.openSession(false, (String)object2);
                                        stringArray = TokenHelper.listObjects((TokenSpi)tokenSpi, null, (byte)12);
                                        object6 = stringArray;
                                        int n = stringArray.length;
                                        for (int i = 0; i < n; ++i) {
                                            object2 = object6[i];
                                            if (!((String)object3).equals(new String(Hex.decode((String)TokenHelper.getObjectID((TokenSpi)tokenSpi, (String)object2))))) continue;
                                            object5 = TokenHelper.getPrivateKeyByAlias((TokenSpi)tokenSpi, (String)object2);
                                        }
                                    }
                                    catch (Exception exception) {
                                        c.error("Errore in fase di recupero chiave privata", (Throwable)exception);
                                        string19 = "KO-" + CardUtils.class.getName() + "-Errore in fase di recupero chiave privata: " + exception.getMessage();
                                    }
                                }
                                catch (Exception exception) {
                                    c.error("Errore in fase di recupero chiave", (Throwable)exception);
                                    string19 = "KO-" + CardUtils.class.getName() + "-Errore in fase di recupero chiave: " + exception.getMessage();
                                }
                                try {
                                    GeneralNames generalNames = new GeneralNames(new GeneralName(1, string13.toLowerCase().replace("\"", "")));
                                    object6 = new Vector();
                                    Vector<X509Extension> vector = new Vector<X509Extension>();
                                    ((Vector)object6).add(X509Extension.subjectAlternativeName);
                                    vector.add(new X509Extension(false, (ASN1OctetString)new DEROctetString((ASN1Encodable)generalNames)));
                                    if (string16 != null && !string16.equals("") && string16.matches("^(0[1-9]|[12][0-9]|3[01])[- /.](0[1-9]|1[012])[- /.](19|20)\\d\\d$")) {
                                        ((Vector)object6).add(X509Extension.subjectDirectoryAttributes);
                                        generalNames = new ASN1EncodableVector();
                                        string16 = new SimpleDateFormat("yyyyMMdd").format(new SimpleDateFormat("dd/MM/yyyy").parse(string16)) + "000000Z";
                                        generalNames.add((ASN1Encodable)new DERGeneralizedTime(string16));
                                        object2 = new Attribute(new ASN1ObjectIdentifier("1.3.6.1.5.5.7.9.1"), (ASN1Set)new DERSet((ASN1EncodableVector)generalNames));
                                        object3 = new Vector<Object>();
                                        ((Vector)object3).add(object2);
                                        object3 = new SubjectDirectoryAttributes((Vector)object3);
                                        vector.add(new X509Extension(false, (ASN1OctetString)new DEROctetString((ASN1Encodable)object3)));
                                    }
                                    generalNames = new X509Extensions((Vector)object6, vector);
                                    object2 = new Attribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Set)new DERSet((ASN1Encodable)generalNames));
                                    object3 = "";
                                    if (string.startsWith("FIRMA")) {
                                        if (string11 != null && !string11.equals("")) {
                                            object3 = (String)object3 + "SERIALNUMBER=" + string11;
                                        }
                                        if (string10 != null && !string10.equals("")) {
                                            object3 = (String)object3 + ", C=" + string10;
                                        }
                                        if (string2 != null && !string2.equals("") && string3 != null && !string3.equals("")) {
                                            object3 = (String)object3 + ", CN=" + string3 + " " + string2;
                                        }
                                        if (string2 != null && !string2.equals("")) {
                                            object3 = (String)object3 + ", GIVENNAME=" + string2;
                                        }
                                        if (string3 != null && !string3.equals("")) {
                                            object3 = (String)object3 + ", SURNAME=" + string3;
                                        }
                                        if (string12 != null && !string12.equals("")) {
                                            object3 = (String)object3 + ", T=" + string12;
                                        }
                                        if (string4 != null && !string4.equals("")) {
                                            object3 = (String)object3 + ", O=" + string4;
                                        }
                                        if (string18 != null && !string18.equals("")) {
                                            object3 = (String)object3 + ", 2.5.4.97=" + string18;
                                        }
                                        if (string9 != null && !string9.equals("")) {
                                            object3 = (String)object3 + ", OU=" + string9;
                                        }
                                        if (string8 != null && !string8.equals("")) {
                                            object3 = (String)object3 + ", OU=" + string8;
                                        }
                                        if (string7 != null && !string7.equals("")) {
                                            object3 = (String)object3 + ", OU=" + string7;
                                        }
                                        if (string6 != null && !string6.equals("")) {
                                            object3 = (String)object3 + ", OU=" + string6;
                                        }
                                        if (string5 != null && !string5.equals("")) {
                                            object3 = (String)object3 + ", OU=" + string5;
                                        }
                                        if (string15 != null && !string15.equals("")) {
                                            object3 = object3 + ", 2.5.4.13=" + string15;
                                        }
                                    } else {
                                        if (string11 != null && !string11.equals("")) {
                                            object3 = (String)object3 + "SERIALNUMBER=" + string11;
                                        }
                                        if (string10 != null && !string10.equals("")) {
                                            object3 = (String)object3 + ", C=" + string10;
                                        }
                                        if (string11 != null && !string11.equals("") && string17 != null && !string17.equals("")) {
                                            object3 = (String)object3 + ", CN=" + string11 + "/" + ((Card)object).getSerial() + "." + string17;
                                        }
                                        if (string2 != null && !string2.equals("")) {
                                            object3 = (String)object3 + ", GIVENNAME=" + string2;
                                        }
                                        if (string3 != null && !string3.equals("")) {
                                            object3 = (String)object3 + ", SURNAME=" + string3;
                                        }
                                        if (string12 != null && !string12.equals("")) {
                                            object3 = (String)object3 + ", T=" + string12;
                                        }
                                        if (string4 != null && !string4.equals("")) {
                                            object3 = (String)object3 + ", O=" + string4;
                                        }
                                        if (string5 != null && !string5.equals("")) {
                                            object3 = (String)object3 + ", OU=" + string5;
                                        }
                                    }
                                    if (((String)object3).startsWith(", ")) {
                                        object3 = ((String)object3).substring(2);
                                    }
                                    object3 = ((String)object3).replace("\"", "");
                                    object3 = new X500Principal(CardUtils.a((String)object3));
                                    try {
                                        object = new JcaPKCS10CertificationRequestBuilder(object3, (PublicKey)object4);
                                        object.addAttribute(object2.getAttrType(), object2.getAttributeValues());
                                        object = object.build(new JcaContentSignerBuilder("SHA1WithRSAEncryption").setProvider((Provider)ActalisSingleton.getActalisProvider()).build((PrivateKey)object5));
                                        byte[] byArray = object.getEncoded();
                                        object = byArray;
                                        if (byArray != null) {
                                            new Base64();
                                            string19 = new String(Base64.encode((byte[])object));
                                        }
                                    }
                                    catch (Exception exception) {
                                        c.error("Errore in fase di costruzione del CSR", (Throwable)exception);
                                        string19 = "KO-" + CardUtils.class.getName() + "-Errore in fase di costruzione del CSR: " + exception.getMessage();
                                    }
                                    finally {
                                        if (tokenSpi != null) {
                                            tokenSpi.closeSession();
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                    c.error("Errore in fase di costruzione del CSR", (Throwable)exception);
                                    string19 = "KO-" + CardUtils.class.getName() + "-Errore in fase di costruzione del CSR: " + exception.getMessage();
                                }
                            } else {
                                string19 = "KO-" + CardUtils.class.getName() + "-Nessuna chiave pubblica corrispondente al keyID passato trovata";
                            }
                        }
                        if (pKCS11Session == null) break block104;
                        try {
                            try {
                                pKCS11Session.logout();
                            }
                            catch (PKCS11Exception pKCS11Exception) {
                                c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                            }
                            pKCS11Session.close();
                        }
                        catch (Exception exception) {}
                        break block104;
                        catch (Exception exception) {
                            try {
                                c.error("Errore in fase di Login", (Throwable)exception);
                                string19 = "KO-" + CardUtils.class.getName() + "-Errore in fase di Login: " + exception.getMessage();
                                if (pKCS11Session == null) break block104;
                            }
                            catch (Throwable throwable) {
                                if (pKCS11Session != null) {
                                    try {
                                        try {
                                            pKCS11Session.logout();
                                        }
                                        catch (PKCS11Exception pKCS11Exception) {
                                            c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                                        }
                                        pKCS11Session.close();
                                    }
                                    catch (Exception exception2) {}
                                }
                                throw throwable;
                            }
                            try {
                                try {
                                    pKCS11Session.logout();
                                }
                                catch (PKCS11Exception pKCS11Exception) {
                                    c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                                }
                                pKCS11Session.close();
                            }
                            catch (Exception exception3) {}
                        }
                    }
                }
            }
            object = string19;
        }
        catch (PKCS11Exception pKCS11Exception) {
            c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
            string19 = "KO-" + CardUtils.class.getName() + "-" + pKCS11Exception.getMessage();
            object = string19;
        }
        return object;
    }

    public static String createCSR_CNS(Card card, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14) {
        return CardUtils.a(card, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14);
    }

    public static String createCSR_CNS(Card card, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13) {
        return CardUtils.a(card, "", string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13);
    }

    /*
     * Loose catch block
     */
    private static String a(Card object, String object2, String string, String subjectDirectoryAttributes, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12) {
        String string13;
        block83: {
            PKCS11Session pKCS11Session;
            block80: {
                c.debug("createCSR_CNS dump:");
                c.debug("    SerialNumber=" + string);
                c.debug("    KeyID=" + (String)subjectDirectoryAttributes);
                c.debug("    Country=" + string2);
                c.debug("    CommonName=" + string3);
                c.debug("    GivenName=" + string4);
                c.debug("    Surname=" + string5);
                c.debug("    Organization=" + string6);
                c.debug("    OrganizationUnit=" + string7);
                c.debug("    DateOfBirth=" + string8);
                c.debug("    Email=" + string9);
                c.debug("    HashPDATA=" + string10);
                c.debug("    Title=" + string11);
                c.debug("    SmartLogOn=" + string12);
                if (object == null) {
                    return "KO-oggetto card non valido";
                }
                boolean bl = true;
                if (string != null && !string.isEmpty()) {
                    string = string.replace("SERIALNUMBER=", "");
                    if (!(string = CardUtils.removeIllegalChars(string)).isEmpty()) {
                        bl = false;
                    }
                }
                if (string4 != null && !string4.isEmpty()) {
                    string4 = string4.replace("GIVENNAME=", "");
                    if (!(string4 = CardUtils.removeIllegalChars(string4)).isEmpty()) {
                        bl = false;
                    }
                }
                if (string5 != null && !string5.isEmpty()) {
                    string5 = string5.replace("SURNAME=", "");
                    if (!(string5 = CardUtils.removeIllegalChars(string5)).isEmpty()) {
                        bl = false;
                    }
                }
                if (string6 != null && !string6.isEmpty()) {
                    string6 = string6.replace("O=", "");
                    if (!(string6 = CardUtils.removeIllegalChars(string6)).isEmpty()) {
                        bl = false;
                    }
                }
                if (string7 != null && !string7.isEmpty()) {
                    string7 = string7.replace("OU=", "");
                    if (!(string7 = CardUtils.removeIllegalChars(string7)).isEmpty()) {
                        bl = false;
                    }
                }
                if (string2 != null && !string2.isEmpty()) {
                    string2 = string2.replace("C=", "");
                    if (!(string2 = CardUtils.removeIllegalChars(string2)).isEmpty()) {
                        bl = false;
                    }
                }
                if (string11 != null && !string11.isEmpty()) {
                    string11 = string11.replace("T=", "");
                    if (!(string11 = CardUtils.removeIllegalChars(string11)).isEmpty()) {
                        bl = false;
                    }
                }
                if (bl) {
                    return "KO-parametri non validi per la creazione del CSR: SerialNumber, GivenName, Surname, Organization, OrganizationUnit, Country, Title non possono essere tutti nulli";
                }
                if (string9 == null) {
                    string9 = "";
                }
                string13 = "";
                try {
                    CardUtils.refreshCard((Card)object);
                    pKCS11Session = ((Card)object).getSlot().openSession(6, null, null);
                }
                catch (PKCS11Exception pKCS11Exception) {
                    c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                    String string14 = string13 = "KO-Errore in fase di apertura sessione: " + pKCS11Exception.getMessage();
                    return string14;
                }
                if (pKCS11Session != null) break block80;
                String string15 = "KO-Errore in fase di apertura sessione";
                return string15;
            }
            try {
                Object object3 = new int[]{0, 258};
                Object object4 = new Object[]{PKCS11Object.PUBLIC_KEY, subjectDirectoryAttributes};
                Object object5 = null;
                try {
                    ArrayList<int[]> arrayList = new ArrayList<int[]>();
                    pKCS11Session.findObjectsInit((int[])object3, (Object[])object4);
                    while (true) {
                        PKCS11Object pKCS11Object = pKCS11Session.findObject();
                        object3 = pKCS11Object;
                        if (pKCS11Object == null) break;
                        arrayList.add((int[])object3);
                    }
                    ArrayList<int[]> arrayList2 = arrayList;
                    object5 = arrayList2.toArray(new PKCS11Object[arrayList2.size()]);
                    pKCS11Session.findObjectsFinal();
                }
                catch (PKCS11Exception pKCS11Exception) {
                    c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                    string13 = "KO-" + pKCS11Exception.getMessage();
                }
                if (string13.equals("")) {
                    if (object5 != null) {
                        int n = -1;
                        for (int i = 0; i < ((PKCS11Object[])object5).length; ++i) {
                            object4 = new String(object5[i].getByteArrayAttributeValue(258), "UTF-8");
                            if (!object4.equals(subjectDirectoryAttributes)) continue;
                            n = i;
                        }
                        if (n >= 0) {
                            PublicKey publicKey = null;
                            object4 = null;
                            TokenSpi tokenSpi = null;
                            try {
                                Object object6;
                                try {
                                    object6 = new ASN1Integer(object5[0].getByteArrayAttributeValue(288)).getPositiveValue();
                                    object5 = new ASN1Integer(object5[0].getBigIntegerAttributeValue(290)).getPositiveValue();
                                    RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec((BigInteger)object6, (BigInteger)object5);
                                    object6 = KeyFactory.getInstance("RSA");
                                    publicKey = object6.generatePublic(rSAPublicKeySpec);
                                }
                                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                                    string13 = "KO-" + noSuchAlgorithmException.getMessage();
                                }
                                catch (InvalidKeySpecException invalidKeySpecException) {
                                    string13 = "KO-" + invalidKeySpecException.getMessage();
                                }
                                catch (Exception exception) {
                                    string13 = "KO-" + exception.getMessage();
                                }
                                try {
                                    tokenSpi = ((Card)object).getToken();
                                    tokenSpi.openSession(false, (String)object2);
                                    object6 = TokenHelper.listObjects((TokenSpi)tokenSpi, null, (byte)12);
                                    object5 = object6;
                                    int n2 = ((String[])object6).length;
                                    for (int i = 0; i < n2; ++i) {
                                        object2 = object5[i];
                                        if (!subjectDirectoryAttributes.equals(new String(Hex.decode((String)TokenHelper.getObjectID((TokenSpi)tokenSpi, (String)object2))))) continue;
                                        object4 = TokenHelper.getPrivateKeyByAlias((TokenSpi)tokenSpi, (String)object2);
                                        break;
                                    }
                                }
                                catch (Exception exception) {
                                    c.error("Errore in fase di recupero chiave privata: ", (Throwable)exception);
                                    string13 = "KO-" + CardUtils.class.getName() + "-Errore in fase di recupero chiave privata: " + exception.getMessage();
                                }
                            }
                            catch (Exception exception) {
                                c.error(exception.getMessage(), (Throwable)exception);
                                string13 = "KO-" + exception.getMessage();
                            }
                            try {
                                GeneralNames generalNames;
                                if (string12 != null && !string12.trim().equals("")) {
                                    object5 = new DERSequence(new ASN1Encodable[]{new ASN1ObjectIdentifier("1.3.6.1.4.1.311.20.2.3"), new DERTaggedObject(true, 0, (ASN1Encodable)new DERUTF8String(string12))});
                                    GeneralName generalName = new GeneralName(0, (ASN1Encodable)object5);
                                    generalNames = new GeneralName(1, string9.toLowerCase().replace("\"", ""));
                                    generalNames = new GeneralNames(new GeneralName[]{generalNames, generalName});
                                } else {
                                    generalNames = new GeneralNames(new GeneralName(1, string9.toLowerCase().replace("\"", "")));
                                }
                                object5 = new Vector();
                                Vector<X509Extension> vector = new Vector<X509Extension>();
                                ((Vector)object5).add(X509Extension.subjectAlternativeName);
                                vector.add(new X509Extension(false, (ASN1OctetString)new DEROctetString((ASN1Encodable)generalNames)));
                                if (string8 != null && !string8.equals("") && string8.matches("^(0[1-9]|[12][0-9]|3[01])[- /.](0[1-9]|1[012])[- /.](19|20)\\d\\d$")) {
                                    ((Vector)object5).add(X509Extension.subjectDirectoryAttributes);
                                    generalNames = new ASN1EncodableVector();
                                    string8 = new SimpleDateFormat("yyyyMMdd").format(new SimpleDateFormat("dd/MM/yyyy").parse(string8)) + "000000Z";
                                    generalNames.add((ASN1Encodable)new DERGeneralizedTime(string8));
                                    object2 = new Attribute(new ASN1ObjectIdentifier("1.3.6.1.5.5.7.9.1"), (ASN1Set)new DERSet((ASN1EncodableVector)generalNames));
                                    subjectDirectoryAttributes = new Vector();
                                    subjectDirectoryAttributes.add(object2);
                                    subjectDirectoryAttributes = new SubjectDirectoryAttributes(subjectDirectoryAttributes);
                                    vector.add(new X509Extension(false, (ASN1OctetString)new DEROctetString((ASN1Encodable)subjectDirectoryAttributes)));
                                }
                                generalNames = new X509Extensions((Vector)object5, vector);
                                object2 = new Attribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Set)new DERSet((ASN1Encodable)generalNames));
                                subjectDirectoryAttributes = "";
                                if (string != null && !string.equals("")) {
                                    subjectDirectoryAttributes = (String)subjectDirectoryAttributes + "SERIALNUMBER=" + string;
                                }
                                if (string2 != null && !string2.equals("")) {
                                    subjectDirectoryAttributes = (String)subjectDirectoryAttributes + ", C=" + string2;
                                }
                                if (string != null && !string.equals("") && string10 != null && !string10.equals("")) {
                                    subjectDirectoryAttributes = (String)subjectDirectoryAttributes + ", CN=" + string + "/" + ((Card)object).getSerial() + "." + string10;
                                }
                                if (string4 != null && !string4.equals("")) {
                                    subjectDirectoryAttributes = (String)subjectDirectoryAttributes + ", GIVENNAME=" + string4;
                                }
                                if (string5 != null && !string5.equals("")) {
                                    subjectDirectoryAttributes = (String)subjectDirectoryAttributes + ", SURNAME=" + string5;
                                }
                                if (string11 != null && !string11.equals("")) {
                                    subjectDirectoryAttributes = (String)subjectDirectoryAttributes + ", T=" + string11;
                                }
                                if (string6 != null && !string6.equals("")) {
                                    subjectDirectoryAttributes = (String)subjectDirectoryAttributes + ", O=" + string6;
                                }
                                if (string7 != null && !string7.equals("")) {
                                    subjectDirectoryAttributes = (String)subjectDirectoryAttributes + ", OU=" + string7;
                                }
                                if (subjectDirectoryAttributes.startsWith(", ")) {
                                    subjectDirectoryAttributes = subjectDirectoryAttributes.substring(2);
                                }
                                subjectDirectoryAttributes = subjectDirectoryAttributes.replace("\"", "");
                                subjectDirectoryAttributes = new X500Principal(CardUtils.a((String)subjectDirectoryAttributes));
                                try {
                                    object = new JcaPKCS10CertificationRequestBuilder((X500Principal)subjectDirectoryAttributes, publicKey);
                                    object.addAttribute(object2.getAttrType(), object2.getAttributeValues());
                                    object = object.build(new JcaContentSignerBuilder("SHA1WithRSAEncryption").setProvider((Provider)ActalisSingleton.getActalisProvider()).build((PrivateKey)object4));
                                    byte[] byArray = object.getEncoded();
                                    object = byArray;
                                    if (byArray != null) {
                                        new Base64();
                                        string13 = new String(Base64.encode((byte[])object));
                                    }
                                }
                                catch (Exception exception) {
                                    c.error(exception.getMessage(), (Throwable)exception);
                                    string13 = "KO-" + exception.getMessage();
                                }
                                finally {
                                    if (tokenSpi != null) {
                                        tokenSpi.closeSession();
                                    }
                                }
                            }
                            catch (Exception exception) {
                                c.error(exception.getMessage(), (Throwable)exception);
                                string13 = "KO-" + exception.getMessage();
                            }
                        } else {
                            string13 = "KO-Nessuna chiave pubblica corrispondente al keyID passato trovata";
                        }
                    } else {
                        string13 = "KO-Nessuna chiave pubblica corrispondente al keyID passato trovata";
                    }
                }
                if (pKCS11Session == null) break block83;
                try {
                    try {
                        pKCS11Session.logout();
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                    }
                    pKCS11Session.close();
                }
                catch (Exception exception) {}
                break block83;
                catch (Exception exception) {
                    try {
                        c.error(exception.getMessage(), (Throwable)exception);
                        string13 = "KO-" + exception.getMessage();
                        if (pKCS11Session == null) break block83;
                    }
                    catch (Throwable throwable) {
                        if (pKCS11Session != null) {
                            try {
                                try {
                                    pKCS11Session.logout();
                                }
                                catch (PKCS11Exception pKCS11Exception) {
                                    c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                                }
                                pKCS11Session.close();
                            }
                            catch (Exception exception2) {}
                        }
                        throw throwable;
                    }
                    try {
                        try {
                            pKCS11Session.logout();
                        }
                        catch (PKCS11Exception pKCS11Exception) {
                            c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                        }
                        pKCS11Session.close();
                    }
                    catch (Exception exception3) {}
                }
            }
            catch (PKCS11Exception pKCS11Exception) {
                c.error(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                string13 = "KO-" + pKCS11Exception.getMessage();
            }
        }
        return string13;
    }

    protected static String removeIllegalChars(String string) {
        if (string == null) {
            return "";
        }
        if (string.isEmpty()) {
            return "";
        }
        String string2 = "";
        if (string.startsWith("\\ ") || string.startsWith("\\#")) {
            string2 = string.substring(0, 2);
            string = string.substring(2);
        } else if (string.startsWith(" ") || string.startsWith("#")) {
            string2 = "\\" + string.substring(0, 1);
            string = string.substring(1);
        }
        while (string.length() > 0 && string.startsWith(" ")) {
            string2 = string2 + " ";
            string = string.substring(1);
        }
        boolean bl = false;
        if (string.endsWith(" ")) {
            bl = true;
        }
        boolean bl2 = true;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == '\\') {
                ++n;
            } else {
                if (c2 == ',' || c2 == '+' || c2 == '<' || c2 == '>' || c2 == ';' || c2 == '\"') {
                    if (i == 0 || n % 2 == 0) {
                        string2 = string2 + "\\";
                    }
                } else if (bl && c2 == ' ' && i >= string.trim().length()) {
                    if (n % 2 != 0) {
                        bl2 = false;
                    } else {
                        string2 = string2.trim();
                    }
                } else if (n % 2 != 0) {
                    string2 = string2 + "\\";
                }
                n = 0;
            }
            string2 = string2 + c2;
        }
        if (n % 2 != 0) {
            string2 = string2 + "\\";
        }
        if (bl2) {
            string2 = string2.trim();
        }
        return string2;
    }

    private static String b(String object) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1", ProvUtils.bcProvider);
        messageDigest.update(((String)object).getBytes("iso-8859-1"), 0, ((String)object).length());
        object = messageDigest.digest();
        object = new String(Base64.encode((byte[])object));
        return object;
    }

    private static byte[] c(String object) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256", ProvUtils.bcProvider);
        messageDigest.update(((String)object).getBytes("iso-8859-1"), 0, ((String)object).length());
        byte[] byArray = messageDigest.digest();
        object = byArray;
        object = byArray;
        return byArray;
    }

    private static void a(PKCS11Session pKCS11Session, String string) throws PKCS11Exception {
        try {
            pKCS11Session.logout();
        }
        catch (PKCS11Exception pKCS11Exception) {
            c.debug(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
        }
        pKCS11Session.login(false, string);
    }

    /*
     * WARNING - void declaration
     */
    private static List<CardFamilyMatch> a(CardUtilsConfig cardUtilsConfig, List<ATR> object, boolean bl) {
        CardFamilyMatch cardFamilyMatch;
        c.debug("identifyModules() start");
        if (c.isDebugEnabled()) {
            c.debug("List of modules into DB");
            for (CardFamily object2 : d.getCardStore().getCardFamilies()) {
                c.debug("  Module: " + object2.getName());
            }
        }
        ArrayList<CardFamilyMatch> arrayList = null;
        if (cardUtilsConfig.getP11Override() != null && !cardUtilsConfig.getP11Override().isEmpty()) {
            boolean throwable;
            c.debug("Loading custom override module " + cardUtilsConfig.getP11Override());
            boolean bl2 = false;
            if (b != null) {
                if (!b.getLib().get(0).equals(cardUtilsConfig.getP11Override())) {
                    try {
                        b.getPKCS11(false).libFinalizePublic();
                    }
                    catch (Throwable throwable2) {
                        c.error("Error closing custom module currently open (" + b.getName() + "): " + throwable2.getMessage());
                    }
                    d.getCardStore().getCardFamilies().remove(b);
                } else {
                    throwable = true;
                }
            }
            if (!throwable) {
                b = new CardFamily(FamilyName.CUSTOM.get(), "12345", "12345678", CNSStrategy.NONE, DSStrategy.NONE);
                b.getLib().add(new CardLibrary.CustomCardLibrary(cardUtilsConfig.getP11Override()));
                d.getCardStore().getCardFamilies().add(b);
            }
            arrayList = new ArrayList<CardFamilyMatch>();
            arrayList.add(new CardFamilyMatch(b, "CUSTOMOVERRIDE"));
        } else {
            c.debug("Select modules by ATR");
            try {
                Iterator i = object.iterator();
                while (i.hasNext()) {
                    object = (ATR)i.next();
                    if (arrayList == null) {
                        arrayList = new ArrayList<CardFamilyMatch>();
                    }
                    if ((cardFamilyMatch = d.getFromAtr((ATR)object)) == null) continue;
                    arrayList.add(cardFamilyMatch);
                }
            }
            catch (Throwable object3) {
                c.error(object3.getMessage(), object3);
            }
            if (arrayList != null) {
                void var3_14;
                c.info(String.format("%d CardFamilies selected:", arrayList.size()));
                boolean bl2 = false;
                while (var3_14 < arrayList.size()) {
                    c.info(String.format("Lector %s CardFamily %s", ((CardFamilyMatch)arrayList.get((int)var3_14)).getTerminalName(), ((CardFamilyMatch)arrayList.get((int)var3_14)).getFamily().getName()));
                    ++var3_14;
                }
            } else {
                c.info("No module is selected!");
            }
        }
        if (cardUtilsConfig.getRuntimeType() == 0) {
            void var3_18;
            String string = "bit4xpki";
            if (Platform.isLinux()) {
                String string2 = "libbit4xpki.so";
            } else if (Platform.isMac()) {
                String string3 = "libbit4xpki.dylib";
            }
            object = new CardFamily("ArubaKeyModule", "12345", "12345678", CNSStrategy.LABEL, DSStrategy.LABEL);
            cardFamilyMatch = new CardFamilyMatch((CardFamily)object, "AK");
            ((CardFamily)object).getLib().add(new CardLibrary.CustomCardLibrary((String)var3_18));
            c.info("Verifico presenza modulo ArubaKey precaricato");
            int n = 0;
            for (CardFamily cardFamily : d.getCardStore().getCardFamilies()) {
                if (cardFamily.getName().equals("ArubaKeyModule")) {
                    c.info("Trovato - rimuovo");
                    d.getCardStore().getCardFamilies().remove(n);
                    break;
                }
                ++n;
            }
            c.info("Forzo caricamento modulo AK su lista moduli preesistente");
            d.getCardStore().getCardFamilies().add((CardFamily)object);
            arrayList.add(cardFamilyMatch);
        }
        c.debug("identifyModules() end");
        return arrayList;
    }

    @Deprecated
    public static Map<CardFamily, List<Card>> retrieveCardMap(ConfigParameter configParameter) throws IOException {
        CardUtilsConfig cardUtilsConfig = new CardUtilsConfig();
        cardUtilsConfig.setP11Override(configParameter.getP11Override());
        cardUtilsConfig.setIgnoreATR(configParameter.getIgnoreAtr());
        cardUtilsConfig.setRuntimeType(configParameter.getRuntimeType());
        return CardUtils.retrieveCardMap(cardUtilsConfig);
    }

    @Deprecated
    public static Map<CardFamily, List<Card>> retrieveCardMap(CardUtilsConfig iterator) throws IOException {
        c.debug("retrieveCardMap() start");
        HashMap hashMap = new HashMap();
        try {
            Object object = SCardUtils.retrieveATR();
            int n = object.size();
            iterator = CardUtils.a((CardUtilsConfig)((Object)iterator), object, true);
            if (iterator == null) {
                throw new IOException(NO_MODULE_LOADED);
            }
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                NativePKCS11 nativePKCS11;
                object = (CardFamilyMatch)iterator.next();
                if (object == null) continue;
                try {
                    c.debug("-- try to initialize the module " + ((CardFamilyMatch)object).getFamily().getName() + " --");
                    nativePKCS11 = CardService.initModule(((CardFamilyMatch)object).getFamily());
                }
                catch (Exception exception) {
                    c.debug("module is skipped because an exception was thrown");
                    continue;
                }
                if (nativePKCS11 == null) {
                    c.debug("module is skipped because no native PKCS11 lib was selected");
                    continue;
                }
                Object object2 = null;
                try {
                    object2 = nativePKCS11.getSlotList(true);
                }
                catch (PKCS11Exception pKCS11Exception) {
                    c.error(pKCS11Exception.getMessage() + " code: " + pKCS11Exception.getCode());
                }
                if (object2 == null) {
                    c.debug("module is skipped because no terminal slots are assigned to it");
                    continue;
                }
                boolean bl = false;
                int n2 = ((PKCS11Slot[])object2).length;
                for (int i = 0; i < n2; ++i) {
                    PKCS11Slot pKCS11Slot = object2[i];
                    if (!pKCS11Slot.getInfo().tokenPresent()) continue;
                    bl = true;
                    ++n;
                }
                if (!bl) {
                    c.debug("module is skipped because no card is inserted into slots assigned to it");
                    continue;
                }
                if (hashMap.get(((CardFamilyMatch)object).getFamily()) == null) {
                    hashMap.put(((CardFamilyMatch)object).getFamily(), new ArrayList());
                }
                if ((object2 = CardService.a((CardFamilyMatch)object, (List)hashMap.get(((CardFamilyMatch)object).getFamily()), null)) == null || object2.size() <= 0) continue;
                Iterator iterator2 = object2.iterator();
                while (iterator2.hasNext()) {
                    Card card = (Card)iterator2.next();
                    if (card.getSerial().equalsIgnoreCase(a)) continue;
                    ((List)hashMap.get(((CardFamilyMatch)object).getFamily())).add(card);
                }
            }
            if (n == 0) {
                throw new IOException(NO_CARD_DETECTED);
            }
            if (hashMap.isEmpty()) {
                throw new IOException(NO_MODULE_LOADED);
            }
            NativePKCS11.nativeInstancesCount();
            throw new IOException(NO_DRIVER_INIT);
        }
        catch (Throwable throwable) {
            c.debug("retrieveCardMap() end");
            throw throwable;
        }
    }

    static {
        b = null;
        c = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
        d = CardService.getInstance();
    }
}

