/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.pkcs11.nat;

public final class Platform {
    public static final int UNSPECIFIED = -1;
    public static final int MAC = 0;
    public static final int LINUX = 1;
    public static final int WINDOWS = 2;
    public static final int SOLARIS = 3;
    public static final int FREEBSD = 4;
    public static final int OPENBSD = 5;
    public static final int WINDOWSCE = 6;
    public static final int AIX = 7;
    public static final int ANDROID = 8;
    public static final int GNU = 9;
    public static final int KFREEBSD = 10;
    public static final int NETBSD = 11;
    public static final boolean RO_FIELDS;
    public static final boolean HAS_BUFFERS;
    public static final boolean HAS_AWT;
    public static final String MATH_LIBRARY_NAME;
    public static final String C_LIBRARY_NAME;
    public static final boolean HAS_DLL_CALLBACKS;
    public static final String RESOURCE_PREFIX;
    private static final int a;
    public static final String ARCH;

    private Platform() {
    }

    public static final int getOSType() {
        return a;
    }

    public static final boolean isMac() {
        return a == 0;
    }

    public static final boolean isAndroid() {
        return a == 8;
    }

    public static final boolean isLinux() {
        return a == 1;
    }

    public static final boolean isAIX() {
        return a == 7;
    }

    public static final boolean isAix() {
        return Platform.isAIX();
    }

    public static final boolean isWindowsCE() {
        return a == 6;
    }

    public static final boolean isWindows() {
        return a == 2 || a == 6;
    }

    public static final boolean isSolaris() {
        return a == 3;
    }

    public static final boolean isFreeBSD() {
        return a == 4;
    }

    public static final boolean isOpenBSD() {
        return a == 5;
    }

    public static final boolean isNetBSD() {
        return a == 11;
    }

    public static final boolean isGNU() {
        return a == 9;
    }

    public static final boolean iskFreeBSD() {
        return a == 10;
    }

    public static final boolean isX11() {
        return !Platform.isWindows() && !Platform.isMac();
    }

    public static final boolean hasRuntimeExec() {
        return !Platform.isWindowsCE() || !"J9".equals(System.getProperty("java.vm.name"));
    }

    public static final boolean is64Bit() {
        String string = System.getProperty("sun.arch.data.model", System.getProperty("com.ibm.vm.bitmode"));
        if (string != null) {
            return "64".equals(string);
        }
        return "x86_64".equals(ARCH) || "ia64".equals(ARCH) || "ppc64".equals(ARCH) || "sparcv9".equals(ARCH) || "amd64".equals(ARCH);
    }

    public static final boolean isIntel() {
        return ARCH.equals("i386") || ARCH.startsWith("i686") || ARCH.equals("x86") || ARCH.equals("x86_64") || ARCH.equals("amd64");
    }

    public static final boolean isPPC() {
        return ARCH.equals("ppc") || ARCH.equals("ppc64") || ARCH.equals("powerpc") || ARCH.equals("powerpc64");
    }

    public static final boolean isARM() {
        return ARCH.startsWith("arm");
    }

    public static final boolean isSPARC() {
        return ARCH.startsWith("sparc");
    }

    static {
        String string;
        String string2 = System.getProperty("os.name");
        if (string2.startsWith("Linux")) {
            if ("dalvik".equals(System.getProperty("java.vm.name").toLowerCase())) {
                a = 8;
                System.setProperty("jna.nounpack", "true");
            } else {
                a = 1;
            }
        } else {
            a = string2.startsWith("AIX") ? 7 : (string2.startsWith("Mac") || string2.startsWith("Darwin") ? 0 : (string2.startsWith("Windows CE") ? 6 : (string2.startsWith("Windows") ? 2 : (string2.startsWith("Solaris") || string2.startsWith("SunOS") ? 3 : (string2.startsWith("FreeBSD") ? 4 : (string2.startsWith("OpenBSD") ? 5 : (string2.equalsIgnoreCase("gnu") ? 9 : (string2.equalsIgnoreCase("gnu/kfreebsd") ? 10 : (string2.equalsIgnoreCase("netbsd") ? 11 : -1)))))))));
        }
        int n = 0;
        try {
            Class.forName("java.nio.Buffer");
            n = 1;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        HAS_AWT = a != 6 && a != 8 && a != 7;
        HAS_BUFFERS = n;
        boolean bl = RO_FIELDS = a != 6;
        String string3 = a == 2 ? "msvcrt" : (C_LIBRARY_NAME = a == 6 ? "coredll" : "c");
        MATH_LIBRARY_NAME = a == 2 ? "msvcrt" : (a == 6 ? "coredll" : "m");
        HAS_DLL_CALLBACKS = a == 2;
        String string4 = System.getProperty("os.name");
        String string5 = System.getProperty("os.arch");
        n = Platform.getOSType();
        string5 = string5.toLowerCase().trim();
        if ("powerpc".equals(string5)) {
            string5 = "ppc";
        } else if ("powerpc64".equals(string5)) {
            string5 = "ppc64";
        } else if ("i386".equals(string5)) {
            string5 = "x86";
        } else if ("x86_64".equals(string5) || "amd64".equals(string5)) {
            string5 = "x86-64";
        }
        switch (n) {
            case 8: {
                if (string5.startsWith("arm")) {
                    string5 = "arm";
                }
                string = "android-" + string5;
                break;
            }
            case 2: {
                string = "win32-" + string5;
                break;
            }
            case 6: {
                string = "w32ce-" + string5;
                break;
            }
            case 0: {
                string = "darwin";
                break;
            }
            case 1: {
                string = "linux-" + string5;
                break;
            }
            case 3: {
                string = "sunos-" + string5;
                break;
            }
            case 4: {
                string = "freebsd-" + string5;
                break;
            }
            case 5: {
                string = "openbsd-" + string5;
                break;
            }
            case 11: {
                string = "netbsd-" + string5;
                break;
            }
            case 10: {
                string = "kfreebsd-" + string5;
                break;
            }
            default: {
                string = string4.toLowerCase();
                int n2 = string.indexOf(" ");
                if (n2 != -1) {
                    string = string.substring(0, n2);
                }
                string = string + "-" + string5;
            }
        }
        RESOURCE_PREFIX = string;
        ARCH = System.getProperty("os.arch").toLowerCase().trim();
    }
}

