/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.signature;

import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.http.HTTP;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.signature.BaseGenerator;
import it.actalis.ellips.capi.signature.BaseSignatureOptions;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.signature.LTResourceResolver;
import it.actalis.ellips.capi.signature.SignatureLevel;
import it.actalis.ellips.capi.signature.SignatureOptions;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public abstract class SignatureGenerator<T extends SignatureOptions>
extends BaseGenerator<T> {
    @Override
    public void validateOptions(T t) throws CapiException {
    }

    public final void sign(T t) throws CapiException {
        this.parameterValidation(t);
        this.innerSign(t);
    }

    public final void addSign(T t) throws CapiException {
        this.parameterValidation(t);
        this.innerAddSign(t);
    }

    public final void updateSign(T t) throws CapiException {
        this.updateParameterValidation(t);
        this.innerUpdateSign(t);
    }

    protected abstract void innerSign(T var1) throws CapiException;

    protected abstract void innerAddSign(T var1) throws CapiException;

    protected abstract void innerUpdateSign(T var1) throws CapiException;

    @Override
    protected void doGenerate() throws CapiException {
        SignatureGenerator signatureGenerator = this;
        signatureGenerator.innerSign((SignatureOptions)signatureGenerator.options);
    }

    protected final X509Certificate retrieveCert(T object) throws CapiException {
        try {
            object = (X509Certificate)((SignatureOptions)object).getKeyStore().getCertificate(((SignatureOptions)object).getAlias());
        }
        catch (KeyStoreException keyStoreException) {
            logger.error(keyStoreException.getMessage(), (Throwable)keyStoreException);
            throw new CapiException("Internal error: " + keyStoreException.getMessage(), 1003, keyStoreException);
        }
        if (object == null) {
            throw new CapiException("Internal error: unable to get signer X509 certificate", 1003);
        }
        return object;
    }

    protected final Certificate retrieveCertCapi(T object) throws CapiException {
        try {
            object = (X509Certificate)((SignatureOptions)object).getKeyStore().getCertificate(((SignatureOptions)object).getAlias());
            if (object == null) {
                throw new CapiException("Internal error: unable to get signer X509 certificate", 1003);
            }
            object = ((java.security.cert.Certificate)object).getEncoded();
            object = new Certificate((byte[])object);
        }
        catch (KeyStoreException keyStoreException) {
            logger.error(keyStoreException.getMessage(), (Throwable)keyStoreException);
            throw new CapiException("Internal error: " + keyStoreException.getMessage(), 1003, keyStoreException);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            logger.error(certificateEncodingException.getMessage(), (Throwable)certificateEncodingException);
            throw new CapiException("Internal error: " + certificateEncodingException.getMessage(), 1003, certificateEncodingException);
        }
        return object;
    }

    protected final PrivateKey retrieveKey(T object) throws CapiException {
        try {
            object = ((SignatureOptions)object).getKeyStorePassword() != null ? (PrivateKey)((SignatureOptions)object).getKeyStore().getKey(((SignatureOptions)object).getAlias(), ((SignatureOptions)object).getKeyStorePassword().toCharArray()) : (PrivateKey)((SignatureOptions)object).getKeyStore().getKey(((SignatureOptions)object).getAlias(), null);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error: " + exception.getMessage(), 1003, exception);
        }
        if (object == null) {
            throw new CapiException("Internal error. Unable to get signer key", 1003);
        }
        return object;
    }

    protected final Provider retrieveProvider(T t) throws CapiException {
        return ((SignatureOptions)t).getKeyStore().getProvider();
    }

    protected final LTResourceResolver getLTResourceResolver(T t, boolean bl) {
        LTResourceResolver lTResourceResolver = null;
        if (((BaseSignatureOptions)t).getSignatureLevel().compareTo(SignatureLevel.T) > 0 || bl) {
            NetworkConfig networkConfig = HTTP.defaultConfig;
            if (((BaseSignatureOptions)t).getNetworkConfig() != null) {
                networkConfig = ((BaseSignatureOptions)t).getNetworkConfig();
            }
            lTResourceResolver = new LTResourceResolver(networkConfig, logger, ((BaseSignatureOptions)t).getCertdb());
        }
        return lTResourceResolver;
    }

    protected void parameterValidation(T t) throws CapiException {
        if (t == null) {
            throw new CapiException("Invalid Signature Options", 1001);
        }
        if (((BaseSignatureOptions)t).getSignatureLevel().equals((Object)SignatureLevel.LTA)) {
            throw new CapiException("FORMAT NOT SUPPORTED", 1001);
        }
        if (!(((BaseSignatureOptions)t).getInput() != null || ((BaseSignatureOptions)t).getDetachedContent() != null || ((BaseSignatureOptions)t).getSignatureProfile() != null && ((BaseSignatureOptions)t).getSignatureProfile().toString().equals("AGID_ID_AUTH_REST_02"))) {
            throw new CapiException("Invalid Input NULL", 1001);
        }
        if (((BaseSignatureOptions)t).getOutput() == null) {
            throw new CapiException("Invalid Output NULL", 1001);
        }
        if (((SignatureOptions)t).getAlias() == null) {
            throw new CapiException("Invalid Alias NULL", 1001);
        }
        if (((BaseSignatureOptions)t).getDigestAlgorithm() == null) {
            throw new CapiException("Invalid DigestAlgorithm NULL", 1001);
        }
        if (((SignatureOptions)t).getKeyStore() == null) {
            throw new CapiException("Invalid KeyStore NULL", 1001);
        }
        if (((BaseSignatureOptions)t).getSignatureLevel() == null) {
            throw new CapiException("Invalid SignatureLevel NULL", 1001);
        }
        if (!((BaseSignatureOptions)t).getSignatureLevel().equals((Object)SignatureLevel.BES)) {
            if (((BaseSignatureOptions)t).getTimeStampOptions() == null) {
                throw new CapiException("Invalid TimeStampOptions NULL but signature level T LT LTA", 1001);
            }
            if (((BaseSignatureOptions)t).getSignatureLevel().compareTo(SignatureLevel.T) > 0 && ((BaseSignatureOptions)t).getCertdb() == null) {
                throw new CapiException("Invalid Certdb NULL but signature level LT LTA", 1001);
            }
        }
        if (((BaseSignatureOptions)t).getSignatureMode() == null) {
            throw new CapiException("Invalid SignatureMode NULL", 1001);
        }
        if (((BaseSignatureOptions)t).getDigestAlgorithm() == DigestAlgorithm.MD5 || ((BaseSignatureOptions)t).getDigestAlgorithm() == DigestAlgorithm.GOST3411 || ((BaseSignatureOptions)t).getDigestAlgorithm() == DigestAlgorithm.RIPEMD128 || ((BaseSignatureOptions)t).getDigestAlgorithm() == DigestAlgorithm.RIPEMD160 || ((BaseSignatureOptions)t).getDigestAlgorithm() == DigestAlgorithm.RIPEMD256) {
            throw new CapiException("Unsupported Digest Algorithm", 3011);
        }
    }

    protected void updateParameterValidation(T t) throws CapiException {
        if (t == null) {
            throw new CapiException("Invalid Signature Options", 1001);
        }
        if (((BaseSignatureOptions)t).getSignatureLevel().equals((Object)SignatureLevel.LTA)) {
            throw new CapiException("FORMAT NOT SUPPORTED", 1001);
        }
        if (((BaseSignatureOptions)t).getInput() == null && ((BaseSignatureOptions)t).getDetachedContent() == null) {
            throw new CapiException("Invalid Input NULL", 1001);
        }
        if (((BaseSignatureOptions)t).getOutput() == null) {
            throw new CapiException("Invalid Output NULL", 1001);
        }
        if (((BaseSignatureOptions)t).getSignatureLevel() == null || ((BaseSignatureOptions)t).getSignatureLevel().equals((Object)SignatureLevel.BES)) {
            throw new CapiException("Invalid SignatureLevel " + (Object)((Object)((BaseSignatureOptions)t).getSignatureLevel()), 1001);
        }
        if (((BaseSignatureOptions)t).getTimeStampOptions() == null) {
            throw new CapiException("Invalid TimeStampOptions NULL but signature level T LT LTA", 1001);
        }
        if (((BaseSignatureOptions)t).getSignatureLevel().compareTo(SignatureLevel.T) > 0 && ((BaseSignatureOptions)t).getCertdb() == null) {
            throw new CapiException("Invalid Certdb NULL but signature level LT LTA", 1001);
        }
        if (((BaseSignatureOptions)t).getSignaturePath() == null || ((BaseSignatureOptions)t).getSignaturePath().isEmpty()) {
            throw new CapiException("Invalid SignaturePath NULL", 1001);
        }
    }
}

