/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.datahandlers.inputs;

import it.actalis.ellips.capi.datahandlers.DataHandler;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.util.CacheOutputStream;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.util.ClonerInputStream;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;

public class StreamInputHandler
extends InputHandler {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    protected InputStream originalStream = null;
    protected CacheOutputStream clonedStream = null;
    protected ClonerInputStream clonerStream = null;

    protected final void initStreamInputHandler(InputStream inputStream, String string) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Please specify a non-null stream!");
        }
        this.originalStream = inputStream;
        this.clonedStream = new CacheOutputStream();
        this.clonerStream = new ClonerInputStream(this.originalStream, (OutputStream)this.clonedStream);
        this.initDataHandler(DataHandler.DATA_TYPE.STREAM, string, null);
    }

    protected StreamInputHandler() {
    }

    public StreamInputHandler(InputStream inputStream, String string) throws IOException {
        this.initStreamInputHandler(inputStream, string);
    }

    public StreamInputHandler(InputStream inputStream) throws IOException {
        this(inputStream, null);
    }

    @Override
    protected InputStream customGetInputAsNewStream() {
        InputStream inputStream = null;
        try {
            inputStream = this.clonerStream.getSlaveInputStream(this.clonedStream.getCache());
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
        }
        return inputStream;
    }
}

