/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.core;

import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.CertificateExpiredException;
import it.actalis.ellips.capi.core.CertificateNotYetValidException;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.core.qc.PdsLocation;
import it.actalis.ellips.capi.core.qc.PkixQCSyntaxv2;
import it.actalis.ellips.capi.core.qc.QcEuLimitValue;
import it.actalis.ellips.capi.core.qc.QcEuRetentionPeriod;
import it.actalis.ellips.capi.core.qc.QcKnown;
import it.actalis.ellips.capi.core.qc.QcPDS;
import it.actalis.ellips.capi.core.qc.QcStatement;
import it.actalis.ellips.capi.core.qc.QcStatements;
import it.actalis.ellips.capi.core.qc.QcType;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DisplayText;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.PolicyQualifierId;
import org.bouncycastle.asn1.x509.PolicyQualifierInfo;
import org.bouncycastle.asn1.x509.SubjectDirectoryAttributes;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.UserNotice;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.asn1.x509.qualified.QCStatement;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX500NameUtil;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.JCEECPublicKey;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;

public class Certificate {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final String NO_CERT_FOUND_INSIDE_SIGNATURE = "NO_CERT_FOUND_INSIDE_SIGNATURE";
    public static final int digitalSignature = 1;
    public static final int nonRepudiation = 2;
    public static final int keyEncipherment = 4;
    public static final int dataEncipherment = 8;
    public static final int keyAgreement = 16;
    public static final int keyCertSign = 32;
    public static final int cRLSign = 64;
    public static final int encipherOnly = 128;
    public static final int decipherOnly = 256;
    public static final int EXT_AuthorityKeyIdentifier = 1;
    public static final int EXT_BasicConstraints = 2;
    public static final int EXT_CertificatePolicies = 3;
    public static final int EXT_CRLDistributionPoints = 4;
    public static final int EXT_IssuerAltName = 5;
    public static final int EXT_KeyUsage = 6;
    public static final int EXT_SubjectAltName = 11;
    public static final int EXT_SubjectKeyIdentifier = 12;
    public static final int EXT_SubjectDirectoryAttributes = 13;
    public static final int EXT_AuthorityInfoAccess = 14;
    public static final int EXT_ExtendedKeyUsage = 30;
    public static final int EXT_QCStatements = 40;
    private static CertificateFactory b;
    private static CertificateFactory c;
    private static final List<String> d;
    private static final List<String> e;
    private CertDBItem[] f = null;
    private boolean g = true;
    private X509Certificate h = null;
    private Boolean i = null;
    private Boolean j = null;
    private Boolean k = null;
    private static Hashtable<String, String> l;
    private static Hashtable<Integer, String> m;
    private static Hashtable<String, ASN1ObjectIdentifier> n;
    private static Hashtable<String, String> o;

    public static boolean isPolicyIncluded(String string, List<String> object) {
        object = object.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            String[] stringArray = string.split(";");
            String[] stringArray2 = stringArray;
            stringArray2 = stringArray;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string3 = stringArray2[i];
                if (!string2.equals(string3)) continue;
                return true;
            }
        }
        return false;
    }

    public Certificate(byte[] byArray) throws CapiException {
        this(byArray, true);
    }

    public Certificate(byte[] byArray, boolean bl) throws CapiException {
        this.g = bl;
        if (bl) {
            a.debug("Certificate constructor");
        }
        if (byArray == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            this.h = (X509Certificate)b.generateCertificate(new ByteArrayInputStream(byArray));
            if (this.h == null) {
                if (bl) {
                    a.debug("Probably this is an IMB JRE, internal cert is null, retry as base64");
                }
                throw new CertificateException("IBM problem");
            }
            return;
        }
        catch (CertificateException certificateException) {
            byArray = Base64.decode((byte[])byArray);
            try {
                this.h = (X509Certificate)b.generateCertificate(new ByteArrayInputStream(byArray));
                if (bl) {
                    a.debug("TEMPDEBUG certificate factory is {}", (Object)b.getClass().getName());
                }
                if (this.h == null) {
                    throw new CapiException("Certificate format unknown or not implemented", 30002);
                }
            }
            catch (CertificateException certificateException2) {
                if (bl) {
                    a.debug(certificateException2.getMessage(), (Throwable)certificateException2);
                }
                throw new CapiException("Certificate format unknown or not implemented", 30002);
            }
        }
        catch (Exception exception) {
            if (bl) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Certificate format unknown or not implemented", 30002);
        }
    }

    public Certificate(X509Certificate x509Certificate) {
        this.h = x509Certificate;
    }

    public X509Certificate getInternalCert() {
        return this.h;
    }

    public String getEncoded() throws CapiException {
        try {
            if (this.h == null) {
                throw new CapiException("Internal error", 30005);
            }
            byte[] byArray = this.h.getEncoded();
            return Util.base64EncodeStr(byArray);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            if (this.g) {
                a.debug(certificateEncodingException.getMessage(), (Throwable)certificateEncodingException);
            }
            throw new CapiException("Certificate format unknown or not implemented", 30002);
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Certificate format unknown or not implemented", 30002);
        }
    }

    public byte[] getDerEncoded() throws CapiException {
        try {
            if (this.h == null) {
                throw new CapiException("Internal error", 30005);
            }
            byte[] byArray = this.h.getEncoded();
            return byArray;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            if (this.g) {
                a.debug(certificateEncodingException.getMessage(), (Throwable)certificateEncodingException);
            }
            throw new CapiException("Certificate format unknown or not implemented", 30002);
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Certificate format unknown or not implemented", 30002);
        }
    }

    public String getIssuerDN() {
        Object object = this.h.getIssuerX500Principal();
        object = object.toString();
        object = ((String)object).replaceAll(", (?=(?<!\\\\, ))(?=([^\\\"]*\\\"[^\\\"]*\\\")*[^\\\"]*$)", ",");
        return object;
    }

    public String[] getIssuerDNAttribute(String rDNArray) throws CapiException {
        Object object;
        if (rDNArray == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (rDNArray.indexOf(".") == -1 && (rDNArray = (object = n.get(rDNArray.toLowerCase())).getId()) == null) {
            throw new CapiException("Unsupported Attribute Name", 1002);
        }
        try {
            object = JcaX500NameUtil.getIssuer((X509Certificate)this.h);
            if (object == null) {
                return null;
            }
            rDNArray = object.getRDNs(new ASN1ObjectIdentifier((String)rDNArray));
            object = new Vector();
            if (rDNArray == null || rDNArray.length == 0) {
                return null;
            }
            for (int i = 0; i < rDNArray.length; ++i) {
                if (!rDNArray[i].isMultiValued()) {
                    ((Vector)object).add(IETFUtils.valueToString((ASN1Encodable)rDNArray[i].getFirst().getValue()));
                    continue;
                }
                AttributeTypeAndValue[] attributeTypeAndValueArray = rDNArray[i].getTypesAndValues();
                if (attributeTypeAndValueArray == null || attributeTypeAndValueArray.length == 0) continue;
                for (int j = 0; j < attributeTypeAndValueArray.length; ++j) {
                    ((Vector)object).add(IETFUtils.valueToString((ASN1Encodable)attributeTypeAndValueArray[j].getValue()));
                }
            }
            if (((Vector)object).size() == 0) {
                return new String[0];
            }
            String[] stringArray = new String[((Vector)object).size()];
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                stringArray[i] = (String)((Vector)object).elementAt(i);
            }
            return stringArray;
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage());
            }
            throw new CapiException("Issuer name format alert", 30002);
        }
    }

    public String getSubjectDN() {
        Object object = this.h.getSubjectX500Principal();
        object = object.toString();
        if (this.g) {
            a.debug("Principal.toString: {}", object);
        }
        object = ((String)object).replaceAll(", (?=(?<!\\\\, ))(?=([^\\\"]*\\\"[^\\\"]*\\\")*[^\\\"]*$)", ",");
        object = ((String)object).replaceAll("\\+ ", "\\+");
        return ((String)object).replaceAll(" \\+", "\\+");
    }

    public String[] getSubjectDNAttribute(String string) throws CapiException {
        String string2;
        RDN[] rDNArray;
        if (string == null) {
            throw new CapiException("Null parameters", 1001);
        }
        if (string.indexOf(".") == -1) {
            rDNArray = n.get(string.toLowerCase());
            if (rDNArray == null) {
                throw new CapiException("Unsupported Attribute Name", 1002);
            }
            string2 = rDNArray.getId();
            if (string2 == null) {
                throw new CapiException("Unsupported Attribute Name", 1002);
            }
        } else {
            string2 = string;
        }
        try {
            rDNArray = JcaX500NameUtil.getSubject((X509Certificate)this.h);
            if (rDNArray == null) {
                return null;
            }
            rDNArray = rDNArray.getRDNs(new ASN1ObjectIdentifier(string2));
            Vector<String> vector = new Vector<String>();
            if (rDNArray == null || rDNArray.length == 0) {
                return null;
            }
            for (int i = 0; i < rDNArray.length; ++i) {
                AttributeTypeAndValue[] attributeTypeAndValueArray;
                if (!rDNArray[i].isMultiValued()) {
                    if (this.g) {
                        a.debug("{} is not multivalue", (Object)string);
                    }
                    vector.add(IETFUtils.valueToString((ASN1Encodable)rDNArray[i].getFirst().getValue()));
                    continue;
                }
                if (this.g) {
                    a.debug("{} is multivalue", (Object)string);
                }
                if ((attributeTypeAndValueArray = rDNArray[i].getTypesAndValues()) == null || attributeTypeAndValueArray.length == 0) continue;
                for (int j = 0; j < attributeTypeAndValueArray.length; ++j) {
                    if (attributeTypeAndValueArray[j].getType().getId().compareToIgnoreCase(string2) != 0) continue;
                    if (this.g) {
                        a.debug("adding: {}", (Object)IETFUtils.valueToString((ASN1Encodable)attributeTypeAndValueArray[j].getValue()));
                    }
                    vector.add(IETFUtils.valueToString((ASN1Encodable)attributeTypeAndValueArray[j].getValue()));
                }
            }
            if (vector.size() == 0) {
                return new String[0];
            }
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                stringArray[i] = (String)vector.elementAt(i);
            }
            return stringArray;
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage());
            }
            throw new CapiException("Subject name format alert", 30002);
        }
    }

    public String getSubjectCommonName() throws CapiException {
        try {
            RDN[] rDNArray = JcaX500NameUtil.getSubject((X509Certificate)this.h);
            rDNArray = rDNArray.getRDNs(BCStyle.CN);
            for (int i = 0; i != rDNArray.length; ++i) {
                AttributeTypeAndValue[] attributeTypeAndValueArray = rDNArray[i];
                if (attributeTypeAndValueArray.isMultiValued()) {
                    attributeTypeAndValueArray = attributeTypeAndValueArray.getTypesAndValues();
                    for (int j = 0; j != attributeTypeAndValueArray.length; ++j) {
                        if (!attributeTypeAndValueArray[j].getType().equals((ASN1Primitive)BCStyle.CN)) continue;
                        return IETFUtils.valueToString((ASN1Encodable)attributeTypeAndValueArray[j].getValue());
                    }
                    if (attributeTypeAndValueArray == null || attributeTypeAndValueArray.length <= 0) continue;
                    return IETFUtils.valueToString((ASN1Encodable)attributeTypeAndValueArray[0].getValue());
                }
                return IETFUtils.valueToString((ASN1Encodable)attributeTypeAndValueArray.getFirst().getValue());
            }
            return null;
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage());
            }
            throw new CapiException("Subject name format alert", 30002);
        }
    }

    public String[] getSubjectOrganization() throws CapiException {
        return this.getSubjectDNAttribute("2.5.4.10");
    }

    public String[] getSubjectCountry() throws CapiException {
        return this.getSubjectDNAttribute("2.5.4.6");
    }

    public String[] getSubjectTitle() throws CapiException {
        return this.getSubjectDNAttribute("2.5.4.12");
    }

    public String[] getSubjectOrganizationalUnit() throws CapiException {
        return this.getSubjectDNAttribute("2.5.4.11");
    }

    public String[] getSubjectSerialNumber() throws CapiException {
        return this.getSubjectDNAttribute("2.5.4.5");
    }

    public String[] getSubjectSurname() throws CapiException {
        return this.getSubjectDNAttribute("2.5.4.4");
    }

    public String[] getSubjectGivenName() throws CapiException {
        return this.getSubjectDNAttribute("2.5.4.42");
    }

    public String[] getSubjectDNQ() throws CapiException {
        return this.getSubjectDNAttribute("2.5.4.46");
    }

    public String getName() {
        String string;
        block12: {
            block11: {
                string = null;
                try {
                    string = this.getSubjectCommonName();
                    if (string != null) {
                        return string;
                    }
                }
                catch (Exception exception) {
                    if (!this.g) break block11;
                    a.debug(exception.getMessage());
                }
            }
            try {
                int n;
                AttributeTypeAndValue[] attributeTypeAndValueArray;
                int n2;
                X500Name x500Name = JcaX500NameUtil.getSubject((X509Certificate)this.h);
                RDN[] rDNArray = x500Name.getRDNs(BCStyle.OU);
                for (n2 = 0; n2 != rDNArray.length; ++n2) {
                    attributeTypeAndValueArray = rDNArray[n2];
                    if (attributeTypeAndValueArray.isMultiValued()) {
                        attributeTypeAndValueArray = attributeTypeAndValueArray.getTypesAndValues();
                        for (n = 0; n != attributeTypeAndValueArray.length; ++n) {
                            if (!attributeTypeAndValueArray[n].getType().equals((ASN1Primitive)BCStyle.OU)) continue;
                            return IETFUtils.valueToString((ASN1Encodable)attributeTypeAndValueArray[n].getValue());
                        }
                        if (attributeTypeAndValueArray == null || attributeTypeAndValueArray.length <= 0) continue;
                        return IETFUtils.valueToString((ASN1Encodable)attributeTypeAndValueArray[0].getValue());
                    }
                    return IETFUtils.valueToString((ASN1Encodable)attributeTypeAndValueArray.getFirst().getValue());
                }
                rDNArray = x500Name.getRDNs(BCStyle.O);
                for (n2 = 0; n2 != rDNArray.length; ++n2) {
                    attributeTypeAndValueArray = rDNArray[n2];
                    if (attributeTypeAndValueArray.isMultiValued()) {
                        attributeTypeAndValueArray = attributeTypeAndValueArray.getTypesAndValues();
                        for (n = 0; n != attributeTypeAndValueArray.length; ++n) {
                            if (!attributeTypeAndValueArray[n].getType().equals((ASN1Primitive)BCStyle.O)) continue;
                            return IETFUtils.valueToString((ASN1Encodable)attributeTypeAndValueArray[n].getValue());
                        }
                        if (attributeTypeAndValueArray == null || attributeTypeAndValueArray.length <= 0) continue;
                        return IETFUtils.valueToString((ASN1Encodable)attributeTypeAndValueArray[0].getValue());
                    }
                    return IETFUtils.valueToString((ASN1Encodable)attributeTypeAndValueArray.getFirst().getValue());
                }
                string = this.getSubjectDN();
            }
            catch (Exception exception) {
                if (!this.g) break block12;
                a.debug(exception.getMessage());
            }
        }
        return string;
    }

    public String[] getSubjectAltName() throws CapiException {
        try {
            Object object = this.h.getExtensionValue(Extension.subjectAlternativeName.getId());
            if (object == null) {
                return new String[0];
            }
            object = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])object));
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(object.getOctets()));
            object = aSN1InputStream;
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)aSN1InputStream.readObject());
            object = aSN1Sequence;
            if (aSN1Sequence == null || object.size() == 0) {
                return new String[0];
            }
            Vector<GeneralName> vector = new Vector<GeneralName>();
            vector.setSize(0);
            for (int i = 0; i < object.size(); ++i) {
                Object object2 = GeneralName.getInstance((Object)object.getObjectAt(i));
                object2 = m.get(new Integer(object2.getTagNo())) + ": " + object2.getName().toString();
                vector.addElement((GeneralName)object2);
            }
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)vector.elementAt(i);
            }
            return stringArray;
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public BigInteger getSerialNumber() throws CapiException {
        try {
            return this.h.getSerialNumber();
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Serial number format alert", 30002);
        }
    }

    public String getValidityNotAfter(String string) throws CapiException {
        try {
            Date date = this.h.getNotAfter();
            if (this.g) {
                a.debug("getNotAfter date: {}", (Object)date);
            }
            return Util.formatDate(date, string);
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Date format alert", 30002);
        }
    }

    public String getValidityNotAfter(String string, String string2) throws CapiException {
        try {
            Date date = this.h.getNotAfter();
            if (this.g) {
                a.debug("getNotAfter date: {}", (Object)date);
            }
            return Util.formatDate(date, string, string2);
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Date format alert", 30002);
        }
    }

    public String getValidityNotBefore(String string) throws CapiException {
        return this.getValidityNotBefore(string, null);
    }

    public String getValidityNotBefore(String string, String string2) throws CapiException {
        try {
            Date date = this.h.getNotBefore();
            if (this.g) {
                a.debug("getNotBefore date: {}", (Object)date);
            }
            return Util.formatDate(date, string, string2);
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Date format alert", 30002);
        }
    }

    public void isValid() throws CertificateExpiredException, CertificateNotYetValidException, CapiException {
        try {
            this.h.checkValidity();
            return;
        }
        catch (java.security.cert.CertificateExpiredException certificateExpiredException) {
            if (this.g) {
                a.debug(certificateExpiredException.getMessage(), (Throwable)certificateExpiredException);
            }
            throw new CertificateExpiredException();
        }
        catch (java.security.cert.CertificateNotYetValidException certificateNotYetValidException) {
            if (this.g) {
                a.debug(certificateNotYetValidException.getMessage(), (Throwable)certificateNotYetValidException);
            }
            throw new CertificateNotYetValidException();
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public void isValid(String object, String string) throws CertificateExpiredException, CertificateNotYetValidException, CapiException {
        if (object == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            object = Util.parseDate((String)object, string);
            if (this.g) {
                a.debug("parsed date: {}", object);
            }
            this.h.checkValidity((Date)object);
            return;
        }
        catch (java.security.cert.CertificateExpiredException certificateExpiredException) {
            if (this.g) {
                a.debug(certificateExpiredException.getMessage(), (Throwable)certificateExpiredException);
            }
            throw new CertificateExpiredException();
        }
        catch (java.security.cert.CertificateNotYetValidException certificateNotYetValidException) {
            if (this.g) {
                a.debug(certificateNotYetValidException.getMessage(), (Throwable)certificateNotYetValidException);
            }
            throw new CertificateNotYetValidException();
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public int getRemainingValidityDays() {
        try {
            this.isValid();
        }
        catch (CapiException capiException) {
            if (this.g) {
                a.debug(capiException.getMessage(), (Throwable)capiException);
            }
            return -1;
        }
        try {
            long l = this.h.getNotAfter().getTime();
            long l2 = new Date().getTime();
            long l3 = l - l2;
            return (int)(l3 / 86400000L + 1L);
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            return -2;
        }
    }

    public void verify(byte[] object) throws CapiException {
        byte[] byArray;
        byte[] byArray2;
        block21: {
            block20: {
                block19: {
                    if (object == null) {
                        throw new CapiException("Null parameters", 1001);
                    }
                    Certificate certificate = new Certificate((byte[])object);
                    object = certificate;
                    Object object2 = certificate.getSubjectDN();
                    if (!this.getIssuerDN().equalsIgnoreCase((String)object2)) {
                        throw new CapiException("IssuerDN does not match", 30004);
                    }
                    object2 = null;
                    try {
                        object2 = ((Certificate)object).getPublicKey();
                        this.h.verify((PublicKey)object2);
                        return;
                    }
                    catch (SignatureException signatureException) {
                        if (this.g) {
                            a.debug(signatureException.getMessage(), (Throwable)signatureException);
                        }
                    }
                    catch (Exception exception) {
                        try {
                            if (this.g) {
                                a.debug(exception.getMessage(), (Throwable)exception);
                            }
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.h.getEncoded());
                            X509Certificate x509Certificate = (X509Certificate)c.generateCertificate(byteArrayInputStream);
                            x509Certificate.verify((PublicKey)object2);
                            return;
                        }
                        catch (Exception exception2) {
                            if (!this.g) break block19;
                            a.debug(exception2.getMessage(), (Throwable)exception2);
                        }
                    }
                }
                byArray2 = null;
                try {
                    byArray2 = this.getAuthorityKeyIdentifier();
                    if (byArray2.length == 0) {
                        byArray2 = null;
                    }
                }
                catch (CapiException capiException) {
                    if (!this.g) break block20;
                    a.debug(capiException.getMessage(), (Throwable)capiException);
                }
            }
            byArray = null;
            try {
                byArray = ((Certificate)object).getSubjectKeyIdentifier();
                if (byArray.length == 0) {
                    byArray = null;
                }
            }
            catch (CapiException capiException) {
                if (!this.g) break block21;
                a.debug(capiException.getMessage(), (Throwable)capiException);
            }
        }
        if (((Certificate)object).getBasicConstraints()) {
            if (byArray == null) {
                throw new CapiException("SubjectKeyIdentifier not present", 30006);
            }
            if (((Certificate)object).isCritical(12)) {
                throw new CapiException("SubjectKeyIdentifier critical", 30006);
            }
        }
        if (byArray2 != null && byArray != null && Util.equalsBlock(byArray2, byArray)) {
            throw new CapiException("The signature is not valid but the AuthKeyId and the issuer SubjectKeyId are the same", 30007);
        }
        throw new CapiException("The signature is not valid", 30003);
    }

    public String getFingerprint(String object) throws CapiException {
        if (object == null) {
            object = "SHA-1";
        }
        if (this.h == null) {
            throw new CapiException("Internal error", 30005);
        }
        if (this.g) {
            a.debug("getFingerprint: {}", object);
        }
        try {
            object = MessageDigest.getInstance((String)object, ProvUtils.bcProvider);
            ((MessageDigest)object).update(this.h.getEncoded());
            byte[] byArray = ((MessageDigest)object).digest();
            object = byArray;
            byte[] byArray2 = Hex.encode((byte[])byArray);
            object = new String(Hex.encode((byte[])object));
            String string = "";
            for (int i = 0; i < byArray2.length; i += 2) {
                int n = i;
                string = string + ((String)object).substring(n, n + 2);
                if (i >= byArray2.length - 2) continue;
                string = string + ":";
            }
            return string.toUpperCase();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (this.g) {
                a.debug(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
            }
            throw new CapiException("Wrong args", 1002);
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public int getKeyUsageBits() throws CapiException {
        if (this.g) {
            a.debug("getKeyUsageBits");
        }
        try {
            if (!this.isCritical(6)) {
                return 0;
            }
            return this.getKeyUsage();
        }
        catch (CapiException capiException) {
            if (this.g) {
                a.debug(capiException.getMessage(), (Throwable)capiException);
            }
            throw capiException;
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public String keyUsageToString(int n) throws CapiException {
        try {
            boolean[] blArray = this.h.getKeyUsage();
            if (blArray == null) {
                return "no KeyUsage";
            }
            String[] stringArray = new String[]{"digitalSignature", "nonRepudiation", "keyEncipherment", "dataEncipherment", "keyAgreement", "keyCertSign", "cRLSign", "encipherOnly", "decipherOnly"};
            String string = "";
            boolean bl = true;
            for (int i = 0; i < blArray.length && i < 9; ++i) {
                if (!blArray[i]) continue;
                if (!bl) {
                    string = string + " | ";
                }
                string = string + stringArray[i];
                bl = false;
            }
            if (string.compareTo("") == 0 || string.length() == 0) {
                return "no KeyUsage";
            }
            return string;
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public boolean hasBasicConstraints() throws CapiException {
        block7: {
            try {
                int n = this.h.getBasicConstraints();
                if (this.g) {
                    a.debug("basic constraints is {}", (Object)n);
                }
                if (n == -1) {
                    return false;
                }
                if (n != Integer.MAX_VALUE) break block7;
                return false;
            }
            catch (Exception exception) {
                if (this.g) {
                    a.debug(exception.getMessage(), (Throwable)exception);
                }
                throw new CapiException("Internal error", 30005);
            }
        }
        if (this.g) {
            a.debug("basic constraints is not null");
        }
        return true;
    }

    public boolean getBasicConstraints() throws CapiException {
        block7: {
            try {
                int n = this.h.getBasicConstraints();
                if (this.g) {
                    a.debug("basic constraints is {}", (Object)n);
                }
                if (n == -1) {
                    return false;
                }
                if (n != Integer.MAX_VALUE) break block7;
                return true;
            }
            catch (Exception exception) {
                if (this.g) {
                    a.debug(exception.getMessage(), (Throwable)exception);
                }
                throw new CapiException("Internal error", 30005);
            }
        }
        if (this.g) {
            a.debug("basic constraints is not null");
        }
        return true;
    }

    public int getBasicConstraintsPathLen() throws CapiException {
        int n;
        block7: {
            try {
                n = this.h.getBasicConstraints();
                if (this.g) {
                    a.debug("basic constraints is {}", (Object)n);
                }
                if (n == -1) {
                    return -1;
                }
                if (n != Integer.MAX_VALUE) break block7;
                return -1;
            }
            catch (Exception exception) {
                if (this.g) {
                    a.debug(exception.getMessage(), (Throwable)exception);
                }
                throw new CapiException("Internal error", 30005);
            }
        }
        if (this.g) {
            a.debug("basic constraints is not null");
        }
        return n;
    }

    public String[] getPolicies(char c2) throws CapiException {
        try {
            Object object = this.h.getExtensionValue(Extension.certificatePolicies.getId());
            if (object == null) {
                return new String[0];
            }
            object = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])object));
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(object.getOctets()));
            object = aSN1InputStream;
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)aSN1InputStream.readObject());
            object = aSN1Sequence;
            if (aSN1Sequence == null) {
                return new String[0];
            }
            String[] stringArray = new String[object.size()];
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < object.size(); ++i) {
                String[] stringArray2;
                ASN1Encodable[] aSN1EncodableArray;
                PolicyInformation policyInformation;
                stringBuffer.setLength(0);
                try {
                    policyInformation = PolicyInformation.getInstance((Object)object.getObjectAt(i));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    stringArray = new String[2];
                    a.error("Malformed policies! Expected sequences must be 1 or 2." + illegalArgumentException.getMessage());
                    ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance((Object)object.getObjectAt(i));
                    aSN1EncodableArray = aSN1Sequence2.toArray();
                    stringBuffer.append(aSN1EncodableArray[0].toString());
                    stringBuffer.append(c2);
                    stringArray2 = ASN1Sequence.getInstance((Object)aSN1EncodableArray[1]);
                    stringArray2 = stringArray2.toArray();
                    stringBuffer.append(stringArray2[0].toString());
                    stringBuffer.append(c2);
                    stringArray[0] = stringBuffer.toString();
                    stringBuffer.setLength(0);
                    stringArray2 = ASN1Sequence.getInstance((Object)aSN1EncodableArray[2]);
                    aSN1EncodableArray = stringArray2.toArray();
                    stringBuffer.append(aSN1EncodableArray[0].toString());
                    stringArray[1] = stringBuffer.toString();
                    a.info("Try to recover:");
                    stringArray2 = stringArray;
                    for (int j = 0; j < 2; ++j) {
                        String string = stringArray2[j];
                        a.info("- policy: " + string);
                    }
                    return stringArray;
                }
                stringBuffer.append(policyInformation.getPolicyIdentifier().getId());
                stringBuffer.append(c2);
                policyInformation = policyInformation.getPolicyQualifiers();
                if (policyInformation != null) {
                    for (int j = 0; j < policyInformation.size(); ++j) {
                        aSN1EncodableArray = PolicyQualifierInfo.getInstance((Object)policyInformation.getObjectAt(j));
                        stringArray2 = aSN1EncodableArray.getPolicyQualifierId();
                        if (stringArray2.equals((ASN1Primitive)PolicyQualifierId.id_qt_cps)) {
                            stringBuffer.append("CPS URI: " + aSN1EncodableArray.getQualifier().toString());
                            stringBuffer.append(c2);
                            continue;
                        }
                        if (!stringArray2.equals((ASN1Primitive)PolicyQualifierId.id_qt_unotice)) continue;
                        stringArray2 = UserNotice.getInstance((Object)aSN1EncodableArray.getQualifier());
                        aSN1EncodableArray = stringArray2.getNoticeRef();
                        stringArray2 = stringArray2.getExplicitText();
                        if (aSN1EncodableArray != null) {
                            DisplayText displayText = aSN1EncodableArray.getOrganization();
                            if (displayText != null) {
                                stringBuffer.append("organization: " + displayText.getString());
                            }
                            if ((aSN1EncodableArray = aSN1EncodableArray.getNoticeNumbers()) != null) {
                                for (int k = 0; k < aSN1EncodableArray.length; ++k) {
                                    stringBuffer.append(" " + aSN1EncodableArray[k].getValue());
                                }
                            }
                            stringBuffer.append(c2);
                        }
                        if (stringArray2 == null) continue;
                        try {
                            if (this.g) {
                                a.debug("[getPolicies] displayText getString: {}", (Object)stringArray2.getString());
                            }
                            stringBuffer.append("displayText: " + stringArray2.getString());
                            stringBuffer.append(c2);
                            continue;
                        }
                        catch (Exception exception) {
                            try {
                                aSN1EncodableArray = DERGeneralString.getInstance((Object)stringArray2);
                                if (aSN1EncodableArray == null) continue;
                                stringBuffer.append("displayText: " + aSN1EncodableArray.getString());
                                continue;
                            }
                            catch (Exception exception2) {}
                        }
                    }
                }
                stringArray[i] = stringBuffer.toString();
            }
            return stringArray;
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public boolean hasExtension(String object) throws CapiException {
        if (this.g) {
            a.debug("hasInhibitAnyPolicyExtension");
        }
        try {
            byte[] byArray = this.h.getExtensionValue((String)object);
            object = byArray;
            if (byArray == null) {
                return false;
            }
            object = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])object));
            object = new ASN1InputStream((InputStream)new ByteArrayInputStream(object.getOctets()));
            return (object = ASN1Sequence.getInstance((Object)object.readObject())) != null;
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public String[] getCdpURLs() throws CapiException {
        try {
            Object object = this.h.getExtensionValue(Extension.cRLDistributionPoints.getId());
            if (object == null) {
                return new String[0];
            }
            object = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])object));
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(object.getOctets()));
            object = aSN1InputStream;
            CRLDistPoint cRLDistPoint = CRLDistPoint.getInstance((Object)aSN1InputStream.readObject());
            object = cRLDistPoint;
            if (cRLDistPoint == null) {
                return new String[0];
            }
            Vector<String> vector = new Vector<String>();
            vector.setSize(0);
            object = object.getDistributionPoints();
            for (int i = 0; i != ((byte[])object).length; ++i) {
                Object object2 = object[i];
                object2.getDistributionPoint();
                GeneralNames generalNames = (GeneralNames)object[i].getDistributionPoint().getName();
                object2 = generalNames;
                object2 = generalNames.getNames();
                for (int j = 0; j < ((byte)object2).length; ++j) {
                    ASN1String aSN1String;
                    if (object2[j].getTagNo() == 6) {
                        aSN1String = (ASN1String)object2[j].getName();
                        vector.addElement(aSN1String.getString());
                        continue;
                    }
                    if (object2[j].getTagNo() == 4) {
                        aSN1String = (X500Name)object2[j].getName();
                        vector.addElement(aSN1String.toString());
                        continue;
                    }
                    vector.addElement(object2[j].toString());
                }
            }
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)vector.elementAt(i);
            }
            return stringArray;
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public String toString() {
        try {
            String string = System.getProperty("line.separator");
            String string2 = "Version: " + this.getVersion() + string;
            string2 = string2 + "Serial number: " + this.getSerialNumber() + string;
            string2 = string2 + "Signature algorithm: " + this.getSigAlgName() + string;
            string2 = string2 + "Issuer: " + this.getIssuerDN() + string;
            string2 = string2 + "Valid not before: " + this.getValidityNotBefore("EEE, d MMM yyyy HH:mm:ss Z") + string;
            string2 = string2 + "Valid not after: " + this.getValidityNotAfter("EEE, d MMM yyyy HH:mm:ss Z") + string;
            string2 = string2 + "Subject: " + this.getSubjectDN() + string;
            string2 = string2 + this.getPublicKey().toString() + string;
            string2 = string2 + "Certificate Fingerprint (SHA256) " + this.getFingerprint("SHA-256") + string;
            string2 = string2 + "Certificate Fingerprint (SHA-1) " + this.getFingerprint("SHA-1") + string;
            int n = this.h.getCriticalExtensionOIDs().size() + this.h.getNonCriticalExtensionOIDs().size();
            string2 = string2 + "Extensions: " + n + string;
            return string2;
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Certificate) {
            object = (Certificate)object;
            return this.h.equals(((Certificate)object).h);
        }
        return false;
    }

    public String getSigAlgName() throws CapiException {
        try {
            return this.h.getSigAlgName();
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("SigAlgName format alert", 30002);
        }
    }

    public int getVersion() throws CapiException {
        try {
            return this.h.getVersion();
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Version format alert", 30002);
        }
    }

    public String[] getExtendedKeyUsageAsString() throws CapiException {
        try {
            List<String> list = this.h.getExtendedKeyUsage();
            if (list == null) {
                return new String[0];
            }
            if (list.size() == 0) {
                return new String[0];
            }
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) == null) continue;
                String string = o.get(list.get(i));
                stringArray[i] = string != null ? string : list.get(i);
            }
            return stringArray;
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public String[] getExtendedKeyUsage() throws CapiException {
        try {
            List<String> list = this.h.getExtendedKeyUsage();
            if (list == null) {
                return new String[0];
            }
            if (list.size() == 0) {
                return new String[0];
            }
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                stringArray[i] = list.get(i);
            }
            return stringArray;
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public String[] getIssuerAltName() throws CapiException {
        try {
            Object object = this.h.getExtensionValue(Extension.issuerAlternativeName.getId());
            if (object == null) {
                return new String[0];
            }
            object = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])object));
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(object.getOctets()));
            object = aSN1InputStream;
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)aSN1InputStream.readObject());
            object = aSN1Sequence;
            if (aSN1Sequence == null || object.size() == 0) {
                return new String[0];
            }
            Vector<GeneralName> vector = new Vector<GeneralName>();
            vector.setSize(0);
            for (int i = 0; i < object.size(); ++i) {
                Object object2 = GeneralName.getInstance((Object)object.getObjectAt(i));
                object2 = m.get(new Integer(object2.getTagNo())) + ": " + object2.getName().toString();
                vector.addElement((GeneralName)object2);
            }
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)vector.elementAt(i);
            }
            return stringArray;
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public String[] getAuthorityInfoAccess() throws CapiException {
        try {
            Object object = this.h.getExtensionValue(Extension.authorityInfoAccess.getId());
            if (object == null) {
                return new String[0];
            }
            object = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])object));
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(object.getOctets()));
            object = aSN1InputStream;
            AuthorityInformationAccess authorityInformationAccess = AuthorityInformationAccess.getInstance((Object)aSN1InputStream.readObject());
            object = authorityInformationAccess;
            AccessDescription[] accessDescriptionArray = authorityInformationAccess.getAccessDescriptions();
            object = accessDescriptionArray;
            if (accessDescriptionArray == null || ((byte[])object).length == 0) {
                return new String[0];
            }
            Vector<String> vector = new Vector<String>();
            vector.setSize(0);
            for (int i = 0; i < ((byte[])object).length; ++i) {
                String string;
                if (object[i] != null && object[i].getAccessMethod().equals((ASN1Primitive)AccessDescription.id_ad_ocsp)) {
                    string = "ocsp;" + m.get(new Integer(object[i].getAccessLocation().getTagNo())) + ": " + object[i].getAccessLocation().getName().toString();
                    vector.addElement(string);
                    continue;
                }
                if (object[i] == null || !object[i].getAccessMethod().equals((ASN1Primitive)AccessDescription.id_ad_caIssuers)) continue;
                string = "caIssuers;" + m.get(new Integer(object[i].getAccessLocation().getTagNo())) + ": " + object[i].getAccessLocation().getName().toString();
                vector.addElement(string);
            }
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)vector.elementAt(i);
            }
            return stringArray;
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public byte[] getAuthorityKeyIdentifier() throws CapiException {
        try {
            Object object = this.h.getExtensionValue(Extension.authorityKeyIdentifier.getId());
            if (object == null) {
                return new byte[0];
            }
            object = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])object));
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(object.getOctets()));
            object = aSN1InputStream;
            AuthorityKeyIdentifier authorityKeyIdentifier = AuthorityKeyIdentifier.getInstance((Object)aSN1InputStream.readObject());
            object = authorityKeyIdentifier;
            if (authorityKeyIdentifier == null) {
                return new byte[0];
            }
            return object.getKeyIdentifier();
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public byte[] getSubjectKeyIdentifier() throws CapiException {
        try {
            Object object = this.h.getExtensionValue(Extension.subjectKeyIdentifier.getId());
            if (object == null) {
                return new byte[0];
            }
            object = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])object));
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(object.getOctets()));
            object = aSN1InputStream;
            SubjectKeyIdentifier subjectKeyIdentifier = SubjectKeyIdentifier.getInstance((Object)aSN1InputStream.readObject());
            object = subjectKeyIdentifier;
            if (subjectKeyIdentifier == null) {
                return new byte[0];
            }
            return object.getKeyIdentifier();
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public boolean isCritical(int n) throws CapiException {
        String string;
        switch (n) {
            case 1: {
                string = X509Extension.authorityKeyIdentifier.getId();
                break;
            }
            case 2: {
                string = X509Extension.basicConstraints.getId();
                break;
            }
            case 3: {
                string = X509Extension.certificatePolicies.getId();
                break;
            }
            case 4: {
                string = X509Extension.cRLDistributionPoints.getId();
                break;
            }
            case 5: {
                string = X509Extension.issuerAlternativeName.getId();
                break;
            }
            case 6: {
                string = X509Extension.keyUsage.getId();
                break;
            }
            case 11: {
                string = X509Extension.subjectAlternativeName.getId();
                break;
            }
            case 13: {
                string = X509Extension.subjectDirectoryAttributes.getId();
                break;
            }
            case 12: {
                string = X509Extension.subjectKeyIdentifier.getId();
                break;
            }
            case 14: {
                string = X509Extension.authorityInfoAccess.getId();
                break;
            }
            case 30: {
                string = X509Extension.extendedKeyUsage.getId();
                break;
            }
            case 40: {
                string = X509Extension.qCStatements.getId();
                break;
            }
            default: {
                throw new CapiException("Unsupported extension " + n, 30005);
            }
        }
        try {
            Object object = this.h.getCriticalExtensionOIDs();
            if (object != null && !object.isEmpty()) {
                object = object.iterator();
                while (object.hasNext()) {
                    String string2 = (String)object.next();
                    if (string2.compareToIgnoreCase(string) != 0) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public static X509Certificate[] getX509CertificatesFromStore(Store object) throws Exception {
        int n;
        Collection collection;
        object = object.getMatches(null);
        object = object;
        if (collection.isEmpty()) {
            a.debug("storecertificate is empty");
            return new X509Certificate[0];
        }
        a.debug("storecertificate size: " + object.size());
        X509Certificate[] x509CertificateArray = new X509Certificate[object.size()];
        X509CertificateHolder[] x509CertificateHolderArray = new X509CertificateHolder[object.size()];
        object = new Vector(object);
        for (n = 0; n < ((Vector)object).size(); ++n) {
            x509CertificateHolderArray[n] = (X509CertificateHolder)((Vector)object).elementAt(n);
        }
        for (n = 0; n < x509CertificateHolderArray.length; ++n) {
            x509CertificateArray[n] = new JcaX509CertificateConverter().setProvider(ProvUtils.bcProvider).getCertificate(x509CertificateHolderArray[n]);
        }
        return x509CertificateArray;
    }

    public static Certificate[] getCapiCertificatesFromStore(Store object) throws Exception {
        int n;
        Collection collection;
        object = object.getMatches(null);
        object = object;
        if (collection.isEmpty()) {
            a.debug("storecertificate is empty");
            return new Certificate[0];
        }
        a.debug("storecertificate size: " + object.size());
        Certificate[] certificateArray = new Certificate[object.size()];
        X509CertificateHolder[] x509CertificateHolderArray = new X509CertificateHolder[object.size()];
        object = new Vector(object);
        for (n = 0; n < ((Vector)object).size(); ++n) {
            x509CertificateHolderArray[n] = (X509CertificateHolder)((Vector)object).elementAt(n);
        }
        for (n = 0; n < x509CertificateHolderArray.length; ++n) {
            certificateArray[n] = new Certificate(x509CertificateHolderArray[n].getEncoded());
        }
        return certificateArray;
    }

    public static Certificate[] parseP7C(InputStream inputStream) throws CapiException {
        try {
            inputStream = new CMSSignedData(inputStream);
            a.debug("Chain toString:\n" + inputStream.toString());
            inputStream = inputStream.getCertificates();
            return Certificate.getCapiCertificatesFromStore((Store)inputStream);
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 30005);
        }
    }

    public String getSubjectPublicKeyInfo() throws CapiException {
        try {
            Object object = this.getPublicKey();
            String string = object.getAlgorithm();
            object = object.getEncoded();
            return string + ": " + new String(Hex.encode((byte[])object));
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public int getKeyUsage() throws CapiException {
        if (this.g) {
            a.debug("getKeyUsage as int");
        }
        try {
            boolean[] blArray = this.h.getKeyUsage();
            if (blArray == null) {
                return 0;
            }
            String string = "1";
            int n = 0;
            for (int i = 0; i < blArray.length; ++i) {
                if (blArray[i]) {
                    n += Integer.parseInt(string, 2);
                }
                string = string + "0";
            }
            if (this.g) {
                a.debug("getKeyUsage");
            }
            return n;
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public boolean hasUnsupportedCriticalExtension() throws CapiException {
        if (this.g) {
            a.debug("hasUnsupportedCriticalExtension");
        }
        try {
            return this.h.hasUnsupportedCriticalExtension();
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public Hashtable<String, String> getSubjectDirectoryAttributes() throws CapiException {
        try {
            Object object = this.h.getExtensionValue(Extension.subjectDirectoryAttributes.getId());
            if (object == null) {
                return null;
            }
            object = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])object));
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(object.getOctets()));
            object = aSN1InputStream;
            SubjectDirectoryAttributes subjectDirectoryAttributes = SubjectDirectoryAttributes.getInstance((Object)aSN1InputStream.readObject());
            object = subjectDirectoryAttributes;
            if (subjectDirectoryAttributes == null) {
                return null;
            }
            Vector vector = object.getAttributes();
            object = vector;
            if (vector == null) {
                return null;
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                Object object2 = (Attribute)((Vector)object).elementAt(i);
                String string = object2.getAttrType().toString();
                Object object3 = object2.getAttrValues();
                if (object3 == null || object3.size() <= 0) {
                    return null;
                }
                stringBuffer.setLength(0);
                if (object2.getAttrType().equals((ASN1Primitive)BCStyle.DATE_OF_BIRTH)) {
                    if (this.g) {
                        a.debug("dateOfBirth...");
                    }
                    string = "dateOfBirth";
                    object2 = DERGeneralizedTime.getInstance((Object)object3.getObjectAt(0));
                    object2 = object2.getDate();
                    object3 = new SimpleDateFormat("dd-MM-yyyy");
                    object2 = object3.format((Date)object2);
                    stringBuffer.append((String)object2);
                    hashtable.put(string, stringBuffer.toString());
                    continue;
                }
                if (object2.getAttrType().equals((ASN1Primitive)BCStyle.PLACE_OF_BIRTH)) {
                    if (this.g) {
                        a.debug("dateOfBirth...");
                    }
                    string = "placeOfBirth";
                    stringBuffer.append(object3.getObjectAt(0));
                    hashtable.put(string, stringBuffer.toString());
                    continue;
                }
                if (object2.getAttrType().equals((ASN1Primitive)BCStyle.GENDER)) {
                    if (this.g) {
                        a.debug("gender...");
                    }
                    string = "gender";
                    stringBuffer.append(object3.getObjectAt(0));
                    hashtable.put(string, stringBuffer.toString());
                    continue;
                }
                if (object2.getAttrType().equals((ASN1Primitive)BCStyle.COUNTRY_OF_CITIZENSHIP)) {
                    if (this.g) {
                        a.debug("countryOfCitizenship...");
                    }
                    string = "countryOfCitizenship";
                    stringBuffer.append(object3.getObjectAt(0));
                    hashtable.put(string, stringBuffer.toString());
                    continue;
                }
                if (object2.getAttrType().equals((ASN1Primitive)BCStyle.COUNTRY_OF_RESIDENCE)) {
                    if (this.g) {
                        a.debug("countryOfResidence...");
                    }
                    string = "countryOfResidence";
                    stringBuffer.append(object3.getObjectAt(0));
                    hashtable.put(string, stringBuffer.toString());
                    continue;
                }
                for (int j = 0; j < object3.size(); ++j) {
                    stringBuffer.append(object3.getObjectAt(j));
                    stringBuffer.append(';');
                }
                hashtable.put(string, stringBuffer.toString());
            }
            return hashtable;
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public List<QcStatement> getQCStatements() throws CapiException {
        try {
            Object object = this.h.getExtensionValue(Extension.qCStatements.getId());
            if (object == null) {
                return null;
            }
            object = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])object));
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(object.getOctets()));
            object = aSN1InputStream;
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)aSN1InputStream.readObject());
            object = aSN1Sequence;
            if (aSN1Sequence == null) {
                return null;
            }
            LinkedList<QcStatement> linkedList = new LinkedList<QcStatement>();
            for (int i = 0; i < object.size(); ++i) {
                Object object2 = QCStatement.getInstance((Object)object.getObjectAt(i));
                String string = object2.getStatementId().getId();
                if (this.g) {
                    a.debug("putting statementID: " + string);
                }
                try {
                    object2 = QcStatement.getInstance(object2.getStatementId().getId(), object2.getStatementInfo());
                    linkedList.add((QcStatement)object2);
                    continue;
                }
                catch (Exception exception) {
                    if (!this.g) continue;
                    a.debug("error parsing qcStatements: {}: {}", (Object)string, (Object)exception.getMessage());
                }
            }
            return linkedList;
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Internal error", 30005);
        }
    }

    public int getRSAPublicKeyLen() throws CapiException {
        try {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)this.h.getPublicKey();
            int n = rSAPublicKey.getModulus().bitLength();
            int n2 = (n + 255) / 256 << 8;
            if (this.g) {
                a.debug("getRSAPublicKeyLen value={} ->{}", (Object)n, (Object)n2);
            }
            return n2;
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Exception getting RSA PublicKey Len " + exception.getMessage(), 3000);
        }
    }

    public boolean isSha1InvalidCert() {
        Object object;
        try {
            object = this.getSigAlgName();
        }
        catch (CapiException capiException) {
            if (this.g) {
                a.debug(capiException.getMessage(), (Throwable)capiException);
            }
            return true;
        }
        if (((String)object).toLowerCase().indexOf("sha256withrsa") == -1) {
            object = this.getInternalCert().getNotBefore();
            return Util.isDateInvalid("20100901", "yyyyMMdd", (Date)object);
        }
        return false;
    }

    public boolean isCNSAuthentication() throws CapiException {
        return this.a(false);
    }

    public boolean isCNSLikeAuthentication() throws CapiException {
        return this.a(true);
    }

    private boolean a(boolean bl) throws CapiException {
        String[] stringArray;
        int n;
        String[] stringArray2;
        if (this.i != null) {
            if (this.g) {
                a.debug("isCNSAuthentication() returning: {}", (Object)this.i);
            }
            return this.i;
        }
        this.i = Boolean.FALSE;
        if (this.g) {
            a.debug("isCNSAuthentication ?");
        }
        if (!this.isCritical(6)) {
            if (this.g) {
                a.debug("Key Usage is not a critical extension");
            }
            return false;
        }
        int n2 = this.getKeyUsage();
        if (this.g) {
            a.debug("Key Usage: {}", (Object)n2);
        }
        if ((n2 & 1) <= 0) {
            if (this.g) {
                a.debug("Key Usage has not digitalSignature set");
            }
            return false;
        }
        if ((n2 & 0x62) > 0) {
            if (this.g) {
                a.debug("Key Usage has set cRLSign or keyCertSign or nonRepudiation");
            }
            return false;
        }
        if (this.g) {
            a.debug("Key Usage is ok.");
        }
        if ((stringArray2 = this.getExtendedKeyUsage()) == null || stringArray2.length == 0) {
            if (this.g) {
                a.debug("Extended Key Usage not found");
            }
            return false;
        }
        if (this.isCritical(30)) {
            if (this.g) {
                a.debug("Extended Key Usage is a critical extension");
            }
            return false;
        }
        for (n = 0; n < stringArray2.length; ++n) {
            if (!this.g) continue;
            a.debug("{}:{}", (Object)n, (Object)stringArray2[n]);
        }
        n = 0;
        String string = "1.3.6.1.5.5.7.3.2";
        if (this.g) {
            a.debug("Searching tsl www client authentication {}", (Object)string);
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!string.equals(stringArray2[i])) continue;
            if (this.g) {
                a.debug("found tsl www client authentication  ");
            }
            n = 1;
            break;
        }
        if (n == 0) {
            if (this.g) {
                a.debug("tsl www client authentication not in Extended Key Usage");
            }
            return false;
        }
        if (!bl) {
            String string2 = null;
            bl = false;
            boolean bl2 = false;
            String[] stringArray3 = this.getPolicies(';');
            if (stringArray3 == null || stringArray3.length <= 0) {
                if (this.g) {
                    a.debug("Missing Certificate Policies extension");
                }
                return false;
            }
            for (int i = 0; i < stringArray3.length; ++i) {
                int n3 = stringArray3[i].indexOf("CPS URI: ");
                if (n3 >= 0) {
                    string2 = stringArray3[i].substring(n3 + 9);
                    if (string2.indexOf(";") >= 4) {
                        string2 = string2.substring(0, string2.indexOf(";"));
                    }
                    if (this.g) {
                        a.debug("found CPS URI: {}", (Object)string2);
                    }
                }
                if ((n3 = stringArray3[i].indexOf("displayText: ")) >= 0) {
                    String string3 = stringArray3[i].substring(n3 + 13);
                    if (string3.indexOf(";") >= 2) {
                        string3 = string3.substring(0, string3.indexOf(";"));
                    }
                    if (this.g) {
                        a.debug("found displayText: {}", (Object)string3);
                    }
                    String string4 = "Identifies X.509 authentication certificates issued for the italian National Service Card (CNS) project in according to the italian regulation";
                    if (string3.trim().toLowerCase().startsWith(string4.toLowerCase())) {
                        bl = true;
                    }
                }
                if (!Certificate.isPolicyIncluded(stringArray3[i], d)) continue;
                if (this.g) {
                    a.debug("found valid CNS Policy object id");
                }
                bl2 = true;
            }
            if (string2 == null) {
                if (this.g) {
                    a.debug("Missing CPS URI in Certificate Policies extension");
                }
                return false;
            }
            if (!bl) {
                if (this.g) {
                    a.debug("Missing CNS Usage in Display Text of Certificate Policies extension");
                }
                return false;
            }
            if (!bl2) {
                if (this.g) {
                    a.debug("Missing valid OID in Certificate Policies extension");
                }
                return false;
            }
        }
        if ((stringArray = this.getCdpURLs()) == null || stringArray.length == 0) {
            if (this.g) {
                a.debug("Missing CRL Distribution Point extension");
            }
            return false;
        }
        if (this.getAuthorityKeyIdentifier() == null) {
            if (this.g) {
                a.debug("Missing Authority Key Identifier extension");
            }
            return false;
        }
        if (this.getSubjectKeyIdentifier() == null) {
            if (this.g) {
                a.debug("Missing Subject Key Identifier extension");
            }
            return false;
        }
        if (this.g) {
            a.debug("Certificate is CNSAuthentication.");
        }
        this.i = Boolean.TRUE;
        return true;
    }

    public PublicKey getPublicKey() {
        return this.h.getPublicKey();
    }

    public X509Principal getSubjectName() throws CapiException {
        try {
            return PrincipalUtil.getSubjectX509Principal((X509Certificate)this.h);
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Subject name format alert", 30002);
        }
    }

    public X500Name getX500SubjectName() throws CapiException {
        try {
            X500Name x500Name = JcaX500NameUtil.getSubject((X509Certificate)this.h);
            return x500Name;
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Subject name format alert", 30002);
        }
    }

    public X509Principal getIssuerName() throws CapiException {
        try {
            return PrincipalUtil.getIssuerX509Principal((X509Certificate)this.h);
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Subject name format alert", 30002);
        }
    }

    public X500Name getX500IssuerName() throws CapiException {
        try {
            X500Name x500Name = JcaX500NameUtil.getIssuer((X509Certificate)this.h);
            return x500Name;
        }
        catch (Exception exception) {
            if (this.g) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Subject name format alert", 30002);
        }
    }

    public boolean isRsVerified() {
        boolean bl = false;
        try {
            String string;
            String[] stringArray = this.getPolicies(',');
            String[] stringArray2 = stringArray;
            stringArray2 = stringArray;
            int n = stringArray.length;
            for (int i = 0; i < n && !(bl = (string = stringArray2[i]).startsWith("1.3.76.16.3,")); ++i) {
            }
        }
        catch (CapiException capiException) {}
        return bl;
    }

    public boolean isSSCD() {
        boolean bl;
        block3: {
            bl = false;
            try {
                Object object = this.getQCStatements();
                if (object == null) break block3;
                object = object.iterator();
                while (object.hasNext()) {
                    QcStatement qcStatement = (QcStatement)object.next();
                    if (!(qcStatement instanceof QcKnown) || ((QcKnown)qcStatement).getType() != QcStatements.QcSSCD) continue;
                    bl = true;
                    break;
                }
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
        }
        return bl;
    }

    public String getQcStatementLimitValue() {
        Object object;
        block3: {
            object = null;
            try {
                Object object2 = this.getQCStatements();
                if (object2 == null) break block3;
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    Object object3 = (QcStatement)object2.next();
                    if (!(object3 instanceof QcKnown) || ((QcKnown)object3).getType() != QcStatements.QcEuLimitValue || (object3 = ((QcEuLimitValue)object3).getValue()) == null) continue;
                    object = object3;
                    break;
                }
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
        }
        return object;
    }

    public List<String> getQcStatementType() {
        List<String> list;
        block3: {
            list = null;
            try {
                Object object = this.getQCStatements();
                if (object == null) break block3;
                object = object.iterator();
                while (object.hasNext()) {
                    QcStatement qcStatement = (QcStatement)object.next();
                    if (!(qcStatement instanceof QcKnown) || ((QcKnown)qcStatement).getType() != QcStatements.QcType) continue;
                    list = ((QcType)qcStatement).getTypes();
                    break;
                }
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
        }
        return list;
    }

    public String getQcStatementRetention() {
        Object object;
        block3: {
            object = null;
            try {
                Object object2 = this.getQCStatements();
                if (object2 == null) break block3;
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    Object object3 = (QcStatement)object2.next();
                    if (!(object3 instanceof QcKnown) || ((QcKnown)object3).getType() != QcStatements.QcEuRetentionPeriod || (object3 = ((QcEuRetentionPeriod)object3).getValue()) == null) continue;
                    object = object3;
                    break;
                }
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
        }
        return object;
    }

    public List<PdsLocation> getQcPdsLocation() {
        List<PdsLocation> list;
        block3: {
            list = null;
            try {
                Object object = this.getQCStatements();
                if (object == null) break block3;
                object = object.iterator();
                while (object.hasNext()) {
                    QcStatement qcStatement = (QcStatement)object.next();
                    if (!(qcStatement instanceof QcKnown) || ((QcKnown)qcStatement).getType() != QcStatements.QcPDS) continue;
                    list = ((QcPDS)qcStatement).getPdsLocations();
                    break;
                }
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
        }
        return list;
    }

    public String getQcStatementSemanticIdentifier() {
        Object object;
        block3: {
            object = null;
            try {
                Object object2 = this.getQCStatements();
                if (object2 == null) break block3;
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    Object object3 = (QcStatement)object2.next();
                    if (!(object3 instanceof QcKnown) || ((QcKnown)object3).getType() != QcStatements.PkixQCSyntaxv2 || (object3 = ((PkixQCSyntaxv2)object3).getSemanticsIdentifier()) == null) continue;
                    object = object3;
                    break;
                }
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
        }
        return object;
    }

    public List<String> getQcStatementNameRegistrationAuthorities() {
        Object object;
        block3: {
            object = null;
            try {
                Object object2 = this.getQCStatements();
                if (object2 == null) break block3;
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    Object object3 = (QcStatement)object2.next();
                    if (!(object3 instanceof QcKnown) || ((QcKnown)object3).getType() != QcStatements.PkixQCSyntaxv2 || (object3 = ((PkixQCSyntaxv2)object3).getNameRegistrationAuthorities()) == null) continue;
                    object = object3;
                    break;
                }
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
        }
        return object;
    }

    public boolean isCompliant() {
        boolean bl;
        block3: {
            bl = false;
            try {
                Object object = this.getQCStatements();
                if (object == null) break block3;
                object = object.iterator();
                while (object.hasNext()) {
                    QcStatement qcStatement = (QcStatement)object.next();
                    if (!(qcStatement instanceof QcKnown) || ((QcKnown)qcStatement).getType() != QcStatements.QcEuCompliance) continue;
                    bl = true;
                    break;
                }
            }
            catch (CapiException capiException) {
                a.error(capiException.getMessage(), (Throwable)capiException);
            }
        }
        return bl;
    }

    public String getCaIssuer() throws CapiException {
        String string = null;
        try {
            Object object = this.h.getExtensionValue(Extension.authorityInfoAccess.getId());
            if (object == null) {
                return null;
            }
            object = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])object));
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(object.getOctets()));
            object = aSN1InputStream;
            AuthorityInformationAccess authorityInformationAccess = AuthorityInformationAccess.getInstance((Object)aSN1InputStream.readObject());
            object = authorityInformationAccess;
            AccessDescription[] accessDescriptionArray = authorityInformationAccess.getAccessDescriptions();
            for (int i = 0; i < accessDescriptionArray.length; ++i) {
                if (accessDescriptionArray[i] == null || !accessDescriptionArray[i].getAccessMethod().equals((ASN1Primitive)AccessDescription.id_ad_caIssuers)) continue;
                DERTaggedObject dERTaggedObject = (DERTaggedObject)object.getAccessDescriptions()[i].getAccessLocation().toASN1Primitive();
                dERTaggedObject = dERTaggedObject.getObjectParser(6, true).toASN1Primitive();
                string = dERTaggedObject.toString();
            }
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
        }
        return string;
    }

    public String getOcspUrl() throws CapiException {
        String string = null;
        try {
            Object object = this.h.getExtensionValue(Extension.authorityInfoAccess.getId());
            if (object == null) {
                return null;
            }
            object = ASN1OctetString.getInstance((Object)ASN1Primitive.fromByteArray((byte[])object));
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(object.getOctets()));
            object = aSN1InputStream;
            AuthorityInformationAccess authorityInformationAccess = AuthorityInformationAccess.getInstance((Object)aSN1InputStream.readObject());
            object = authorityInformationAccess;
            AccessDescription[] accessDescriptionArray = authorityInformationAccess.getAccessDescriptions();
            for (int i = 0; i < accessDescriptionArray.length; ++i) {
                if (accessDescriptionArray[i] == null || !accessDescriptionArray[i].getAccessMethod().equals((ASN1Primitive)AccessDescription.id_ad_ocsp)) continue;
                DERTaggedObject dERTaggedObject = (DERTaggedObject)object.getAccessDescriptions()[i].getAccessLocation().toASN1Primitive();
                dERTaggedObject = dERTaggedObject.getObjectParser(6, true).toASN1Primitive();
                string = dERTaggedObject.toString();
            }
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
        }
        return string;
    }

    public boolean isKeyLengthValid() {
        int n = this.getKeyLength();
        if (n < 2048) {
            Date date = this.getInternalCert().getNotBefore();
            return !Constants.DPCM_AGID_189_2017_DEADLINE.before(date);
        }
        return true;
    }

    public boolean hasValidNaturalPersonSemantic() {
        if (this.getQcStatementSemanticIdentifier() != null && this.getQcStatementSemanticIdentifier().equals("0.4.0.194121.1.1")) {
            List<String> list = this.getQcStatementNameRegistrationAuthorities();
            boolean bl = false;
            try {
                String[] stringArray = this.getIssuerDNAttribute(X509ObjectIdentifiers.countryName.getId());
                String[] stringArray2 = this.getIssuerDNAttribute("2.5.4.5");
                String[] stringArray3 = this.getIssuerDNAttribute(X509ObjectIdentifiers.commonName.getId());
                String[] stringArray4 = null;
                String[] stringArray5 = null;
                String[] stringArray6 = null;
                try {
                    stringArray4 = this.getIssuerDNAttribute("2.5.4.42");
                }
                catch (CapiException capiException) {}
                try {
                    stringArray5 = this.getIssuerDNAttribute("2.5.4.4");
                }
                catch (CapiException capiException) {}
                try {
                    stringArray6 = this.getIssuerDNAttribute("2.5.4.65");
                }
                catch (CapiException capiException) {}
                if (stringArray != null && stringArray.length == 1 && stringArray2 != null && stringArray2.length == 1 && stringArray3 != null && stringArray3.length == 1 && (stringArray4 != null && stringArray4.length == 1 && stringArray5 != null && stringArray5.length == 1 || stringArray6 != null && stringArray6.length == 1)) {
                    String string = stringArray2[0];
                    bl = string != null && string.length() > 6 && string.charAt(5) == '-' && (string.toUpperCase().startsWith("PAS") || string.toUpperCase().startsWith("IDC") || string.toUpperCase().startsWith("PNO") || string.toUpperCase().startsWith("VAT") || string.toUpperCase().startsWith("TIN") || string.charAt(2) == ':' && list != null && list.size() > 0 && list.get(0) != null);
                }
            }
            catch (CapiException capiException) {
                bl = false;
            }
            return bl;
        }
        return true;
    }

    public boolean hasValidLegalPersonSemantic() {
        if (this.getQcStatementSemanticIdentifier() != null && this.getQcStatementSemanticIdentifier().equals("0.4.0.194121.1.2")) {
            List<String> list = this.getQcStatementNameRegistrationAuthorities();
            boolean bl = false;
            try {
                String[] stringArray = this.getIssuerDNAttribute(X509ObjectIdentifiers.countryName.getId());
                String[] stringArray2 = this.getIssuerDNAttribute(X509ObjectIdentifiers.organization.getId());
                String[] stringArray3 = this.getIssuerDNAttribute(X509ObjectIdentifiers.commonName.getId());
                String[] stringArray4 = this.getIssuerDNAttribute("2.5.4.97");
                if (stringArray != null && stringArray.length == 1 && stringArray2 != null && stringArray2.length == 1 && stringArray3 != null && stringArray3.length == 1 && stringArray4 != null && stringArray4.length == 1) {
                    String string = stringArray4[0];
                    bl = string != null && string.length() > 6 && string.charAt(5) == '-' && (string.toUpperCase().startsWith("VAT") || string.toUpperCase().startsWith("NTR") || string.charAt(2) == ':' && list != null && list.size() > 0 && list.get(0) != null);
                }
            }
            catch (CapiException capiException) {
                bl = false;
            }
            return bl;
        }
        return true;
    }

    public int getKeyLength() {
        int n = -1;
        PublicKey publicKey = this.getPublicKey();
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            n = rSAPublicKey.getModulus().bitLength();
        } else if (publicKey instanceof JCEECPublicKey) {
            JCEECPublicKey jCEECPublicKey = (JCEECPublicKey)publicKey;
            n = (jCEECPublicKey = jCEECPublicKey.getParameters()) != null ? jCEECPublicKey.getN().bitLength() : 0;
        } else if (publicKey instanceof ECPublicKey) {
            Object object = (ECPublicKey)publicKey;
            n = (object = object.getParams()) != null ? ((ECParameterSpec)object).getOrder().bitLength() : 0;
        } else if (publicKey instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
            n = dSAPublicKey.getParams() != null ? dSAPublicKey.getParams().getP().bitLength() : dSAPublicKey.getY().bitLength();
        }
        return n;
    }

    public boolean issuedAfterSPIDAuthentication() throws CapiException {
        if (this.j != null) {
            if (this.g) {
                a.debug("issuedAfterSPIDAuthentication() returning: {}", (Object)this.j);
            }
            return this.j;
        }
        this.j = Boolean.FALSE;
        if (this.g) {
            a.debug("issuedAfterSPIDAuthentication ?");
        }
        String string = "1.3.76.16.5";
        String[] stringArray = this.getPolicies(';');
        int n = 0;
        while (!this.i.booleanValue()) {
            String[] stringArray2 = stringArray[n].split(";");
            String[] stringArray3 = stringArray2;
            stringArray3 = stringArray2;
            int n2 = stringArray2.length;
            for (int i = 0; i < n2; ++i) {
                String string2 = stringArray3[i];
                if (!string.equals(string2)) continue;
                if (this.g) {
                    a.debug("Certificate is issuedAfterSPIDAuthentication.");
                }
                this.i = Boolean.TRUE;
            }
            ++n;
        }
        return this.i;
    }

    public boolean isCIEAuthentication() throws CapiException {
        int n;
        String[] stringArray;
        if (this.k != null) {
            if (this.g) {
                a.debug("isCIEAuthentication() returning: {}", (Object)this.k);
            }
            return this.k;
        }
        this.k = Boolean.FALSE;
        if (this.g) {
            a.debug("isCIEAuthentication ?");
        }
        if (!this.isCritical(6)) {
            if (this.g) {
                a.debug("Key Usage is not a critical extension");
            }
            return false;
        }
        int n2 = this.getKeyUsage();
        if (this.g) {
            a.debug("Key Usage: {}", (Object)n2);
        }
        if ((n2 & 1) <= 0) {
            if (this.g) {
                a.debug("Key Usage has not digitalSignature set");
            }
            return false;
        }
        if ((n2 & 0x62) > 0) {
            if (this.g) {
                a.debug("Key Usage has set cRLSign or keyCertSign or nonRepudiation");
            }
            return false;
        }
        if (this.g) {
            a.debug("Key Usage is ok.");
        }
        if ((stringArray = this.getExtendedKeyUsage()) == null || stringArray.length == 0) {
            if (this.g) {
                a.debug("Extended Key Usage not found");
            }
            return false;
        }
        if (this.isCritical(30)) {
            if (this.g) {
                a.debug("Extended Key Usage is a critical extension");
            }
            return false;
        }
        for (n = 0; n < stringArray.length; ++n) {
            a.info(n + ":" + stringArray[n]);
        }
        n = 0;
        String[] stringArray2 = "1.3.6.1.5.5.7.3.2";
        if (this.g) {
            a.debug("Searching tsl www client authentication {}", (Object)stringArray2);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray2.equals(stringArray[i])) continue;
            if (this.g) {
                a.debug("found tsl www client authentication  ");
            }
            n = 1;
            break;
        }
        if (n == 0) {
            if (this.g) {
                a.debug("tsl www client authentication not in Extended Key Usage");
            }
            return false;
        }
        String string = null;
        boolean bl = false;
        n = 0;
        stringArray2 = this.getPolicies(';');
        if (stringArray2 == null || stringArray2.length <= 0) {
            if (this.g) {
                a.debug("Missing Certificate Policies extension");
            }
            return false;
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            int n3 = stringArray2[i].indexOf("CPS URI: ");
            if (n3 >= 0) {
                string = stringArray2[i].substring(n3 + 9);
                if (string.indexOf(";") >= 4) {
                    string = string.substring(0, string.indexOf(";"));
                }
                if (this.g) {
                    a.debug("found CPS URI: {}", (Object)string);
                }
            }
            if ((n3 = stringArray2[i].indexOf("displayText: ")) >= 0) {
                String string2 = stringArray2[i].substring(n3 + 13);
                if (string2.indexOf(";") >= 2) {
                    string2 = string2.substring(0, string2.indexOf(";"));
                }
                if (this.g) {
                    a.debug("found displayText: {}", (Object)string2);
                }
                String string3 = "X.509 authentication certificate issued by the Italian Ministry of Interior for the Electronic Identity Card";
                if (string2.trim().toLowerCase().startsWith(string3.toLowerCase())) {
                    bl = true;
                }
            }
            if (!Certificate.isPolicyIncluded(stringArray2[i], e)) continue;
            if (this.g) {
                a.debug("found valid CNS Policy object id");
            }
            n = 1;
        }
        if (string == null) {
            if (this.g) {
                a.debug("Missing CPS URI in Certificate Policies extension");
            }
            return false;
        }
        if (!bl) {
            if (this.g) {
                a.debug("Missing CIE Usage in Display Text of Certificate Policies extension");
            }
            return false;
        }
        if (n == 0) {
            if (this.g) {
                a.debug("Missing valid OID in Certificate Policies extension");
            }
            return false;
        }
        String[] stringArray3 = this.getCdpURLs();
        if (stringArray3 == null || stringArray3.length == 0) {
            if (this.g) {
                a.debug("Missing CRL Distribution Point extension");
            }
            return false;
        }
        if (this.getAuthorityKeyIdentifier() == null) {
            if (this.g) {
                a.debug("Missing Authority Key Identifier extension");
            }
            return false;
        }
        if (this.getSubjectKeyIdentifier() == null) {
            if (this.g) {
                a.debug("Missing Subject Key Identifier extension");
            }
            return false;
        }
        if (this.g) {
            a.debug("Certificate is CIEAuthentication.");
        }
        this.k = Boolean.TRUE;
        return true;
    }

    public boolean isWebSiteAuthentication() {
        List<String> list = this.getQcStatementType();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (!list.get(i).equals("0.4.0.1862.1.6.3")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isElectronicSeal() {
        List<String> list = this.getQcStatementType();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (!list.get(i).equals("0.4.0.1862.1.6.2")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isElectronicSignature() {
        List<String> list = this.getQcStatementType();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (!list.get(i).equals("0.4.0.1862.1.6.1")) continue;
                return true;
            }
        }
        return false;
    }

    public CertDBItem[] getValidatedChain() {
        return this.f;
    }

    public void setValidatedChain(CertDBItem[] certDBItemArray) {
        this.f = certDBItemArray;
    }

    public boolean isSmartLogonCertificate() {
        if (!this.a()) {
            a.debug("User Principal Name not found");
            return false;
        }
        if (!this.b()) {
            a.debug("Smartcard logon extended key usage not found");
            return false;
        }
        if (!this.c()) {
            a.debug("Digital signature key usage not found");
            return false;
        }
        return true;
    }

    private boolean a() {
        try {
            String[] stringArray = this.getSubjectAltName();
            String[] stringArray2 = stringArray;
            stringArray2 = stringArray;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray2[i];
                if (!string.contains("1.3.6.1.4.1.311.20.2.3")) continue;
                return true;
            }
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
        }
        return false;
    }

    private boolean b() {
        try {
            String[] stringArray = this.getExtendedKeyUsage();
            String[] stringArray2 = stringArray;
            stringArray2 = stringArray;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray2[i];
                if (!string.equals("1.3.6.1.4.1.311.20.2.2")) continue;
                return true;
            }
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
        }
        return false;
    }

    private boolean c() {
        try {
            boolean[] blArray = this.h.getKeyUsage();
            if (blArray == null || blArray.length == 0) {
                return false;
            }
            return blArray[0];
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    static {
        d = new ArrayList<String>();
        d.add("1.3.76.16.2.1");
        d.add("1.3.159.6.1.3.2.10");
        d.add("1.3.76.12.1.1.10.2.2.10");
        e = new ArrayList<String>();
        e.add("1.3.76.47.4");
        l = new Hashtable();
        m = new Hashtable();
        n = new Hashtable();
        o = new Hashtable();
        l.put("2.5.4.13", "Description");
        l.put("2.5.4.46", "dnQualifier");
        l.put("2.5.4.12", "title");
        l.put("2.5.4.4", "surname");
        n.put("country", BCStyle.C);
        n.put("commonname", BCStyle.CN);
        n.put("countryofresidence", BCStyle.COUNTRY_OF_RESIDENCE);
        n.put("dateofbirth", BCStyle.DATE_OF_BIRTH);
        n.put("description", new ASN1ObjectIdentifier("2.5.4.13"));
        n.put("domaincomponent", BCStyle.DC);
        n.put("dnqualifier", BCStyle.DN_QUALIFIER);
        n.put("emailaddress", BCStyle.EmailAddress);
        n.put("gender", BCStyle.GENDER);
        n.put("generationqualifier", BCStyle.GENERATION);
        n.put("givenname", BCStyle.GIVENNAME);
        n.put("initials", BCStyle.INITIALS);
        n.put("locality", BCStyle.L);
        n.put("nameatbirth", BCStyle.NAME_AT_BIRTH);
        n.put("organization", BCStyle.O);
        n.put("organizationalunit", BCStyle.OU);
        n.put("placeofbirth ", BCStyle.PLACE_OF_BIRTH);
        n.put("pseudonym", BCStyle.PSEUDONYM);
        n.put("surname", BCStyle.SURNAME);
        n.put("street", BCStyle.STREET);
        n.put("title", BCStyle.T);
        n.put("serialnumber", BCStyle.SERIALNUMBER);
        n.put("stateorprovince", BCStyle.ST);
        m.put(4, "directoryName");
        m.put(2, "dNSName");
        m.put(5, "ediPartyName");
        m.put(7, "iPAddress");
        m.put(0, "otherName");
        m.put(8, "registeredID");
        m.put(1, "rfc822Name");
        m.put(6, "uniformResourceIdentifier");
        m.put(3, "x400Address");
        o.put(KeyPurposeId.id_kp_serverAuth.getId(), "TLS Web server Server authentication");
        o.put(KeyPurposeId.id_kp_clientAuth.getId(), "TLS Web client authentication");
        o.put(KeyPurposeId.id_kp_codeSigning.getId(), "Code signing");
        o.put(KeyPurposeId.id_kp_emailProtection.getId(), "E-mail protection");
        o.put(KeyPurposeId.id_kp_timeStamping.getId(), "Timestamping");
        o.put(KeyPurposeId.id_kp_OCSPSigning.getId(), "OCSPsigning");
        o.put(KeyPurposeId.id_kp_smartcardlogon.getId(), "SmartCardLogon");
        try {
            b = CertificateFactory.getInstance("X.509", (Provider)new BouncyCastleProvider());
        }
        catch (CertificateException certificateException) {
            a.error(certificateException.getMessage(), (Throwable)certificateException);
        }
        try {
            c = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            a.error(certificateException.getMessage(), (Throwable)certificateException);
        }
    }
}

