/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.MultipleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.core.qc.PdsLocation;
import java.util.LinkedList;
import java.util.List;

public class StepX509QcPDS
extends MultipleValidationSubStepImpl {
    public StepX509QcPDS() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected List<ValidatorMessage> innerChecks(LinkedList<ValidatorMessage> linkedList, ValidationContextParameters validationContextParameters) {
        List<PdsLocation> list;
        linkedList = new LinkedList();
        if (validationContextParameters != null && validationContextParameters.getSignerCertificate() != null && validationContextParameters.getSignerCertificate().getCert() != null && (list = validationContextParameters.getSignerCertificate().getCert().getQcPdsLocation()) != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).getUrl() == null || list.get(i).getLanguage() == null) continue;
                linkedList.add(new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IC0007_CERT_PDS, list.get(i).getLanguage(), list.get(i).getUrl()));
            }
        }
        return linkedList;
    }
}

