/*
 * Decompiled with CFR 0.152.
 */
package qtq.mrh;

import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class chtxkhuk<K, V> {
    private final LinkedHashMap<K, V> map;
    private int size;
    private int maxSize;
    private int putCount;
    private int createCount;
    private int evictionCount;
    private int hitCount;
    private int missCount;

    public chtxkhuk(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.maxSize = n;
        this.map = new LinkedHashMap(0, 0.75f, true);
    }

    public final synchronized V get(K k) {
        if (k == null) {
            throw new NullPointerException("key == null");
        }
        V v = this.map.get(k);
        if (v != null) {
            ++this.hitCount;
            return v;
        }
        ++this.missCount;
        v = this.create(k);
        if (v != null) {
            ++this.createCount;
            this.size += this.safeSizeOf(k, v);
            this.map.put(k, v);
            this.trimToSize(this.maxSize);
        }
        return v;
    }

    public final synchronized void put(K k, V v) {
        if (k == null || v == null) {
            throw new NullPointerException("key == null || value == null");
        }
        ++this.putCount;
        this.size += this.safeSizeOf(k, v);
        V v2 = this.map.put(k, v);
        if (v2 != null) {
            this.size -= this.safeSizeOf(k, v2);
        }
        this.trimToSize(this.maxSize);
    }

    private void trimToSize(int n) {
        Map.Entry<K, V> entry;
        while (this.size > n && !this.map.isEmpty() && (entry = this.map.entrySet().iterator().next()) != null) {
            K k = entry.getKey();
            V v = entry.getValue();
            this.map.remove(k);
            this.size -= this.safeSizeOf(k, v);
            ++this.evictionCount;
            this.entryEvicted(k, v);
        }
        if (this.size < 0 || this.map.isEmpty() && this.size != 0) {
            throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
        }
    }

    public final synchronized V remove(K k) {
        if (k == null) {
            throw new NullPointerException("key == null");
        }
        Object v = this.map.remove(k);
        if (v != null) {
            this.size -= this.safeSizeOf(k, v);
        }
        return v;
    }

    protected void entryEvicted(K k, V v) {
    }

    protected V create(K k) {
        return null;
    }

    private int safeSizeOf(K k, V v) {
        int n = this.sizeOf(k, v);
        if (n < 0) {
            throw new IllegalStateException("Negative size: " + k + "=" + v);
        }
        return n;
    }

    protected int sizeOf(K k, V v) {
        return 1;
    }

    public final synchronized void evictAll() {
        this.trimToSize(-1);
    }

    public final synchronized int size() {
        return this.size;
    }

    public final synchronized int maxSize() {
        return this.maxSize;
    }

    public final synchronized int hitCount() {
        return this.hitCount;
    }

    public final synchronized int missCount() {
        return this.missCount;
    }

    public final synchronized int createCount() {
        return this.createCount;
    }

    public final synchronized int putCount() {
        return this.putCount;
    }

    public final synchronized int evictionCount() {
        return this.evictionCount;
    }

    public final synchronized Map<K, V> snapshot() {
        return new LinkedHashMap<K, V>(this.map);
    }
}

