/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.dom;

import esecurity.desktop.JsUtils;
import esecurity.desktop.View;
import esecurity.desktop.dom.DOMElement;

public class Checkbox
extends DOMElement {
    public Checkbox(String id, View view, boolean create) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        if (create) {
            Checkbox.createElementWithID("input", id, view);
            this.setAttribute("type", "checkbox");
        }
    }

    public Checkbox(String id, String parentId, View view) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.createElementWithIDAndAppendIt("input", id, parentId);
        this.setAttribute("type", "checkbox");
    }

    public Checkbox(String id, DOMElement parent, View view) {
        super(new StringBuilder(id.length() + 29).append("document.getElementById(\"").append(JsUtils.escapeJs(id)).append("\")"), view, id);
        this.createElementWithIDAndAppendIt("input", id, parent.getId());
        this.setAttribute("type", "checkbox");
    }

    @Override
    public void setDisable(boolean disable) {
        this.view.execute(new StringBuilder(this.jsToEvaluateElement.length() + 21).append((CharSequence)this.jsToEvaluateElement).append(".disabled = \"").append(disable ? "true" : "false").append("\"").toString());
    }

    public void check(boolean fireEvent) {
        if (fireEvent) {
            this.view.execute(new StringBuilder(this.id.length() + 73).append("var ch=document.getElementById(\"").append(JsUtils.escapeJs(this.id)).append("\");if(ch.checked===false){ch.click();}").toString());
        } else {
            this.view.execute(new StringBuilder(this.id.length() + 50).append("var ch=document.getElementById(\"").append(JsUtils.escapeJs(this.id)).append("\").checked=true;").toString());
        }
    }

    public void uncheck(boolean fireEvent) {
        if (fireEvent) {
            this.view.execute(new StringBuilder(this.id.length() + 66).append("var ch = document.getElementById(\"").append(JsUtils.escapeJs(this.id)).append("\");if(ch.checked){ch.click();}").toString());
        } else {
            this.view.execute(new StringBuilder(this.id.length() + 55).append("var ch = document.getElementById(\"").append(JsUtils.escapeJs(this.id)).append("\").checked = false;").toString());
        }
    }

    public boolean isChecked() {
        StringBuilder evaluateJsElement = new StringBuilder(this.id.length() + 37).append("document.getElementById(\"").append(JsUtils.escapeJs(this.id)).append("\").checked");
        Boolean ret = Boolean.FALSE;
        try {
            ret = (Boolean)this.view.evaluate(new StringBuilder(evaluateJsElement.length() * 3 + 39).append("return (").append((CharSequence)evaluateJsElement).append("!=null&&").append((CharSequence)evaluateJsElement).append("!=undefined&&").append((CharSequence)evaluateJsElement).append("!==false);").toString());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return ret == null ? false : ret;
    }

    public static Checkbox retrieveCheckbox(String id, View currentView) {
        if (Checkbox.exist(id, currentView)) {
            return new Checkbox(id, currentView, false);
        }
        return null;
    }
}

