/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.jna.win;

import com.github.markusbernhardt.proxy.jna.win.WTypes2;
import com.github.markusbernhardt.proxy.jna.win.WinHttp;
import com.github.markusbernhardt.proxy.util.Logger;
import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.win32.W32APIOptions;
import java.util.Map;

public class WinHttpHelpers {
    public static final WinHttp WINHTTP_INSTANCE = (WinHttp)Native.load((String)"winhttp", WinHttp.class, (Map)W32APIOptions.UNICODE_OPTIONS);
    private static final int ERROR_WINHTTP_AUTODETECTION_FAILED = 12180;

    private WinHttpHelpers() {
    }

    public static String detectAutoProxyConfigUrl(WinDef.DWORD dwAutoDetectFlags) {
        WTypes2.LPWSTRByReference ppwszAutoConfigUrl = new WTypes2.LPWSTRByReference();
        boolean result = false;
        try {
            result = WINHTTP_INSTANCE.WinHttpDetectAutoProxyConfigUrl(dwAutoDetectFlags, ppwszAutoConfigUrl);
        }
        catch (LastErrorException ex) {
            if (ex.getErrorCode() == 12180) {
                return null;
            }
            Logger.log(WinHttpHelpers.class, Logger.LogLevel.ERROR, "Windows function WinHttpDetectAutoProxyConfigUrl returned error : {}", ex.getMessage());
            return null;
        }
        if (result) {
            return ppwszAutoConfigUrl.getString();
        }
        return null;
    }

    private String sanitizeUrl(String urlStr) {
        String u = urlStr.trim();
        int pos = u.indexOf(10);
        if (pos == 0) {
            return "";
        }
        if (pos > 0) {
            return u.substring(0, pos);
        }
        return u;
    }
}

