/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.pkcs7;

import esecurity.dts.Client;
import esecurity.dts.DTSClient;
import esecurity.dts.TimeStampToken;
import esecurity.dts.util.IllegalParamException;
import esecurity.validator.parser.utils.DerParserUtils;
import it.actalis.ellips.capi.cms.CadesSignedDataProxy;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.HttpsClient;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.net.HTTP_URLConnection;
import it.actalis.ellips.capi.pkcs7.CapiSignerInformation;
import it.actalis.ellips.capi.pkcs7.CounterSignedEnvelope;
import it.actalis.ellips.capi.pkcs7.RFC5652.CheckSignerInformation;
import it.actalis.ellips.capi.pkcs7.RFC5652.VerificationResult;
import it.actalis.ellips.capi.pkcs7.SignedEnvelopeUtils;
import it.actalis.ellips.capi.pkcs7.VerRsContentSignerBuilder;
import it.actalis.ellips.capi.pkcs7.VerifyInfo;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX500NameUtil;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.CMSAbsentContent;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.DefaultCMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;
import org.bouncycastle.cms.bc.BcRSASignerInfoVerifierBuilder;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;

public class SignedEnvelope {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final int IMPLICIT = 1;
    public static final int EXPLICIT = 2;
    public static final int TYPEDATA = 1;
    public static final int TYPEDIGEST = 2;
    public static final String SHA1 = CMSSignedDataGenerator.DIGEST_SHA1;
    public static final String SHA256 = CMSSignedDataGenerator.DIGEST_SHA256;
    protected CMSSignedData pkcs7SignedData = null;
    private MessageDigest b = null;
    private MessageDigest c = null;
    private String d = SHA256;
    private byte[] e = null;
    private int f = 0;
    private List<String> g = new LinkedList<String>();
    private List<it.actalis.ellips.capi.core.Certificate> h = new LinkedList<it.actalis.ellips.capi.core.Certificate>();
    private List<VerifyInfo> i = new LinkedList<VerifyInfo>();
    protected List<X509Certificate> certsVector = new LinkedList<X509Certificate>();
    private int j = -1;
    private int k = 1;
    protected boolean isCounterSignedEnv = false;
    private String l = null;
    private String m = null;
    private String n = null;
    private boolean o = true;
    private HttpsClient p = null;
    private String q = null;
    private String r = null;
    private DTSClient s = null;
    private boolean t = true;
    private static boolean u = false;

    public SignedEnvelope(byte[] byArray) throws CapiException {
        this.k = 1;
        this.j = 3;
        if (byArray == null) {
            throw new CapiException("Null data", 1001);
        }
        this.a();
        try {
            this.pkcs7SignedData = new CMSSignedData((InputStream)new ByteArrayInputStream(byArray));
            a.debug("DER format");
        }
        catch (CMSException cMSException) {
            this.a(byArray);
        }
        if (this.pkcs7SignedData == null) {
            a.debug("null pkcs7SignedData");
            throw new CapiException("Internal error", 50050);
        }
        a.debug("signed data ok");
        this.b(null);
    }

    public SignedEnvelope(byte[] object, boolean bl) throws CapiException {
        this.k = 1;
        this.j = 3;
        u = bl;
        try {
            if (object == null) {
                throw new CapiException("Null data", 1001);
            }
            this.a();
            try {
                this.pkcs7SignedData = new CMSSignedData((InputStream)new ByteArrayInputStream((byte[])object));
                a.debug("DER format");
            }
            catch (CMSException cMSException) {
                this.a((byte[])object);
            }
            if (this.pkcs7SignedData == null) {
                a.debug("null pkcs7SignedData");
                throw new CapiException("Internal error", 50050);
            }
            a.debug("signed data ok");
            this.b(null);
            return;
        }
        catch (CapiException capiException) {
            object = (Object)capiException;
            throw capiException;
        }
        finally {
            u = false;
        }
    }

    private void a() throws CapiException {
        try {
            this.b = MessageDigest.getInstance(Constants.SHA1, ProvUtils.bcProvider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            a.debug(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
            throw new CapiException("SHA1 Digest Algorithm not available", 50050);
        }
        try {
            this.c = MessageDigest.getInstance(Constants.SHA256, ProvUtils.bcProvider);
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            a.debug(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
            throw new CapiException("SHA256 Digest Algorithm not available", 50050);
        }
    }

    private void a(byte[] object) throws CapiException {
        try {
            a.debug("trying Base64 decode ... ");
            byte[] byArray = Util.base64Decode((byte[])object);
            this.pkcs7SignedData = new CMSSignedData((InputStream)new ByteArrayInputStream(byArray));
            return;
        }
        catch (Exception exception) {
            object = new PEMParser((Reader)new StringReader(new String((byte[])object)));
            try {
                a.debug("not Base64, trying PEM Tagged format  ... ");
                ContentInfo contentInfo = (ContentInfo)object.readObject();
                object = contentInfo;
                if (contentInfo == null) {
                    throw new CapiException("Envelope format unknown or not implemented", 50021);
                }
                if (!object.getContentType().equals((ASN1Primitive)PKCSObjectIdentifiers.signedData)) {
                    throw new CapiException("Not a valid PKCS#7 signed-data object - wrong header " + object.getContentType().getId(), 50021);
                }
                this.pkcs7SignedData = new CMSSignedData((ContentInfo)object);
                return;
            }
            catch (Exception exception2) {
                a.debug(exception.getMessage(), (Throwable)exception2);
                throw new CapiException("Envelope format unknown or not implemented", 50021);
            }
        }
    }

    protected static void verifySigners(Store store, List<SignerInformation> list, List<String> list2, List<it.actalis.ellips.capi.core.Certificate> list3, List<VerifyInfo> list4) throws CapiException {
        SignedEnvelope.verifySigners(store, list, list2, list3, list4, null);
    }

    protected static void verifySigners(Store store, List<SignerInformation> list, List<String> list2, List<it.actalis.ellips.capi.core.Certificate> list3, List<VerifyInfo> list4, CadesSignedDataProxy cadesSignedDataProxy) throws CapiException {
        for (int i = 0; i < list.size(); ++i) {
            try {
                SignerInformation signerInformation = list.get(i);
                SignedEnvelope.verifySigner(signerInformation, store, list2, list3, list4, cadesSignedDataProxy);
                continue;
            }
            catch (Exception exception) {
                throw new CapiException(exception.getMessage(), 50050);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void verifySigner(SignerInformation object, Store store, List<String> list, List<it.actalis.ellips.capi.core.Certificate> list2, List<VerifyInfo> list3, CadesSignedDataProxy cadesSignedDataProxy) throws Exception {
        Object object2;
        Object object3 = null;
        try {
            object3 = object.getSID();
            object2 = object3.getSubjectKeyIdentifier();
            if (object2 != null) {
                a.debug("signerInfo has SubjectKeyIdentifier");
            } else {
                a.debug("signerInfo has IssuerAndSerialNumber");
            }
        }
        catch (Exception exception) {
            a.debug("Cannot validate signature: Exception " + exception.getMessage());
            a.debug(exception.getMessage(), (Throwable)exception);
            list3.add(new VerifyInfo(false, VerifyInfo.FailureReason.MISSING_SIGNER_CERT));
        }
        Collection collection = store.getMatches((Selector)object3);
        object2 = collection;
        if (collection.size() <= 0) {
            a.debug("Signer certificate not found. Cannot validate signature");
            list.add(null);
            list2.add(null);
            list3.add(new VerifyInfo(false, VerifyInfo.FailureReason.MISSING_SIGNER_CERT));
            return;
        }
        try {
            store = (X509CertificateHolder)object2.iterator().next();
            object3 = new it.actalis.ellips.capi.core.Certificate(store.getEncoded());
            object2 = object3.getSubjectDN();
            list.add((String)object2);
            list2.add((it.actalis.ellips.capi.core.Certificate)object3);
            a.debug("Found signer certificate: " + (String)object2);
            boolean bl = false;
            boolean bl2 = false;
            object2 = object.getSignedAttributes();
            if (object2 != null) {
                object2 = SignedEnvelopeUtils.getSignignCertificateV1((SignerInformation)object);
                if (object2 != null) {
                    a.debug("Validating the first ESSCertID ...");
                    try {
                        DerParserUtils.validateESSCertID((ESSCertID)object2, (X509Certificate)object3.getInternalCert());
                    }
                    catch (Exception exception) {
                        list3.add(new VerifyInfo(false, VerifyInfo.FailureReason.INVALID_SIGNING_CERTIFICATE_AUTH_ATTRIBUTE));
                        return;
                    }
                    bl = true;
                    a.debug("ESSCertID V1 successfully validated.");
                } else {
                    try {
                        bl2 = SignedEnvelope.hasSigningCertificateV2((SignerInformation)object, object3.getInternalCert());
                    }
                    catch (Exception exception) {
                        list3.add(new VerifyInfo(false, VerifyInfo.FailureReason.INVALID_SIGNING_CERTIFICATE_AUTH_ATTRIBUTE));
                        return;
                    }
                }
                store = new JcaSimpleSignerInfoVerifierBuilder().setProvider(ProvUtils.bcProvider).build((X509CertificateHolder)store);
                object3 = null;
                try {
                    object3 = CheckSignerInformation.customVerify((SignerInformationVerifier)store, (SignerInformation)object, cadesSignedDataProxy);
                }
                catch (CMSException cMSException) {
                    a.error(cMSException.getMessage(), (Throwable)cMSException);
                }
                if (((VerificationResult)object3).isRelaxedValid()) {
                    a.debug("Valid signature");
                    object = new VerifyInfo(true);
                } else {
                    a.debug("Invalid signature");
                    object = new VerifyInfo(false, VerifyInfo.FailureReason.WRONG_SIGNATURE);
                }
                if (bl2) {
                    ((VerifyInfo)object).a(bl2);
                } else if (bl) {
                    ((VerifyInfo)object).d();
                }
                if (!((VerificationResult)object3).isDerEncodedSignedAttributes()) {
                    a.warn("Valid signature, but signed attributes not DER encoded");
                    ((VerifyInfo)object).setRFC5652_SignedAttrDER(false);
                }
                if (!((VerificationResult)object3).isValidSigningTime()) {
                    a.warn("Valid signature, but signing time is not included in the certificate validity period");
                    ((VerifyInfo)object).setValidSigningTime(false);
                }
                ((VerifyInfo)object).setVerificationResult((VerificationResult)object3);
                list3.add((VerifyInfo)object);
                return;
            }
            a.debug("No signed attribute table found.");
            if (u) {
                a.debug("No signed attribute table found. Using BcRSASignerInfoVerifierBuilder ...");
                object2 = new BcRSASignerInfoVerifierBuilder((CMSSignatureAlgorithmNameGenerator)new DefaultCMSSignatureAlgorithmNameGenerator(), (SignatureAlgorithmIdentifierFinder)new DefaultSignatureAlgorithmIdentifierFinder(), (DigestAlgorithmIdentifierFinder)new DefaultDigestAlgorithmIdentifierFinder(), (DigestCalculatorProvider)new BcDigestCalculatorProvider());
                store = object2.build((X509CertificateHolder)store);
                if (object.verify((SignerInformationVerifier)store)) {
                    list3.add(new VerifyInfo(true));
                    a.debug("Valid signature");
                    return;
                }
                list3.add(new VerifyInfo(false, VerifyInfo.FailureReason.WRONG_SIGNATURE));
                a.debug("Invalid signature");
                return;
            }
            if (object.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(ProvUtils.bcProvider).build((X509CertificateHolder)store))) {
                list3.add(new VerifyInfo(true));
                a.debug("Valid signature");
                return;
            }
            list3.add(new VerifyInfo(false, VerifyInfo.FailureReason.WRONG_SIGNATURE));
            a.debug("Invalid signature");
            return;
        }
        catch (Exception exception) {
            a.debug("Cannot validate signature: Exception " + exception.getMessage());
            a.debug(exception.getMessage(), (Throwable)exception);
            list3.add(new VerifyInfo(false, VerifyInfo.FailureReason.MISSING_SIGNER_CERT));
            return;
        }
    }

    private void b(byte[] object) throws CapiException {
        Object object2;
        if (object == null) {
            a.debug("setting encapsulated content data...");
            try {
                this.e = (byte[])this.pkcs7SignedData.getSignedContent().getContent();
            }
            catch (Exception exception) {
                a.debug(exception.getMessage(), (Throwable)exception);
                throw new CapiException("No data found into encrypted envelope", 50000);
            }
        } else {
            a.debug("setting detached content data...");
            this.e = object;
        }
        a.debug("getting certificates...");
        try {
            object = this.pkcs7SignedData.getCertificates();
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Exception " + exception.getMessage(), 50050);
        }
        try {
            if (object == null) {
                a.debug("no certificates found!");
            }
            object2 = it.actalis.ellips.capi.core.Certificate.getX509CertificatesFromStore((Store)object);
            this.certsVector = new Vector<X509Certificate>(Arrays.asList(object2));
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("StoreException", 50050);
        }
        a.debug(this.certsVector.size() + " certificates found");
        a.debug("getting signers DN...");
        this.g = new Vector<String>();
        this.h = new LinkedList<it.actalis.ellips.capi.core.Certificate>();
        this.i = new LinkedList<VerifyInfo>();
        object2 = this.pkcs7SignedData.getSignerInfos();
        ArrayList<CapiSignerInformation> arrayList = new ArrayList<CapiSignerInformation>();
        for (SignerInformation signerInformation : object2.getSigners()) {
            arrayList.add(new CapiSignerInformation(signerInformation, this.pkcs7SignedData.getSignedContent()));
        }
        object2 = new Vector(arrayList);
        a.debug("signerInformVector size = " + ((Vector)object2).size());
        SignedEnvelope.verifySigners((Store)object, (List<SignerInformation>)object2, this.g, this.h, this.i);
        a.debug("getting signers DN OK");
    }

    protected static boolean hasSigningCertificate(SignerInformation signerInformation, X509Certificate x509Certificate) throws CapiException {
        try {
            signerInformation = SignedEnvelopeUtils.getSignignCertificateV1(signerInformation);
            if (signerInformation == null) {
                return false;
            }
            a.debug("Validating the first ESSCertID ...");
            DerParserUtils.validateESSCertID((ESSCertID)signerInformation, (X509Certificate)x509Certificate);
        }
        catch (Exception exception) {
            throw new CapiException("Cannot parse ESSCertID", 3010);
        }
        a.debug("ESSCertID V1 successfully validated.");
        return true;
    }

    public static boolean hasNoSignedAttribute(SignerInformation signerInformation) throws Exception {
        if ((signerInformation = signerInformation.getSignedAttributes()) == null) {
            a.debug("No signed attribute table found.");
            return true;
        }
        return false;
    }

    protected static boolean hasSigningCertificateV2(SignerInformation signerInformation, X509Certificate x509Certificate) throws CapiException {
        return SignedEnvelope.getSigningCertificateV2HashAlg(signerInformation, x509Certificate) != null;
    }

    protected static String getSigningCertificateV2HashAlg(SignerInformation signerInformation, X509Certificate x509Certificate) throws CapiException {
        if ((signerInformation = SignedEnvelopeUtils.getSigningCertificateV2(signerInformation)) == null) {
            return null;
        }
        a.debug("Validating the first ESSCertID ...");
        DerParserUtils.validateESSCertID((ESSCertIDv2)signerInformation, (X509Certificate)x509Certificate);
        a.debug("ESSCertID V2 successfully validated.");
        return signerInformation.getHashAlgorithm().getAlgorithm().getId();
    }

    public SignedEnvelope(String string) throws CapiException {
        this.k = 1;
        this.j = 3;
        if (string == null) {
            throw new CapiException("Null data", 1001);
        }
        this.a();
        this.a(string.getBytes());
        if (this.pkcs7SignedData == null) {
            a.debug("null pkcs7SignedData");
            throw new CapiException("Internal error", 50050);
        }
        a.debug("signed data ok");
        this.b(null);
    }

    public SignedEnvelope(String object, byte[] byArray) throws CapiException {
        this.k = 2;
        this.j = 3;
        if (object == null || byArray == null) {
            throw new CapiException("Null data", 1001);
        }
        this.a();
        byte[] byArray2 = byArray;
        Object object2 = ((String)object).getBytes();
        object = this;
        try {
            a.debug("trying Base64 decode ... ");
            byte[] byArray3 = Util.base64Decode((byte[])object2);
            ((SignedEnvelope)object).pkcs7SignedData = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(byArray2), (InputStream)new ByteArrayInputStream(byArray3));
        }
        catch (Exception exception) {
            object2 = new PEMParser((Reader)new StringReader(new String((byte[])object2)));
            try {
                a.debug("not Base64, trying PEM Tagged format  ... ");
                ContentInfo contentInfo = (ContentInfo)object2.readObject();
                object2 = contentInfo;
                if (contentInfo == null) {
                    throw new CapiException("Envelope format unknown or not implemented", 50021);
                }
                if (!object2.getContentType().equals((ASN1Primitive)PKCSObjectIdentifiers.signedData)) {
                    throw new CapiException("Not a valid PKCS#7 signed-data object - wrong header " + object2.getContentType().getId(), 50021);
                }
                ((SignedEnvelope)object).pkcs7SignedData = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(byArray2), (ContentInfo)object2);
            }
            catch (Exception exception2) {
                a.debug(exception.getMessage(), (Throwable)exception2);
                throw new CapiException("Envelope format unknown or not implemented", 50021);
            }
        }
        if (this.pkcs7SignedData == null) {
            a.debug("null pkcs7SignedData");
            throw new CapiException("Internal error", 50050);
        }
        a.debug("signed data ok");
        this.b(byArray);
    }

    public String[] listSigners() {
        String[] stringArray = new String[this.g.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.g.get(i);
        }
        return stringArray;
    }

    public byte[] getData() {
        byte[] byArray = new byte[this.e.length];
        System.arraycopy(this.e, 0, byArray, 0, this.e.length);
        return byArray;
    }

    public int getDataType() {
        if (this.f == 0) {
            return 1;
        }
        return this.f;
    }

    public List<it.actalis.ellips.capi.core.Certificate> listCertificates() throws CapiException {
        try {
            LinkedList<it.actalis.ellips.capi.core.Certificate> linkedList = new LinkedList<it.actalis.ellips.capi.core.Certificate>();
            for (int i = 0; i < this.certsVector.size(); ++i) {
                X509Certificate x509Certificate = this.certsVector.get(i);
                x509Certificate = new it.actalis.ellips.capi.core.Certificate(x509Certificate);
                linkedList.add((it.actalis.ellips.capi.core.Certificate)x509Certificate);
            }
            return linkedList;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 50050);
        }
    }

    public it.actalis.ellips.capi.core.Certificate verify(int n) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed before", 50001);
        }
        if (n < 0 || n >= this.g.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.h.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.i.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        Boolean bl = this.i.get(n).a();
        if (bl.booleanValue()) {
            return this.h.get(n);
        }
        VerifyInfo verifyInfo = this.i.get(n);
        throw new CapiException("Invalid signature", 3010, verifyInfo.a.value());
    }

    public it.actalis.ellips.capi.core.Certificate getSignerCertificate(int n) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed before", 50001);
        }
        if (n < 0 || n >= this.g.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.h.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.i.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        return this.h.get(n);
    }

    public String getSignerDigestAlg(int n) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            Object object = this.pkcs7SignedData.getSignerInfos();
            object = object.getSigners();
            object = new Vector(object);
            if (n < 0 || n >= ((Vector)object).size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation signerInformation = (SignerInformation)((Vector)object).elementAt(n);
            a.debug("[getSignerDigestAlg] " + signerInformation.getDigestAlgOID());
            if (signerInformation.getDigestAlgOID().equalsIgnoreCase(SHA256)) {
                return Constants.SHA256;
            }
            if (signerInformation.getDigestAlgOID().equalsIgnoreCase(SHA1)) {
                return Constants.SHA1;
            }
            return signerInformation.getDigestAlgOID();
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Cannot get signer digest algorithm oid " + exception.getMessage(), 50023);
        }
    }

    public String getSignerDigestAlgOid(int n) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            Object object = this.pkcs7SignedData.getSignerInfos();
            object = object.getSigners();
            object = new Vector(object);
            if (n < 0 || n >= ((Vector)object).size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation signerInformation = (SignerInformation)((Vector)object).elementAt(n);
            a.debug("[getSignerDigestAlg] " + signerInformation.getDigestAlgOID());
            return signerInformation.getDigestAlgOID();
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Cannot get signer digest algorithm oid " + exception.getMessage(), 50023);
        }
    }

    public boolean hasSigningCertificateV2(int n) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed before", 50001);
        }
        if (n < 0 || n >= this.g.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.h.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.i.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        VerifyInfo verifyInfo = this.i.get(n);
        return verifyInfo.c();
    }

    public boolean hasRFC5652_SignedAttrDER(int n) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed before", 50001);
        }
        if (n < 0 || n >= this.i.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        VerifyInfo verifyInfo = this.i.get(n);
        return verifyInfo.e();
    }

    public String getSigningCertificateV2HashAlg(int n) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed before", 50001);
        }
        if (!this.hasSigningCertificateV2(n)) {
            return null;
        }
        if (n < 0 || n >= this.g.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.h.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.i.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        Object object = this.h.get(n);
        try {
            Object object2 = this.pkcs7SignedData.getSignerInfos();
            object2 = object2.getSigners();
            object2 = new Vector(object2);
            if (n < 0 || n >= ((Vector)object2).size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            Object object3 = (SignerInformation)((Vector)object2).elementAt(n);
            object = object.getInternalCert();
            object3 = SignedEnvelope.getSigningCertificateV2HashAlg(object3, (X509Certificate)object);
            return object3;
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            return null;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    public boolean hasSigningCertificate(int n) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed before", 50001);
        }
        if (n < 0 || n >= this.g.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.h.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.i.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        VerifyInfo verifyInfo = this.i.get(n);
        return verifyInfo.b();
    }

    public boolean hasNoSignerAttribute(int n) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed before", 50001);
        }
        if (n < 0 || n >= this.g.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.h.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n < 0 || n >= this.i.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        try {
            Object object = this.pkcs7SignedData.getSignerInfos();
            object = object.getSigners();
            object = new Vector(object);
            if (n < 0 || n >= ((Vector)object).size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation signerInformation = (SignerInformation)((Vector)object).elementAt(n);
            boolean bl = SignedEnvelope.hasNoSignedAttribute(signerInformation);
            return bl;
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            return false;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public String getSignerEncryptionAlg(int n) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            Object object = this.pkcs7SignedData.getSignerInfos();
            object = object.getSigners();
            object = new Vector(object);
            if (n < 0 || n >= ((Vector)object).size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation signerInformation = (SignerInformation)((Vector)object).elementAt(n);
            if (signerInformation.getEncryptionAlgOID().equalsIgnoreCase(CMSSignedDataGenerator.ENCRYPTION_RSA)) {
                a.debug("[getEncryptionAlgOID] is ENCRYPTION_RSA");
                return "RSA";
            }
            a.debug("[getEncryptionAlgOID] " + signerInformation.getEncryptionAlgOID());
            return signerInformation.getEncryptionAlgOID();
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Cannot get signer encryption algorithm oid " + exception.getMessage(), 50023);
        }
    }

    public byte[] getSignature(int n) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            Object object = this.pkcs7SignedData.getSignerInfos();
            object = object.getSigners();
            object = new Vector(object);
            if (n < 0 || n >= ((Vector)object).size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation signerInformation = (SignerInformation)((Vector)object).elementAt(n);
            return signerInformation.getSignature();
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Cannot get signature value", 50023);
        }
    }

    public String getSigningTime(int n, String string) throws CapiException {
        return this.getSigningTime(n, string, null);
    }

    public String getSigningTime(int n, String string, String cloneable) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            cloneable = this.pkcs7SignedData.getSignerInfos();
            cloneable = cloneable.getSigners();
            cloneable = new Vector(cloneable);
            if (n < 0 || n >= cloneable.size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation signerInformation = (SignerInformation)cloneable.elementAt(n);
            Object object = signerInformation;
            object = signerInformation;
            object = signerInformation.getSignedAttributes();
            cloneable = null;
            if (object != null && (object = object.get(CMSAttributes.signingTime)) != null) {
                object = Time.getInstance((Object)object.getAttrValues().getObjectAt(0).toASN1Primitive());
                cloneable = object.getDate();
            }
            if ((object = cloneable) == null) {
                return null;
            }
            return Util.formatDate((Date)object, (String)string);
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Wrong signingTime format", 50023);
        }
    }

    public byte[] getMessageDigest(int n) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            Object object = this.pkcs7SignedData.getSignerInfos();
            object = object.getSigners();
            object = new Vector(object);
            if (n < 0 || n >= object.size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation signerInformation = (SignerInformation)object.elementAt(n);
            SignerInformation signerInformation2 = signerInformation;
            signerInformation2 = signerInformation;
            signerInformation2 = signerInformation.getSignedAttributes();
            object = null;
            if (signerInformation2 != null && (signerInformation2 = signerInformation2.get(CMSAttributes.messageDigest)) != null) {
                signerInformation2 = (ASN1OctetString)signerInformation2.getAttrValues().getObjectAt(0).toASN1Primitive();
                object = signerInformation2.getOctets();
            }
            return object;
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Wrong digest format", 50023);
        }
    }

    public SignedEnvelope() throws CapiException {
        this(1);
    }

    public SignedEnvelope(int n) throws CapiException {
        int n2 = 2;
        n2 = 1;
        int n3 = n;
        String string = "mode";
        if (n3 <= 0 || n3 > 2) {
            throw new CapiException("Parameter " + string + " value ( " + n3 + " ) is out of the range allowed [1" + " : 2" + "]", 1002);
        }
        this.j = 0;
        this.k = n;
        this.a();
    }

    public void setData(byte[] byArray) throws CapiException {
        this.setData(byArray, 1);
    }

    public void setData(byte[] byArray, int n) throws CapiException {
        if (n == 2 && this.k == 1) {
            throw new CapiException("DIGEST type only for explicit mode", 50021);
        }
        if (this.j > 1) {
            throw new CapiException("Not allowed if already signed", 50002);
        }
        if (byArray == null) {
            throw new CapiException("Null data", 1001);
        }
        this.f = n;
        this.e = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.e, 0, byArray.length);
        if (n == 2) {
            if (this.e.length == 20) {
                this.d = SHA1;
            }
            if (this.e.length == 32) {
                this.d = SHA256;
            }
        }
        this.j = 1;
    }

    public void addSigner(TokenSpi tokenSpi, String string) throws CapiException {
        this.addSigner(tokenSpi, string, null);
    }

    @Deprecated
    public void addSigner(TokenSpi tokenSpi, String string, boolean bl) throws CapiException {
        this.addSigner(tokenSpi, string);
    }

    public void addSigner(TokenSpi object, String collection, Date date) throws CapiException {
        ESSCertID eSSCertID;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        try {
            a.debug("[addSigner] getting credential from token...");
            object5 = object.getCert((String)((Object)collection));
            object4 = ((String)object5).getBytes("ISO8859_1");
            object4 = new ByteArrayInputStream((byte[])object4);
            object3 = CertificateFactory.getInstance("X.509");
            try {
                object4 = (X509Certificate)((CertificateFactory)object3).generateCertificate((InputStream)object4);
            }
            catch (CertificateException certificateException) {
                object3 = "CERTIFICATE";
                StringBuilder stringBuilder = new StringBuilder().append("-----BEGIN " + (String)object3 + "-----" + System.getProperty("line.separator")).append((String)object5);
                object3 = "CERTIFICATE";
                String string = stringBuilder.append(System.getProperty("line.separator") + "-----END " + (String)object3 + "-----").toString();
                object4 = string;
                object4 = string.getBytes("ISO8859_1");
                object4 = new ByteArrayInputStream((byte[])object4);
                object3 = CertificateFactory.getInstance("X.509");
                object4 = (X509Certificate)((CertificateFactory)object3).generateCertificate((InputStream)object4);
                a.debug("alias cert Subject: " + ((X509Certificate)object4).getSubjectDN().getName());
            }
            a.debug("...cert ok");
            object = object.getPrivateKey((String)((Object)collection));
            a.debug("[addSigner] getting credential from token ok");
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 50050);
        }
        collection = object;
        object = object4;
        object3 = this;
        object5 = ((SignedEnvelope)object3).b;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        a.debug("Adding signer ...");
        try {
            object2 = new IssuerSerial(new GeneralNames(new GeneralName(JcaX500NameUtil.getIssuer((X509Certificate)object))), new ASN1Integer(((X509Certificate)object).getSerialNumber()));
        }
        catch (Exception exception) {
            throw new CapiException("Exception creating IssuerSerial", 50040);
        }
        if (((SignedEnvelope)object3).d.compareToIgnoreCase(CMSSignedDataGenerator.DIGEST_SHA1) == 0) {
            a.debug("using SHA1 digest ...");
            try {
                ((SignedEnvelope)object3).b.reset();
                eSSCertID = new ESSCertID(((SignedEnvelope)object3).b.digest(((Certificate)object).getEncoded()), (IssuerSerial)object2);
                object2 = new Attribute(SignedData.id_aa_signingCertificate, (ASN1Set)new DERSet((ASN1Encodable)new SigningCertificate(eSSCertID)));
                aSN1EncodableVector.add((ASN1Encodable)object2);
            }
            catch (Exception exception) {
                throw new CapiException("Exception creating id_aa_signingCertificate.", 50040);
            }
        } else if (((SignedEnvelope)object3).d.compareToIgnoreCase(CMSSignedDataGenerator.DIGEST_SHA256) == 0) {
            a.debug("using SHA256 digest ...");
            object5 = ((SignedEnvelope)object3).c;
            try {
                ((SignedEnvelope)object3).c.reset();
                eSSCertID = new ESSCertIDv2(new AlgorithmIdentifier(new ASN1ObjectIdentifier(CMSSignedDataGenerator.DIGEST_SHA256)), ((SignedEnvelope)object3).c.digest(((Certificate)object).getEncoded()), (IssuerSerial)object2);
                Attribute attribute = new ESSCertIDv2[1];
                object2 = attribute;
                attribute[0] = eSSCertID;
                object2 = new Attribute(SignedData.id_aa_signingCertificateV2, (ASN1Set)new DERSet((ASN1Encodable)new SigningCertificateV2((ESSCertIDv2[])object2)));
                aSN1EncodableVector.add((ASN1Encodable)object2);
            }
            catch (Exception exception) {
                throw new CapiException("Exception creating id_aa_signingCertificate.", 50040);
            }
        } else {
            throw new CapiException("Invalid digest algorithm", 1002);
        }
        try {
            eSSCertID = new CMSSignedDataGenerator();
            if (!((SignedEnvelope)object3).isCounterSignedEnv) {
                a.debug("this is a signature->Content type in signed attribute");
                object2 = new Attribute(CMSAttributes.contentType, (ASN1Set)new DERSet((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.7.1")));
                aSN1EncodableVector.add((ASN1Encodable)object2);
            } else {
                a.debug("this is a countersignature->No content type in signed attribute");
            }
            if (((SignedEnvelope)object3).t) {
                if (date != null) {
                    object2 = new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new Time(date)));
                    aSN1EncodableVector.add((ASN1Encodable)object2);
                } else {
                    object2 = new Attribute(CMSAttributes.signingTime, (ASN1Set)new DERSet((ASN1Encodable)new Time(new Date())));
                    aSN1EncodableVector.add((ASN1Encodable)object2);
                }
            }
            if (((SignedEnvelope)object3).f == 2) {
                object2 = ((SignedEnvelope)object3).e;
                object2 = new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((ASN1Encodable)new DEROctetString((byte[])object2)));
                aSN1EncodableVector.add((ASN1Encodable)object2);
            } else {
                object2 = new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DERSet((ASN1Encodable)new DEROctetString(((MessageDigest)object5).digest(((SignedEnvelope)object3).e))));
                aSN1EncodableVector.add((ASN1Encodable)object2);
            }
            a.debug("pkcs7SignedDataGen.addSigner ...");
            object2 = "SHA256WithRSAEncryption";
            if (((SignedEnvelope)object3).d.compareToIgnoreCase(SHA256) != 0) {
                object2 = "SHA1WithRSAEncryption";
            }
            collection = (date = new it.actalis.ellips.capi.core.Certificate((X509Certificate)object)).isRsVerified() ? new VerRsContentSignerBuilder((String)object2).setProvider(ProvUtils.retrieveBestProviderForKey((PrivateKey)((Object)collection))).build((PrivateKey)((Object)collection)) : new JcaContentSignerBuilder((String)object2).setProvider(ProvUtils.retrieveBestProviderForKey((PrivateKey)((Object)collection))).build((PrivateKey)((Object)collection));
            date = new JcaDigestCalculatorProviderBuilder().setProvider(ProvUtils.bcProvider).build();
            new JcaSignerInfoGeneratorBuilder((DigestCalculatorProvider)date);
            object5 = new AttributeTable(aSN1EncodableVector);
            object5.toASN1EncodableVector();
            object5 = new SimpleAttributeTableGenerator((AttributeTable)object5);
            date = new SignerInfoGeneratorBuilder((DigestCalculatorProvider)date);
            date.setSignedAttributeGenerator((CMSAttributeTableGenerator)object5);
            collection = date.build((ContentSigner)collection, (X509CertificateHolder)new JcaX509CertificateHolder((X509Certificate)object));
            eSSCertID.addSignerInfoGenerator((SignerInfoGenerator)collection);
            a.debug("pkcs7SignedDataGen.addSigner done.");
            collection = new Vector<Object>();
            ((Vector)collection).addElement((Date)object);
            object = new JcaCertStore((Collection)collection);
            eSSCertID.addCertificates((Store)object);
            a.debug("pkcs7SignedDataGen.generate ...");
            if (((SignedEnvelope)object3).f == 2) {
                object = eSSCertID.generate((CMSTypedData)new CMSAbsentContent(), false);
            } else if (((SignedEnvelope)object3).k == 2) {
                object = eSSCertID.generate((CMSTypedData)new CMSAbsentContent(), false);
            } else {
                collection = new CMSProcessableByteArray(((SignedEnvelope)object3).e);
                object = ((SignedEnvelope)object3).isCounterSignedEnv ? eSSCertID.generate((CMSTypedData)new CMSAbsentContent(), false) : eSSCertID.generate((CMSTypedData)collection, true);
            }
            a.debug("pkcs7SignedDataGen.generate done.");
            collection = object.getSignerInfos();
            collection = collection.getSigners();
            collection = new Vector(collection);
            date = (SignerInformation)((Vector)collection).elementAt(0);
            if (((SignedEnvelope)object3).l != null) {
                a.debug("Signature TimeStampToken adding..");
                object5 = super.c(date.getSignature());
                object2 = new TimeStampToken((byte[])object5);
                byte[] byArray = object2.toByteArray(false, true);
                object2 = byArray;
                object2 = SignedEnvelope.d(byArray);
                date = SignedEnvelope.a(object2, (SignerInformation)date);
                ((Vector)collection).set(0, date);
                object = CMSSignedData.replaceSigners((CMSSignedData)object, (SignerInformationStore)new SignerInformationStore(collection));
            }
            if (((SignedEnvelope)object3).pkcs7SignedData != null && ((SignedEnvelope)object3).pkcs7SignedData.getSignerInfos().size() > 0) {
                collection = ((SignedEnvelope)object3).pkcs7SignedData.getSignerInfos().getSigners();
                date = (SignerInformation)object.getSignerInfos().getSigners().toArray()[0];
                collection.add(date);
                ((SignedEnvelope)object3).pkcs7SignedData = CMSSignedData.replaceSigners((CMSSignedData)((SignedEnvelope)object3).pkcs7SignedData, (SignerInformationStore)new SignerInformationStore(collection));
                object5 = ((SignedEnvelope)object3).pkcs7SignedData.getCertificates();
                object2 = object5.getMatches((Selector)date.getSID());
                if (object2.isEmpty()) {
                    object2 = object.getCertificates().getMatches(null);
                    object = object5.getMatches(null);
                    object.addAll(object2);
                    object = new JcaCertStore((Collection)object);
                    ((SignedEnvelope)object3).pkcs7SignedData = CMSSignedData.replaceCertificatesAndCRLs((CMSSignedData)((SignedEnvelope)object3).pkcs7SignedData, (Store)object, null, null);
                }
            } else {
                ((SignedEnvelope)object3).pkcs7SignedData = object;
            }
            a.debug("Signer added.");
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error: " + exception.getMessage(), 1003, (Throwable)exception);
        }
        try {
            this.g.add(new it.actalis.ellips.capi.core.Certificate(((Certificate)object4).getEncoded()).getSubjectDN());
            object5 = new it.actalis.ellips.capi.core.Certificate((X509Certificate)object4);
            this.h.add((it.actalis.ellips.capi.core.Certificate)object5);
            this.i.add(new VerifyInfo(true));
        }
        catch (CertificateEncodingException certificateEncodingException) {
            a.debug(certificateEncodingException.getMessage(), (Throwable)certificateEncodingException);
            throw new CapiException("Internal error", 50050);
        }
        if (!this.certsVector.contains(object4)) {
            this.certsVector.add((X509Certificate)object4);
        }
        a.debug("Signer added.");
        this.j = 2;
    }

    @Deprecated
    public void addSignerAS(String string, String string2, boolean bl) throws CapiException {
        throw new CapiException("unsupported token type", 1003);
    }

    public void addCertificate(byte[] object) throws CapiException {
        if (this.j <= 0) {
            throw new CapiException("Data must be set before", 50000);
        }
        if (!this.certsVector.contains(object = (Object)new it.actalis.ellips.capi.core.Certificate(object).getInternalCert())) {
            this.certsVector.add((X509Certificate)object);
            if (this.j == 3) {
                this.j = 2;
            }
        }
    }

    public void setSignatureTimeStampParams(String string, String string2, String string3, boolean bl, HttpsClient httpsClient) throws CapiException {
        if (string == null || string2 == null || httpsClient == null) {
            throw new CapiException("Null data", 1001);
        }
        if (string2.compareToIgnoreCase("SHA-1") != 0 && string2.compareToIgnoreCase("SHA-256") != 0 && string2.compareToIgnoreCase("MD5") != 0) {
            throw new CapiException("Invalid hash Algorithm", 1002);
        }
        this.l = string;
        this.m = string2;
        this.n = string3;
        this.o = bl;
        this.p = httpsClient;
        a.debug("[setSignatureTimeStampParams] done.");
    }

    public void setSignatureTimeStampParams(String string, String string2, String string3, boolean bl, String string4, String string5) throws CapiException {
        if (string == null || string2 == null) {
            throw new CapiException("Null data", 1001);
        }
        if (string2.compareToIgnoreCase("SHA-1") != 0 && string2.compareToIgnoreCase("SHA-256") != 0 && string2.compareToIgnoreCase("MD5") != 0) {
            throw new CapiException("Invalid hash Algorithm", 1002);
        }
        this.l = string;
        this.m = string2;
        this.n = string3;
        this.o = bl;
        this.q = string4;
        this.r = string5;
        this.p = null;
        a.debug("[setSignatureTimeStampParams] done.");
    }

    public void setSignatureTimeStampParams(String string, String string2, boolean bl, DTSClient dTSClient) throws CapiException {
        if (dTSClient == null) {
            throw new CapiException("Null DTSClient", 1001);
        }
        this.m = string;
        this.n = string2;
        this.o = bl;
        this.s = dTSClient;
        this.l = "TSCLIENT";
        a.debug("[setSignatureTimeStampParams DTSClient] done.");
    }

    public String getEncoded() throws CapiException {
        if (this.j < 2) {
            throw new CapiException("Data must be signed before", 50001);
        }
        try {
            StringWriter stringWriter = new StringWriter();
            PEMWriter pEMWriter = new PEMWriter((Writer)stringWriter);
            pEMWriter.writeObject((Object)this.pkcs7SignedData.toASN1Structure());
            pEMWriter.close();
            return Util.fromPemString((String)stringWriter.getBuffer().toString(), (boolean)false);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Error encoding signed envelope", 50022);
        }
    }

    public void setDigestAlg(String string) throws CapiException {
        a.debug("Setting digest algorithm ...");
        if (string == null) {
            throw new CapiException("Null data", 1001);
        }
        if (string.compareToIgnoreCase(CMSSignedDataGenerator.DIGEST_SHA1) == 0) {
            a.debug("set SHA1 digest");
            this.d = CMSSignedDataGenerator.DIGEST_SHA1;
            return;
        }
        if (string.compareToIgnoreCase(CMSSignedDataGenerator.DIGEST_SHA256) == 0) {
            a.debug("set SHA256 digest ");
            this.d = CMSSignedDataGenerator.DIGEST_SHA256;
            return;
        }
        throw new CapiException("Invalid digest algorithm", 1002);
    }

    public void includeSigningTime(boolean bl) {
        if (a.isDebugEnabled()) {
            a.debug("includeSigningTime called ... omit is " + bl);
        }
        this.t = bl;
    }

    private byte[] c(byte[] object) throws CapiException {
        Object object2 = new BigInteger(64, Util.secureRandom);
        try {
            if (this.s != null) {
                return this.s.timeStamp(this.n, this.m, object, (BigInteger)object2, this.o).toByteArray(false, true);
            }
            Client client = new Client();
            object = client.getRequest(this.n, this.m, object, false, (BigInteger)object2, this.o);
            a.debug("[getTimeStamp] generated TSReq");
            object2 = new ByteArrayInputStream(Util.base64DecodeStr((String)object));
        }
        catch (IllegalParamException illegalParamException) {
            throw new CapiException("Error generating TSReq", 50040);
        }
        catch (CapiException capiException) {
            a.debug("[getTimeStamp] Error generating TSReq");
            throw capiException;
        }
        catch (IOException iOException) {
            object = iOException;
            if (iOException.getMessage() != null) {
                throw new CapiException("Error sending TSReq: " + object.getMessage(), 50040);
            }
            throw new CapiException("Error sending TSReq", 50040);
        }
        a.debug("[getTimeStamp] trying send TSA Request ...");
        try {
            if (this.p != null) {
                object = this.p.doPost(this.l, "application/timestamp-query", (InputStream)object2, null);
            } else {
                object2 = new HTTP_URLConnection();
                object = object2.doPost(this.l, "application/timestamp-query", Util.base64DecodeStr((String)object), this.q, this.r);
            }
        }
        catch (CapiException capiException) {
            a.debug("[getTimeStamp] Error sending TSReq");
            throw capiException;
        }
        catch (Exception exception) {
            object2 = exception;
            exception.printStackTrace();
            a.debug("[getTimeStamp] Error sending TSReq");
            throw new CapiException("Exception posting TSReq using HTTP_URLConnection: " + ((Throwable)object2).getMessage(), 91007);
        }
        if (object == null || ((byte[])object).length == 0) {
            throw new CapiException("Null response from TSA", 50040);
        }
        a.debug("[getTimeStamp] received Time Stamp Token form TSA.");
        return object;
    }

    private static Attribute d(byte[] object) throws CapiException {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream((byte[])object));
            object = aSN1InputStream;
            object = ContentInfo.getInstance((Object)aSN1InputStream.readObject());
            Attribute attribute = new Attribute(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken, (ASN1Set)new DERSet((ASN1Encodable)object));
            object = attribute;
            return attribute;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Error adding signature Time Stamp Token", 50040);
        }
    }

    private static SignerInformation a(Attribute attribute, SignerInformation signerInformation) {
        Object object = signerInformation.getUnsignedAttributes();
        if (object != null) {
            a.debug("removing existing TimeStampToken unsignedAttributes ... ");
            object = object.toHashtable();
            object.remove(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
            a.debug("adding TS attribute to existing unsignedAttributes ... ");
            object = new AttributeTable((Hashtable)object).toASN1EncodableVector();
        } else {
            object = new ASN1EncodableVector();
        }
        object.add((ASN1Encodable)attribute);
        object = SignerInformation.replaceUnsignedAttributes((SignerInformation)signerInformation, (AttributeTable)new AttributeTable((ASN1EncodableVector)object));
        return object;
    }

    public SignedEnvelope(byte[] object, byte[] object2) throws CapiException {
        this((byte[])object2);
        SignedEnvelope signedEnvelope = new SignedEnvelope((byte[])object);
        object = signedEnvelope;
        object2 = signedEnvelope.getData();
        Object object3 = this.getData();
        ((SignedEnvelope)object).listSigners();
        this.listSigners();
        if (object2 != null && object3 != null) {
            if (((String)(object2 = (Object)new String((byte[])object2))).compareTo((String)(object3 = (Object)new String((byte[])object3))) != 0) {
                System.out.println("-- contenuti non uguali --");
                throw new CapiException("Parameter is wrong", 1002);
            }
            try {
                System.out.println("-- contenuti uguali --");
                System.out.println("-- creare un ogetto pkcs7 uguale ad env 1 --");
                object2 = this.pkcs7SignedData.getSignerInfos().getSigners();
                object3 = ((SignedEnvelope)object).pkcs7SignedData.getSignerInfos().getSigners();
                object2.addAll(object3);
                this.pkcs7SignedData = CMSSignedData.replaceSigners((CMSSignedData)this.pkcs7SignedData, (SignerInformationStore)new SignerInformationStore((Collection)object2));
                object2 = this.pkcs7SignedData.getCertificates();
                object2 = object2.getMatches(null);
                object = ((SignedEnvelope)object).pkcs7SignedData.getCertificates();
                object = object.getMatches(null);
                object2.addAll(object);
                object = new JcaCertStore((Collection)object2);
                this.pkcs7SignedData = CMSSignedData.replaceCertificatesAndCRLs((CMSSignedData)this.pkcs7SignedData, (Store)object, null, null);
            }
            catch (Exception exception) {
                a.debug(exception.getMessage(), (Throwable)exception);
                throw new CapiException("Internal error", 50050);
            }
            a.debug("signer info and certificates added...");
            return;
        }
        System.out.println("-- contenuti non uguali --");
        throw new CapiException("Parameter is wrong", 1002);
    }

    public SignedEnvelope(String object, String object2, byte[] object3) throws CapiException {
        this((String)object2, (byte[])object3);
        object = new SignedEnvelope((String)object, (byte[])object3);
        object2 = ((SignedEnvelope)object).getData();
        object3 = this.getData();
        ((SignedEnvelope)object).listSigners();
        this.listSigners();
        if (object2 != null && object3 != null) {
            if (((String)(object2 = new String((byte[])object2))).compareTo((String)(object3 = (Object)new String((byte[])object3))) != 0) {
                System.out.println("-- contenuti non uguali --");
                throw new CapiException("Parameter is wrong", 1002);
            }
            try {
                System.out.println("-- contenuti uguali --");
                System.out.println("-- creare un ogetto pkcs7 uguale ad env 1 --");
                object2 = this.pkcs7SignedData.getSignerInfos().getSigners();
                object3 = ((SignedEnvelope)object).pkcs7SignedData.getSignerInfos().getSigners();
                object2.addAll(object3);
                this.pkcs7SignedData = CMSSignedData.replaceSigners((CMSSignedData)this.pkcs7SignedData, (SignerInformationStore)new SignerInformationStore((Collection)object2));
                object2 = this.pkcs7SignedData.getCertificates();
                object2 = object2.getMatches(null);
                object = ((SignedEnvelope)object).pkcs7SignedData.getCertificates();
                object = object.getMatches(null);
                object2.addAll(object);
                object = new JcaCertStore((Collection)object2);
                this.pkcs7SignedData = CMSSignedData.replaceCertificatesAndCRLs((CMSSignedData)this.pkcs7SignedData, (Store)object, null, null);
            }
            catch (Exception exception) {
                a.debug(exception.getMessage(), (Throwable)exception);
                throw new CapiException("Internal error", 50050);
            }
            a.debug("signer info and certificates added...");
            return;
        }
        System.out.println("-- contenuti non uguali --");
        throw new CapiException("Parameter is wrong", 1002);
    }

    protected SignerInformationStore getSignersInfos() throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed before", 50001);
        }
        try {
            SignerInformationStore signerInformationStore = this.pkcs7SignedData.getSignerInfos();
            return signerInformationStore;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 50050);
        }
    }

    public CounterSignedEnvelope getCounterSignature(int n) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed or parsed before", 50001);
        }
        if (n < 0 || n >= this.g.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        Object object = this.pkcs7SignedData.getSignerInfos();
        object = object.getSigners();
        object = new Vector(object);
        if (n < 0 || n >= ((Vector)object).size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        try {
            object = (SignerInformation)((Vector)object).elementAt(n);
            SignerInformationStore signerInformationStore = object.getCounterSignatures();
            CounterSignedEnvelope counterSignedEnvelope = new CounterSignedEnvelope();
            new CounterSignedEnvelope().certsVector = this.certsVector;
            counterSignedEnvelope.setData(object.getSignature());
            counterSignedEnvelope.a(signerInformationStore, n);
            return counterSignedEnvelope;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Internal error", 50050);
        }
    }

    final void a(SignerInformationStore object, int n) throws CapiException {
        if (this.j <= 0) {
            throw new CapiException("Data must be set before", 50000);
        }
        Object object2 = new CMSSignedDataGenerator();
        CMSProcessableByteArray cMSProcessableByteArray2 = new CMSProcessableByteArray(this.e);
        if (!this.g.isEmpty()) {
            this.g.clear();
        }
        if (!this.i.isEmpty()) {
            this.i.clear();
        }
        try {
            if (object == null || object.size() == 0) {
                a.debug("No CounterSignatures already present for signer " + n);
                this.pkcs7SignedData = object2.generate((CMSTypedData)cMSProcessableByteArray2, false);
            } else {
                a.debug("Found " + object.size() + " CounterSignatures for signer " + n);
                Collection collection = object.getSigners();
                new Vector(collection);
                collection = new JcaCertStore(this.certsVector);
                object2.addCertificates((Store)collection);
                this.pkcs7SignedData = object2.generate((CMSTypedData)cMSProcessableByteArray2, false);
                this.pkcs7SignedData = CMSSignedData.replaceSigners((CMSSignedData)this.pkcs7SignedData, (SignerInformationStore)object);
                object = new ArrayList();
                for (CMSProcessableByteArray cMSProcessableByteArray2 : this.pkcs7SignedData.getSignerInfos().getSigners()) {
                    object.add(new CapiSignerInformation((SignerInformation)cMSProcessableByteArray2, this.pkcs7SignedData.getSignedContent()));
                }
                object2 = new Vector(object);
                for (int i = 0; i < ((Vector)object2).size(); ++i) {
                    object = (CapiSignerInformation)((Object)((Vector)object2).elementAt(i));
                    SignedEnvelope.verifySigner((SignerInformation)object, (Store)collection, this.g, this.h, this.i, null);
                }
            }
            this.j = 3;
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            a.debug(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
            throw new CapiException("No implementation for signature algorithm:", 50050);
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException(exception.getMessage(), 50050);
        }
    }

    public void setCounterSignature(int n, CounterSignedEnvelope counterSignedEnvelope) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed or parsed before", 50001);
        }
        if (n < 0 || n >= this.g.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (counterSignedEnvelope == null) {
            throw new CapiException("CounterSignedEnvelope must be valid and signed", 1001);
        }
        Object object = this.pkcs7SignedData.getSignerInfos();
        object = object.getSigners();
        if (n < 0 || n >= object.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        try {
            Collection collection = this.pkcs7SignedData.getCertificates().getMatches(null);
            Object object2 = counterSignedEnvelope.pkcs7SignedData.getCertificates().getMatches(null);
            object2 = new Vector(object2);
            for (int i = 0; i < object2.size(); ++i) {
                if (collection.contains(object2.elementAt(i))) continue;
                collection.add(object2.elementAt(i));
            }
            JcaCertStore jcaCertStore = new JcaCertStore(collection);
            this.pkcs7SignedData = CMSSignedData.replaceCertificatesAndCRLs((CMSSignedData)this.pkcs7SignedData, (Store)jcaCertStore, null, null);
            counterSignedEnvelope = counterSignedEnvelope.getSignersInfos();
            a.debug("adding " + counterSignedEnvelope.size() + " countersignatures to signer " + n);
            object = new Vector(object);
            collection = (SignerInformation)((Vector)object).get(n);
            object2 = collection.getUnsignedAttributes();
            if (object2 != null) {
                a.debug("replacing CS attribute ... ");
                object2 = object2.toHashtable();
                object2.remove(CMSAttributes.counterSignature);
                object2 = new AttributeTable((Hashtable)object2);
                collection = SignerInformation.replaceUnsignedAttributes((SignerInformation)collection, (AttributeTable)object2);
            }
            object2 = SignerInformation.addCounterSigners((SignerInformation)collection, (SignerInformationStore)counterSignedEnvelope);
            ((Vector)object).set(n, object2);
            this.pkcs7SignedData = CMSSignedData.replaceSigners((CMSSignedData)this.pkcs7SignedData, (SignerInformationStore)new SignerInformationStore((Collection)object));
            return;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("CounterSignature internal error", 50050);
        }
    }

    public boolean hasCounterSignature(int n) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed or parsed before", 50001);
        }
        if (n < 0 || n >= this.g.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        Vector vector = this.pkcs7SignedData.getSignerInfos().getSigners();
        vector = new Vector(vector);
        SignerInformation signerInformation = (SignerInformation)vector.elementAt(n);
        return (signerInformation = signerInformation.getCounterSignatures()) != null && signerInformation.size() > 0;
    }

    public void setSignatureTimeStampToken(int n, TimeStampToken object) throws CapiException, IOException {
        if (object == null) {
            throw new CapiException("Time Stamp Token is null", 1001);
        }
        object = object.toByteArray(false, true);
        this.setSignatureTimeStampToken(n, (byte[])object);
    }

    public void setSignatureTimeStampToken(int n, byte[] object) throws CapiException {
        if (object == null) {
            throw new CapiException("Time Stamp Token is null", 1001);
        }
        object = SignedEnvelope.d(object);
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Data must be signed or parsed before", 50001);
        }
        if (n < 0 || n >= this.g.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        Object object2 = this.pkcs7SignedData.getSignerInfos();
        object2 = object2.getSigners();
        if (n < 0 || n >= object2.size()) {
            throw new CapiException("Wrong signer index", 50010);
        }
        try {
            object2 = new Vector(object2);
            SignerInformation signerInformation = (SignerInformation)((Vector)object2).get(n);
            signerInformation = SignedEnvelope.a((Attribute)object, signerInformation);
            ((Vector)object2).set(n, signerInformation);
            this.pkcs7SignedData = CMSSignedData.replaceSigners((CMSSignedData)this.pkcs7SignedData, (SignerInformationStore)new SignerInformationStore((Collection)object2));
            return;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("CounterSignature internal error", 50050);
        }
    }

    public byte[] getSignatureTimeStampToken(int n) throws CapiException {
        if (this.pkcs7SignedData == null) {
            throw new CapiException("Null parameters", 1001);
        }
        try {
            Object object = this.pkcs7SignedData.getSignerInfos();
            object = object.getSigners();
            object = new Vector(object);
            if (n < 0 || n >= object.size()) {
                throw new CapiException("Wrong signer index", 50010);
            }
            SignerInformation signerInformation = (SignerInformation)object.elementAt(n);
            signerInformation = signerInformation.getUnsignedAttributes();
            object = null;
            if (signerInformation != null && (signerInformation = signerInformation.get(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) != null) {
                signerInformation = ContentInfo.getInstance((Object)signerInformation.getAttrValues().getObjectAt(0).toASN1Primitive());
                object = signerInformation.getEncoded("DER");
            }
            return object;
        }
        catch (CapiException capiException) {
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Wrong timeStampToken format", 50023);
        }
    }

    public CadesSignedDataProxy getSignedDataProxy() {
        return new CadesSignedDataProxy(this.pkcs7SignedData);
    }
}

