/*
 * Decompiled with CFR 0.152.
 */
package esecurity.desktop.swt;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import esecurity.desktop.BaseController;
import esecurity.desktop.Listener;
import esecurity.desktop.Region;
import esecurity.desktop.ResUtils;
import esecurity.desktop.View;
import esecurity.desktop.observable.ObservableListener;
import esecurity.desktop.observable.ObservableObject;
import esecurity.desktop.swt.Browser;
import esecurity.desktop.swt.BrowserFunction;
import esecurity.desktop.swt.Composite;
import esecurity.desktop.swt.Device;
import esecurity.desktop.swt.Display;
import esecurity.desktop.swt.DragAndDropInnerArea;
import esecurity.desktop.swt.DropTarget;
import esecurity.desktop.swt.DropTargetAdapter;
import esecurity.desktop.swt.DropTargetEvent;
import esecurity.desktop.swt.Event;
import esecurity.desktop.swt.FileTransfer;
import esecurity.desktop.swt.Image;
import esecurity.desktop.swt.KeyPressListener;
import esecurity.desktop.swt.Menu;
import esecurity.desktop.swt.MenuItem;
import esecurity.desktop.swt.Monitor;
import esecurity.desktop.swt.Point;
import esecurity.desktop.swt.ProgressAdapter;
import esecurity.desktop.swt.ProgressEvent;
import esecurity.desktop.swt.Rectangle;
import esecurity.desktop.swt.SWTViewResizer;
import esecurity.desktop.swt.Shell;
import esecurity.desktop.swt.WIN_OS;
import java.awt.MouseInfo;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SWTView
extends View {
    private static Display display = null;
    private boolean resizable = false;
    private Runnable onResize = null;
    private Browser browser = null;
    private Shell shell = null;
    private Composite dragAndDropComposite = null;
    private BaseController controller;
    private boolean dragIn = false;
    private int shellInnerCurrentWidth = 0;
    private int shellInnerCurrentHeight = 0;
    private int titleBarHeight = 0;
    private boolean decorated = false;
    private int minHeight;
    private int minWidth;
    private boolean dragAndDropEnabled = true;
    int prevWidth = 0;
    int prevHeight = 0;
    private boolean dragWindow = false;
    private int offsetX = 0;
    private int offsetY = 0;
    private final Map<DragAndDropInnerArea, Boolean> dropInnerAreas = new HashMap<DragAndDropInnerArea, Boolean>();
    private Composite windowDragComposite;
    private SWTViewResizer resizer = null;
    private final ObservableObject<Boolean> isMaximized = new ObservableObject<Boolean>(false);
    private final List<String> documentStyles = new ArrayList<String>();
    private final ScheduledThreadPoolExecutor dragAndDropMouseMonitorExecutor = new ScheduledThreadPoolExecutor(1);
    private ScheduledFuture<?> dragAndDropMouseMonitor = null;

    @Override
    public void setDragAndDropEnabled(boolean dragAndDropEnabled) {
        this.dragAndDropEnabled = dragAndDropEnabled;
    }

    public static void startUIThread(Runnable application) {
        File xulPath;
        if (display != null) {
            throw new IllegalStateException("Display already created. This method can only be invoked once");
        }
        if (System.getProperty("org.eclipse.swt.browser.XULRunnerPath", "").equals("") && (xulPath = new File("xulrunner")).exists() && !SWTView.isIE11Installed()) {
            logger.info("IE11 not installed, use XULRunner: " + xulPath.getAbsolutePath());
            System.setProperty("org.eclipse.swt.browser.XULRunnerPath", xulPath.getAbsolutePath());
        }
        display = Display.getDefault();
        Thread app = new Thread(application, "ApplicationThread");
        app.start();
        try {
            while (!display.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
        display = null;
    }

    private static boolean isIE11Installed() {
        if (!Platform.isWindows()) {
            return false;
        }
        String ieVersion = SWTView.getIEVErsion("svcVersion");
        if (ieVersion != null) {
            return SWTView.isVersionGreaterEqual(ieVersion, "11");
        }
        ieVersion = SWTView.getIEVErsion("Version");
        if (ieVersion != null) {
            return SWTView.isVersionGreaterEqual(ieVersion, "9.11");
        }
        return false;
    }

    private static String getIEVErsion(String versionName) {
        String ieVersion = SWTView.getKey(WinReg.HKEY_LOCAL_MACHINE, "Software\\Microsoft\\Internet Explorer", versionName);
        if (ieVersion == null) {
            ieVersion = SWTView.getKey(WinReg.HKEY_CURRENT_USER, "Software\\Microsoft\\Internet Explorer", versionName);
        }
        return ieVersion;
    }

    private static String getKey(WinReg.HKEY hkey, String key, String value) {
        try {
            String keyValue = Advapi32Util.registryGetStringValue((WinReg.HKEY)hkey, (String)key, (String)value);
            if (keyValue != null && !keyValue.isEmpty()) {
                return keyValue;
            }
        }
        catch (Win32Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    private static boolean isVersionGreaterEqual(String version, String of) {
        String ver1 = version;
        String ver2 = of;
        while (!ver1.isEmpty() && !ver2.isEmpty()) {
            int n2;
            int n1;
            int dotIndex = ver1.indexOf(".");
            if (dotIndex > 0) {
                n1 = Integer.parseInt(ver1.substring(0, dotIndex));
                ver1 = ver1.substring(dotIndex + 1);
            } else if (!ver1.isEmpty()) {
                n1 = Integer.parseInt(ver1);
                ver1 = "";
            } else {
                n1 = 0;
            }
            dotIndex = ver2.indexOf(".");
            if (dotIndex > 0) {
                n2 = Integer.parseInt(ver2.substring(0, dotIndex));
                ver2 = ver2.substring(dotIndex + 1);
            } else if (!ver2.isEmpty()) {
                n2 = Integer.parseInt(ver2);
                ver2 = "";
            } else {
                n2 = 0;
            }
            if (n1 >= n2) continue;
            return false;
        }
        return true;
    }

    public static void shutdown() {
        if (display != null) {
            display.dispose();
        }
    }

    @Override
    protected void initialize(final BaseController controller, View parent, String title, byte[] image, View.ModalType modalType, Region viewArea, Region dragArea, boolean decorated, boolean resizable, boolean onTop) throws Exception {
        this.controller = controller;
        this.resizable = resizable;
        this.decorated = decorated;
        controller.setView(this);
        if (display == null) {
            throw new Exception("Display not present, call startUIThread first");
        }
        display.syncExec(() -> {
            int bitMask = decorated ? 1264 : 8;
            if (!resizable) {
                bitMask &= 0xFFFFFFEF;
                bitMask &= 0xFFFFFBFF;
            }
            if (onTop) {
                bitMask |= 0x4000;
            }
            if (modalType != null && modalType != View.ModalType.NONE) {
                bitMask |= modalType.equals((Object)View.ModalType.PARENT_MODAL) ? 32768 : 65536;
            }
            this.shell = parent != null ? new Shell((Shell)parent.getWindow(), bitMask) : new Shell(display, bitMask);
            if (image != null) {
                this.shell.setImage(new Image((Device)display, new ByteArrayInputStream(image)));
            }
            this.shellInnerCurrentWidth = this.minWidth = viewArea.getWidth();
            this.shellInnerCurrentHeight = this.minHeight = viewArea.getHeight();
            this.shell.setBounds(viewArea.getX(), viewArea.getY(), this.minWidth, this.minHeight + this.titleBarHeight);
            this.shell.setMinimumSize(this.minWidth, this.minHeight);
            this.shell.setText(title);
            if (Platform.isMac()) {
                this.addMacOSMenuListeners();
            }
            this.shell.addListener(11, new esecurity.desktop.swt.Listener(){

                @Override
                public void handleEvent(Event e) {
                    Rectangle rect = SWTView.this.shell.getClientArea();
                    SWTView.this.browser.setSize(rect.width, rect.height);
                    double widthRatio = SWTView.this.shellInnerCurrentWidth == 0 ? 0.0 : (double)rect.width / (double)SWTView.this.shellInnerCurrentWidth;
                    double heightRatio = SWTView.this.shellInnerCurrentHeight == 0 ? 0.0 : (double)rect.height / (double)SWTView.this.shellInnerCurrentHeight;
                    SWTView.this.shellInnerCurrentWidth = rect.width;
                    SWTView.this.shellInnerCurrentHeight = rect.height;
                    SWTView.this.dragAndDropComposite.setSize(SWTView.this.shellInnerCurrentWidth, SWTView.this.shellInnerCurrentHeight);
                    if (SWTView.this.resizer != null) {
                        SWTView.this.resizer.updatePosition(SWTView.this.shellInnerCurrentWidth, SWTView.this.shellInnerCurrentHeight);
                    }
                    if (!SWTView.this.dropInnerAreas.isEmpty()) {
                        try {
                            for (DragAndDropInnerArea dadia : SWTView.this.dropInnerAreas.keySet()) {
                                dadia.resizeView(new Point2D.Double(widthRatio, heightRatio));
                            }
                        }
                        catch (Throwable t) {
                            logger.error(t.getMessage(), t);
                        }
                    }
                    if (SWTView.this.onResize != null) {
                        SWTView.this.onResize.run();
                    }
                }
            });
            this.dragAndDropComposite = new Composite(this.shell, 0x40000000);
            if (!System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                this.dragAndDropComposite.setBackgroundImage(new Image((Device)display, this.getClass().getResourceAsStream("/transparent.png")));
            }
            this.dragAndDropComposite.setLocation(0, 0);
            this.dragAndDropComposite.setSize(this.minWidth, this.minHeight);
            this.dragAndDropComposite.addMouseTrackListener(new esecurity.desktop.swt.Listener(){

                @Override
                public void handleEvent(Event e) {
                    if (!SWTView.this.dragIn) {
                        SWTView.this.onDragEnd();
                    }
                }
            }, null, null);
            if (!decorated && resizable) {
                this.resizer = new SWTViewResizer(this.shell, display, this.minWidth, this.minHeight);
            }
            if (dragArea != null) {
                this.setDragArea(dragArea);
                if (!decorated && resizable && this.resizer != null) {
                    this.resizer.moveAbove(this.windowDragComposite);
                }
            }
            this.setDropTarget();
            try {
                this.browser = System.getProperty("org.eclipse.swt.browser.XULRunnerPath", "").equals("") ? new Browser(this.shell, 0) : new Browser(this.shell, 32768);
                this.browser.addProgressListener(new ProgressAdapter(){

                    @Override
                    public void completed(ProgressEvent event) {
                        logger.debug("Browser page loading completed");
                        if (Platform.isLinux()) {
                            SWTView.this.evaluate("controller_" + controller.getId() + "_viewOnLoad();");
                        }
                    }
                });
                new Thread(() -> {
                    KeyPressListener keyPressListener = new KeyPressListener();
                    display.syncExec(() -> this.browser.addKeyListener(null, keyPressListener));
                }).start();
                this.registerJsMethod("controller_" + controller.getId() + "_viewOnLoad", controller);
                String html = ResUtils.composeHtml(controller, true, this.documentStyles).outerHtml();
                if (Platform.isLinux()) {
                    Path htmlFilePath = Files.createTempFile("page", ".html", new FileAttribute[0]);
                    logger.debug("Platform is Linux, create file: " + htmlFilePath.toString());
                    try (FileOutputStream fos = new FileOutputStream(htmlFilePath.toFile());){
                        fos.write(html.getBytes());
                    }
                    this.browser.setUrl("file://" + htmlFilePath.toString());
                    htmlFilePath.toFile().deleteOnExit();
                } else if (!this.browser.setText(html)) {
                    throw new Exception("Error in browser setText");
                }
                this.browser.setSize(this.minWidth, this.minHeight);
                String br = (String)this.browser.evaluate("var ua = navigator.userAgent, tem, M = ua.match(/(opera|chrome|safari|firefox|msie|trident(?=\\/))\\/?\\s*(\\d+)/i) || []; if (/trident/i.test(M[1])) { tem = /\\brv[ :]+(\\d+)/g.exec(ua) || []; return 'IE ' + (tem[1] || ''); } if (M[1] === 'Chrome') { tem = ua.match(/\\b(OPR|Edge)\\/(\\d+)/); if (tem != null) return tem.slice(1).join(' ').replace('OPR', 'Opera'); } M = M[2] ? [M[1], M[2]] : [navigator.appName, navigator.appVersion, '-?']; if ((tem = ua.match(/version\\/(\\d+)/i)) != null) M.splice(1, 1, tem[1]); return M.join(' ');");
                if (br != null) {
                    logger.info(br);
                } else {
                    logger.info("Browser not recognized");
                }
            }
            catch (Exception th) {
                logger.error(th.getMessage(), (Throwable)th);
                display.dispose();
            }
        });
    }

    private void addMacOSMenuListeners() {
        try {
            Menu systemMenu = Display.getDefault().getSystemMenu();
            for (MenuItem menuItem : systemMenu.getItems()) {
                if (menuItem.getID() != -6) continue;
                menuItem.addListener(13, new esecurity.desktop.swt.Listener(){

                    @Override
                    public void handleEvent(Event e) {
                        SWTView.this.shell.close();
                    }
                });
                return;
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    private void setDragArea(Region dragArea) {
        this.windowDragComposite = new Composite(this.shell, 0x40000000);
        this.windowDragComposite.setLocation(dragArea.getX(), dragArea.getY());
        this.windowDragComposite.setSize(dragArea.getWidth(), dragArea.getHeight());
        if (!System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            this.windowDragComposite.setBackgroundImage(new Image((Device)display, this.getClass().getResourceAsStream("/transparent.png")));
        }
        this.windowDragComposite.addListener(3, new esecurity.desktop.swt.Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTView.this.offsetX = (int)MouseInfo.getPointerInfo().getLocation().getX();
                SWTView.this.offsetY = (int)MouseInfo.getPointerInfo().getLocation().getY();
                SWTView.this.dragWindow = true;
            }
        });
        if (this.resizable) {
            this.windowDragComposite.addListener(8, new esecurity.desktop.swt.Listener(){

                @Override
                public void handleEvent(Event e) {
                    SWTView.this.toggleMaximization();
                }
            });
        }
        this.windowDragComposite.addListener(5, new esecurity.desktop.swt.Listener(){

            @Override
            public void handleEvent(Event e) {
                if (SWTView.this.dragWindow) {
                    if (((Boolean)SWTView.this.isMaximized.getValue()).booleanValue()) {
                        SWTView.this.toggleMaximization();
                    }
                    if (SWTView.this.resizer != null) {
                        SWTView.this.resizer.enable();
                    }
                    int x = (int)MouseInfo.getPointerInfo().getLocation().getX();
                    int y = (int)MouseInfo.getPointerInfo().getLocation().getY();
                    SWTView.this.shell.setLocation(((SWTView)SWTView.this).shell.getLocation().x + (x - SWTView.this.offsetX), ((SWTView)SWTView.this).shell.getLocation().y + (y - SWTView.this.offsetY));
                    SWTView.this.offsetX = x;
                    SWTView.this.offsetY = y;
                }
            }
        });
        this.windowDragComposite.addListener(4, new esecurity.desktop.swt.Listener(){

            @Override
            public void handleEvent(Event e) {
                SWTView.this.dragWindow = false;
            }
        });
    }

    private void setDropTarget() {
        DropTarget dt = new DropTarget(this.dragAndDropComposite, 23);
        dt.setTransfer(FileTransfer.getInstance());
        dt.addDropListener(new DropTargetAdapter(){

            @Override
            public void dragEnter(DropTargetEvent dte) {
                block5: {
                    try {
                        if (!SWTView.this.dragAndDropEnabled) break block5;
                        try {
                            if (SWTView.this.dragAndDropMouseMonitor != null) {
                                SWTView.this.dragAndDropMouseMonitor.cancel(true);
                            }
                        }
                        catch (Throwable t) {
                            logger.error(t.getMessage(), t);
                        }
                        SWTView.this.dragIn = true;
                        new Thread(() -> {
                            try {
                                if (dte.operations == 5) {
                                    SWTView.this.onDragError();
                                } else {
                                    SWTView.this.controller.onDragEnter();
                                }
                            }
                            catch (Throwable t) {
                                logger.error(t.getMessage(), t);
                            }
                        }).start();
                    }
                    catch (Throwable t) {
                        logger.error(t.getMessage(), t);
                    }
                }
            }

            @Override
            public void dragOver(DropTargetEvent dte) {
                try {
                    if (SWTView.this.dragAndDropEnabled && SWTView.this.dragIn && dte.operations != 5 && !SWTView.this.dropInnerAreas.isEmpty()) {
                        Rectangle bound = SWTView.this.shell.getBounds();
                        int absoluteMouseX = (int)MouseInfo.getPointerInfo().getLocation().getX();
                        int absoluteMouseY = (int)MouseInfo.getPointerInfo().getLocation().getY();
                        int relativeMouseX = absoluteMouseX - bound.x - (bound.width - ((SWTView)SWTView.this).shell.getClientArea().width) / 2;
                        int relativeMouseY = absoluteMouseY - bound.y - SWTView.this.titleBarHeight;
                        for (Map.Entry entry : SWTView.this.dropInnerAreas.entrySet()) {
                            boolean isIn = ((DragAndDropInnerArea)entry.getKey()).contains(relativeMouseX, relativeMouseY);
                            if (isIn && !((Boolean)entry.getValue()).booleanValue()) {
                                new Thread(() -> ((DragAndDropInnerArea)dropInnerArea.getKey()).dragEnter()).start();
                            } else if (((Boolean)entry.getValue()).booleanValue() && !isIn) {
                                new Thread(() -> ((DragAndDropInnerArea)dropInnerArea.getKey()).dragLeave()).start();
                            }
                            entry.setValue(isIn);
                        }
                    }
                }
                catch (Throwable t) {
                    logger.error(t.getMessage(), t);
                }
            }

            @Override
            public void dragLeave(DropTargetEvent dte) {
                new Thread(() -> {
                    try {
                        display.syncExec(() -> SWTView.this.dragAndDropComposite.moveBelow(SWTView.this.browser));
                        SWTView.this.dragIn = false;
                        try {
                            SWTView.this.controller.onDragLeave();
                        }
                        catch (Throwable t) {
                            logger.error(t.getMessage(), t);
                        }
                    }
                    catch (Throwable t) {
                        logger.error(t.getMessage(), t);
                    }
                }).start();
            }

            @Override
            public void drop(DropTargetEvent dte) {
                try {
                    if (SWTView.this.dragAndDropEnabled && dte.operations != 5 && FileTransfer.getInstance().isSupportedType(dte.currentDataType)) {
                        String[] fileList = (String[])dte.data;
                        JsonArray jarray = new JsonArray();
                        for (String file : fileList) {
                            jarray.add(file);
                        }
                        JsonObject el = new JsonObject();
                        el.addProperty("type", "filedrop");
                        el.addProperty("callerId", "document");
                        el.add("fileList", (JsonElement)jarray);
                        try {
                            esecurity.desktop.Event droptEvent = new esecurity.desktop.Event(el.toString());
                            new Thread(() -> {
                                try {
                                    SWTView.this.controller.onDropEvent(droptEvent);
                                }
                                catch (Throwable t) {
                                    logger.error(t.getMessage(), t);
                                }
                            }).start();
                        }
                        catch (IOException ex) {
                            logger.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                    SWTView.this.dragAndDropComposite.moveBelow(SWTView.this.browser);
                    SWTView.this.dragIn = false;
                }
                catch (Throwable t) {
                    logger.error(t.getMessage(), t);
                }
            }
        });
    }

    @Override
    public void show() {
        display.syncExec(() -> {
            this.shell.open();
            this.shell.forceActive();
            this.dragAndDropComposite.moveBelow(this.browser);
            Rectangle shellBounds = this.shell.getBounds();
            Rectangle shellClientArea = this.shell.getClientArea();
            this.titleBarHeight = shellBounds.height - shellClientArea.height - (shellBounds.width - shellClientArea.width) / 2;
            this.shell.setMinimumSize(this.minWidth, this.minHeight + this.titleBarHeight);
            this.shell.setSize(this.shellInnerCurrentWidth, this.shellInnerCurrentHeight + this.titleBarHeight);
        });
    }

    @Override
    public void close() {
        display.syncExec(() -> this.shell.close());
    }

    @Override
    public Object evaluate(String expression) {
        Object[] ret = new Object[1];
        display.syncExec(() -> {
            Object[] objectArray = ret;
            synchronized (ret) {
                ret[0] = this.browser.evaluate(expression);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        });
        return ret[0];
    }

    @Override
    public void registerJsMethod(String name, BaseController controller) {
        final BaseController controllerFinal = controller;
        final Method methodFinal = controller.getJsMethod(name);
        display.syncExec(() -> {
            BrowserFunction function = new BrowserFunction(this.browser, name){

                @Override
                public Object function(Object[] arguments) {
                    try {
                        if (methodFinal.getParameterTypes().length == arguments.length) {
                            return methodFinal.invoke((Object)controllerFinal, arguments);
                        }
                        logger.info("Numero di argomenti errato per il methodo --> " + methodFinal.getName());
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                        logger.error(ex.getMessage(), (Throwable)ex);
                    }
                    return null;
                }
            };
        });
    }

    @Override
    public void enableDropEvent() {
        display.syncExec(() -> {
            this.execute("document.getElementsByTagName(\"body\")[0].setAttribute(\"ondragenter\", \"controller_" + this.controller.getId() + "_onJSDragEnter()\");");
            this.execute("document.getElementsByTagName(\"body\")[0].setAttribute(\"ondragend\", \"controller_" + this.controller.getId() + "_onJSDragEnd()\");");
        });
    }

    @Override
    public final void onDragEnter() {
        display.syncExec(() -> {
            this.dragAndDropComposite.moveAbove(this.browser);
            this.dragAndDropMouseMonitor = this.dragAndDropMouseMonitorExecutor.scheduleAtFixedRate(() -> {
                int mouseX = (int)MouseInfo.getPointerInfo().getLocation().getX();
                int mouseY = (int)MouseInfo.getPointerInfo().getLocation().getY();
                boolean[] contain = new boolean[]{false};
                display.syncExec(() -> {
                    contain[0] = this.shell.getBounds().contains(mouseX, mouseY);
                });
                if (!contain[0]) {
                    this.onDragEnd();
                    this.dragAndDropMouseMonitor.cancel(true);
                }
            }, 0L, 50L, TimeUnit.MILLISECONDS);
        });
    }

    @Override
    public final void onDragError() {
        this.controller.onDragError();
    }

    @Override
    public final void onDragEnd() {
        display.syncExec(() -> {
            this.dragAndDropComposite.moveBelow(this.browser);
            this.dragIn = false;
        });
    }

    @Override
    public Object getWindow() {
        return this.shell;
    }

    @Override
    public void forceActive() {
        display.asyncExec(() -> {
            if (Platform.isWindows()) {
                this.forceActiveWIN();
                return;
            }
            this.shell.forceActive();
        });
    }

    public void forceActiveWIN() {
        long hFrom = WIN_OS.GetForegroundWindow();
        long shellHandle = this.shell.getHandle();
        if (hFrom <= 0L) {
            WIN_OS.SetForegroundWindow(shellHandle);
            return;
        }
        if (shellHandle == hFrom) {
            return;
        }
        int pid = WIN_OS.GetWindowThreadProcessId(hFrom, null);
        int _threadid = WIN_OS.GetWindowThreadProcessId(shellHandle, null);
        if (_threadid == pid) {
            WIN_OS.SetForegroundWindow(shellHandle);
            return;
        }
        if (pid > 0) {
            if (!WIN_OS.AttachThreadInput(_threadid, pid, true)) {
                return;
            }
            WIN_OS.SetForegroundWindow(shellHandle);
            WIN_OS.AttachThreadInput(_threadid, pid, false);
        }
        WIN_OS.BringWindowToTop(shellHandle);
        WIN_OS.UpdateWindow(shellHandle);
        WIN_OS.SetActiveWindow(shellHandle);
    }

    @Override
    public void setActive() {
        display.asyncExec(this.shell::setActive);
    }

    @Override
    public void execute(String expression) {
        long thId = Thread.currentThread().getId();
        if (this.bufferedPerThread.containsKey(thId) && ((Boolean)this.bufferedPerThread.get(thId)).booleanValue()) {
            if (!this.javascriptCallsPerThread.containsKey(thId)) {
                this.javascriptCallsPerThread.put(thId, new ArrayDeque());
            }
            ((ArrayDeque)this.javascriptCallsPerThread.get(thId)).add(expression);
        } else {
            display.syncExec(() -> this.browser.execute(expression));
        }
    }

    @Override
    public void stopBuffering() {
        long thId = Thread.currentThread().getId();
        if (this.bufferedPerThread.containsKey(thId) && ((Boolean)this.bufferedPerThread.get(thId)).booleanValue()) {
            StringBuilder builder = new StringBuilder();
            for (String jsCall : (ArrayDeque)this.javascriptCallsPerThread.get(thId)) {
                builder.append(jsCall);
                builder.append("; ");
            }
            display.syncExec(() -> this.browser.execute(builder.toString()));
            ((ArrayDeque)this.javascriptCallsPerThread.get(thId)).clear();
            this.bufferedPerThread.put(thId, Boolean.FALSE);
        }
    }

    @Override
    public void onClose(final Listener<esecurity.desktop.Event> listener) {
        display.syncExec(() -> this.shell.addListener(21, new esecurity.desktop.swt.Listener(){

            @Override
            public void handleEvent(Event e) {
                listener.notify(new esecurity.desktop.Event(e));
            }
        }));
    }

    @Override
    public void onShow(final Listener<esecurity.desktop.Event> listener) {
        display.syncExec(() -> this.shell.addListener(22, new esecurity.desktop.swt.Listener(){

            @Override
            public void handleEvent(Event e) {
                listener.notify(new esecurity.desktop.Event(e));
            }
        }));
    }

    @Override
    public void setDimension(int width, int height) {
        display.syncExec(() -> {
            this.shell.setSize(width, height + this.titleBarHeight);
            if (this.shell.getClientArea().height != height) {
                this.shell.setSize(width, height + this.titleBarHeight + (height - this.shell.getClientArea().height));
            }
        });
    }

    @Override
    public void setMinDimension(int width, int height) {
        this.minWidth = width;
        this.minHeight = height;
        if (this.resizer != null) {
            this.resizer.setMinDimension(this.minWidth, this.minHeight);
        }
        display.syncExec(() -> this.shell.setMinimumSize(this.minWidth, this.minHeight + this.titleBarHeight));
    }

    @Override
    public boolean isVisible() {
        return this.shell.isVisible();
    }

    @Override
    public void setVisible(boolean visible) {
        display.syncExec(() -> this.shell.setVisible(visible));
    }

    @Override
    public void maximize() {
        display.syncExec(() -> {
            if (this.decorated) {
                this.shell.setMaximized(true);
            } else {
                this.shell.setBounds(display.getPrimaryMonitor().getClientArea());
            }
        });
    }

    @Override
    public void minimize(boolean minimize) {
        display.syncExec(() -> this.shell.setMinimized(minimize));
    }

    @Override
    public int getInnerCurrentWidth() {
        return this.shellInnerCurrentWidth;
    }

    @Override
    public int getInnerCurrentHeight() {
        return this.shellInnerCurrentHeight;
    }

    @Override
    public void onResize(Runnable runnable) {
        this.onResize = runnable;
    }

    @Override
    public void redraw() {
        display.syncExec(() -> this.browser.redraw());
    }

    @Override
    public void setDraggableDimension(int width, int height) {
        this.dragAndDropComposite.setSize(width, height);
    }

    @Override
    public void setDraggableBarDimension(int width, int height) {
        this.windowDragComposite.setSize(width, height);
    }

    @Override
    public void setTitle(String title) {
        display.syncExec(() -> this.shell.setText(title));
    }

    @Override
    public String getTitle() {
        String[] s = new String[1];
        display.syncExec(() -> {
            s[0] = this.shell.getText();
        });
        return s[0];
    }

    @Override
    public int getShellWidth() {
        int[] s = new int[1];
        display.syncExec(() -> {
            s[0] = this.shell.getBounds().width;
        });
        return s[0];
    }

    @Override
    public int getShellHeight() {
        int[] s = new int[1];
        display.syncExec(() -> {
            s[0] = this.shell.getBounds().height;
        });
        return s[0];
    }

    @Override
    public void setLocation(int x, int y) {
        this.shell.setLocation(x, y);
    }

    @Override
    public Point getLocation() {
        return this.shell.getLocation();
    }

    @Override
    public void toggleMaximization() {
        if (!this.isMaximized.getValue().booleanValue()) {
            this.prevWidth = this.shell.getBounds().width;
            this.prevHeight = this.shell.getBounds().height;
            this.maximize();
            this.isMaximized.setValue(true);
            if (this.resizer != null) {
                this.resizer.disable();
            }
        } else {
            this.setDimension(this.prevWidth, this.prevHeight);
            this.isMaximized.setValue(false);
            if (this.resizer != null) {
                this.resizer.enable();
            }
        }
    }

    @Override
    public void onMaximizationChange(final Runnable run) {
        ObservableListener<Boolean> listener = new ObservableListener<Boolean>(){

            @Override
            protected void run(Boolean value) {
                run.run();
            }
        };
        this.isMaximized.addListener(listener);
    }

    @Override
    public boolean isMaximized() {
        return this.isMaximized.getValue();
    }

    @Override
    public void centerOnScreen() {
        display.syncExec(() -> {
            Monitor[] monitors = display.getMonitors();
            if (monitors == null || monitors.length == 0 || this.shell == null) {
                return;
            }
            Point location = this.shell.getLocation();
            for (Monitor m : monitors) {
                Rectangle area = m.getClientArea();
                if (location.x < area.x || location.x > area.x + area.width || location.y < area.y || location.y > area.y + area.height) continue;
                this.shell.setLocation(area.x + area.width / 2 - this.shellInnerCurrentWidth / 2, area.y + area.height / 2 - this.shellInnerCurrentHeight / 2);
                break;
            }
        });
    }

    public Shell getShell() {
        return this.shell;
    }

    @Override
    public void removeDragAndDropInnerArea(DragAndDropInnerArea dropInnerArea) {
        this.dropInnerAreas.remove(dropInnerArea);
    }

    @Override
    public void addDragAndDropInnerArea(DragAndDropInnerArea dropInnerArea) {
        this.dropInnerAreas.put(dropInnerArea, false);
    }

    @Override
    public List<String> getDocumentStyles() {
        return this.documentStyles;
    }
}

