/*
 * Decompiled with CFR 0.152.
 */
package it.actalis.ellips.capi.xml.parser;

import esecurity.dts.TimeStampToken;
import esecurity.validator.parser.utils.EventHandlerMultiSelector;
import esecurity.validator.parser.utils.EventHandlerSelector;
import esecurity.validator.parser.utils.OcspUtils;
import esecurity.validator.parser.utils.SignerInfoUtils;
import esecurity.validator.xades.bean.XadesSignerInfoData;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.http.HttpsClient;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.util.RFC4519InternalStyle;
import it.actalis.ellips.capi.xml.DOMSubTreeData;
import it.actalis.ellips.capi.xml.InternalKeySelector;
import it.actalis.ellips.capi.xml.InternalUriDereferencer;
import it.actalis.ellips.capi.xml.parser.a;
import it.actalis.ellips.capi.xml.parser.b;
import it.actalis.ellips.capi.xml.utils.XMLUtils;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ProgressMonitor;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class SignedXMLEnvelope {
    private static final Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static XMLSignatureFactory b = XMLUtils.getXMLSignatureFactoryInstance();
    public static final int ENVELOPED = 1;
    public static final int ENVELOPING = 2;
    public static final int DETACHED = 3;
    public static final int CANONIC_INCLUDE = 4;
    public static final int CANONIC_EXCLUDE = 5;
    private LinkedList<X509Certificate> c = new LinkedList();
    private HashMap<Integer, LinkedList<X509Certificate>> d = new HashMap();
    private HashMap<Integer, LinkedList<CRL>> e = new HashMap();
    private HashMap<Integer, LinkedList<BasicOCSPResp>> f = new HashMap();
    private InternalUriDereferencer g;
    private NamespaceContext h = null;
    private Document i = null;
    private String[] j = null;
    private boolean[] k = null;
    private boolean[] l = null;
    private String[] m = null;
    private String[] n = null;
    private String[] o = null;
    private BigInteger[] p = null;
    private ItemList[] q = null;
    private Element[][] r = null;
    private String[] s = null;
    private Node[] t = null;
    private String[] u = null;
    private String[] v = null;
    private String[] w = null;
    private String[] x = null;
    private boolean[] y = null;
    private boolean[][] z = null;
    private Reference[][] A;
    private boolean[] B = null;
    private int C = 5;
    private int D = 0;
    private String[] E = null;
    private String[] F = null;
    private String[] G = null;
    private String[] H = null;
    private String[] I = null;
    private NodeList J = null;
    private String K = null;
    protected int signerIndexToBeCSigned = 0;
    private XMLSignature L = null;
    protected Element counterSignatureElem = null;
    private int M = -1;

    public SignedXMLEnvelope(InputHandler inputHandler, String string, HttpsClient httpsClient, ProgressMonitor progressMonitor, String[] stringArray) throws CapiException {
        this(inputHandler, string, httpsClient, progressMonitor, stringArray, null, null);
    }

    public SignedXMLEnvelope(InputHandler inputHandler, String object, HttpsClient object2, ProgressMonitor object3, String[] stringArray, EventHandlerSelector eventHandlerSelector, InternalUriDereferencer internalUriDereferencer) throws CapiException {
        if (object != null) {
            this.setBaseURI((String)object);
        }
        this.M = -1;
        if (a.isDebugEnabled()) {
            this.print("done init..");
        }
        if (a.isDebugEnabled()) {
            this.print("loading XML envelope...");
        }
        try {
            object = DocumentBuilderFactory.newInstance();
            try {
                ((DocumentBuilderFactory)object).setNamespaceAware(true);
                ((DocumentBuilderFactory)object).setFeature("http://xml.org/sax/features/external-general-entities", false);
                ((DocumentBuilderFactory)object).setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                ((DocumentBuilderFactory)object).setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                ((DocumentBuilderFactory)object).setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                if (a.isDebugEnabled()) {
                    a.debug(parserConfigurationException.getMessage(), (Throwable)parserConfigurationException);
                }
                throw new CapiException("XML SAXNotRecognized", 50040);
            }
            try {
                object = ((DocumentBuilderFactory)object).newDocumentBuilder();
                this.i = ((DocumentBuilder)object).parse(inputHandler.getInputAsNewStream());
                if (this.g == null) {
                    this.g = new InternalUriDereferencer((HttpsClient)object2, eventHandlerSelector, (DocumentBuilder)object);
                    this.g.setDocument(inputHandler);
                } else {
                    this.g = internalUriDereferencer;
                }
            }
            catch (Exception exception) {
                if (a.isDebugEnabled()) {
                    a.debug(exception.getMessage(), (Throwable)exception);
                }
                throw new CapiException("Envelope format unknown or not implemented", 50023);
            }
            object = this.i.getElementsByTagName("*");
            for (int i = 0; i < object.getLength(); ++i) {
                object2 = (Element)object.item(i);
                object3 = object2.getAttribute("Id");
                if (object3 != null && !((String)object3).equals("")) {
                    object2.setIdAttribute("Id", true);
                    continue;
                }
                object3 = object2.getAttribute("ID");
                if (object3 == null || ((String)object3).equals("")) continue;
                object2.setIdAttribute("ID", true);
            }
            String string = this.i.getDocumentElement().getAttribute("Id");
            if (string != null && !string.equals("")) {
                this.i.getDocumentElement().setIdAttribute("Id", true);
            }
            object2 = this.i.getElementsByTagName("xades:SignedProperties");
            for (int i = 0; i < object2.getLength(); ++i) {
                string = ((Element)object2.item(i)).getAttribute("Id");
                if (string == null || string.equals("")) continue;
                ((Element)object2.item(i)).setIdAttribute("Id", true);
            }
            NodeList nodeList = this.i.getElementsByTagName("SignedProperties");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                object = ((Element)nodeList.item(i)).getAttribute("Id");
                if (object == null || ((String)object).equals("")) continue;
                ((Element)nodeList.item(i)).setIdAttribute("Id", true);
            }
            Object object4 = this.i.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "SignedProperties");
            for (int i = 0; i < object4.getLength(); ++i) {
                object2 = ((Element)object4.item(i)).getAttribute("Id");
                if (object2 == null || ((String)object2).equals("")) continue;
                ((Element)object4.item(i)).setIdAttribute("Id", true);
            }
            Object object5 = this.i.getElementsByTagName("ds:Object");
            for (int i = 0; i < object5.getLength(); ++i) {
                object4 = ((Element)object5.item(i)).getAttribute("Id");
                if (object4 == null || ((String)object4).equals("")) continue;
                ((Element)object5.item(i)).setIdAttribute("Id", true);
            }
            Object object6 = this.i.getElementsByTagName("ds:KeyInfo");
            for (int i = 0; i < object6.getLength(); ++i) {
                object5 = ((Element)object6.item(i)).getAttribute("Id");
                if (object5 == null || ((String)object5).equals("")) continue;
                ((Element)object6.item(i)).setIdAttribute("Id", true);
            }
            Object object7 = this.i.getElementsByTagName("Revision");
            for (int i = 0; i < object7.getLength(); ++i) {
                object6 = ((Element)object7.item(i)).getAttribute("ID");
                if (object6 == null || ((String)object6).equals("")) continue;
                ((Element)object7.item(i)).setIdAttribute("ID", true);
            }
            Object object8 = this.i.getElementsByTagName("Atto").item(0);
            if (object8 != null) {
                object6 = ((Element)object8).getAttribute("ID");
                if (object6 != null && !((String)object6).equals("")) {
                    ((Element)object8).setIdAttribute("ID", true);
                }
            } else {
                String string2;
                object7 = this.i.getElementsByTagName("Revision");
                for (int i = 0; i < object7.getLength(); ++i) {
                    object8 = ((Element)object7.item(i)).getAttribute("ID");
                    if (object8 == null || ((String)object8).equals("")) continue;
                    ((Element)object7.item(i)).setIdAttribute("ID", true);
                }
                object8 = this.i.getElementsByTagName("Atto").item(0);
                if (object8 != null && (string2 = ((Element)object8).getAttribute("ID")) != null && !string2.equals("")) {
                    ((Element)object8).setIdAttribute("ID", true);
                }
            }
            SignedXMLEnvelope signedXMLEnvelope = this;
            object8 = signedXMLEnvelope.i;
            object7 = signedXMLEnvelope;
            signedXMLEnvelope.a((Node)object8);
            this.h = new b(this);
            try {
                XPath xPath = XPathFactory.newInstance().newXPath();
                xPath.setNamespaceContext(this.h);
                object8 = xPath.compile("//ds:Signature[not(ancestor::ds:Signature)]");
                this.J = (NodeList)object8.evaluate(this.i, XPathConstants.NODESET);
            }
            catch (XPathExpressionException xPathExpressionException) {
                throw new CapiException("XPathExpressionException getting Signature Nodes", 50001);
            }
            if (this.J.getLength() == 0) {
                throw new CapiException("Envelope not signed", 50001);
            }
            SignedXMLEnvelope signedXMLEnvelope2 = this;
            signedXMLEnvelope2.a(signedXMLEnvelope2.J, eventHandlerSelector);
            this.M = 3;
            return;
        }
        catch (CapiException capiException) {
            object = capiException;
            throw capiException;
        }
    }

    public SignedXMLEnvelope(InputHandler inputHandler, String string, HttpsClient httpsClient) throws CapiException {
        this(inputHandler, string, httpsClient, null, null);
    }

    public SignedXMLEnvelope(InputHandler inputHandler, String string) throws CapiException {
        this(inputHandler, string, null);
    }

    public SignedXMLEnvelope(InputHandler inputHandler, HttpsClient httpsClient) throws CapiException {
        this(inputHandler, null, httpsClient);
    }

    public SignedXMLEnvelope(InputHandler inputHandler) throws CapiException {
        this(inputHandler, null, null);
    }

    public SignedXMLEnvelope(InputHandler inputHandler, InternalUriDereferencer internalUriDereferencer) throws CapiException {
        this(inputHandler, null, null, null, null, null, internalUriDereferencer);
    }

    public SignedXMLEnvelope(InputHandler inputHandler, EventHandlerSelector eventHandlerSelector) throws CapiException {
        this(inputHandler, null, null, null, null, eventHandlerSelector, null);
    }

    private void a(Node object) {
        switch (object.getNodeType()) {
            case 7: {
                this.a((ProcessingInstruction)object);
            }
        }
        object = object.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            this.a(object.item(i));
        }
    }

    private void a(ProcessingInstruction object) {
        if (a.isDebugEnabled()) {
            this.print("[dumpProcesssInstruction] PI: target=" + object.getTarget());
        }
        if (a.isDebugEnabled()) {
            this.print("[dumpProcesssInstruction] PI: data=" + object.getData());
        }
        if (object.getTarget().startsWith("xml-stylesheet")) {
            int n;
            Node node = object.getParentNode();
            if (node != null) {
                node.getNodeType();
            }
            if ((n = object.getData().indexOf("href=")) < 0) {
                if (a.isDebugEnabled()) {
                    this.print("[dumpProcesssInstruction] error parsing stylesheet href");
                }
                return;
            }
            n = ((String)(object = object.getData().substring(n + 5))).indexOf("\"");
            if (n < 0) {
                if (a.isDebugEnabled()) {
                    this.print("[dumpProcesssInstruction] error parsing stylesheet href");
                }
                return;
            }
            int n2 = ((String)object).indexOf("\"", n + 1);
            if (n2 <= n + 1) {
                if (a.isDebugEnabled()) {
                    this.print("[dumpProcesssInstruction] error parsing stylesheet href");
                }
                return;
            }
            this.K = ((String)object).substring(n + 1, n2);
            if (a.isDebugEnabled()) {
                this.print("[dumpProcesssInstruction] stylesheet href setted to: " + this.K);
            }
        }
    }

    SignedXMLEnvelope(Document object, int n, Element object2, NodeList nodeList) throws CapiException {
        this.i = object;
        this.signerIndexToBeCSigned = n;
        object = new DOMValidateContext(new InternalKeySelector(this.i), (Node)object2);
        try {
            this.L = b.unmarshalXMLSignature((XMLValidateContext)object);
        }
        catch (MarshalException marshalException) {
            if (a.isDebugEnabled()) {
                a.debug(marshalException.getMessage(), (Throwable)marshalException);
            }
            throw new CapiException("XMLSignatureException", 50025);
        }
        this.M = -1;
        this.J = nodeList;
        if (a.isDebugEnabled()) {
            this.print("done init..");
        }
        if (a.isDebugEnabled()) {
            this.print("loading XML node list...");
        }
        if (nodeList != null && nodeList.getLength() > 0) {
            try {
                this.a(nodeList, null);
            }
            catch (CapiException capiException) {
                if (a.isDebugEnabled()) {
                    a.debug(capiException.getMessage(), (Throwable)capiException);
                }
                throw capiException;
            }
        }
        object = null;
        try {
            Object object3 = this.L.getId();
            if (object3 == null || ((String)object3).equals("")) {
                object3 = "Signer-N-" + this.signerIndexToBeCSigned;
                object2.setAttributeNS(null, "Id", (String)object3);
            }
            object2 = this.b((Node)object2, "ds:Object");
            int n2 = object2.getLength();
            for (int i = 0; i < n2 && (object = (Element)SignedXMLEnvelope.a(object2.item(i), "QualifyingProperties")) == null; ++i) {
            }
            if (object == null) {
                if (a.isDebugEnabled()) {
                    this.print("[init] ds:Object not found: creating now...");
                }
                object = this.i.createElement("xades:QualifyingProperties");
                object.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xades", "http://uri.etsi.org/01903/v1.3.2#");
                object.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                object.setAttribute("xsi:schemaLocation", "http://uri.etsi.org/01903/v1.3.2# http://uri.etsi.org/01903/v1.3.2/XAdES.xsd");
                object.setAttributeNS(null, "Target", "#" + (String)object3);
                Element element = this.i.createElement("xades:UnsignedProperties");
                object.appendChild(element);
                object3 = this.i.createElement("xades:UnsignedSignatureProperties");
                element.appendChild((Node)object3);
                this.counterSignatureElem = this.i.createElement("xades:CounterSignature");
                object3.appendChild(this.counterSignatureElem);
                object3 = new DOMStructure((Node)object);
                b.newXMLObject(Collections.singletonList(object3), null, null, null);
            } else {
                String string;
                object3 = object.getAttribute("xmlns");
                if (object3 != null && ((String)object3).compareToIgnoreCase("http://uri.etsi.org/01903/v1.3.2#") == 0) {
                    if (a.isDebugEnabled()) {
                        this.print("[init] QualifyingProperties has Default namespace URI: creating elements without prefix");
                    }
                    string = "";
                } else {
                    string = object.getPrefix();
                    string = string == null || string.compareTo("") == 0 ? "" : string + ":";
                }
                object3 = SignedXMLEnvelope.a((Node)object, "UnsignedProperties");
                if (object3 == null) {
                    if (a.isDebugEnabled()) {
                        this.print("[init] UnsignedProperties not found: creating now...");
                    }
                    object3 = this.i.createElement(string + "UnsignedProperties");
                    object.appendChild((Node)object3);
                    object = this.i.createElement(string + "UnsignedSignatureProperties");
                    object3.appendChild((Node)object);
                    this.counterSignatureElem = this.i.createElement(string + "CounterSignature");
                    object.appendChild(this.counterSignatureElem);
                } else {
                    object = SignedXMLEnvelope.a((Node)object3, "UnsignedSignatureProperties");
                    if (object == null) {
                        if (a.isDebugEnabled()) {
                            this.print("[init] UnsignedSignatureProperties not found: creating now...");
                        }
                        object = this.i.createElement(string + "UnsignedSignatureProperties");
                        object3.appendChild((Node)object);
                        this.counterSignatureElem = this.i.createElement(string + "CounterSignature");
                        object.appendChild(this.counterSignatureElem);
                    } else {
                        this.counterSignatureElem = this.i.createElement(string + "CounterSignature");
                        object.appendChild(this.counterSignatureElem);
                    }
                }
            }
            if (a.isDebugEnabled()) {
                this.print("[init] Empty CounterSignature element added");
            }
            this.M = 3;
            return;
        }
        catch (Exception exception) {
            if (a.isDebugEnabled()) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("CounterSignature encoding error", 50025);
        }
    }

    public SignedXMLEnvelope(int n) throws CapiException {
        this(n, null);
    }

    @Deprecated
    public SignedXMLEnvelope(int n, HttpsClient httpsClient) throws CapiException {
        this.M = -1;
        if (n != 2 && n != 1 && n != 3) {
            throw new CapiException("mode: " + n + " not allowed", 1002);
        }
        this.E = new String[this.C];
        this.I = new String[this.C];
        this.F = new String[this.C];
        this.G = new String[this.C];
        this.H = new String[this.C];
        this.M = 2;
        this.g = new InternalUriDereferencer(httpsClient, null, null);
    }

    public void setData(String string, String string2) throws CapiException {
        if (this.M != 2) {
            throw new CapiException("No signature mode specified", 50040);
        }
        if (string == null || string2 == null) {
            throw new CapiException("Null data", 1001);
        }
        if (string2.compareTo("UTF-8") != 0 && string2.compareTo("http://www.w3.org/2000/09/xmldsig#base64") != 0) {
            throw new CapiException("Invalid encoding", 1002);
        }
        if (a.isDebugEnabled()) {
            this.print("[setData] Mimetype: " + string);
        }
        if (a.isDebugEnabled()) {
            this.print("[setData] Encoding: " + string2);
        }
    }

    public void setBaseURI(String string) throws CapiException {
        if (string == null) {
            return;
        }
        try {
            new URL(string);
            return;
        }
        catch (Exception exception) {
            if (a.isDebugEnabled()) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("Invalid BaseURI", 1002);
        }
    }

    public void setCanonicOmitComm() throws CapiException {
        if (a.isDebugEnabled()) {
            this.print("[setCanonicOmitComm] done.");
        }
    }

    public void setCanonicWithComm() throws CapiException {
        if (a.isDebugEnabled()) {
            this.print("[setCanonicWithComm] done.");
        }
    }

    public void setTransfB64() throws CapiException {
        if (this.M != 2) {
            throw new CapiException("No signature mode specified", 50040);
        }
        if (this.D >= this.C) {
            throw new CapiException("Too many transforms", 50040);
        }
        this.E[this.D] = "http://www.w3.org/2000/09/xmldsig#base64";
        ++this.D;
        if (a.isDebugEnabled()) {
            this.print("[setTransfB64] done.");
        }
    }

    public void setTransfCanonicWithComm() throws CapiException {
        if (this.M != 2) {
            throw new CapiException("No signature mode specified", 50040);
        }
        if (this.D >= this.C) {
            throw new CapiException("Too many transforms", 50040);
        }
        this.E[this.D] = "http://www.w3.org/2006/12/xml-c14n11#WithComments";
        ++this.D;
        if (a.isDebugEnabled()) {
            this.print("[setTransfCanonicWithComm] done.");
        }
    }

    public void setTransfCanonicOmitComm() throws CapiException {
        if (this.M != 2) {
            throw new CapiException("No signature mode specified", 50040);
        }
        if (this.D >= this.C) {
            throw new CapiException("Too many transforms", 50040);
        }
        this.E[this.D] = "http://www.w3.org/2006/12/xml-c14n11";
        ++this.D;
        if (a.isDebugEnabled()) {
            this.print("[setTransfCanonicOmitComm] done.");
        }
    }

    public void setTransfXpath1(String string) throws CapiException {
        if (this.M != 2) {
            throw new CapiException("No signature mode specified", 50040);
        }
        if (this.D >= this.C) {
            throw new CapiException("Too many transforms", 50040);
        }
        if (string == null) {
            throw new CapiException("Null data", 1001);
        }
        this.E[this.D] = "http://www.w3.org/TR/1999/REC-xpath-19991116";
        this.I[this.D] = string;
        ++this.D;
        if (a.isDebugEnabled()) {
            this.print("[setTransfXpath] done. Xpath expression: " + string);
        }
    }

    public void setTransfXpathFilter2(String string, String string2) throws CapiException {
        this.setTransfXpathFilter2(string, string2, null, null);
    }

    public void setTransfXpathFilter2(String string, String string2, String string3, String string4) throws CapiException {
        if (this.M != 2) {
            throw new CapiException("No signature mode specified", 50040);
        }
        if (this.D >= this.C) {
            throw new CapiException("Too many transforms", 50040);
        }
        if (string2 == null || string == null) {
            throw new CapiException("Null data", 1001);
        }
        this.E[this.D] = "http://www.w3.org/2002/06/xmldsig-filter2";
        this.I[this.D] = string2;
        this.F[this.D] = string;
        this.G[this.D] = string3;
        this.H[this.D] = string4;
        ++this.D;
        if (a.isDebugEnabled()) {
            this.print("[setTransfXpathFilter2] done. Filter: " + string + " Xpath expression: " + string2 + " Xpath NS Prefix: " + string3 + " Xpath NS URI: " + string4);
        }
    }

    public void setTransfXSLT(String string) throws CapiException {
        if (this.M != 2) {
            throw new CapiException("No signature mode specified", 50040);
        }
        if (this.D >= this.C) {
            throw new CapiException("Too many transforms", 50040);
        }
        if (string == null) {
            throw new CapiException("Null data", 1001);
        }
        this.E[this.D] = "http://www.w3.org/TR/1999/REC-xslt-19991116";
        this.I[this.D] = string;
        ++this.D;
        if (a.isDebugEnabled()) {
            this.print("[setTransfXSLT] done. XSL Style Sheet: " + string);
        }
    }

    public String[] listSigners() throws CapiException {
        if (this.M != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.y == null || this.u == null || this.s == null || this.v == null || this.z == null) {
            throw new CapiException("No signer found", 50010);
        }
        return this.u;
    }

    public String[] listSignersId() throws CapiException {
        if (this.M != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.y == null || this.u == null || this.s == null || this.v == null || this.z == null) {
            throw new CapiException("No signer found", 50010);
        }
        return this.s;
    }

    @Deprecated
    public String[] listCertificates() throws CapiException {
        if (this.M != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.y == null || this.u == null || this.s == null || this.v == null || this.z == null) {
            throw new CapiException("No signer found", 50010);
        }
        return this.v;
    }

    public String verify(int n) throws CapiException {
        block23: {
            if (this.M != 3) {
                throw new CapiException("No parsed enveloped", 50040);
            }
            if (this.y == null || this.u == null || this.s == null || this.v == null || this.z == null) {
                throw new CapiException("No signer found", 50010);
            }
            if (n < 0 || n >= this.y.length) {
                throw new CapiException("Wrong signer index", 50010);
            }
            if (this.k[n] && this.v[n] != null) {
                String string;
                Object object;
                it.actalis.ellips.capi.core.Certificate certificate;
                block22: {
                    certificate = new it.actalis.ellips.capi.core.Certificate(this.v[n].getBytes());
                    if (this.m[n] != null && this.n[n] != null) {
                        try {
                            object = DigestAlgorithm.valueFromXadesId(this.m[n]);
                            if (object != null) {
                                string = object.getId();
                                object = MessageDigest.getInstance(string, ProvUtils.bcProvider);
                                byte[] byArray = ((MessageDigest)object).digest(certificate.getInternalCert().getEncoded());
                                object = byArray;
                                if (!Arrays.equals(byArray, Base64.decode((String)this.n[n]))) {
                                    throw new CapiException("Wrong Signing Certificate inside SignedProperties", 50010);
                                }
                                break block22;
                            }
                            throw new CapiException("Unknown Digest Method for Signing Certificate", 50010);
                        }
                        catch (Exception exception) {
                            a.error("Unknown Digest Method for Signing Certificate", (Throwable)exception);
                            throw new CapiException("Unknown Digest Method for Signing Certificate", 50010);
                        }
                    }
                    throw new CapiException("Missing Signing Certificate Digest inside SignedProperties", 50010);
                }
                if (this.o[n] != null && this.p[n] != null) {
                    try {
                        object = certificate.getX500IssuerName();
                        string = new X500Name(RFC4519InternalStyle.INSTANCE, this.o[n]);
                        if (object == null || !object.equals(string)) {
                            throw new CapiException("Wrong Signing Certificate Issuer Name inside SignedProperties", 50010);
                        }
                        break block23;
                    }
                    catch (Exception exception) {
                        throw new CapiException("Wrong Signing Certificate Issuer Name inside SignedProperties", 50010);
                    }
                }
                throw new CapiException("Missing Signing Certificate Issuer Serial inside SignedProperties", 50010);
            }
            if (this.l[n] && this.v[n] != null) {
                it.actalis.ellips.capi.core.Certificate certificate = new it.actalis.ellips.capi.core.Certificate(this.v[n].getBytes());
                if (this.m[n] != null && this.n[n] != null) {
                    try {
                        Object object = DigestAlgorithm.valueFromXadesId(this.m[n]);
                        if (object != null) {
                            String string = object.getId();
                            object = MessageDigest.getInstance(string, ProvUtils.bcProvider);
                            byte[] byArray = ((MessageDigest)object).digest(certificate.getInternalCert().getEncoded());
                            object = byArray;
                            if (!Arrays.equals(byArray, Base64.decode((String)this.n[n]))) {
                                throw new CapiException("Wrong Signing Certificate inside SignedProperties", 50010);
                            }
                            break block23;
                        }
                        throw new CapiException("Unknown Digest Method for Signing Certificate", 50010);
                    }
                    catch (Exception exception) {
                        a.error("Unknown Digest Method for Signing Certificate", (Throwable)exception);
                        throw new CapiException("Unknown Digest Method for Signing Certificate", 50010);
                    }
                }
                throw new CapiException("Missing Signing Certificate Digest inside SignedProperties", 50010);
            }
        }
        if (!this.y[n]) {
            if (a.isDebugEnabled()) {
                this.print("[verify] Signer n. " + n + " has an invalid signature");
            }
            throw new CapiException("Invalid signature", 3010);
        }
        if (n >= this.v.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        return this.v[n];
    }

    public String getSigningTime(int n) throws CapiException {
        if (this.M != 3 || this.j == null) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.y == null || this.u == null || this.s == null || this.v == null || this.z == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (n < 0 || n >= this.y.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n >= this.j.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        return this.j[n];
    }

    public boolean hasCounterSignature(int n) throws CapiException {
        if (this.M != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.y == null || this.u == null || this.s == null || this.v == null || this.z == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (n < 0 || n >= this.y.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.q == null || n >= this.q.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        return this.q[n] != null;
    }

    @Deprecated
    public InputStream getReference(int n, int n2) throws CapiException {
        return null;
    }

    public boolean getReferenceIsVerified(int n, int n2) throws CapiException {
        if (this.M != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.y == null || this.u == null || this.s == null || this.v == null || this.z == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (n < 0 || n >= this.y.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.z[n] == null) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n2 >= this.z[n].length) {
            throw new CapiException("Wrong reference index", 50010);
        }
        try {
            return this.z[n][n2];
        }
        catch (Exception exception) {
            throw new CapiException("Wrong signer index", 50010);
        }
    }

    @Deprecated
    public InputStream getReferenceInputStream(int n, int n2) throws CapiException {
        return null;
    }

    public TimeStampToken getSignatureTimeStamp(int n, int n2) throws CapiException {
        if (this.M != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.y == null || this.u == null || this.s == null || this.v == null || this.z == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (n < 0 || n >= this.y.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.r == null || n >= this.r.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.r[n] == null) {
            return null;
        }
        if (n2 < 0 || n2 >= this.r[n].length) {
            return null;
        }
        Object object = "http://www.w3.org/2006/12/xml-c14n11#WithComments";
        try {
            Object object2;
            Object object3;
            Element element = (Element)SignedXMLEnvelope.a((Node)this.r[n][n2], "CanonicalizationMethod");
            if (element != null) {
                object = element.getAttribute("Algorithm");
                if (a.isDebugEnabled()) {
                    this.print("[getSignatureTimeStamp] Canonicalizer: " + (String)object);
                }
            } else if (a.isDebugEnabled()) {
                this.print("[getSignatureTimeStamp] Using Default Canonicalizer: " + (String)object);
            }
            if ((object3 = (Element)SignedXMLEnvelope.a((Node)this.r[n][n2], "EncapsulatedTimeStamp")) == null) {
                if (a.isDebugEnabled()) {
                    this.print("[getSignatureTimeStamp] Missing EncapsulatedTimeStamp");
                }
                throw new CapiException("Missing EncapsulatedTimeStamp", 50023);
            }
            object = object3.getAttribute("Encoding");
            if (!(object == null || ((String)object).startsWith("http://uri.etsi.org/01903") && ((String)object).endsWith("#DER"))) {
                if (a.isDebugEnabled()) {
                    this.print("[getSignatureTimeStamp] Wrong TimeStamp Encoding. " + (String)object + " Expected DER encoding.");
                }
                throw new CapiException("Wrong TimeStamp Encoding. Expected DER encoding.", 50023);
            }
            object3 = object3.getFirstChild().getNodeValue();
            new Util();
            object3 = Util.base64DecodeStr((String)object3);
            object3 = new TimeStampToken((byte[])object3);
            object = object2 = (Element)SignedXMLEnvelope.a(this.J.item(n), "SignatureValue");
            object2 = this;
            object2 = SignedXMLEnvelope.a((Element)object, "http://www.w3.org/2006/12/xml-c14n11#WithComments");
            if (!((TimeStampToken)object3).compare((byte[])object2, false)) {
                if (a.isDebugEnabled()) {
                    this.print("[getSignatureTimeStamp] SignatureTimeStamp does not match signature value");
                }
                throw new CapiException("SignatureTimeStamp does not match signature value.", 50023);
            }
            if (a.isDebugEnabled()) {
                this.print("[getSignatureTimeStamp] SignatureTimeStamp parsed.");
            }
            return object3;
        }
        catch (CapiException capiException) {
            if (a.isDebugEnabled()) {
                this.print("[getSignatureTimeStamp] Error parsing SignatureTimeStamp" + capiException.getMessage());
            }
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            if (a.isDebugEnabled()) {
                this.print("[getSignatureTimeStamp] Error parsing SignatureTimeStamp" + exception.getMessage());
            }
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Error parsing SignatureTimeStamp", 50023);
        }
    }

    public byte[] getSignature(int n) throws CapiException {
        if (this.M != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.y == null || this.u == null || this.s == null || this.v == null || this.z == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (n < 0 || n >= this.y.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.r == null || n >= this.r.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.r[n] == null) {
            return null;
        }
        try {
            Element element = (Element)SignedXMLEnvelope.a(this.J.item(n), "SignatureValue");
            Object object = (XadesSignerInfoData)SignerInfoUtils.parse(this.getRawSignature(n));
            byte[] byArray = SignedXMLEnvelope.a(element, ((XadesSignerInfoData)object).getCanonicalizationMethod());
            object = byArray;
            return byArray;
        }
        catch (CapiException capiException) {
            if (a.isDebugEnabled()) {
                this.print("[getSignatureTimeStamp] Error parsing SignatureTimeStamp" + capiException.getMessage());
            }
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            if (a.isDebugEnabled()) {
                this.print("[getSignatureTimeStamp] Error parsing SignatureTimeStamp" + exception.getMessage());
            }
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Error parsing SignatureTimeStamp", 50023);
        }
    }

    public byte[] getTimeStamp(int n, int n2) throws CapiException {
        if (this.M != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.y == null || this.u == null || this.s == null || this.v == null || this.z == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (n < 0 || n >= this.y.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.r == null || n >= this.r.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.r[n] == null) {
            return null;
        }
        if (n2 < 0 || n2 >= this.r[n].length) {
            return null;
        }
        String string = "http://www.w3.org/2006/12/xml-c14n11#WithComments";
        try {
            Object object;
            Element element = (Element)SignedXMLEnvelope.a((Node)this.r[n][n2], "CanonicalizationMethod");
            if (element != null) {
                string = element.getAttribute("Algorithm");
                if (a.isDebugEnabled()) {
                    this.print("[getSignatureTimeStamp] Canonicalizer: " + string);
                }
            } else if (a.isDebugEnabled()) {
                this.print("[getSignatureTimeStamp] Using Default Canonicalizer: " + string);
            }
            if ((object = (Element)SignedXMLEnvelope.a((Node)this.r[n][n2], "EncapsulatedTimeStamp")) == null) {
                if (a.isDebugEnabled()) {
                    this.print("[getSignatureTimeStamp] Missing EncapsulatedTimeStamp");
                }
                throw new CapiException("Missing EncapsulatedTimeStamp", 50023);
            }
            String string2 = object.getAttribute("Encoding");
            if (!(string2 == null || string2.isEmpty() || string2.startsWith("http://uri.etsi.org/01903") && string2.endsWith("#DER"))) {
                if (a.isDebugEnabled()) {
                    this.print("[getSignatureTimeStamp] Wrong TimeStamp Encoding. " + string2 + " Expected DER encoding.");
                }
                throw new CapiException("Wrong TimeStamp Encoding. Expected DER encoding.", 50023);
            }
            object = object.getFirstChild().getNodeValue();
            new Util();
            byte[] byArray = Util.base64DecodeStr((String)object);
            object = byArray;
            return byArray;
        }
        catch (CapiException capiException) {
            if (a.isDebugEnabled()) {
                this.print("[getSignatureTimeStamp] Error parsing SignatureTimeStamp" + capiException.getMessage());
            }
            a.debug(capiException.getMessage(), (Throwable)capiException);
            throw capiException;
        }
        catch (Exception exception) {
            if (a.isDebugEnabled()) {
                this.print("[getSignatureTimeStamp] Error parsing SignatureTimeStamp" + exception.getMessage());
            }
            a.debug(exception.getMessage(), (Throwable)exception);
            throw new CapiException("Error parsing SignatureTimeStamp", 50023);
        }
    }

    public int getNumSignatureTimeStamp(int n) throws CapiException {
        if (this.M != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.y == null || this.u == null || this.s == null || this.v == null || this.z == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (n < 0 || n >= this.y.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.r == null || n >= this.r.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.r[n] == null) {
            return 0;
        }
        return this.r[n].length;
    }

    public a getCounterSignature(int n) throws CapiException {
        if (this.M != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.y == null || this.u == null || this.s == null || this.v == null || this.z == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (n < 0 || n >= this.y.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.q == null || n >= this.q.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        Element element = (Element)this.J.item(n);
        a a2 = new a(this.i, n, element, this.q[n]);
        if (a.isDebugEnabled()) {
            this.print("[getCounterSignature] done.");
        }
        return a2;
    }

    public void setCounterSignature(int n, a object) throws CapiException {
        if (this.M != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.y == null || this.u == null || this.s == null || this.v == null || this.z == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (n < 0 || n >= this.y.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.q == null || n >= this.q.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n != ((a)object).signerIndexToBeCSigned) {
            throw new CapiException("Signer index mismatch CounterSignedXMLEnvelope", 50010);
        }
        if (this.q[n] == null) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            if (a.isDebugEnabled()) {
                this.print("[setCounterSignature] Adding first countersignature to signer n. " + n + " ...");
            }
            try {
                object = SignedXMLEnvelope.a((Node)((a)object).counterSignatureElem, "Signature");
            }
            catch (Exception exception) {
                throw new CapiException("CounterSignature resynch error", 50025);
            }
            if (object == null) {
                throw new CapiException("CounterSignature resynch error", 50025);
            }
            arrayList.add((Node)object);
            this.q[n] = object = new ItemList(this, arrayList);
            return;
        }
        if (this.q[n] != null) {
            Node node;
            if (a.isDebugEnabled()) {
                this.print("[setCounterSignature] Adding another countersignature to signer " + n + " ...");
            }
            try {
                node = SignedXMLEnvelope.a((Node)((a)object).counterSignatureElem, "Signature");
            }
            catch (Exception exception) {
                throw new CapiException("CounterSignature resynch error", 50025);
            }
            if (node != null) {
                this.q[n].add(node);
                return;
            }
            throw new CapiException("CounterSignature resynch error", 50025);
        }
    }

    public String getSignerCertificate(int n) throws CapiException {
        if (this.M != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.y == null || this.u == null || this.s == null || this.v == null || this.z == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (n < 0 || n >= this.v.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        return this.v[n];
    }

    public String getSignerDigestAlg(int n) throws CapiException {
        if (this.M != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.y == null || this.u == null || this.s == null || this.v == null || this.z == null || this.w == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (n < 0 || n >= this.w.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        return this.w[n];
    }

    public String getSignerEncDigestAlg(int n) throws CapiException {
        if (this.M != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.y == null || this.u == null || this.s == null || this.v == null || this.z == null || this.x == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (n < 0 || n >= this.x.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        return this.x[n];
    }

    public String getSignerEncryptionAlg(int n) throws CapiException {
        if (this.M != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.y == null || this.u == null || this.s == null || this.v == null || this.z == null || this.x == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (n < 0 || n >= this.x.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        int n2 = this.x[n].lastIndexOf("-");
        if (n2 != -1 && n2 < this.x[n].length() - 1) {
            if (a.isDebugEnabled()) {
                this.print("[getSignerEncryptionAlg] Encryption-Alg: " + this.x[n].substring(0, n2).toUpperCase());
            }
            return this.x[n].substring(0, n2).toUpperCase();
        }
        return this.x[n];
    }

    public int getNumReference(int n) throws CapiException {
        if (this.M != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.y == null || this.u == null || this.s == null || this.v == null || this.A == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (n < 0 || n >= this.y.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (n >= this.A.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        return this.A[n].length;
    }

    public Reference getReferenceInfo(int n, int n2) throws CapiException {
        if (this.M != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.y == null || this.u == null || this.s == null || this.v == null || this.A == null) {
            throw new CapiException("No signer found", 50010);
        }
        if (n < 0 || n >= this.y.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.A == null || n >= this.A.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        if (this.A[n] == null) {
            return null;
        }
        if (n2 >= this.A[n].length) {
            return null;
        }
        try {
            return this.A[n][n2];
        }
        catch (Exception exception) {
            throw new CapiException("Wrong signer index", 50010);
        }
    }

    public boolean isSignatureParsed(int n) throws CapiException {
        if (this.M != 3) {
            throw new CapiException("No parsed enveloped", 50040);
        }
        if (this.B == null || n >= this.B.length) {
            throw new CapiException("Wrong signer index", 50010);
        }
        return this.B[n];
    }

    private void a(NodeList nodeList, EventHandlerSelector eventHandlerSelector) throws CapiException {
        int n = 0;
        int n2 = 0;
        this.u = new String[nodeList.getLength()];
        this.s = new String[nodeList.getLength()];
        this.v = new String[nodeList.getLength()];
        this.w = new String[nodeList.getLength()];
        this.x = new String[nodeList.getLength()];
        this.y = new boolean[nodeList.getLength()];
        this.j = new String[nodeList.getLength()];
        this.m = new String[nodeList.getLength()];
        this.n = new String[nodeList.getLength()];
        this.o = new String[nodeList.getLength()];
        this.p = new BigInteger[nodeList.getLength()];
        this.k = new boolean[nodeList.getLength()];
        this.l = new boolean[nodeList.getLength()];
        this.r = new Element[nodeList.getLength()][];
        this.q = new ItemList[nodeList.getLength()];
        this.z = new boolean[nodeList.getLength()][];
        this.A = new Reference[nodeList.getLength()][];
        this.t = new Node[nodeList.getLength()];
        this.B = new boolean[nodeList.getLength()];
        if (a.isDebugEnabled()) {
            this.print("[parseNodeList] parsing " + nodeList.getLength() + " XMLSignatures");
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            String string2;
            int n3;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            if (a.isDebugEnabled()) {
                this.print("[parseNodeList] start parsing XMLSignature " + i);
            }
            Object object5 = (Element)nodeList.item(i);
            if (eventHandlerSelector instanceof EventHandlerMultiSelector && (object4 = ((EventHandlerMultiSelector)eventHandlerSelector).selectAllHandler()) != null && !object4.isEmpty()) {
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (InputHandler)object3.next();
                    this.g.addDocument((InputHandler)object2);
                }
            }
            try {
                object3 = new DOMValidateContext(new InternalKeySelector(this.i), (Node)object5);
                ((DOMCryptoContext)object3).setProperty("javax.xml.crypto.dsig.cacheReference", Boolean.TRUE);
                ((DOMCryptoContext)object3).setProperty("org.jcp.xml.dsig.internal.dom.SignatureProvider", ProvUtils.bcProvider);
                ((DOMCryptoContext)object3).setURIDereferencer(this.g);
                object4 = b.unmarshalXMLSignature((XMLValidateContext)object3);
            }
            catch (Exception exception) {
                if (a.isDebugEnabled()) {
                    a.debug(exception.getMessage(), (Throwable)exception);
                }
                this.B[i] = false;
                ++n2;
                NodeList nodeList2 = object5.getElementsByTagName("ds:KeyInfo");
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node = nodeList2.item(j);
                    try {
                        object = new DOMStructure(node);
                        List<XMLStructure> list = KeyInfoFactory.getInstance().unmarshalKeyInfo((XMLStructure)object).getContent();
                        for (int k = 0; k < list.size(); ++k) {
                            object = list.get(k);
                            if (!(object instanceof X509Data)) continue;
                            for (Object object6 : ((X509Data)object).getContent()) {
                                if (!(object6 instanceof X509Certificate)) continue;
                                object5 = (X509Certificate)object6;
                                this.v[i] = new String(Util.base64Encode(((Certificate)object5).getEncoded()));
                                if (!this.c.contains(object5)) {
                                    this.c.add((X509Certificate)object5);
                                }
                                if (this.d.get(i) == null) {
                                    this.d.put(i, new LinkedList());
                                }
                                if (!this.d.get(i).contains(object5)) {
                                    this.d.get(i).add((X509Certificate)object5);
                                }
                                object5 = new it.actalis.ellips.capi.core.Certificate(this.v[i].getBytes());
                                this.u[i] = ((it.actalis.ellips.capi.core.Certificate)object5).getSubjectDN();
                                if (this.u[i] != null && this.v[i] != null) continue;
                                throw new CapiException("malformed X509Certificate for signer index " + (i + 1), 50025);
                            }
                        }
                        continue;
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        throw new CapiException("CertificateEncodingException", 50025);
                    }
                    catch (MarshalException marshalException) {}
                }
                continue;
            }
            this.B[i] = true;
            object2 = null;
            if (object4.getSignedInfo() == null) {
                throw new CapiException("SignedInfo not found", 50025);
            }
            if (object4.getKeyInfo() == null) {
                throw new CapiException("KeyInfo not found", 50025);
            }
            boolean bl = false;
            SignatureMethod signatureMethod = object4.getSignedInfo().getSignatureMethod();
            if (signatureMethod == null) {
                throw new CapiException("SignatureMethodURI not found", 50025);
            }
            object = signatureMethod.getAlgorithm();
            SignedXMLEnvelope signedXMLEnvelope = this;
            if (a.isDebugEnabled()) {
                signedXMLEnvelope.print("[getDigestAlg] SignatureMethodURI() " + (String)object);
            }
            if ((n3 = ((String)object).lastIndexOf("-")) != -1 && n3 < ((String)object).length() - 1) {
                if (a.isDebugEnabled()) {
                    signedXMLEnvelope.print("[getDigestAlg] Digest: " + ((String)object).substring(n3 + 1).toUpperCase());
                }
                string2 = ((String)object).substring(n3 + 1).toUpperCase();
            } else {
                string2 = null;
            }
            this.w[i] = string2;
            object = signatureMethod.getAlgorithm();
            signedXMLEnvelope = this;
            if (a.isDebugEnabled()) {
                signedXMLEnvelope.print("[getEncryptionAndDigestAlg] SignatureMethodURI() " + (String)object);
            }
            if ((n3 = ((String)object).lastIndexOf("#")) != -1 && n3 < ((String)object).length() - 1) {
                if (a.isDebugEnabled()) {
                    signedXMLEnvelope.print("[getEncryptionAndDigestAlg] Encryption-Digest: " + ((String)object).substring(n3 + 1).toUpperCase());
                }
                string = ((String)object).substring(n3 + 1).toUpperCase();
            } else {
                string = null;
            }
            this.x[i] = string;
            this.t[i] = nodeList.item(i).getParentNode();
            this.s[i] = object4.getId();
            boolean bl2 = false;
            object = new ArrayList();
            try {
                bl2 = object4.validate((XMLValidateContext)object3);
                object = ((InternalKeySelector.InternalKeySelectorResult)object4.getKeySelectorResult()).getX509List();
                object2 = ((InternalKeySelector.InternalKeySelectorResult)object4.getKeySelectorResult()).getX509();
            }
            catch (XMLSignatureException xMLSignatureException) {
                XMLSignatureException xMLSignatureException2 = xMLSignatureException;
                if (xMLSignatureException.getCause() instanceof URIReferenceException) {
                    bl2 = false;
                    object = ((InternalKeySelector.InternalKeySelectorResult)object4.getKeySelectorResult()).getX509List();
                    object2 = ((InternalKeySelector.InternalKeySelectorResult)object4.getKeySelectorResult()).getX509();
                }
                if (xMLSignatureException2.getMessage().equals("cannot find validation key")) {
                    bl = true;
                }
                throw new CapiException("XMLSignatureException", 50052);
            }
            if (!bl) {
                try {
                    this.v[i] = new String(Util.base64Encode(((Certificate)object2).getEncoded()));
                    if (!this.c.contains(object2)) {
                        this.c.add((X509Certificate)object2);
                    }
                    if (this.d.get(i) == null) {
                        this.d.put(i, new LinkedList());
                    }
                    Object object7 = object.iterator();
                    while (object7.hasNext()) {
                        object2 = (X509Certificate)object7.next();
                        this.d.get(i).add((X509Certificate)object2);
                    }
                    object7 = new it.actalis.ellips.capi.core.Certificate(this.v[i].getBytes());
                    this.u[i] = ((it.actalis.ellips.capi.core.Certificate)object7).getSubjectDN();
                    if (this.u[i] == null || this.v[i] == null) {
                        throw new CapiException("malformed X509Certificate for signer index " + (i + 1), 50025);
                    }
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw new CapiException("CertificateEncodingException", 50025);
                }
            }
            int n4 = object4.getSignedInfo().getReferences().size();
            this.A[i] = new Reference[n4];
            this.z[i] = new boolean[n4];
            for (int j = 0; j < n4; ++j) {
                if (a.isDebugEnabled()) {
                    this.print("[parseNodeList] setting each Reference ... ");
                }
                object = object4.getSignedInfo().getReferences().get(j);
                try {
                    Object object6;
                    object.validate((XMLValidateContext)object3);
                    if (a.isDebugEnabled()) {
                        this.print("[parseNodeList] reference uri: " + object.getURI());
                    }
                    Object object8 = object.getDigestValue();
                    object6 = object.getCalculatedDigestValue();
                    this.z[i][j] = MessageDigest.isEqual((byte[])object8, object6);
                }
                catch (XMLSignatureException xMLSignatureException) {
                    this.z[i][j] = false;
                }
                this.A[i][j] = object;
            }
            this.y[i] = bl2;
            if (a.isDebugEnabled()) {
                this.print("[parseNodeList] Certificate Subject DN: " + this.u[i]);
            }
            if (a.isDebugEnabled()) {
                this.print("[parseNodeList] Signature is" + (bl2 ? " " : " NOT ") + "valid");
            }
            if (bl2) {
                ++n;
            } else {
                ++n2;
            }
            this.a((Element)object5, i);
            if (!a.isDebugEnabled()) continue;
            this.print("[parseNodeList] end parsing XMLSignature " + i);
        }
        if (a.isDebugEnabled()) {
            this.print("[parseNodeList] Valid signatures: " + n + " out of " + nodeList.getLength());
        }
        if (a.isDebugEnabled()) {
            this.print("[parseNodeList] Not valid signatures: " + n2 + " out of " + nodeList.getLength());
        }
    }

    private static Node a(Node object, String string) throws Exception {
        if (object.hasChildNodes()) {
            object = object.getChildNodes();
            for (int i = 0; i < object.getLength(); ++i) {
                short s = object.item(i).getNodeType();
                if (s != 1 || !object.item(i).getNodeName().endsWith(string)) continue;
                return object.item(i);
            }
        }
        return null;
    }

    private ItemList b(Node object, String string) throws Exception {
        ItemList itemList = null;
        if (object.hasChildNodes()) {
            itemList = new ItemList(this, new ArrayList<Node>());
            object = object.getChildNodes();
            for (int i = 0; i < object.getLength(); ++i) {
                short s = object.item(i).getNodeType();
                if (s != 1 || !object.item(i).getNodeName().endsWith(string)) continue;
                itemList.add(object.item(i));
            }
        }
        return itemList;
    }

    private void a(Element node, int n) throws CapiException {
        Object object;
        Node node2 = null;
        try {
            object = this.b(node, "ds:Object");
            for (int i = 0; i < ((ItemList)object).getLength(); ++i) {
                Node node3;
                Node node4;
                node = (Element)((ItemList)object).item(i);
                if (a.isDebugEnabled()) {
                    this.print("[checkXADES] finding SigningTime...");
                }
                if ((node2 = SignedXMLEnvelope.a(node, "QualifyingProperties")) == null || (node = SignedXMLEnvelope.a(node2, "SignedProperties")) == null) continue;
                Object object2 = node.getAttribute("Id");
                if (a.isDebugEnabled()) {
                    this.print("[checkXADES] Signed Properties Id: " + (String)object2);
                }
                if ((node4 = SignedXMLEnvelope.a(node, "SignedSignatureProperties")) == null) continue;
                node = SignedXMLEnvelope.a(node4, "SigningTime");
                if (node != null) {
                    this.j[n] = node.getFirstChild().getNodeValue();
                    if (a.isDebugEnabled()) {
                        this.print("[checkXADES] Found Signing Time for Signer n. " + n + " : " + this.j[n]);
                    }
                }
                if ((node = SignedXMLEnvelope.a(node4, "SigningCertificate")) != null) {
                    this.k[n] = true;
                    if (a.isDebugEnabled()) {
                        this.print("[checkXADES] Found Signing Certificate for Signer n. " + n);
                    }
                    if ((node = SignedXMLEnvelope.a(node, "Cert")) != null) {
                        if (a.isDebugEnabled()) {
                            this.print("[checkXADES] Found Cert for Signer n. " + n);
                        }
                        if ((object2 = SignedXMLEnvelope.a(node, "CertDigest")) != null) {
                            if (a.isDebugEnabled()) {
                                this.print("[checkXADES] Found CertDigest for Signer n. " + n);
                            }
                            if ((node3 = SignedXMLEnvelope.a((Node)object2, "DigestMethod")) != null && node3.hasAttributes() && node3.getAttributes().getNamedItem("Algorithm") != null) {
                                this.m[n] = node3.getAttributes().getNamedItem("Algorithm").getNodeValue();
                                if (a.isDebugEnabled()) {
                                    this.print("[checkXADES] Found CertDigest Method for Signer n. " + n + " : " + this.m[n]);
                                }
                            }
                            if ((object2 = SignedXMLEnvelope.a((Node)object2, "DigestValue")) != null) {
                                this.n[n] = object2.getFirstChild().getNodeValue();
                                if (a.isDebugEnabled()) {
                                    this.print("[checkXADES] Found CertDigest Value for Signer n. " + n + " : " + this.n[n]);
                                }
                            }
                        }
                        if ((node = SignedXMLEnvelope.a(node, "IssuerSerial")) != null) {
                            if (a.isDebugEnabled()) {
                                this.print("[checkXADES] Found IssuerSerial for Signer n. " + n);
                            }
                            if ((object2 = SignedXMLEnvelope.a(node, "X509IssuerName")) != null) {
                                this.o[n] = object2.getFirstChild().getNodeValue();
                                if (a.isDebugEnabled()) {
                                    this.print("[checkXADES] Found IsserSerial Name for Signer n. " + n + " : " + this.o[n]);
                                }
                            }
                            if ((node = SignedXMLEnvelope.a(node, "X509SerialNumber")) != null) {
                                try {
                                    this.p[n] = new BigInteger(node.getFirstChild().getNodeValue());
                                    if (a.isDebugEnabled()) {
                                        this.print("[checkXADES] Found IsserSerial Number for Signer n. " + n + " : " + this.p[n]);
                                    }
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                } else {
                    this.k[n] = false;
                }
                if ((node = SignedXMLEnvelope.a(node4, "SigningCertificateV2")) != null) {
                    this.l[n] = true;
                    if (a.isDebugEnabled()) {
                        this.print("[checkXADES] Found Signing Certificate V2 for Signer n. " + n + " : " + this.j[n]);
                    }
                    if ((node = SignedXMLEnvelope.a(node, "Cert")) == null) continue;
                    if (a.isDebugEnabled()) {
                        this.print("[checkXADES] Found Cert for Signer n. " + n);
                    }
                    if ((object2 = SignedXMLEnvelope.a(node, "CertDigest")) != null) {
                        if (a.isDebugEnabled()) {
                            this.print("[checkXADES] Found CertDigest for Signer n. " + n);
                        }
                        if ((node3 = SignedXMLEnvelope.a((Node)object2, "DigestMethod")) != null && node3.hasAttributes() && node3.getAttributes().getNamedItem("Algorithm") != null) {
                            this.m[n] = node3.getAttributes().getNamedItem("Algorithm").getNodeValue();
                            if (a.isDebugEnabled()) {
                                this.print("[checkXADES] Found CertDigest Method for Signer n. " + n + " : " + this.m[n]);
                            }
                        }
                        if ((object2 = SignedXMLEnvelope.a((Node)object2, "DigestValue")) != null) {
                            this.n[n] = object2.getFirstChild().getNodeValue();
                            if (a.isDebugEnabled()) {
                                this.print("[checkXADES] Found CertDigest Value for Signer n. " + n + " : " + this.n[n]);
                            }
                        }
                    }
                    if ((node = SignedXMLEnvelope.a(node, "IssuerSerialV2")) == null) continue;
                    this.o[n] = node.getFirstChild().getNodeValue();
                    if (!a.isDebugEnabled()) continue;
                    this.print("[checkXADES] Found IssuerSerialV2 for Signer n. " + n);
                    continue;
                }
                this.l[n] = false;
            }
        }
        catch (Exception exception) {
            if (a.isDebugEnabled()) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("SigningTime encoding error", 50025);
        }
        if (node2 == null) {
            return;
        }
        try {
            ((Element)node2).getAttribute("xmlns");
            Node node5 = SignedXMLEnvelope.a(node2, "UnsignedProperties");
            if (node5 == null) {
                return;
            }
            object = SignedXMLEnvelope.a(node5, "UnsignedSignatureProperties");
            if (object == null) {
                return;
            }
        }
        catch (CapiException capiException) {
            if (a.isDebugEnabled()) {
                a.debug(capiException.getMessage(), (Throwable)capiException);
            }
            throw capiException;
        }
        catch (Exception exception) {
            if (a.isDebugEnabled()) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("UnsignedProperties error", 50025);
        }
        this.a((Node)object, n);
    }

    private void a(Node node, int n) throws CapiException {
        Object object;
        Object object2;
        block47: {
            Object object3;
            Object object4;
            Object object5;
            block46: {
                int n2;
                block45: {
                    try {
                        if (a.isDebugEnabled()) {
                            this.print("[checkXADES] finding xades:CertificateValues...");
                        }
                        object5 = object2 = SignedXMLEnvelope.a(node, "xades:CertificateValues");
                        n2 = n;
                        object2 = this;
                        if (object5 != null && (object4 = super.b((Node)object5, "xades:EncapsulatedX509Certificate")) != null) {
                            for (int i = 0; i < ((ItemList)object4).getLength(); ++i) {
                                object3 = ((ItemList)object4).item(i);
                                object3 = object3.getTextContent();
                                object3 = new it.actalis.ellips.capi.core.Certificate(Base64.decode((String)object3));
                                if (((SignedXMLEnvelope)object2).d.get(n2) == null) {
                                    ((SignedXMLEnvelope)object2).d.put(n2, new LinkedList());
                                }
                                if (((SignedXMLEnvelope)object2).d.get(n2).contains(((it.actalis.ellips.capi.core.Certificate)object3).getInternalCert())) continue;
                                ((SignedXMLEnvelope)object2).d.get(n2).add(((it.actalis.ellips.capi.core.Certificate)object3).getInternalCert());
                            }
                        }
                    }
                    catch (CapiException capiException) {
                        if (a.isDebugEnabled()) {
                            a.debug(capiException.getMessage(), (Throwable)capiException);
                        }
                    }
                    catch (Exception exception) {
                        if (!a.isDebugEnabled()) break block45;
                        a.debug(exception.getMessage(), (Throwable)exception);
                    }
                }
                try {
                    if (a.isDebugEnabled()) {
                        this.print("[checkXADES] finding <xades:RevocationValues>...");
                    }
                    object5 = object2 = SignedXMLEnvelope.a(node, "xades:RevocationValues");
                    n2 = n;
                    object2 = this;
                    if (object5 != null) {
                        object4 = SignedXMLEnvelope.a((Node)object5, "xades:OCSPValues");
                        if (object4 != null) {
                            super.a(n2, (Node)object4);
                        }
                        if ((object5 = SignedXMLEnvelope.a((Node)object5, "xades:CRLValues")) != null) {
                            super.b(n2, (Node)object5);
                        }
                    }
                }
                catch (CapiException capiException) {
                    if (a.isDebugEnabled()) {
                        a.debug(capiException.getMessage(), (Throwable)capiException);
                    }
                }
                catch (Exception exception) {
                    if (!a.isDebugEnabled()) break block46;
                    a.debug(exception.getMessage(), (Throwable)exception);
                }
            }
            try {
                if (a.isDebugEnabled()) {
                    this.print("[checkXADES] finding CounterSignatures...");
                }
                object2 = null;
                object = SignedXMLEnvelope.a(node, "CounterSignature");
                if (object != null && SignedXMLEnvelope.a((Node)object, "Signature") != null) {
                    object5 = XPathFactory.newInstance().newXPath();
                    object5.setNamespaceContext(this.h);
                    object = object5.compile("xades:CounterSignature[ds:Signature]");
                    object2 = (NodeList)object.evaluate(node, XPathConstants.NODESET);
                }
                if (object2 == null || object2.getLength() == 0) {
                    if (a.isDebugEnabled()) {
                        this.print("[checkXADES] Signer " + n + " has not Contersignatures in xades namespace");
                    }
                    break block47;
                }
                if (a.isDebugEnabled()) {
                    this.print("[checkXADES] Signer " + n + " has: " + object2.getLength() + " Contersignatures");
                }
                object = new ArrayList();
                for (int i = 0; i < object2.getLength(); ++i) {
                    if (a.isDebugEnabled()) {
                        this.print("[checkXADES] parsing Countersignature element n. " + i + " ...");
                    }
                    if ((object5 = SignedXMLEnvelope.a(object2.item(i), "Signature")) == null) {
                        if (!a.isDebugEnabled()) continue;
                        this.print("[checkXADES] CounterSignature error: missing Signature element");
                        continue;
                    }
                    boolean bl = false;
                    try {
                        if (a.isDebugEnabled()) {
                            this.print("[checkXADES] Verifying Countersignature is referred to SignatureValue");
                        }
                        object3 = new DOMValidateContext(new InternalKeySelector(this.i), (Node)object5);
                        object3 = b.unmarshalXMLSignature((XMLValidateContext)object3);
                        Object object6 = (Element)SignedXMLEnvelope.a(this.J.item(n), "SignatureValue");
                        if (object6 == null) {
                            if (!a.isDebugEnabled()) continue;
                            this.print("[checkXADES] Cannot find signatureValue the countersignature is referred to");
                            continue;
                        }
                        if ((object6 = object6.getAttribute("Id")) == null || ((String)object6).equals("")) {
                            if (!a.isDebugEnabled()) continue;
                            this.print("[checkXADES] missing signatureValue Id for signatureValue the countersignature is referred to");
                            continue;
                        }
                        if (a.isDebugEnabled()) {
                            this.print("[checkXADES] Referred SignatureValue has Id: " + (String)object6);
                        }
                        int n3 = object3.getSignedInfo().getReferences().size();
                        for (int j = 0; j < n3; ++j) {
                            String string = object3.getSignedInfo().getReferences().get(j).getURI();
                            if (a.isDebugEnabled()) {
                                this.print("[checkXADES] CounterSignature ReferenceURI is: " + string);
                            }
                            if (string.compareTo("#" + (String)object6) != 0 && string.compareTo("#xpointer(id('" + (String)object6 + "'))") != 0) continue;
                            if (a.isDebugEnabled()) {
                                this.print("[checkXADES] CounterSignature is referred to Signature Value");
                            }
                            bl = true;
                            break;
                        }
                    }
                    catch (Exception exception) {
                        if (!a.isDebugEnabled()) continue;
                        this.print("CounterSignature encoding error: " + exception.getMessage());
                        continue;
                    }
                    if (!bl) {
                        if (!a.isDebugEnabled()) continue;
                        this.print("[checkXADES] CounterSignature is not referred to Signature Value");
                        continue;
                    }
                    object.add(object5);
                }
                this.q[n] = object4 = new ItemList(this, (List<Node>)object);
            }
            catch (CapiException capiException) {
                if (a.isDebugEnabled()) {
                    a.debug(capiException.getMessage(), (Throwable)capiException);
                }
                throw capiException;
            }
            catch (Exception exception) {
                if (a.isDebugEnabled()) {
                    a.debug(exception.getMessage(), (Throwable)exception);
                }
                throw new CapiException("CounterSignature encoding error", 50025);
            }
        }
        try {
            block51: {
                block50: {
                    block49: {
                        if (a.isDebugEnabled()) {
                            this.print("[checkXADES] finding SignatureTimeStamp...");
                        }
                        if ((object2 = this.b(node, "SignatureTimeStamp")) != null && ((ItemList)object2).getLength() != 0) break block49;
                        if (!a.isDebugEnabled()) break block50;
                        break block51;
                    }
                    if (a.isDebugEnabled()) {
                        this.print("[checkXADES] Signer " + n + " has: " + ((ItemList)object2).getLength() + " SignatureTimeStamps");
                    }
                    this.r[n] = new Element[((ItemList)object2).getLength()];
                    for (int i = 0; i < ((ItemList)object2).getLength(); ++i) {
                        this.r[n][i] = object = (Element)((ItemList)object2).item(i);
                    }
                }
                return;
            }
            this.print("[checkXADES] Signer " + n + " has not SignatureTimeStamps");
        }
        catch (Exception exception) {
            if (a.isDebugEnabled()) {
                a.debug(exception.getMessage(), (Throwable)exception);
            }
            throw new CapiException("SignatureTimeStamp encoding error", 50025);
        }
    }

    private void a(int n, Node object) throws Exception {
        if (object == null) {
            return;
        }
        if ((object = this.b((Node)object, "xades:EncapsulatedOCSPValue")) != null) {
            for (int i = 0; i < ((ItemList)object).getLength(); ++i) {
                Object object2 = ((ItemList)object).item(i);
                object2 = object2.getTextContent();
                object2 = OcspUtils.getInstaceByBytes(Base64.decode((String)object2));
                if (this.f.get(n) == null) {
                    this.f.put(n, new LinkedList());
                }
                if (this.f.get(n).contains(object2)) continue;
                this.f.get(n).add((BasicOCSPResp)object2);
            }
        }
    }

    private void b(int n, Node object) throws Exception {
        if (object == null) {
            return;
        }
        if ((object = this.b((Node)object, "xades:EncapsulatedCRLValue")) != null) {
            for (int i = 0; i < ((ItemList)object).getLength(); ++i) {
                Object object2 = ((ItemList)object).item(i);
                object2 = object2.getTextContent();
                object2 = new CRL(Base64.decode((String)object2));
                if (this.e.get(n) == null) {
                    this.e.put(n, new LinkedList());
                }
                if (this.e.get(n).contains(object2)) continue;
                this.e.get(n).add((CRL)object2);
            }
        }
    }

    protected void print(String string) {
        a.debug("[SignedXMLEnvelope] " + string);
    }

    public byte[] getRawSignature(int n) {
        Object object = (DOMImplementationLS)((Object)this.i.getImplementation());
        LSSerializer lSSerializer = object.createLSSerializer();
        object = object.createLSOutput();
        object.setEncoding("UTF-8");
        StringWriter stringWriter = new StringWriter();
        object.setCharacterStream(stringWriter);
        lSSerializer.write(this.J.item(n), (LSOutput)object);
        String string = ((Object)stringWriter).toString();
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
    }

    public LinkedList<X509Certificate> getCertificates(int n) throws Exception {
        return this.d.get(n);
    }

    public LinkedList<CRL> getCRLS(int n) throws CapiException, CRLException, CMSException {
        return this.e.get(n);
    }

    public LinkedList<BasicOCSPResp> getBasicOCSPResponses(int n) throws CMSException, CRLException {
        return this.f.get(n);
    }

    public boolean hasSigningCertificate(int n) {
        return this.k[n] || this.l[n];
    }

    private static byte[] a(Element object, String object2) throws IOException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, TransformException {
        object2 = TransformService.getInstance((String)object2, "DOM");
        DOMValidateContext dOMValidateContext = new DOMValidateContext(new InternalKeySelector(null), (Node)object);
        ((TransformService)object2).init(new DOMStructure((Node)object), null);
        object = object2.transform(new DOMSubTreeData((Node)object, false), dOMValidateContext);
        object = ((OctetStreamData)object).getOctetStream();
        return IOUtils.toByteArray((InputStream)object);
    }

    protected class ItemList
    implements NodeList {
        private List<Node> a = null;

        ItemList(SignedXMLEnvelope signedXMLEnvelope, List<Node> list) {
            this.a = list;
        }

        @Override
        public Node item(int n) {
            return this.a.get(n);
        }

        @Override
        public int getLength() {
            return this.a.size();
        }

        public void add(Node node) {
            this.a.add(node);
        }
    }
}

