/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.tst;

import esecurity.dts.TimeStampToken;
import esecurity.validator.bean.SignerInfoData;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.vol.utils.Constants;
import java.util.Date;
import java.util.LinkedList;

public class TimeStampStepSignatureDigestAlgoCheck
extends SingleValidationSubStepImpl {
    public TimeStampStepSignatureDigestAlgoCheck() {
        super(ValidationType.SIGNATURE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> object, ValidationContextParameters validationContextParameters) {
        if (validationContextParameters == null) {
            return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName());
        }
        if (validationContextParameters.getSignature() == null) {
            return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName());
        }
        object = validationContextParameters.getCalculatedValidationDate().getDate();
        if (((Date)object).after(Constants.DPCM_AGID_121_2019)) {
            TimeStampToken timeStampToken;
            object = validationContextParameters.getSignature().getSignerInfoData();
            if (object == null) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WS0008_TIMESTAMP_NOSHA256, this.getClass().getName());
            }
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.valueFromCadesId(((SignerInfoData)object).getDigestAlgo());
            if (digestAlgorithm == null) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0029_DIGEST_ALGORITHM_NOT_SUPPORTED, ((SignerInfoData)object).getDigestAlgo(), this.getClass().getName());
            }
            if (digestAlgorithm.isForbidden()) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0030_DIGEST_ALGORITHM_FORBIDDEN, digestAlgorithm.name(), this.getClass().getName());
            }
            if (!digestAlgorithm.isRecommended()) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0016_DIGEST_ALGORITHM_NOT_RECOMMENDED, digestAlgorithm.name(), this.getClass().getName());
            }
            try {
                timeStampToken = new TimeStampToken(validationContextParameters.getSignature().getSignatureInfo());
            }
            catch (CapiException capiException) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EA0002_UNMANAGED_ERROR, this.getClass().getName());
            }
            try {
                if (timeStampToken.hasSigningCertificateV2()) {
                    digestAlgorithm = DigestAlgorithm.valueFromCadesId(timeStampToken.getSigningCertificateV2HashAlg());
                } else if (timeStampToken.hasSigningCertificate()) {
                    digestAlgorithm = DigestAlgorithm.SHA1;
                }
                if (digestAlgorithm == null) {
                    return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0029_DIGEST_ALGORITHM_NOT_SUPPORTED, "", this.getClass().getName());
                }
                if (digestAlgorithm.isForbidden()) {
                    return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0030_DIGEST_ALGORITHM_FORBIDDEN, digestAlgorithm.name(), this.getClass().getName());
                }
                if (!digestAlgorithm.isRecommended()) {
                    return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0016_DIGEST_ALGORITHM_NOT_RECOMMENDED, digestAlgorithm.name(), this.getClass().getName());
                }
                digestAlgorithm = DigestAlgorithm.valueFromCadesId(timeStampToken.getInternalTst().getTimeStampInfo().getMessageImprintAlgOID().getId());
                if (digestAlgorithm == null) {
                    return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0029_DIGEST_ALGORITHM_NOT_SUPPORTED, ((SignerInfoData)object).getDigestAlgo(), this.getClass().getName());
                }
                if (digestAlgorithm.isForbidden()) {
                    return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0030_DIGEST_ALGORITHM_FORBIDDEN, digestAlgorithm.name(), this.getClass().getName());
                }
                if (!digestAlgorithm.isRecommended()) {
                    return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.INFO, (EsecurityMessage)ValidatorMessageEnum.IS0016_DIGEST_ALGORITHM_NOT_RECOMMENDED, digestAlgorithm.name(), this.getClass().getName());
                }
            }
            catch (CapiException capiException) {
                this.logger.error("Errore verifica Digest Algo", (Throwable)capiException);
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.ES0027_INVALID_TIMESTAMP, this.getClass().getName());
            }
        }
        return null;
    }
}

