/*
  Copyright (C) 2014 David Robillard <d@drobilla.net>
    
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stddef.h>

#include "reverbs.h"
#include "plugin_lv2.h"

extern "C" {

static LV2_Handle
instantiate(const LV2_Descriptor*     descriptor,
            double                    rate,
            const char*               bundle_path,
            const LV2_Feature* const* features)
{
	return new Ladspa_zita_reverb(rate);
}

static LV2_Handle
instantiate_amb(const LV2_Descriptor*     descriptor,
                double                    rate,
                const char*               bundle_path,
                const LV2_Feature* const* features)
{
	return new Ladspa_zita_reverb_amb(rate);
}

static const LV2_Descriptor descriptors[] = {
	{
		"http://drobilla.net/plugins/fomp/reverb",
		instantiate,
		connect_port,
		activate,
		run,
		deactivate,
		cleanup,
		NULL
	} , {
		"http://drobilla.net/plugins/fomp/reverb_amb",
		instantiate_amb,
		connect_port,
		activate,
		run,
		deactivate,
		cleanup,
		NULL
	}
};

LV2_SYMBOL_EXPORT
const LV2_Descriptor*
lv2_descriptor(uint32_t index)
{
	return (index < 2) ? &descriptors[index] : NULL;
}

}  // extern "C"
