#include "includeeditor.h"
#include <QDialogButtonBox>
#include <QPushButton>
#include <QMessageBox>

IncludeEditor::IncludeEditor(QString inclstr, const QString &_dir, QWidget *parent) : QDialog(parent){
    setWindowTitle(QString("included file :%1").arg(inclstr));
    fileName = inclstr.remove(QRegularExpression("^\\++"));

    dirName=_dir;
    fileName=QString("%1/%2").arg(dirName).arg(fileName);
    setMinimumWidth(500);
    //qDebug()<<fileName;
    //QVBoxLayout *pvla = new QVBoxLayout();
    edi = new CodeEditor();
    QString inspatternfile=":ins_res_style.ini";
    edi->highlighter->loadHighlightPatterns(inspatternfile);
    QFont font;
    font.setFamily(FONTFAM);
    font.setFixedPitch(true);
    font.setPointSize(9);
    edi->setFont(font);
    edi->setLineWrapMode(QPlainTextEdit::NoWrap);
    QFile p(fileName);
    p.open(QIODevice::ReadOnly|QIODevice::Text);
    edi->setPlainText(p.readAll());
    p.close();
    edi->setReadOnly(false);

    QDialogButtonBox *buttonBox = new QDialogButtonBox(QDialogButtonBox::Save | QDialogButtonBox::Cancel);
    ok = buttonBox->button(QDialogButtonBox::Save);

    ok->setDisabled(false);
    connect(buttonBox, SIGNAL(accepted()), this, SLOT(accept()));
    connect(buttonBox, SIGNAL(rejected()), this, SLOT(reject()));
    QVBoxLayout *lo = new QVBoxLayout();
    lo->addWidget(edi);
    lo->addWidget(buttonBox);
    setLayout(lo);
    //this->setWindowState(Qt::WindowMaximized);
}

void IncludeEditor::accept(){
  QFile f(fileName);
  bool success = f.open(QIODevice::WriteOnly|QIODevice::Text);
  if (success){
    f.write(edi->toPlainText().toLatin1());
    f.close();
  }else{
      QMessageBox::information(0,"information",QString("Can't write %1.").arg(fileName));
      f.close();// I don't know if this required bit I think it doesn't hurt.
    
  }

  done(QDialog::Accepted );

}

void IncludeEditor::setDirName(const QString &_dir){
    dirName=_dir;
}
