#include <Python.h>
#include <goom_core.h>

int pygoom_isinit = 0;
int pygoom_width  = 100;
int pygoom_height = 100;
int pygoom_cinema = 0;

static PyObject* pygoom_init( PyObject *self, PyObject *args ); 
static PyObject* pygoom_set_asm_use( PyObject *self, PyObject *args );
static PyObject* pygoom_get_asm_use( PyObject *self, PyObject *args );
static PyObject* pygoom_close( PyObject *self, PyObject *args );
static PyObject* pygoom_set_resolution( PyObject *self, PyObject *args );
static PyObject* pygoom_get_resolution( PyObject *self, PyObject *args );
static PyObject* pygoom_update( PyObject *self, PyObject *args ); 

static PyMethodDef pygoomMethods[] = {
 {"init",           pygoom_init,           METH_VARARGS, "Initialize GOOM. Arguments are width, height and cinemascope usage (optional)."},
 {"set_asm_use",    pygoom_set_asm_use,    METH_VARARGS, "Set Assembly optimizations usage."},
 {"get_asm_use",    pygoom_get_asm_use,    METH_VARARGS,         "Get Assembly optimizations usage status."},
 {"close",          pygoom_close,          METH_VARARGS,         "Close GOOM."},
 {"set_resolution", pygoom_set_resolution, METH_VARARGS, "Set resolution. Arguments are width, height and cinemascope usage (optional)."},
 {"get_resolution", pygoom_get_resolution, METH_VARARGS,         "Get resolution. Returns a tuple ( width, height, cinemascope)."},
 {"update",         pygoom_update,         METH_VARARGS, "Update image. Get sound data (2048 bytes, 2 channels with 512 samples of 16-bit integers) and render to a 32 bit (RGBA) image, returning it."},

 { NULL, NULL, 0, NULL }
};



