/******************************************************************************
 * This file is part of MPlayer Audio Visualization.                          *
 *                                                                            *
 *                                                                            *
 *  MPlayer Audio Visualization is free software; you can redistribute it     *
 *  and/or modify it under the terms of the GNU General Public License as     *
 *  published by the Free Software Foundation; either version 2 of the        *
 *  License, or (at your option) any later version.                           *
 *                                                                            *
 *  MPlayer Audio Visualization is distributed in the hope that it will be    *
 *  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General *
 *  Public License for more details.                                          *
 *                                                                            * 
 *  You should have received a copy of the GNU General Public License         *
 *  along with MPlayer Audio Visualization; if not, write to the Free         *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA         *
 *  02111-1307  USA                                                           *
 ******************************************************************************/
#include "msglist.h"

int msglist_addnode( msglist_t **list, msgnode_t *node )
{
  if ( ! list ) 
    return( -1 );
  else
    if ( ! *list )
      {	
	*list = node;
	return( 0 );
      }
    else
      {
	msglist_t *l = *list;
	while ( l->next != NULL )
	  l = l->next;
	l->next = node;
	return( 0 );
      }
}

msgnode_t *msglist_delnode( msglist_t **list, msgnode_t *node )
{
  if ( ( ! list ) || ( ! *list ) || ( ! node ) )
    return( NULL );
  else
    {
      msglist_t **l = list;

      // replace list head
      if ( *list == node )
	{
	  (*list) = node->next;
	  node->next = NULL;
	  return( node );
	}

      while ( ( *l ) && ( ( *l )->next != node ) )
	( *l ) = ( *l )->next;

      if ( ! *l ) 
	return( NULL );
      else
	{
	  ( *l )->next = node->next;
	  node->next = NULL;
	  return( node );
	}
    }
}

void msglist_print( msglist_t *list )
{
  int i=0;

  while ( list )
    {
      mpav_fmsg( stdout, 
		 "ID=%p font=\"%s\" x=%d y=%d shadow=\"%s\"", 
		 list, 
		 TTF_FontFaceFamilyName( list->font ), 
		 list->x, 
		 list->y, 
		 ( list->shadow ? "yes" : "no" ) );
      if ( list->shadow )
	mpav_fmsg( stdout, " shx=%d shy=%d", list->shx, list->shy );
      
      mpav_fmsg( stdout, " msg=\"%s\"\n", list->msg );
      i ++;
      list = list->next;
    }
  
  if ( ! i )
    mpav_fmsg( stderr, "No messages.\n" );
}

msgnode_t *msglist_createnode( char *msg,
			       char *fontfile, int ptsize,
			       int x, int y, Uint32 fgcolor,
			       int shadow, int shx, int shy, Uint32 shcolor
			       )
{
  msgnode_t *node = ( msgnode_t *) calloc( 1, sizeof( msgnode_t ) );
  
  if ( fontfile && ( ptsize > 0 ) )
    {
      if ( ( node->font = TTF_OpenFont( fontfile, ptsize ) ) == NULL )
	{
	  fprintf( stderr, "TTF Font error: %s\n", SDL_GetError() );
	  free( node );
	  return( NULL );
	}
    }
  else 
    {
      fprintf( stderr, "Font or size invalid!\n" );
      free( node );
      return( NULL );
    }

  if ( msg )
    {
      node->msg = ( char * ) calloc( strlen( msg ), sizeof( char ) );
      strcpy( node->msg, msg );
    }
  else
    node->msg = NULL;
  

  node->x = x;
  node->y = y;
  node->shx = shx;
  node->shy = shy;
  node->shadow = shadow;
  node->fgcolor = fgcolor;
  node->shcolor = shcolor;
  node->next = NULL;

  return( node );
}

msgnode_t *msglist_createnode_nsh( char *msg,
				   char *fontfile, int ptsize,
				   int x, int y, Uint32 fgcolor			       
				   )
{
  return msglist_createnode( msg, fontfile, ptsize, x, y, fgcolor, 0, 0, 0, 0 );
}

int msglist_destroynode( msgnode_t **node )
{
  if ( ( ! node ) || ( ! *node ) )
    return( -1 );
  
  if ( ( *node )->font )
    TTF_CloseFont( ( *node )->font );
  
  if ( ( *node )->msg )
    free( ( *node )->msg );

  free( *node );
  
  ( *node ) = NULL;
  
  return( 0 );
}

