.ds q \N'34'
.TH AMDGPU __drivermansuffix__ __vendorversion__
.SH NAME
amdgpu \- AMD RADEON GPU video driver
.SH SYNOPSIS
.nf
.B "Section \*qDevice\*q"
.BI "  Identifier \*q"  devname \*q
.B  "  Driver \*qamdgpu\*q"
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B amdgpu
is an __xservername__ driver for AMD RADEON-based video cards with the
following features:
.PP
.PD 0
.TP 2
\(bu
Support for 24-bit pixel depth;
.TP
\(bu
RandR support up to version 1.4;
.TP
\(bu
3D acceleration;
.PD
.SH SUPPORTED HARDWARE
The
.B amdgpu
driver supports SI and newer families' video cards.
.PD
.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(__filemansuffix__) for general configuration
details.  This section only covers configuration details specific to this
driver.
.PP
The following driver
.B Options
are supported:
.TP
.BI "Option \*qSWcursor\*q \*q" boolean \*q
Selects software cursor.  The default is
.B off.
.TP
.BI "Option \*qAccel\*q \*q" boolean \*q
Enables or disables all hardware acceleration.
.br
The default is
.B on.

.TP
.BI "Option \*qZaphodHeads\*q \*q" string \*q
Specify the RandR output(s) to use with zaphod mode for a particular driver
instance.  If you use this option you must use this option for all instances
of the driver.
.br
For example:
.B
Option \*qZaphodHeads\*q \*qLVDS,VGA-0\*q
will assign xrandr outputs LVDS and VGA-0 to this instance of the driver.
.TP
.BI "Option \*qDRI\*q \*q" integer \*q
Define the maximum level of DRI to enable. Valid values are 2 for DRI2 or 3 for DRI3.
The default is
.B 3 for DRI3
if the Xorg version is >= 1.18.3, otherwise
.B 2 for DRI2.
.TP
.BI "Option \*qEnablePageFlip\*q \*q" boolean \*q
Enable DRI2 page flipping.  The default is
.B on.
.TP
.BI "Option \*qTearFree\*q \*q" boolean \*q
Set the default value of the per-output 'TearFree' property, which controls
tearing prevention using the hardware page flipping mechanism. TearFree is
on for any CRTC associated with one or more outputs with TearFree on. Two
separate scanout buffers need to be allocated for each CRTC with TearFree
on. If this option is set, the default value of the property is 'on' or 'off'
accordingly. If this option isn't set, the default value of the property is
.B auto,
which means that TearFree is on for outputs with rotation or other RandR
transforms, and for RandR 1.4 slave outputs, otherwise off.
.TP
.BI "Option \*qAccelMethod\*q \*q" string \*q
Setting this option to
.B none
disables use of the glamor acceleration architecture. In that case, all 2D
rendering is done by the CPU, but 3D and video hardware acceleration can still
work. This is mainly useful for OpenGL driver bring-up.
.br
The default is to use glamor.

.PP
The following driver
.B Option
is supported for
.B glamor
:
.TP
.BI "Option \*qShadowPrimary\*q \*q" boolean \*q
This option enables a so-called "shadow primary" buffer for fast CPU access to
pixel data, and separate scanout buffers for each display controller (CRTC).
This may improve performance for some 2D workloads, potentially at the expense
of other (e.g. 3D, video) workloads.
Note in particular that enabling this option currently disables page flipping.
The default is
.B off.

.SH SEE ALSO
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), Xserver(__appmansuffix__), X(__miscmansuffix__)
.IP " 1." 4
Wiki page:
.RS 4
https://www.x.org/wiki/radeon
.RE
.IP " 2." 4
Overview about amdgpu development code:
.RS 4
https://cgit.freedesktop.org/xorg/driver/xf86-video-amdgpu/
.RE
.IP " 3." 4
Mailing list:
.RS 4
https://lists.freedesktop.org/mailman/listinfo/amd-gfx
.RE
.IP " 4." 4
IRC channel:
.RS 4
#radeon on irc.freenode.net
.RE
.IP " 5." 4
Query the bugtracker for amdgpu bugs:
.RS 4
https://bugs.freedesktop.org/query.cgi?product=xorg&component=Driver/AMDgpu
.RE
.IP " 6." 4
Submit bugs & patches:
.RS 4
https://bugs.freedesktop.org/enter_bug.cgi?product=xorg&component=Driver/AMDgpu
.RE

.SH AUTHORS
.nf
Authors include:
Michel D\(:anzer            \fImichel@daenzer.net\fP
Alex Deucher             \fIalexdeucher@gmail.com\fP
