static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006, 2010 Øyvind Kolås <pippin@gimp.org>                      \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (std_dev, _(\"Standard Deviation\"), 0.55)                    \n"
"    description(_(\"Standard deviation (spatial scale factor)\"))             \n"
"    value_range (0.2, 300)                                                    \n"
"    ui_range    (0.2, 40.0)                                                   \n"
"    ui_gamma    (3.0)                                                         \n"
"    ui_meta     (\"unit\", \"pixel-distance\")                                \n"
"                                                                              \n"
"property_double (scale, _(\"Scale\"), 4.0)                                    \n"
"    description(_(\"Scale, strength of effect\"))                             \n"
"    value_range (0.0, 300.0)                                                  \n"
"    ui_range    (0.0, 10.0)                                                   \n"
"    ui_gamma    (3.0)                                                         \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_META                                                          \n"
"#define GEGL_OP_NAME     unsharp_mask                                         \n"
"#define GEGL_OP_C_SOURCE unsharp-mask.c                                       \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"attach (GeglOperation *operation)                                             \n"
"{                                                                             \n"
"  GeglNode *gegl, *input, *output, *add, *multiply, *subtract, *blur;         \n"
"                                                                              \n"
"  gegl = operation->node;                                                     \n"
"                                                                              \n"
"  input    = gegl_node_get_input_proxy (gegl, \"input\");                     \n"
"  output   = gegl_node_get_output_proxy (gegl, \"output\");                   \n"
"  add      = gegl_node_new_child (gegl, \"operation\", \"gegl:add\", NULL);   \n"
"  multiply = gegl_node_new_child (gegl, \"operation\", \"gegl:multiply\", NULL);\n"
"  subtract = gegl_node_new_child (gegl, \"operation\", \"gegl:subtract\", NULL);\n"
"  blur     = gegl_node_new_child (gegl, \"operation\", \"gegl:gaussian-blur\", NULL);\n"
"                                                                              \n"
"  gegl_node_link_many (input, subtract, multiply, NULL);                      \n"
"  gegl_node_link (input, blur);                                               \n"
"  gegl_node_link_many (multiply, add, output, NULL);                          \n"
"                                                                              \n"
"  gegl_node_connect_from (subtract, \"aux\",   blur,     \"output\");         \n"
"  gegl_node_connect_from (add,      \"aux\",   input, \"output\");            \n"
"                                                                              \n"
"  gegl_operation_meta_redirect (operation, \"scale\", multiply, \"value\");   \n"
"  gegl_operation_meta_redirect (operation, \"std-dev\", blur, \"std-dev-x\"); \n"
"  gegl_operation_meta_redirect (operation, \"std-dev\", blur, \"std-dev-y\"); \n"
"                                                                              \n"
"  gegl_operation_meta_watch_nodes (operation, add, multiply, subtract, blur, NULL);\n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass *operation_class;                                        \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"                                                                              \n"
"  operation_class->attach = attach;                                           \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:unsharp-mask\",                                   \n"
"    \"title\",       _(\"Unsharp Mask\"),                                     \n"
"    \"categories\",  \"enhance:sharpen\",                                     \n"
"    \"description\", _(\"Sharpen image, by adding difference to blurred image, a technique for sharpening originally used in darkrooms.\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
