/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *
 */

#include "stdafx.h"

#include "Doc/SchemaTypesDoc/CClassInstancePropertyDoc.h"
#include "Doc/SchemaTypesDoc/CClassPropertyDoc.h"
#include "Doc/SchemaTypesDoc/CDataClassDoc.h"

using namespace Caf;

/// Definition of a data class that may be generated by the provider
CDataClassDoc::CDataClassDoc() :
	_unique(false),
	_transientVal(false),
	_isInitialized(false) {}
CDataClassDoc::~CDataClassDoc() {}

/// Initializes the object with everything required by this
/// container. Once initialized, this object cannot
/// be changed (i.e. it is immutable).
void CDataClassDoc::initialize(
	const std::string namespaceVal,
	const std::string name,
	const std::string version,
	const std::deque<SmartPtrCClassPropertyDoc> propertyCollection,
	const std::deque<SmartPtrCClassInstancePropertyDoc> instancePropertyCollection,
	const bool unique,
	const bool transientVal,
	const std::string displayName,
	const std::string description) {
	if (! _isInitialized) {
		_namespaceVal = namespaceVal;
		_name = name;
		_version = version;
		_propertyCollection = propertyCollection;
		_instancePropertyCollection = instancePropertyCollection;
		_unique = unique;
		_transientVal = transientVal;
		_displayName = displayName;
		_description = description;

		_isInitialized = true;
	}
}

/// Accessor for the NamespaceVal
std::string CDataClassDoc::getNamespaceVal() const {
	return _namespaceVal;
}

/// Accessor for the Name
std::string CDataClassDoc::getName() const {
	return _name;
}

/// Accessor for the Version
std::string CDataClassDoc::getVersion() const {
	return _version;
}

/// Accessor for the Property
std::deque<SmartPtrCClassPropertyDoc> CDataClassDoc::getPropertyCollection() const {
	return _propertyCollection;
}

/// Accessor for the InstanceProperty
std::deque<SmartPtrCClassInstancePropertyDoc> CDataClassDoc::getInstancePropertyCollection() const {
	return _instancePropertyCollection;
}

/// Indicates whether the key properties of this class are enough to guarantee uniqueness from other classes of the same type
bool CDataClassDoc::getUnique() const {
	return _unique;
}

/// Accessor for the TransientVal
bool CDataClassDoc::getTransientVal() const {
	return _transientVal;
}

/// A hint as to what this class should be called when displaying it to a human
std::string CDataClassDoc::getDisplayName() const {
	return _displayName;
}

/// A phrase to describe the class for mouse-over text, etc
std::string CDataClassDoc::getDescription() const {
	return _description;
}





