static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2009 Henrik Akesson <h.m.akesson (a) gmail.com>                  \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"\")                                  \n"
"   description     (_(\"Path of file to load.\"))                             \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SOURCE                                                        \n"
"#define GEGL_OP_C_SOURCE ppm-load.c                                           \n"
"                                                                              \n"
"#define MAX_CHARS_IN_ROW        500                                           \n"
"#define CHANNEL_COUNT           3                                             \n"
"#define CHANNEL_COUNT_GRAY      1                                             \n"
"#define ASCII_P                 'P'                                           \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <stdio.h>                                                            \n"
"#include <stdlib.h>                                                           \n"
"#include <errno.h>                                                            \n"
"                                                                              \n"
"typedef enum {                                                                \n"
"  PIXMAP_ASCII_GRAY = '2',                                                    \n"
"  PIXMAP_ASCII      = '3',                                                    \n"
"  PIXMAP_RAW_GRAY   = '5',                                                    \n"
"  PIXMAP_RAW        = '6',                                                    \n"
"} map_type;                                                                   \n"
"                                                                              \n"
"typedef struct {                                                              \n"
"  map_type   type;                                                            \n"
"  glong      width;                                                           \n"
"  glong      height;                                                          \n"
"  gsize      numsamples; /* width * height * channels */                      \n"
"  gsize      channels;                                                        \n"
"  gsize      bpc;        /* bytes per channel */                              \n"
"  guchar    *data;                                                            \n"
"} pnm_struct;                                                                 \n"
"                                                                              \n"
"static gboolean                                                               \n"
"ppm_load_read_header(FILE       *fp,                                          \n"
"                     pnm_struct *img)                                         \n"
"{                                                                             \n"
"    /* PPM Headers Variable Declaration */                                    \n"
"    gchar *ptr;                                                               \n"
"    //gchar *retval;                                                          \n"
"    gchar  header[MAX_CHARS_IN_ROW];                                          \n"
"    gint   maxval;                                                            \n"
"    int    channel_count;                                                     \n"
"                                                                              \n"
"    /* Check the PPM file Type P3 or P6 */                                    \n"
"    if (fgets (header, MAX_CHARS_IN_ROW, fp) == NULL ||                       \n"
"        header[0] != ASCII_P ||                                               \n"
"        (header[1] != PIXMAP_ASCII_GRAY &&                                    \n"
"         header[1] != PIXMAP_ASCII &&                                         \n"
"         header[1] != PIXMAP_RAW_GRAY &&                                      \n"
"         header[1] != PIXMAP_RAW))                                            \n"
"      {                                                                       \n"
"        g_warning (\"Image is not a portable pixmap\");                       \n"
"        return FALSE;                                                         \n"
"      }                                                                       \n"
"                                                                              \n"
"    img->type = header[1];                                                    \n"
"                                                                              \n"
"    if (img->type == PIXMAP_RAW_GRAY || img->type == PIXMAP_ASCII_GRAY)       \n"
"      channel_count = CHANNEL_COUNT_GRAY;                                     \n"
"    else                                                                      \n"
"      channel_count = CHANNEL_COUNT;                                          \n"
"                                                                              \n"
"    /* Check the Comments */                                                  \n"
"    while((fgets (header, MAX_CHARS_IN_ROW, fp)) && (header[0] == '#'))       \n"
"      ;                                                                       \n"
"                                                                              \n"
"    /* Get Width and Height */                                                \n"
"    errno = 0;                                                                \n"
"    img->width = strtol (header, &ptr, 10);                                   \n"
"    if (errno)                                                                \n"
"      {                                                                       \n"
"        g_warning (\"Error reading width: %s\", strerror(errno));             \n"
"        return FALSE;                                                         \n"
"      }                                                                       \n"
"    else if (img->width < 0)                                                  \n"
"      {                                                                       \n"
"        g_warning (\"Error: width is negative\");                             \n"
"        return FALSE;                                                         \n"
"      }                                                                       \n"
"                                                                              \n"
"    img->height = strtol (ptr, &ptr, 10);                                     \n"
"    if (errno)                                                                \n"
"      {                                                                       \n"
"        g_warning (\"Error reading height: %s\", strerror(errno));            \n"
"        return FALSE;                                                         \n"
"      }                                                                       \n"
"    else if (img->width < 0)                                                  \n"
"      {                                                                       \n"
"        g_warning (\"Error: height is negative\");                            \n"
"        return FALSE;                                                         \n"
"      }                                                                       \n"
"                                                                              \n"
"    if (fgets (header, MAX_CHARS_IN_ROW, fp))                                 \n"
"      maxval = strtol (header, &ptr, 10);                                     \n"
"    else                                                                      \n"
"      maxval = 0;                                                             \n"
"                                                                              \n"
"    if ((maxval != 255) && (maxval != 65535))                                 \n"
"      {                                                                       \n"
"        g_warning (\"Image is not an 8-bit or 16-bit portable pixmap\");      \n"
"        return FALSE;                                                         \n"
"      }                                                                       \n"
"                                                                              \n"
"  switch (maxval)                                                             \n"
"    {                                                                         \n"
"    case 255:                                                                 \n"
"      img->bpc = sizeof (guchar);                                             \n"
"      break;                                                                  \n"
"                                                                              \n"
"    case 65535:                                                               \n"
"      img->bpc = sizeof (gushort);                                            \n"
"      break;                                                                  \n"
"                                                                              \n"
"    default:                                                                  \n"
"      g_warning (\"%s: Programmer stupidity error\", G_STRLOC);               \n"
"    }                                                                         \n"
"                                                                              \n"
"    /* Later on, img->numsamples is multiplied with img->bpc to allocate      \n"
"     * memory. Ensure it doesn't overflow. */                                 \n"
"    if (!img->width || !img->height ||                                        \n"
"        G_MAXSIZE / img->width / img->height / CHANNEL_COUNT < img->bpc)      \n"
"      {                                                                       \n"
"        g_warning (\"Illegal width/height: %ld/%ld\", img->width, img->height);\n"
"        return FALSE;                                                         \n"
"      }                                                                       \n"
"                                                                              \n"
"                                                                              \n"
"    img->channels = channel_count;                                            \n"
"    img->numsamples = img->width * img->height * channel_count;               \n"
"                                                                              \n"
"    return TRUE;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"ppm_load_read_image(FILE       *fp,                                           \n"
"                    pnm_struct *img)                                          \n"
"{                                                                             \n"
"    guint i;                                                                  \n"
"                                                                              \n"
"    if (img->type == PIXMAP_RAW || img->type == PIXMAP_RAW_GRAY)              \n"
"      {                                                                       \n"
"        if (fread (img->data, img->bpc, img->numsamples, fp) == 0)            \n"
"          return;                                                             \n"
"                                                                              \n"
"        /* Fix endianness if necessary */                                     \n"
"        if (img->bpc > 1)                                                     \n"
"          {                                                                   \n"
"            gushort *ptr = (gushort *) img->data;                             \n"
"                                                                              \n"
"            for (i=0; i < img->numsamples; i++)                               \n"
"              {                                                               \n"
"                *ptr = GUINT16_FROM_BE (*ptr);                                \n"
"                ptr++;                                                        \n"
"              }                                                               \n"
"          }                                                                   \n"
"      }                                                                       \n"
"    else                                                                      \n"
"      {                                                                       \n"
"        /* Plain PPM or PGM format */                                         \n"
"                                                                              \n"
"        if (img->bpc == sizeof (guchar))                                      \n"
"          {                                                                   \n"
"            guchar *ptr = img->data;                                          \n"
"                                                                              \n"
"            for (i = 0; i < img->numsamples; i++)                             \n"
"              {                                                               \n"
"                guint sample;                                                 \n"
"                if (!fscanf (fp, \" %u\", &sample))                           \n"
"                  sample = 0;                                                 \n"
"                *ptr++ = sample;                                              \n"
"              }                                                               \n"
"          }                                                                   \n"
"        else if (img->bpc == sizeof (gushort))                                \n"
"          {                                                                   \n"
"            gushort *ptr = (gushort *) img->data;                             \n"
"                                                                              \n"
"            for (i = 0; i < img->numsamples; i++)                             \n"
"              {                                                               \n"
"                guint sample;                                                 \n"
"                if (!fscanf (fp, \" %u\", &sample))                           \n"
"                  sample = 0;                                                 \n"
"                *ptr++ = sample;                                              \n"
"              }                                                               \n"
"          }                                                                   \n"
"        else                                                                  \n"
"          {                                                                   \n"
"            g_warning (\"%s: Programmer stupidity error\", G_STRLOC);         \n"
"          }                                                                   \n"
"      }                                                                       \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglProperties   *o = GEGL_PROPERTIES (operation);                          \n"
"  GeglRectangle result = {0,0,0,0};                                           \n"
"  pnm_struct    img;                                                          \n"
"  FILE         *fp;                                                           \n"
"                                                                              \n"
"  fp = (!strcmp (o->path, \"-\") ? stdin : fopen (o->path,\"rb\") );          \n"
"                                                                              \n"
"  if (!fp)                                                                    \n"
"    return result;                                                            \n"
"                                                                              \n"
"  if (!ppm_load_read_header (fp, &img))                                       \n"
"    goto out;                                                                 \n"
"                                                                              \n"
"  if (img.bpc == 1)                                                           \n"
"    {                                                                         \n"
"      if (img.channels == 3)                                                  \n"
"        gegl_operation_set_format (operation, \"output\",                     \n"
"                                   babl_format (\"R'G'B' u8\"));              \n"
"      else                                                                    \n"
"        gegl_operation_set_format (operation, \"output\",                     \n"
"                                   babl_format (\"Y' u8\"));                  \n"
"    }                                                                         \n"
"  else if (img.bpc == 2)                                                      \n"
"    {                                                                         \n"
"      if (img.channels == 3)                                                  \n"
"        gegl_operation_set_format (operation, \"output\",                     \n"
"                                   babl_format (\"R'G'B' u16\"));             \n"
"      else                                                                    \n"
"        gegl_operation_set_format (operation, \"output\",                     \n"
"                                   babl_format (\"Y' u16\"));                 \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    g_warning (\"%s: Programmer stupidity error\", G_STRLOC);                 \n"
"                                                                              \n"
"  result.width = img.width;                                                   \n"
"  result.height = img.height;                                                 \n"
"                                                                              \n"
" out:                                                                         \n"
"  if (stdin != fp)                                                            \n"
"    fclose (fp);                                                              \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties   *o = GEGL_PROPERTIES (operation);                          \n"
"  FILE         *fp;                                                           \n"
"  pnm_struct    img;                                                          \n"
"  GeglRectangle rect = {0,0,0,0};                                             \n"
"  gboolean      ret = FALSE;                                                  \n"
"                                                                              \n"
"  fp = (!strcmp (o->path, \"-\") ? stdin : fopen (o->path,\"rb\"));           \n"
"                                                                              \n"
"  if (!fp)                                                                    \n"
"    return FALSE;                                                             \n"
"                                                                              \n"
"  if (!ppm_load_read_header (fp, &img))                                       \n"
"    goto out;                                                                 \n"
"                                                                              \n"
"  /* Allocating Array Size */                                                 \n"
"                                                                              \n"
"  /* Should use g_try_malloc(), but this causes crashes elsewhere because the \n"
"   * error signalled by returning FALSE isn't properly acted upon. Therefore  \n"
"   * g_malloc() is used here which aborts if the requested memory size can't be\n"
"   * allocated causing a controlled crash. */                                 \n"
"  img.data = (guchar*) g_malloc (img.numsamples * img.bpc);                   \n"
"                                                                              \n"
"  /* No-op without g_try_malloc(), see above. */                              \n"
"  if (! img.data)                                                             \n"
"    {                                                                         \n"
"      g_warning (\"Couldn't allocate %\" G_GSIZE_FORMAT \" bytes, giving up.\", ((gsize)img.numsamples * img.bpc));\n"
"      goto out;                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  rect.height = img.height;                                                   \n"
"  rect.width = img.width;                                                     \n"
"                                                                              \n"
"  if (img.bpc == 1)                                                           \n"
"    {                                                                         \n"
"      if (img.channels == 3)                                                  \n"
"        gegl_buffer_get (output, &rect, 1.0, babl_format (\"R'G'B' u8\"), img.data,\n"
"                         GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);               \n"
"      else                                                                    \n"
"        gegl_buffer_get (output, &rect, 1.0, babl_format (\"Y' u8\"), img.data,\n"
"                         GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);               \n"
"    }                                                                         \n"
"  else if (img.bpc == 2)                                                      \n"
"    {                                                                         \n"
"      if (img.channels == 3)                                                  \n"
"        gegl_buffer_get (output, &rect, 1.0, babl_format (\"R'G'B' u16\"), img.data,\n"
"                         GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);               \n"
"      else                                                                    \n"
"        gegl_buffer_get (output, &rect, 1.0, babl_format (\"Y' u16\"), img.data,\n"
"                         GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);               \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    g_warning (\"%s: Programmer stupidity error\", G_STRLOC);                 \n"
"                                                                              \n"
"  ppm_load_read_image (fp, &img);                                             \n"
"                                                                              \n"
"  if (img.bpc == 1)                                                           \n"
"    {                                                                         \n"
"      if (img.channels == 3)                                                  \n"
"        gegl_buffer_set (output, &rect, 0, babl_format (\"R'G'B' u8\"), img.data,\n"
"                         GEGL_AUTO_ROWSTRIDE);                                \n"
"      else                                                                    \n"
"        gegl_buffer_set (output, &rect, 0, babl_format (\"Y' u8\"), img.data, \n"
"                         GEGL_AUTO_ROWSTRIDE);                                \n"
"    }                                                                         \n"
"  else if (img.bpc == 2)                                                      \n"
"    {                                                                         \n"
"      if (img.channels == 3)                                                  \n"
"        gegl_buffer_set (output, &rect, 0, babl_format (\"R'G'B' u16\"), img.data,\n"
"                         GEGL_AUTO_ROWSTRIDE);                                \n"
"      else                                                                    \n"
"        gegl_buffer_set (output, &rect, 0, babl_format (\"Y' u16\"), img.data,\n"
"                         GEGL_AUTO_ROWSTRIDE);                                \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    g_warning (\"%s: Programmer stupidity error\", G_STRLOC);                 \n"
"                                                                              \n"
"  g_free (img.data);                                                          \n"
"                                                                              \n"
"  ret = TRUE;                                                                 \n"
"                                                                              \n"
" out:                                                                         \n"
"  if (stdin != fp)                                                            \n"
"    fclose (fp);                                                              \n"
"                                                                              \n"
"  return ret;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  return get_bounding_box (operation);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationSourceClass *source_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  source_class    = GEGL_OPERATION_SOURCE_CLASS (klass);                      \n"
"                                                                              \n"
"  source_class->process = process;                                            \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->get_cached_region = get_cached_region;                     \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",         \"gegl:ppm-load\",                                      \n"
"    \"title\",        _(\"PPM File Loader\"),                                 \n"
"    \"categories\",   \"hidden\",                                             \n"
"    \"description\",  _(\"PPM image loader.\"),                               \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \"image/x-portable-pixmap\", \"gegl:ppm-load\");                          \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \".ppm\", \"gegl:ppm-load\");                                             \n"
"                                                                              \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \"image/x-portable-graymap:\", \"gegl:ppm-load\");                        \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \".pgm\", \"gegl:ppm-load\");                                             \n"
"                                                                              \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \"image/x-portable-anymap\", \"gegl:ppm-load\");                          \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \".pnm\", \"gegl:ppm-load\");                                             \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
