.\"
.\" "$Id: lprm.man 11893 2014-05-23 02:45:48Z msweet $"
.\"
.\" lprm man page for CUPS.
.\"
.\" Copyright 2007-2014 by Apple Inc.
.\" Copyright 1997-2006 by Easy Software Products.
.\"
.\" These coded instructions, statements, and computer programs are the
.\" property of Apple Inc. and are protected by Federal copyright
.\" law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\" which should have been included with this file.  If this file is
.\" file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH lprm 1 "CUPS" "22 May 2014" "Apple Inc."
.SH NAME
lprm \- cancel print jobs
.SH SYNOPSIS
.B lprm
[
.B \-E
] [
.B \-U
.I username
] [
.B \-h
.IR server [ :port ]
] [
.B \-P
.IR destination [ /instance ]
] [
.B \-
] [
.I job-id(s)
]
.SH DESCRIPTION
.B lprm
cancels print jobs that have been queued for printing.
If no arguments are supplied, the current job on the default destination is canceled.
You can specify one or more job ID numbers to cancel those jobs or use the \fI\-\fR option to cancel all jobs.
.SH OPTIONS
The
.B lprm
command supports the following options:
.TP 5
.B \-E
Forces encryption when connecting to the server.
.TP 5
\fB\-P \fIdestination\fR[\fI/instance\fR]
Specifies the destination printer or class.
.TP 5
\fB\-U \fIusername\fR
Specifies an alternate username.
.TP 5
\fB\-h \fIserver\fR[\fI:port\fR]
Specifies an alternate server.
.SH CONFORMING TO
The CUPS version of
.B lprm
is compatible with the standard Berkeley command of the same name.
.SH EXAMPLES
Cancel the current job on the default printer:
.nf

    lprm

.fi
Cancel job 1234:
.nf

    lprm 1234

.fi
Cancel all jobs:
.nf

    lprm \-
.fi
.SH SEE ALSO
.BR cancel (1),
.BR lp (1),
.BR lpq (1),
.BR lpr (1),
.BR lpstat (1),
CUPS Online Help (http://localhost:631/help)
.SH COPYRIGHT
Copyright \[co] 2007-2014 by Apple Inc.
.\"
.\" End of "$Id: lprm.man 11893 2014-05-23 02:45:48Z msweet $".
.\"
