/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimppalettes_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "gimp.h"


/**
 * SECTION: gimppalettes
 * @title: gimppalettes
 * @short_description: Operations related to palettes.
 *
 * Operations related to palettes.
 **/


/**
 * gimp_palettes_refresh:
 *
 * Refreshes current palettes. This function always succeeds.
 *
 * This procedure retrieves all palettes currently in the user's
 * palette path and updates the palette dialogs accordingly.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_palettes_refresh (void)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-palettes-refresh",
                                              args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_palettes_get_list:
 * @filter: An optional regular expression used to filter the list.
 * @num_palettes: (out): The number of palettes in the list.
 *
 * Retrieves a list of all of the available palettes
 *
 * This procedure returns a complete listing of available palettes.
 * Each name returned can be used as input to the command
 * gimp_context_set_palette().
 *
 * Returns: (array length=num_palettes) (element-type gchar*) (transfer full):
 *          The list of palette names.
 *          The returned value must be freed with g_strfreev().
 **/
gchar **
gimp_palettes_get_list (const gchar *filter,
                        gint        *num_palettes)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar **palette_list = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, filter,
                                          G_TYPE_NONE);

  return_vals = gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                              "gimp-palettes-get-list",
                                              args);
  gimp_value_array_unref (args);

  *num_palettes = 0;

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    {
      *num_palettes = GIMP_VALUES_GET_INT (return_vals, 1);
      palette_list = GIMP_VALUES_DUP_STRING_ARRAY (return_vals, 2);
    }

  gimp_value_array_unref (return_vals);

  return palette_list;
}
