/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.concurrent.locks;

import info.aduna.concurrent.locks.AbstractDebugLock;
import info.aduna.concurrent.locks.AbstractLock;
import info.aduna.concurrent.locks.Lock;
import info.aduna.concurrent.locks.Properties;
import info.aduna.concurrent.locks.ReadWriteLockManager;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReadWriteLockManager
implements ReadWriteLockManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean trackLocks;
    protected boolean writerActive = false;
    protected int activeReaders = 0;
    private List<WeakReference<Lock>> readLocks;
    private WeakReference<Lock> writeLock;

    public AbstractReadWriteLockManager() {
        this(false);
    }

    public AbstractReadWriteLockManager(boolean trackLocks) {
        boolean bl = this.trackLocks = trackLocks || Properties.lockTrackingEnabled();
        if (this.trackLocks) {
            this.readLocks = new LinkedList<WeakReference<Lock>>();
        }
    }

    protected Lock createReadLock() {
        ++this.activeReaders;
        if (this.trackLocks) {
            ReadDebugLock lock = new ReadDebugLock(this.logger, true);
            if (this.trackLocks) {
                this.readLocks.add(new WeakReference<ReadDebugLock>(lock));
            }
            return lock;
        }
        return new ReadLock();
    }

    private synchronized void releaseReadLock(Lock lock) {
        --this.activeReaders;
        if (this.trackLocks) {
            Iterator<WeakReference<Lock>> iter = this.readLocks.iterator();
            while (iter.hasNext()) {
                if (iter.next().get() != lock) continue;
                iter.remove();
                break;
            }
        }
        if (this.activeReaders == 0) {
            this.notifyAll();
        }
    }

    protected Lock createWriteLock() {
        this.writerActive = true;
        if (this.trackLocks) {
            WriteDebugLock lock = new WriteDebugLock(this.logger, true);
            if (this.trackLocks) {
                this.writeLock = new WeakReference<WriteDebugLock>(lock);
            }
            return lock;
        }
        return new WriteLock();
    }

    private synchronized void releaseWriteLock() {
        this.writerActive = false;
        if (this.trackLocks) {
            this.writeLock = null;
        }
        this.notifyAll();
    }

    protected class WriteDebugLock
    extends AbstractDebugLock {
        public WriteDebugLock(Logger logger, boolean enableTrace) {
            super(logger, enableTrace);
        }

        protected void releaseLock() {
            AbstractReadWriteLockManager.this.releaseWriteLock();
        }
    }

    protected class WriteLock
    extends AbstractLock {
        protected WriteLock() {
        }

        protected void releaseLock() {
            AbstractReadWriteLockManager.this.releaseWriteLock();
        }
    }

    protected class ReadDebugLock
    extends AbstractDebugLock {
        public ReadDebugLock(Logger logger, boolean enableTrace) {
            super(logger, enableTrace);
        }

        protected void releaseLock() {
            AbstractReadWriteLockManager.this.releaseReadLock(this);
        }
    }

    protected class ReadLock
    extends AbstractLock {
        protected ReadLock() {
        }

        protected void releaseLock() {
            AbstractReadWriteLockManager.this.releaseReadLock(this);
        }
    }
}

