/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.helpers;

import java.io.File;
import org.openrdf.model.ValueFactory;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailChangedListener;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.StackableSail;

public class SailWrapper
implements StackableSail {
    private Sail baseSail;

    public SailWrapper() {
    }

    public SailWrapper(Sail baseSail) {
        this.setBaseSail(baseSail);
    }

    public void setBaseSail(Sail baseSail) {
        this.baseSail = baseSail;
    }

    public Sail getBaseSail() {
        return this.baseSail;
    }

    private void verifyBaseSailSet() {
        if (this.baseSail == null) {
            throw new IllegalStateException("No base Sail has been set");
        }
    }

    public File getDataDir() {
        return this.baseSail.getDataDir();
    }

    public void setDataDir(File dataDir) {
        this.baseSail.setDataDir(dataDir);
    }

    public void initialize() throws SailException {
        this.verifyBaseSailSet();
        this.baseSail.initialize();
    }

    public void shutDown() throws SailException {
        this.verifyBaseSailSet();
        this.baseSail.shutDown();
    }

    public boolean isWritable() throws SailException {
        this.verifyBaseSailSet();
        return this.baseSail.isWritable();
    }

    public SailConnection getConnection() throws SailException {
        this.verifyBaseSailSet();
        return this.baseSail.getConnection();
    }

    public ValueFactory getValueFactory() {
        this.verifyBaseSailSet();
        return this.baseSail.getValueFactory();
    }

    public void addSailChangedListener(SailChangedListener listener) {
        this.verifyBaseSailSet();
        this.baseSail.addSailChangedListener(listener);
    }

    public void removeSailChangedListener(SailChangedListener listener) {
        this.verifyBaseSailSet();
        this.baseSail.removeSailChangedListener(listener);
    }
}

